#!/bin/sh
#
# Product:     Insight Integration for TEC
#
#Copyright (c), @ 1999, 2005 Hewlett-Packard Development Company, L.P. All rights reserved.
#
#Based on sample code provided by Tivoli Systems, Inc. Copyright (c) 1996,
#1997 All Rights Reserved.


#
# Removes Insight Integration for TEC 3.0 files from the Tivoli directories.
# Removes Insight Integration components from Tivoli.
#

#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=setup_env.sh

############################################################################
#
#  Script functions
#
############################################################################

mnname() {
	if [ "$DEBUG" = true ]; then set -x; fi
	mnoid=`objcall 0.0.0 get_host_location`
	eval mnname=`idlattr -t -g $mnoid label string`
	echo $mnname
}



###
#
# ironame
#
ironame() {
	if [ "$DEBUG" = true ]; then set -x; fi
	iro=`wlookup InterRegion`
	ironame=`idlattr -t -g $iro name string`
	ironame=`eval echo $ironame`
	echo $ironame
}


###
#
# errexit
#
errexit()
{
	if [ "$DEBUG" = true ]; then set -x; fi
	echo "$*" >&2
	exit 1
}


###
#
# init_script
#
init_script()
{
	#
	#	If this is NT, then etc is in a different location
	#
	if [ x\"$OS\" = x\"Windows_NT\" ] ; then
	     ETC=$SystemRoot/system32/drivers/etc/Tivoli
	fi

	ETC=`echo $ETC | tr "\\\\\\\\" "/"`

	. "$ETC/$SCRIPT"

	TEMP=/tmp
	if [ x"$OS" = x"Windows_NT" ]; then
		TEMP=$DBDIR/tmp
	else
		TEMP=/tmp
	fi

	IRONAME="`ironame`"; export IRONAME
	MNNAME="`mnname`"; export MNNAME

	PRODDIR="$BINDIR"
	cd "$BINDIR"
	cd ..
	PRODDIR=`pwd`
	PRODDIR=$PRODDIR/generic_unix/TME/PLUS/IM2

	if [ -f "$PRODDIR/PLUSproduct-info.sh" ]; then
		. "$PRODDIR/PLUSproduct-info.sh" > /dev/null
	else
		echo "Could not locate $PRODDIR/PLUSproduct-info.sh." >&2
	fi

	# If all is well with product-info.sh then there should not be any problems.
	[ -z "$SHORT_PRODNAME" ] && SHORT_PRODNAME=IM2
	if [ -z "$MEDIUM_PRODNAME" ]; then
		REAL_PRODNAME="Insight Integration for TEC"
		MEDIUM_PRODNAME="$REAL_PRODNAME"
	fi

	echo "BINDIR=$BINDIR"
	echo "DBDIR=$DBDIR"
	echo "TEMP=$TEMP"
	echo " "
	CURDIR=`pwd`

	SilentMode=
	if [ "$1" = "silent" ]; then
		SilentMode=yes
	fi

}


###
#
# ask_about_wchkdb
#
# If $1 is WARN then display the warning if they say no.
#
ask_about_wchkdb()
{
	echo "It is recommended that you run wchkdb -u at this time."
	echo "Would you like wchkdb -u to be executed (y or n)?"
	read answer
	echo
	if [ "$answer" = "y" -o "$answer" = "Y" ]; then
		wchkdb -u
		echo
		return
	fi

	if [ "$1" = "WARN" ]; then
		echo "Some Insight Integration Plus objects may not be known to the name registry."
		sleep 5
	fi

}


###
#
# delete_task
#
delete_task()
{
	TheTaskName="$1"
	TheTaskName=`echo "$1" | sed 's/[^a-zA-Z0-9]/_/g'`
	CheckTask=""
	CheckTask=`wlstlib "$TASKLIB" 2> /dev/null | grep -i "$TheTaskName" 2> /dev/null`
	[ -z "$CheckTask" ] && return
	set -x
	wdeltask "$TheTaskName" "$TASKLIB"
	set +x
	echo
}

###
#
# delete_job
#
delete_job()
{
	# Emulate the link function normalize_name.
	TheJobName=`echo "$1" | sed 's/[^a-zA-Z0-9]/_/g'`
	wlookup -r Job "$TheTaskName ($SHORT_PRODNAME)"#"${IRONAME}" > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
		set -x
		wdeljob "$TheJobName ($SHORT_PRODNAME)" "$TASKLIB"
		set +x
		echo
	fi
}

###
#
# delete_job_and_task
#
delete_job_and_task()
{
	wlookup -r TaskLibrary "$TASKLIB" > /dev/null 2> /dev/null
	[ $? -ne 0 ] && return

	delete_task "$1"
	delete_job "$1"
}

###
#
# delete_task_lib
#
delete_task_lib()
{
	wlookup -r TaskLibrary "$1" > /dev/null 2> /dev/null
	[ $? -ne 0 ] && return
	set -x
	wdel @TaskLibrary:"$1"
	set +x
	echo
}

###
#
# delete_task_libraries
#
delete_task_libraries()
{

	TASKLIB="Insight Administrative Tasks"#"${IRONAME}"
	wlookup -r TaskLibrary "$TASKLIB" > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
		delete_job_and_task "HP Insight Management Agents"
		delete_job_and_task "Set Internet Browser Location"
		delete_job_and_task "HP Insight Manager 7"
		delete_job_and_task "HP Storage Management Appliance"
		delete_task_lib "$TASKLIB"
	fi
	
	TASKLIB="Insight Hidden Tasks"#"${IRONAME}"
	wlookup -r TaskLibrary "$TASKLIB" > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
		delete_job_and_task "HP Insight Management Agents"
		delete_job_and_task "HP Insight Manager 7"
		delete_job_and_task "HP Storage Management Appliance"
		delete_job_and_task "Open Trouble Ticket"
		delete_job_and_task "Run Job"
		delete_job_and_task "Verify Installed"
		delete_task_lib "$TASKLIB"
	fi

	TASKLIB="Insight Integration for TEC Utility Task Library"#"${IRONAME}"
	wlookup -r TaskLibrary "$TASKLIB" > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
		delete_task_lib "$TASKLIB"
	fi
	
	TASKLIB="Insight Plus Configuration"#"${IRONAME}"
	wlookup -r TaskLibrary "$TASKLIB" > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
		delete_job_and_task "About Insight Tivoli Module"
		delete_job_and_task "Plus Configuration"
		delete_task_lib "$TASKLIB"
	fi

	TASKLIB="Insight SNMP Adapter Configuration"#"${IRONAME}"
	wlookup -r TaskLibrary "$TASKLIB" > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
		delete_job_and_task "Configure SNMP Adapter"
		delete_task_lib "$TASKLIB"
	fi

	TASKLIB="Insight TEC Configuration"#"${IRONAME}"
	wlookup -r TaskLibrary "$TASKLIB" > /dev/null 2> /dev/null
	if [ $? -eq 0 ]; then
		delete_job_and_task "Setup TEC Event Server"
		delete_task_lib "$TASKLIB"
	fi

}


###
#
# delete_profile
#
delete_profile()
{
	Type="$1"
	wlookup -r $Type "$2"#"${IRONAME}" > /dev/null 2> /dev/null
	[ $? -ne 0 ] && return
	if [ "$Type" = "ProfileManager" ]; then
		wunsub -a @"${Type}":"$2"#"${IRONAME}"
	fi
	set -x
		wdel @"${Type}":"$2"#"${IRONAME}"
	set +x
	echo

}

###
#
# delete_app_launch_icons
#
# $1 is the base name of the icon
# $2 is the name of the collection the icon is in
#
delete_app_launch_icons()
{
	Nodes=`wls /Library/TMF_imp_TSysAdmin::PolicyDrivenBase | grep -i "$1"`

	for node in "$Nodes"; do
		set -x
		wdel "TivoliPlus"/"Insight Integration for TEC"/"${node}"
		set +x
	done
}

###
#
# delete_icons
#
delete_icons()
{
	wls TivoliPlus > /dev/null 2> /dev/null
	[ $? -ne 0 ] && return
	wls TivoliPlus/"Insight Integration for TEC" > /dev/null 2> /dev/null
	[ $? -ne 0 ] && return
	set -x
	wrm TivoliPlus/"Insight Integration for TEC"/"Insight Administration Tasks"/"Configure SNMP Adapter"
	wrm TivoliPlus/"Insight Integration for TEC"/"Insight Administration Tasks"/"Setup TEC Event Server"
	wrm TivoliPlus/"Insight Integration for TEC"/"Insight Administration Tasks"

	wrm TivoliPlus/"Insight Integration for TEC"/"About Insight Tivoli Module"	
	wrm TivoliPlus/"Insight Integration for TEC"/"Set Internet Browser Location"
	wrm TivoliPlus/"Insight Integration for TEC"/"HP Insight Management Agents"
	wrm TivoliPlus/"Insight Integration for TEC"/"HP Insight Manager 7"
	wrm TivoliPlus/"Insight Integration for TEC"/"HP Storage Management Appliance"

	wrm TivoliPlus/"Insight Integration for TEC"

	set +x
}

###
#
# delete_event_group
#
delete_event_group()
{
	wdeleg "HP_Insight_Manager"
}


###
#
# delete_policy_region
#
delete_policy_region()
{

wlookup -r PolicyRegion "${MEDIUM_PRODNAME}"#"${IRONAME}" > /dev/null 2> /dev/null
if [ $? -eq 0 ]; then
	set -x
	wdel @PolicyRegion:"${MEDIUM_PRODNAME}"#"${IRONAME}"
	set +x
fi

}

###
#
# remove_ProductInfo
#
# Removes the ProductInfo object for the module
# $1 is the name of the product to remove.  Look in the .IND file for the name.
#
remove_ProductInfo()
{
	if [ "$DEBUG" = true ]; then set -x; fi

	if is_TMR_server; then
		# Remove the product and patch installation objects
		echo "Removing Product object"
		PROD="$1"
	
		PROD_INFO=`wlookup -r ProductInfo "$PROD" 2> /dev/null`
		
		if [ -n "$PROD_INFO" ]; then
			wdel @ProductInfo:"$PROD"
		else
			echo "The product $PROD is not installed."
		fi
		
		wlookup -r ProductInfo "$PROD" 1> /dev/null 2> /dev/null

		[ $? -eq 0 ] && echo "Failed to remove product information for the product $PROD."

	fi

}

###
#
# remove_module_files()
#
remove_module_files()
{
cd "$BINDIR/../generic_unix/.installed"
rm -f "IM_GBIN"

cd "$BINDIR/../generic_unix"
rm -f "IM_GBIN"

cd "$DBDIR"
rm -f "IM2plus-installed"
rm -f "IM_ALIDB"

cd "$BINDIR/../generic_unix/TME/PLUS"
rm -f -r "IM2"

cd "$DBDIR/.installed"
rm -f "IM_ALIDB"

cd "$TEMP"
rm -f "IM2_PLUS.log"
rm -f "IM2_after.output"
rm -f "IM_ALIDB_after.error"
rm -f "IM_ALIDB_after.output"

# Remove the known .tll files from $TEMP
rm -f "HPQ_Insight_Hidden_Tasks__V3_0.tll"
rm -f "HPQ_Insight_Administrative_Tasks__V3_0.tll"
rm -f "HPQ_Insight_Plus_Configuration__V3_0.tll"
rm -f "HPQ_Insight_SNMP_Adapter_Configuration__V3_0.tll"
rm -f "HPQ_Insight_TEC_Configuration__V3_0.tll"

cd "$BINDIR/../../msg_cat/.installed"
rm -f "IM_CAT"

cd "$BINDIR/../../msg_cat"
rm -f "IM_CAT"

cd "$BINDIR/../../msg_cat/C/"
rm -f IM*.cat
rm -f im*.cat

remove_utilities_files

remove_task_lib_files
}

###
#
# remove_utilities_files
#
remove_utilities_files()
{
	if [ ! -z "$LCF_BINDIR" ]; then
		cd "$LCF_BINDIR"
		cd ..
		cd TME/TEC/adapters/etc
		AdapterDir=`pwd`
		[ -f "$AdapterDir/ins_evt.cds" ] && rm -f "$AdapterDir/ins_evt.cds"
		[ -f "$AdapterDir/ins_evt.oid" ] && rm -f "$AdapterDir/ins_evt.oid"
		AdapterDir=""
	fi

	if [ ! -z "$BINDIR" ]; then

		[ -f "$BINDIR/TME/TEC/adapters/etc/ins_evt.cds" ] && rm -f "$BINDIR/TME/TEC/adapters/etc/ins_evt.cds"
		[ -f "$BINDIR/TME/TEC/adapters/etc/ins_evt.oid" ] && rm -f "$BINDIR/TME/TEC/adapters/etc/ins_evt.oid"

	fi


	if [ "$OS" = "Windows_NT" ]; then
		UTILSDIR=c:"${UTILSDIR}"
	fi

}

###
#
# remove_task_lib_files
#
remove_task_lib_files()
{

THETASKS=""
THETASKS=`wgettask "Configure_Internet_Browser" "Insight Administrative Tasks" 2> /dev/null`


cd $BINDIR
cd ..
TheTivoliBinDir=`pwd`

# If the task lib isn't there, try a Tivoli standard library.
if [ -z "$THETASKS" ]; then
	task_file=""
	task_file=`wgettask "Send_Event" "T/EC Tasks" | grep -i install-dir | cut -d'>' -f2`
   task_file="$TheTivoliBinDir/$task_file"
	task_dir=""
	task_dir=`dirname "$task_file"`
else
	task_file=""
	task_dir=""
	task_file=`echo "$THETASKS" | grep -i install-dir | cut -d'>' -f2`
   task_file="$TheTivoliBinDir/${task_file}"
	task_dir=`dirname "$task_file"`
fi

#
# If task_dir exists see if Insight* files exist.
# If so, prompt for deletion.
# 
if [ ! -z "$task_dir" -a -d "$task_dir" ]; then
	cd "$task_dir"
	check_for_files=""
	check_for_files=`ls "$task_dir" | grep -i Insight 2> /dev/null`
	if [ ! -z "$check_for_files" ]; then
		echo
		echo "Files remain at:"
		echo "---------------------------"
		echo "$task_dir"
		ls "$task_dir" | grep -i Insight
		echo
		echo "These files are no longer needed.  Do you wish to remove them (y or n?):"
		answer=""
		read answer
		if [ "$answer" = "Y" -o "$answer" = "y" ]; then
			for f in $check_for_files; do
				rm -f "$task_dir/$f"
			done
			check_for_files=""
			check_for_files=`ls "$task_dir" | grep -i IM 2> /dev/null`
			if [ ! -z "$check_for_files" ]; then
				echo "Deletion failed.  Files remain."
				echo "------------------------------------------"
				ls "$task_dir" | grep -i Insight  2> /dev/null
			else
				echo "File deletion was successful."
			fi
		fi
	fi
fi

}
 
###
#
#	is_TMR_server
#
#	This function taken from Link 3.1.o in PLUScommon-install.sh
#
is_TMR_server() {
  ODNUM=`odadmin | grep Dispatcher | awk '{print $3}'`
  if [ $ODNUM -ne 1 ]; then
    return 1
  fi
  return 0
}

###
#
# ask_about_files
#
ask_about_files()
{
	echo "Would you like to delete the Insight Integration for TEC files (y or n)?"
	read answer
	echo
	if [ "$answer" = "n" -o "$answer" = "N" ]; then
		exit 0
	else
		remove_module_files

		tecsnmppath=`sed '1q' $BINDIR/instec30.ini` 
		rulebase=`cat -n $BINDIR/instec30.ini | grep 2 |awk '{ print $2 }'`
		rulebasepath=`cat -n $BINDIR/instec30.ini | grep 3 |awk '{ print $2 }`
		if [ "`uname`" = "Windows_NT" ]; then
			TECSNMP_START_CMD="net start TECSNMPadapter"
			TECSNMP_STOP_CMD="net stop TECSNMPadapter"
		else
			TECSNMP_START_CMD="$tecsnmppath/../bin/init.tecad_snmp start"
			TECSNMP_STOP_CMD="$tecsnmppath/../bin/init.tecad_snmp stop"
		fi
		$TECSNMP_STOP_CMD
		cfirst=`sed -n '/Hewlett/ =' $tecsnmppath/tecad_snmp.cds`
		clast=`sed -n '/hpq_sanEventURL/ =' $tecsnmppath/tecad_snmp.cds`
		if [ "`uname`" = "Windows_NT" ]; then
		clast=$((clast+3))
		else
		clast=`echo $clast+3|bc`
		fi
		sed -e "$cfirst,$clast d" $tecsnmppath/tecad_snmp.cds > tmpcds.txt
		mv tmpcds.txt $tecsnmppath/tecad_snmp.cds
		ofirst=`sed -n '/1.3.6.1.2.1.1.1/ =' $tecsnmppath/tecad_snmp.oid`
		olast=`sed -n '/1.3.6.1.4.1.1754.1.5.9/ =' $tecsnmppath/tecad_snmp.oid`
		sed -e "$ofirst,$olast d" $tecsnmppath/tecad_snmp.oid > tmpoid.txt
		mv tmpoid.txt $tecsnmppath/tecad_snmp.oid
#	echo "Would you like to delete $rulebase  (y or n)?"
#	read answer
#	echo
#	if [ "$answer" = "y" -o "$answer" = "Y" ]; then
		wdelrb $rulebase
		rm -rf $rulebasepath
		rm -f tmpcds.txt
		rm -f tmpoid.txt
		rm -f $BINDIR/instec30.ini
		$TECSNMP_START_CMD
#	fi

		exit 0
	fi
}

###
#
# ask_about_objects
#
ask_about_objects()
{
	echo "Would you like to delete the Insight Integration for TEC database objects (y or n)?"
	read answer
	echo
	if [ "$answer" = "n" -o "$answer" = "N" ]; then
		ask_about_files
	fi
}

###
#
# main
#
main()
{

	init_script

	ask_about_objects

	ask_about_wchkdb WARN

	delete_task_libraries

	delete_icons

	delete_policy_region

	ask_about_wchkdb

	remove_ProductInfo "IM"

	ask_about_files


}

main