#!/bin/sh
# $Id: $
#
# Component:	TivoliPlus Generic Installation Script.
#
# $Source: $
# $Revision: $
#
# Description:  
#		
#
# Author:	Annelle Harrison
#		Tivoli Systems, Inc.
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1999, 2000
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#


#
#	Set up environment (similar to old /etc/Tivoli/setup_env.sh)
#
OSERV=`objcall 0.0.0 get_oserv`; export OSERV
INST_DIR=`objcall $OSERV query install_dir | tr "\\\\\\\\" "/"`; export INST_DIR
INTERP=`objcall $OSERV query interp`; export INTERP
BINDIR=$INST_DIR/$INTERP; export BINDIR
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK; export LINKDIR
DBDIR=`objcall $OSERV query db_dir | tr "\\\\\\\\" "/"`; export DBDIR
TEMP=/tmp; export TEMP
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
fi
if [ ! -d $TEMP ]; then
	$LINKDIR/mkdir.sh $TEMP
fi
PATH=$LINKDIR:$PATH

#
#	get all the common functions loaded
#
. $LINKDIR/PLUScommon-install.sh

cd $LINKDIR

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR=$TEMP/.plusdebug
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
## just make it true always...
DEBUG=true
export DEBUG

#
# Set shell flags for trace, abort install if error
#
if $DEBUG; then set -xv; fi
set -e

#
# Use the common link installation logic
#
install_link_class || exit 1

exit 0
