#!/bin/sh
#
# File:         configsnmp.sh
#
# Product:      Tivoli Module v4.0
# Description:  Shell Script
# Author:               Module Generator
#
# Generated:    
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
#
###################
# Support Functions
###################

###
#
# restart_tecsnmp
#
restart_tecsnmp()
{
	echo "`get_message CFSNMP_STARTING_SNMP_ADAPTER`"
	$TECSNMP_START_CMD > /dev/null 2>&1 &
}

###
#
# errexit
#
errexit()
{
	echo "$*" >&2
	exit 1
}


###
#
# errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

###
#
# is_managed_node
#
is_managed_node() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 0
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 1
  else
    return 0
  fi
}

###
#
# is_OS_NT
#
is_OS_NT() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ "`uname`" = "Windows_NT" ]; then
    return 0
  else
    return 1
  fi
}


###
#
#   Return value for BINDIR
#
bindir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    INTERP=`objcall $OSERV query interp`; export INTERP
    inst_dir="`objcall $OSERV query install_dir`"
    bindir="$inst_dir/$INTERP"
  else
    bindir="$LCF_BINDIR/.."
  fi
  bindir="`echo $bindir | sed -e 's,\\\\,/,g'`"
  echo $bindir
}

###
#
#   Return value for INST_DIR
#
inst_dir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    inst_dir="`objcall $OSERV query install_dir`"
  else
    inst_dir="$LCFROOT"
  fi
  inst_dir="`echo $inst_dir | sed -e 's,\\\\,/,g'`"
  echo $inst_dir
}

###
#
#   Return correct value for tmp directory
#
temp() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    temp=/tmp
    if is_OS_NT; then
	temp="$DBDIR/tmp"
    fi
  else
    if [ -n "$LCF_TEMPDIR" ]; then
      temp="$LCF_TEMPDIR"
    else
      temp="$LCF_DATDIR/tmp"
    fi
  fi
  if [ ! -d "$temp" ]; then
    mkdir -p "$temp"
  fi
  echo $temp
}

###
#
#    Find the Tivoli etc directory and source the right environment setup file
#
source_etc_setup_env() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    ETC=/etc/Tivoli

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/system32/drivers/etc/Tivoli
    fi

    # Look for the optional Plus override script, if not there use the standard one
    SETUP_SCRIPT=""
    if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
    fi
    . $ETC/$SETUP_SCRIPT
  else
    # not a managed node; find the most recent lcf_env.sh and source it
    ETC=/etc/Tivoli/lcf

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/Tivoli/lcf
	 if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
		ETC=$SystemRoot/Tivoli/lcf/1
       fi
    fi
    SETUP_SCRIPT=lcf_env.sh
    LCF_ETC_SCRIPT=`echo \`ls -td ${ETC}/*\` | awk '{print $1}'`/$SETUP_SCRIPT
    if [ -f "$LCF_ETC_SCRIPT" ]; then
      . $LCF_ETC_SCRIPT > /dev/null 2> /dev/null
    fi
  fi
}

###
#
# ironame
#
ironame() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    #
    #	Get the region name to avoid collisions
    #
    iro=`wlookup InterRegion`
    ironame=`idlattr -t -g $iro name string`
    ironame=`eval echo $ironame`
    echo $ironame
  else
    echo ""
  fi
}

###
#
# mnname
#
mnname() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    mnoid=`objcall 0.0.0 get_host_location`
    eval mnname=`idlattr -t -g $mnoid label string`
    echo $mnname
  else
    echo ""
  fi
}

###
#
# source_product_info
#
source_product_info() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -d "$1" ]; then
    cd "$1"
    if [ -f PLUSproduct-info.sh ]; then
      . ./PLUSproduct-info.sh
      export WINSTRUCTED
      export MODULE_VERSION
    fi
  fi
}

###
#
# get_install_opts
#
get_install_opts() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -n "$INSTALL_OPTS" ]; then
   if [ -f "$LINKDIR/PLUSget_install_opts.sh" ]; then
	. "$LINKDIR/PLUSget_install_opts.sh"
   fi
  fi
}

#----------------------------------------------------------
#	Used to determine if system is Windows 9x.
#
is_OS_WIN9X(){
  if [ "$DEBUG" = true ]; then set -x; fi
	if is_OS_NT; then
		return 1
	fi
	the_uname=""
	the_uname=`uname | grep -i windows_9`
  if [ ! -z "$the_uname" ]; then
    return 0
  else
    return 1
  fi

}

#----------------------------------------------------------
#	Used to determine if system is Windows 9x or NT
#
is_OS_WINDOWS()
{
	if is_OS_NT; then
		return 0
	fi
	
	if is_OS_WIN9X; then
		return 0
	fi
	return 1
}

#----------------------------------------------------------
#	Returns 0 if system is a UNIX box.
# 	Returns 1 otherwise.
#
is_OS_UNIX()
{
	if is_OS_WINDOWS; then
		return 1
	fi
	return 0
}

set_win_dir()
{
	#
	# Thuridion
	#
	if is_OS_WINDOWS; then
		THE_WIN_DIR=""
		if [ ! -z "$windir" ] ; then
			THE_WIN_DIR="`echo $windir | sed -e 's,\\\\,/,g'`"
		fi
	fi
}

#----------------------------------------------------------
# Returns a message.  Localize the strings within this function.
# Made as a function because this script may run on UNIX.
# Precede all $# items with a backslash character.
# Example \$1
# To put quote in a string do: '\"'
# Example: MSG_TEST="This is the parameter '\"'\$1'\"'."

get_localized_message()
{
	CFSNMP_DEBUG_RESULTSREDIRECTED="Results redirected to \$1."
	CFSNMP_CDS_FILE_USED="The file \$1 will be used to configure the SNMP adapter."
	CFSNMP_ADDED_OID_ENTRY="Added entry for \$1 to tecad_snmp.oid."
	CFSNMP_OID_ENTRY_EXISTS="Entry for \$1 already exists in tecad_snmp.oid."
	CFSNMP_NODE_DOES_NOT_HAVE_SNMP_BIN="The TEC SNMP bin directory could not be found.  It may not be installed.  Please enter the SNMP path when running this task."
	CFSNMP_NODE_DOES_NOT_HAVE_SNMP_ETC="The TEC SNMP etc directory could not be found.  It may not be installed.  Please enter the SNMP path when running this task."
	CFSNMP_NODE_DOES_NOT_HAVE_SNMP_ADAPTER="The TEC SNMP executable could not be found.  This node may not have the TEC snmp adapter installed."
	CFSNMP_STOPPING_SNMP_ADAPTER="Stopping the TEC SNMP adapter."
	CFSNMP_STARTING_SNMP_ADAPTER="Starting the TEC SNMP adapter."
	CFSNMP_FILE_NOT_FOUND="Could not find file \$1."
	CFSNMP_DISTRIBUTE_UTILS_PACKAGE="Insight Integration Plus Utilities do not exist on this node.  Distribute a Insight Integration File Package to this node."
	CFSNMP_FILE_PATH_IS="\$1 path is \$2."
	CFSNMP_COPYING_FILE="Copying file \$1 to \$2."
	CFSNMP_WRITING_CDS_ENTRIES="Writing the ins_evt.cds entries to \$1."
	CFSNMP_DEBUG_EXECUTING_SCRIPT="Executing \$1 \(\$2\)."

	cmd=$1
	shift
	string=`eval echo \\\$$cmd`
	if [ -z "$string" ]; then
		echo "get_message: $cmd not found in table lookup.  $cmd"
		params=""
		whiledone=0
		while [ $# -gt 0 -a $whiledone -eq 0 ]; do
			if [ ! -z "$1" ]; then
				params="$params $1"
			else
				echo $params
				whiledone=1
			fi
			shift
		done
	else
	  eval echo $string
	fi
}

get_message()
{
	cmd=$1
	shift
	get_localized_message $cmd "$1" "$2" "$3" "$4" "$5" "$6" "$7" "$8" "$9"
}

#----------------------------------------------------------
#	Write out an oid entry if it is not present in the file.
#  Parameter 1 is the name of the trap entry.
#  Parameter 2 is the full oid of the trap entry.
#
add_oid_entry()
{
	RC=0
	oid_entries=""
	converted_oid=""

	#
	# Need to convert the #.#.#... to #\.#\. for grep to be happy.
	# 
	converted_oid=`echo "$2" | sed 's/\./\\\\./g'`

	# Search for all of the entry names that match $1
	oid_entries=`grep -i "$1" "$TECSNMP_OID"`
	if [ "$DEBUG" = "true" -o -d "$DEBUGDIR" -o -f "$DEBUGDIR" ]; then
		echo "Converted oid to $converted_oid for use with grep."
	fi
	oid_check=""
	if [ ! -z "$oid_entries" ]; then
		# Here if there are entries.
		# So get a list that matches $1 and the oid number which is in $2.
		#
		oid_check=`echo "$oid_entries" | grep -i "$1.*$converted_oid" "$TECSNMP_OID"`
	fi

	if [ -z "$oid_check" ]; then	
		# Entry needs to be added.
		echo "\"$1\" \"$2\"" >> "$TECSNMP_OID"
		echo "`get_message CFSNMP_ADDED_OID_ENTRY $1`"
	else
		echo "`get_message CFSNMP_OID_ENTRY_EXISTS $1`"
	fi

}

#----------------------------------------------------------
#	Write out the oid entries.
#
add_oid_entries()
{
	#
	# Now write out each of the .oid entries:
	#
	#
	# Create an empty file if it does not exist.
	# Why doesn't it exist?
	#
	if [ ! -f "$TECSNMP_OID" ]; then
		echo " " > "$TECSNMP_OID"
	fi

	#
	# 2.0 added 137

      	add_oid_entry "sysDescr" "1.3.6.1.2.1.1.1"
      	add_oid_entry "sysObjectID" "1.3.6.1.2.1.1.2" 
      	add_oid_entry "sysContact" "1.3.6.1.2.1.1.4"
	add_oid_entry "sysName" "1.3.6.1.2.1.1.5"
      	add_oid_entry "sysLocation" "1.3.6.1.2.1.1.6"
      	add_oid_entry "ipAdEntAddr" "1.3.6.1.2.1.4.20.1.1"
	add_oid_entry "agSlotNumber" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.1.1.1.31"
	add_oid_entry "agRackId" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.1.1.1.37"
	add_oid_entry "agChassis" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.1.1.1.38"
	add_oid_entry "ipCurCfgGwIndex" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.3.1.2.4.1.1"
	add_oid_entry "ipCurCfgGwAddr" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.3.1.2.4.1.2"
	add_oid_entry "vrrpCurCfgVirtRtrIndx" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.3.1.6.3.1.1"
	add_oid_entry "vrrpCurCfgVirtRtrAddr" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.3.1.6.3.1.3"
	add_oid_entry "vrrpCurCfgIfIndx" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.3.1.6.6.1.1"
	add_oid_entry "vrrpCurCfgIfPasswd" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.3.1.6.6.1.3"
	add_oid_entry "bt2SwTrapDisplayString" "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7.1000"
	add_oid_entry "ssSubsysName" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.2"
	add_oid_entry "ssDiskName" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.28"
	add_oid_entry "ssPowerSupplyLocation" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.29"
      	add_oid_entry "ssFanLocation" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.30"
	add_oid_entry "ssCacheBatteryLocation" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.31"
	add_oid_entry "ssTemperatureSensorLocation" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.32"
	add_oid_entry "ssCabinetNumber" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.33"
	add_oid_entry "ssLunName" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.34"
	add_oid_entry "ssDiskPort" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.35"
	add_oid_entry "ssDiskTarget" "1.3.6.1.4.1.36.2.15.21.1.3.2.1.36"
	add_oid_entry "agHostName" "1.3.6.1.4.1.36.2.15.21.1.4"
	add_oid_entry "svrCluMemberIndex" "1.3.6.1.4.1.36.2.18.22.4.1.1.2.11.1.1"
	add_oid_entry "svrCluMemberName" "1.3.6.1.4.1.36.2.18.22.4.1.1.2.11.1.2"
	add_oid_entry "cpqSeCpuSlot" "1.3.6.1.4.1.232.1.2.2.1.1.2"
	add_oid_entry "cpqSeCpuSpeed" "1.3.6.1.4.1.232.1.2.2.1.1.4"
	add_oid_entry "cpqSeCpuExtSpeed" "1.3.6.1.4.1.232.1.2.2.1.1.7"
	add_oid_entry "cpqSeCpuSocketNumber" "1.3.6.1.4.1.232.1.2.2.1.1.9"
	add_oid_entry "cpqSeCpuCacheSize" "1.3.6.1.4.1.232.1.2.2.3.1.3"
      	add_oid_entry "cpqSePciSlotBoardName" "1.3.6.1.4.1.232.1.2.13.1.1.5"
	add_oid_entry "cpqSePCCardSlotIndex" "1.3.6.1.4.1.232.1.2.14.1.1.1"
	add_oid_entry "cpqSePCCardDeviceInfo" "1.3.6.1.4.1.232.1.2.14.1.1.10"
	add_oid_entry "cpqSePCCardProductInfo" "1.3.6.1.4.1.232.1.2.14.1.1.11"
	add_oid_entry "cpqSiMemErrorIndex" "1.3.6.1.4.1.232.2.2.4.14"
	add_oid_entry "cpqSiMemConfigChangeData" "1.3.6.1.4.1.232.2.2.4.16"
	add_oid_entry "cpqSiServerSystemId" "1.3.6.1.4.1.232.2.2.4.17" 
	add_oid_entry "cpqSiMemModuleIndex" "1.3.6.1.4.1.232.2.2.4.5.1.2"
      	add_oid_entry "cpqSiMemModuleSize" "1.3.6.1.4.1.232.2.2.4.5.1.3"
	add_oid_entry "cpqSiMonitorIndex" "1.3.6.1.4.1.232.2.2.8.2.1.1"
	add_oid_entry "cpqSiHotPlugSlotChassis" "1.3.6.1.4.1.232.2.2.9.4.1.1"
	add_oid_entry "cpqSiHotPlugSlotIndex" "1.3.6.1.4.1.232.2.2.9.4.1.2"
	add_oid_entry "cpqSiHotPlugSlotErrorStatus" "1.3.6.1.4.1.232.2.2.9.4.1.6"
	add_oid_entry "cpqSiSysBatteryIndex" "1.3.6.1.4.1.232.2.2.10.2.1.1"
	add_oid_entry "cpqSiSysBatterySerialNum" "1.3.6.1.4.1.232.2.2.10.2.1.3"
	add_oid_entry "cpqDaCntlrIndex" "1.3.6.1.4.1.232.3.2.2.1.1.1"
	add_oid_entry "cpqDaCntlrModel" "1.3.6.1.4.1.232.3.2.2.1.1.2"
	add_oid_entry "cpqDaCntlrFWRev" "1.3.6.1.4.1.232.3.2.2.1.1.3"
	add_oid_entry "cpqDaCntlrSlot" "1.3.6.1.4.1.232.3.2.2.1.1.5"
	add_oid_entry "cpqDaCntlrPartnerSlot" "1.3.6.1.4.1.232.3.2.2.1.1.8"
	add_oid_entry "cpqDaCntlrBoardStatus" "1.3.6.1.4.1.232.3.2.2.1.1.10"
	add_oid_entry "cpqDaCntlrSerialNumber" "1.3.6.1.4.1.232.3.2.2.1.1.15"
	add_oid_entry "cpqDaCntlrHwLocation" "1.3.6.1.4.1.232.3.2.2.1.1.20"
	add_oid_entry "cpqDaAccelTable" "1.3.6.1.4.1.232.3.2.2.2"
	add_oid_entry "cpqDaAccelCntlrIndex" "1.3.6.1.4.1.232.3.2.2.2.1.1"
	add_oid_entry "cpqDaAccelStatus" "1.3.6.1.4.1.232.3.2.2.2.1.2"
	add_oid_entry "cpqDaAccelBadData" "1.3.6.1.4.1.232.3.2.2.2.1.4"
	add_oid_entry "cpqDaAccelErrCode" "1.3.6.1.4.1.232.3.2.2.2.1.5"
	add_oid_entry "cpqDaAccelBattery" "1.3.6.1.4.1.232.3.2.2.2.1.6"
	add_oid_entry "cpqDaAccelSerialNumber" "1.3.6.1.4.1.232.3.2.2.2.1.11"
	add_oid_entry "cpqDaAccelTotalMemory" "1.3.6.1.4.1.232.3.2.2.2.1.12"
	add_oid_entry "cpqDaLogDrvCntlrIndex" "1.3.6.1.4.1.232.3.2.3.1.1.1"
	add_oid_entry "cpqDaLogDrvIndex" "1.3.6.1.4.1.232.3.2.3.1.1.2"
	add_oid_entry "cpqDaLogDrvStatus" "1.3.6.1.4.1.232.3.2.3.1.1.4"
	add_oid_entry "cpqDaSpareCntlrIndex" "1.3.6.1.4.1.232.3.2.4.1.1.1"
	add_oid_entry "cpqDaSparePhyDrvIndex" "1.3.6.1.4.1.232.3.2.4.1.1.2"
	add_oid_entry "cpqDaSpareStatus" "1.3.6.1.4.1.232.3.2.4.1.1.3"
	add_oid_entry "cpqDaSpareBusNumber" "1.3.6.1.4.1.232.3.2.4.1.1.7"
	add_oid_entry "cpqDaSpareBay" "1.3.6.1.4.1.232.3.2.4.1.1.8"
	add_oid_entry "cpqDaSpareLocationString" "1.3.6.1.4.1.232.3.2.4.1.1.12"
	add_oid_entry "cpqDaPhyDrvCntlrIndex" "1.3.6.1.4.1.232.3.2.5.1.1.1"
	add_oid_entry "cpqDaPhyDrvIndex" "1.3.6.1.4.1.232.3.2.5.1.1.2"
	add_oid_entry "cpqDaPhyDrvModel" "1.3.6.1.4.1.232.3.2.5.1.1.3"
	add_oid_entry "cpqDaPhyDrvFWRev" "1.3.6.1.4.1.232.3.2.5.1.1.4"
	add_oid_entry "cpqDaPhyDrvBay" "1.3.6.1.4.1.232.3.2.5.1.1.5"
	add_oid_entry "cpqDaPhyDrvStatus" "1.3.6.1.4.1.232.3.2.5.1.1.6"
	add_oid_entry "cpqDaPhyDrvThreshPassed" "1.3.6.1.4.1.232.3.2.5.1.1.35"
	add_oid_entry "cpqDaPhyDrvBusNumber" "1.3.6.1.4.1.232.3.2.5.1.1.50"
	add_oid_entry "cpqDaPhyDrvSerialNum" "1.3.6.1.4.1.232.3.2.5.1.1.51"
	add_oid_entry "cpqDaPhyDrvFailureCode" "1.3.6.1.4.1.232.3.2.5.1.1.55"
	add_oid_entry "cpqDaPhyDrvType" "1.3.6.1.4.1.232.3.2.5.1.1.60"
	add_oid_entry "cpqDaPhyDrvLocationString" "1.3.6.1.4.1.232.3.2.5.1.1.64"
	add_oid_entry "cpqDaTapeDrvCntlrIndex" "1.3.6.1.4.1.232.3.2.9.1.1.1"
	add_oid_entry "cpqDaTapeDrvBusIndex" "1.3.6.1.4.1.232.3.2.9.1.1.2"
	add_oid_entry "cpqDaTapeDrvScsiIdIndex" "1.3.6.1.4.1.232.3.2.9.1.1.3"
	add_oid_entry "cpqDaTapeDrvLunIndex" "1.3.6.1.4.1.232.3.2.9.1.1.4"
      	add_oid_entry "cpqDaTapeDrvName" "1.3.6.1.4.1.232.3.2.9.1.1.5"
      	add_oid_entry "cpqDaTapeDrvSerialNumber" "1.3.6.1.4.1.232.3.2.9.1.1.6"
      	add_oid_entry "cpqDaTapeDrvFwRev" "1.3.6.1.4.1.232.3.2.9.1.1.7"
	add_oid_entry "cpqDaTapeDrvStatus" "1.3.6.1.4.1.232.3.2.9.1.1.8"
      	add_oid_entry "cpqDaTapeDrvCondition" "1.3.6.1.4.1.232.3.2.9.1.1.9"
      	add_oid_entry "cpqDaTapeDrvFwSubtype" "1.3.6.1.4.1.232.3.2.9.1.1.10"
      	add_oid_entry "cpqDaTapeDrvType" "1.3.6.1.4.1.232.3.2.9.1.1.11"
      	add_oid_entry "cpqDaTapeDrvCleanReq" "1.3.6.1.4.1.232.3.2.9.1.1.12"
      	add_oid_entry "cpqDaTapeDrvCleanTapeRepl" "1.3.6.1.4.1.232.3.2.9.1.1.13"
      	add_oid_entry "cpqDaTapeDrvCleanTapeCount" "1.3.6.1.4.1.232.3.2.9.1.1.14"
      	add_oid_entry "cpqDaTapeDrvLibraryDrive" "1.3.6.1.4.1.232.3.2.9.1.1.15"
      	add_oid_entry "cpqDaTapeDrvMagSize" "1.3.6.1.4.1.232.3.2.9.1.1.16"
      	add_oid_entry "cpqDaTapeDrvHotPlug" "1.3.6.1.4.1.232.3.2.9.1.1.17"
      	add_oid_entry "cpqDaTapeDrvPlacement" "1.3.6.1.4.1.232.3.2.9.1.1.18"
      	add_oid_entry "cpqDaTapeDrvCurrentWidth" "1.3.6.1.4.1.232.3.2.9.1.1.19"
      	add_oid_entry "cpqDaTapeDrvCurrentSpeed" "1.3.6.1.4.1.232.3.2.9.1.1.20"
	add_oid_entry "cpqDaTapeLibraryCntlrIndex" "1.3.6.1.4.1.232.3.2.11.1.1.1"
	add_oid_entry "cpqDaTapeLibraryScsiBus" "1.3.6.1.4.1.232.3.2.11.1.1.2"
	add_oid_entry "cpqDaTapeLibraryScsiTarget" "1.3.6.1.4.1.232.3.2.11.1.1.3"
	add_oid_entry "cpqDaTapeLibraryScsiLun" "1.3.6.1.4.1.232.3.2.11.1.1.4"
      	add_oid_entry "cpqDaTapeLibrarySerialNumber" "1.3.6.1.4.1.232.3.2.11.1.1.5"
      	add_oid_entry "cpqDaTapeLibraryModel" "1.3.6.1.4.1.232.3.2.11.1.1.6"
      	add_oid_entry "cpqDaTapeLibraryFWRev" "1.3.6.1.4.1.232.3.2.11.1.1.7"
	add_oid_entry "cpqDaTapeLibraryStatus" "1.3.6.1.4.1.232.3.2.11.1.1.8"
	add_oid_entry "cpqDaTapeLibraryDoorStatus" "1.3.6.1.4.1.232.3.2.11.1.1.9"
      	add_oid_entry "cpqDaTapeLibraryCondition" "1.3.6.1.4.1.232.3.2.11.1.1.10"
      	add_oid_entry "cpqDaTapeLibraryOverallCondition" "1.3.6.1.4.1.232.3.2.11.1.1.11"
      	add_oid_entry "cpqDaTapeLibraryLastError" "1.3.6.1.4.1.232.3.2.11.1.1.12"
      	add_oid_entry "cpqDaTapeLibraryStatHours" "1.3.6.1.4.1.232.3.2.11.1.1.13"
      	add_oid_entry "cpqDaTapeLibraryStatMoves" "1.3.6.1.4.1.232.3.2.11.1.1.14"
      	add_oid_entry "cpqDaTapeLibraryDriveList" "1.3.6.1.4.1.232.3.2.11.1.1.15"
      	add_oid_entry "cpqDaTapeLibraryCurrentWidth" "1.3.6.1.4.1.232.3.2.11.1.1.16"
      	add_oid_entry "cpqDaTapeLibraryCurrentSpeed" "1.3.6.1.4.1.232.3.2.11.1.1.17"
	add_oid_entry "cpqScsiCntlrStatus" "1.3.6.1.4.1.232.5.2.2.1.1.7"
	add_oid_entry "cpqScsiLogDrvCntlrIndex" "1.3.6.1.4.1.232.5.2.3.1.1.1"
	add_oid_entry "cpqScsiLogDrvBusIndex" "1.3.6.1.4.1.232.5.2.3.1.1.2"
	add_oid_entry "cpqScsiLogDrvIndex" "1.3.6.1.4.1.232.5.2.3.1.1.3"
	add_oid_entry "cpqScsiLogDrvStatus" "1.3.6.1.4.1.232.5.2.3.1.1.5"
	add_oid_entry "cpqScsiLogDrvOsName" "1.3.6.1.4.1.232.5.2.3.1.1.12"
	add_oid_entry "cpqScsiPhyDrvCntlrIndex" "1.3.6.1.4.1.232.5.2.4.1.1.1"
	add_oid_entry "cpqScsiPhyDrvBusIndex" "1.3.6.1.4.1.232.5.2.4.1.1.2"
	add_oid_entry "cpqScsiPhyDrvIndex" "1.3.6.1.4.1.232.5.2.4.1.1.3"
	add_oid_entry "cpqScsiPhyDrvModel" "1.3.6.1.4.1.232.5.2.4.1.1.4"
	add_oid_entry "cpqScsiPhyDrvFWRev" "1.3.6.1.4.1.232.5.2.4.1.1.5"
	add_oid_entry "cpqScsiPhyDrvVendor" "1.3.6.1.4.1.232.5.2.4.1.1.6"
	add_oid_entry "cpqScsiPhyDrvStatus" "1.3.6.1.4.1.232.5.2.4.1.1.9"
	add_oid_entry "cpqScsiPhyDrvSerialNum" "1.3.6.1.4.1.232.5.2.4.1.1.30"
      	add_oid_entry "cpqScsiPhyDrvOsName" "1.3.6.1.4.1.232.5.2.4.1.1.37"
	add_oid_entry "cpqCdLibraryCntlrIndex" "1.3.6.1.4.1.232.5.2.6.2.1.1"
	add_oid_entry "cpqCdLibraryBusIndex" "1.3.6.1.4.1.232.5.2.6.2.1.2"
	add_oid_entry "cpqCdLibraryScsiIdIndex" "1.3.6.1.4.1.232.5.2.6.2.1.3"
	add_oid_entry "cpqCdLibraryStatus" "1.3.6.1.4.1.232.5.2.6.2.1.6"
	add_oid_entry "cpqTapePhyDrvCntlrIndex" "1.3.6.1.4.1.232.5.4.1.1.1.1"
	add_oid_entry "cpqTapePhyDrvBusIndex" "1.3.6.1.4.1.232.5.4.1.1.1.2"
	add_oid_entry "cpqTapePhyDrvScsiIdIndex" "1.3.6.1.4.1.232.5.4.1.1.1.3"
      	add_oid_entry "cpqTapePhyDrvLunIndex" "1.3.6.1.4.1.232.5.4.1.1.1.4"
	add_oid_entry "cpqTapePhyDrvCondition" "1.3.6.1.4.1.232.5.4.1.1.1.6"
      	add_oid_entry "cpqTapePhyDrvSerialNumber" "1.3.6.1.4.1.232.5.4.1.1.1.8"
      	add_oid_entry "cpqTapePhyDrvName" "1.3.6.1.4.1.232.5.4.1.1.1.12"
      	add_oid_entry "cpqTapePhyDrvFwRev" "1.3.6.1.4.1.232.5.4.1.1.1.14"
	add_oid_entry "cpqTapePhyDrvStatus" "1.3.6.1.4.1.232.5.4.1.1.1.15"
      	add_oid_entry "cpqTapeLibraryCntlrIndex" "1.3.6.1.4.1.232.5.4.3.1.1.1"
      	add_oid_entry "cpqTapeLibraryBusIndex" "1.3.6.1.4.1.232.5.4.3.1.1.2"
      	add_oid_entry "cpqTapeLibraryScsiIdIndex" "1.3.6.1.4.1.232.5.4.3.1.1.3"
      	add_oid_entry "cpqTapeLibraryLunIndex" "1.3.6.1.4.1.232.5.4.3.1.1.4"
      	add_oid_entry "cpqTapeLibraryCondition" "1.3.6.1.4.1.232.5.4.3.1.1.5"
      	add_oid_entry "cpqTapeLibraryStatus" "1.3.6.1.4.1.232.5.4.3.1.1.6"
      	add_oid_entry "cpqTapeLibraryDoorStatus" "1.3.6.1.4.1.232.5.4.3.1.1.7"
      	add_oid_entry "cpqTapeLibraryStatHours" "1.3.6.1.4.1.232.5.4.3.1.1.8"
      	add_oid_entry "cpqTapeLibraryStatMoves" "1.3.6.1.4.1.232.5.4.3.1.1.9"
      	add_oid_entry "cpqTapeLibraryName" "1.3.6.1.4.1.232.5.4.3.1.1.10"
	add_oid_entry "cpqTapeLibrarySerialNumber" "1.3.6.1.4.1.232.5.4.3.1.1.11"
      	add_oid_entry "cpqTapeLibraryDriveList" "1.3.6.1.4.1.232.5.4.3.1.1.12"
      	add_oid_entry "cpqTapeLibraryState" "1.3.6.1.4.1.232.5.4.3.1.1.13"
      	add_oid_entry "cpqTapeLibraryTemperature" "1.3.6.1.4.1.232.5.4.3.1.1.14"
      	add_oid_entry "cpqTapeLibraryRedundancy" "1.3.6.1.4.1.232.5.4.3.1.1.15"
      	add_oid_entry "cpqTapeLibraryHotSwap" "1.3.6.1.4.1.232.5.4.3.1.1.16"
      	add_oid_entry "cpqTapeLibraryFwRev" "1.3.6.1.4.1.232.5.4.3.1.1.17"
	add_oid_entry "cpqSasHbaHwLocation" "1.3.6.1.4.1.232.5.5.1.1.1.2"
	add_oid_entry "cpqSasPhyDrvHbaIndex" "1.3.6.1.4.1.232.5.5.2.1.1.1"
	add_oid_entry "cpqSasPhyDrvIndex" "1.3.6.1.4.1.232.5.5.2.1.1.2"
	add_oid_entry "cpqSasPhyDrvLocationString" "1.3.6.1.4.1.232.5.5.2.1.1.3"
	add_oid_entry "cpqSasPhyDrvModel" "1.3.6.1.4.1.232.5.5.2.1.1.4"
	add_oid_entry "cpqSasPhyDrvStatus" "1.3.6.1.4.1.232.5.5.2.1.1.5"
	add_oid_entry "cpqSasPhyDrvFWRev" "1.3.6.1.4.1.232.5.5.2.1.1.7"
	add_oid_entry "cpqSasPhyDrvSerialNumber" "1.3.6.1.4.1.232.5.5.2.1.1.10"
	add_oid_entry "cpqSasPhyDrvType" "1.3.6.1.4.1.232.5.5.2.1.1.16"
	add_oid_entry "cpqSasPhyDrvSasAddress" "1.3.6.1.4.1.232.5.5.2.1.1.17"
	add_oid_entry "cpqSasLogDrvHbaIndex" "1.3.6.1.4.1.232.5.5.3.1.1.1"
	add_oid_entry "cpqSasLogDrvIndex" "1.3.6.1.4.1.232.5.5.3.1.1.2"
	add_oid_entry "cpqSasLogDrvStatus" "1.3.6.1.4.1.232.5.5.3.1.1.4"
	add_oid_entry "cpqSasLogDrvOsName" "1.3.6.1.4.1.232.5.5.3.1.1.11"
	add_oid_entry "cpqHeCorrMemLogStatus" "1.3.6.1.4.1.232.6.2.3.1"
	add_oid_entry "cpqHeCorrMemTotalErrs" "1.3.6.1.4.1.232.6.2.3.3"
	add_oid_entry "cpqHeThermalDegradedAction" "1.3.6.1.4.1.232.6.2.6.2"
	add_oid_entry "cpqHeFltTolFanChassis" "1.3.6.1.4.1.232.6.2.6.7.1.1"
	add_oid_entry "cpqHeFltTolFanIndex" "1.3.6.1.4.1.232.6.2.6.7.1.2"
	add_oid_entry "cpqHeTemperatureChassis" "1.3.6.1.4.1.232.6.2.6.8.1.1"
	add_oid_entry "cpqHeTemperatureLocale" "1.3.6.1.4.1.232.6.2.6.8.1.3"
	add_oid_entry "cpqHeFltTolPowerSupplyChassis" "1.3.6.1.4.1.232.6.2.9.3.1.1"
	add_oid_entry "cpqHeFltTolPowerSupplyBay" "1.3.6.1.4.1.232.6.2.9.3.1.2"
	add_oid_entry "cpqHeFltTolPowerSupplyStatus" "1.3.6.1.4.1.232.6.2.9.3.1.5"   
	add_oid_entry "cpqHeFltTolPowerSupplyModel" "1.3.6.1.4.1.232.6.2.9.3.1.10"  
	add_oid_entry "cpqHeFltTolPowerSupplySerialNumber" "1.3.6.1.4.1.232.6.2.9.3.1.11"  
	add_oid_entry "cpqHeFltTolPowerSupplyAutoRev" "1.3.6.1.4.1.232.6.2.9.3.1.12" 
	add_oid_entry "cpqHeFltTolPowerSupplyFirmwareRev" "1.3.6.1.4.1.232.6.2.9.3.1.14" 
	add_oid_entry "cpqHeFltTolPowerSupplySparePartNum" "1.3.6.1.4.1.232.6.2.9.3.1.16"  
	add_oid_entry "cpqHeEventLogEntryNumber" "1.3.6.1.4.1.232.6.2.11.3.1.1"
	add_oid_entry "cpqHeEventLogEntrySeverity" "1.3.6.1.4.1.232.6.2.11.3.1.2"
	add_oid_entry "cpqHeEventLogUpdateTime" "1.3.6.1.4.1.232.6.2.11.3.1.7"
	add_oid_entry "cpqHeEventLogErrorDesc" "1.3.6.1.4.1.232.6.2.11.3.1.8"
	add_oid_entry "cpqHePwrConvChassis" "1.3.6.1.4.1.232.6.2.13.3.1.1"
	add_oid_entry "cpqHePwrConvSlot" "1.3.6.1.4.1.232.6.2.13.3.1.4"
	add_oid_entry "cpqHePwrConvSocket" "1.3.6.1.4.1.232.6.2.13.3.1.5"
      	add_oid_entry "cpqHeResMemBoardSlotIndex" "1.3.6.1.4.1.232.6.2.14.10.1.1"
	add_oid_entry "cpqHeResMemBoardIndex" "1.3.6.1.4.1.232.6.2.14.11.1.1"
	add_oid_entry "cpqHeResMemModuleIndex" "1.3.6.1.4.1.232.6.2.14.11.1.2"
	add_oid_entry "cpqHeResMemModuleSparePartNo" "1.3.6.1.4.1.232.6.2.14.11.1.3"
	add_oid_entry "cpqSsBoxCntlrIndex" "1.3.6.1.4.1.232.8.2.1.1.1"
	add_oid_entry "cpqSsBoxBusIndex" "1.3.6.1.4.1.232.8.2.1.1.2"
	add_oid_entry "cpqSsBoxModel" "1.3.6.1.4.1.232.8.2.1.1.4"
	add_oid_entry "cpqSsBoxVendor" "1.3.6.1.4.1.232.8.2.1.1.6"	
	add_oid_entry "cpqSsBoxFanStatus" "1.3.6.1.4.1.232.8.2.1.1.7"
	add_oid_entry "cpqSsBoxTempStatus" "1.3.6.1.4.1.232.8.2.1.1.9"
	add_oid_entry "cpqSsBoxSidePanelStatus" "1.3.6.1.4.1.232.8.2.1.1.10"
	add_oid_entry "cpqSsBoxFltTolPwrSupplyStatus" "1.3.6.1.4.1.232.8.2.1.1.11"
	add_oid_entry "cpqSsBoxSerialNumber" "1.3.6.1.4.1.232.8.2.1.1.17"
	add_oid_entry "cpqSsBoxCntlrHwLocation" "1.3.6.1.4.1.232.8.2.1.1.18"
	add_oid_entry "cpqSsBoxLocationString" "1.3.6.1.4.1.232.8.2.1.1.23"
      	add_oid_entry "cpqSsChassisIndex" "1.3.6.1.4.1.232.8.2.2.1.1.1"
	add_oid_entry "cpqSsChassisName" "1.3.6.1.4.1.232.8.2.2.1.1.4"
	add_oid_entry "cpqSsChassisTime" "1.3.6.1.4.1.232.8.2.2.1.1.18"
      	add_oid_entry "cpqSsChassisRsoStatus" "1.3.6.1.4.1.232.8.2.2.1.1.22"
	add_oid_entry "cpqSsPowerSupplyBay" "1.3.6.1.4.1.232.8.2.2.3.1.3"
	add_oid_entry "cpqSsPowerSupplyStatus" "1.3.6.1.4.1.232.8.2.2.3.1.4"
	add_oid_entry "cpqSsPowerSupplyUpsStatus" "1.3.6.1.4.1.232.8.2.2.3.1.5"
	add_oid_entry "cpqSsPowerSupplySerialNumber" "1.3.6.1.4.1.232.8.2.2.3.1.7"
	add_oid_entry "cpqSsPowerSupplyBoardRevision" "1.3.6.1.4.1.232.8.2.2.3.1.8"
	add_oid_entry "cpqSsPowerSupplyFirmwareRevision" "1.3.6.1.4.1.232.8.2.2.3.1.9"
	add_oid_entry "cpqSsFanModuleStatus" "1.3.6.1.4.1.232.8.2.2.4.1.3"
	add_oid_entry "cpqSsFanModuleLocation" "1.3.6.1.4.1.232.8.2.2.4.1.5"
	add_oid_entry "cpqSsFanModuleSerialNumber" "1.3.6.1.4.1.232.8.2.2.4.1.6"
	add_oid_entry "cpqSsFanModuleBoardRevision" "1.3.6.1.4.1.232.8.2.2.4.1.7"
	add_oid_entry "cpqSsTempSensorStatus" "1.3.6.1.4.1.232.8.2.2.5.1.3"
	add_oid_entry "cpqSsTempSensorLocation" "1.3.6.1.4.1.232.8.2.2.5.1.5"
	add_oid_entry "cpqSsTempSensorCurrentValue" "1.3.6.1.4.1.232.8.2.2.5.1.6"
	add_oid_entry "cpqSsBackplaneIndex" "1.3.6.1.4.1.232.8.2.2.6.1.2"
	add_oid_entry "cpqSsBackplaneVendor" "1.3.6.1.4.1.232.8.2.2.6.1.8"
	add_oid_entry "cpqSsBackplaneModel" "1.3.6.1.4.1.232.8.2.2.6.1.9"
	add_oid_entry "cpqSsBackplaneFanStatus" "1.3.6.1.4.1.232.8.2.2.6.1.10"
	add_oid_entry "cpqSsBackplaneTempStatus" "1.3.6.1.4.1.232.8.2.2.6.1.11"
	add_oid_entry "cpqSsBackplaneFtpsStatus" "1.3.6.1.4.1.232.8.2.2.6.1.12"
	add_oid_entry "cpqSsBackplaneSerialNumber" "1.3.6.1.4.1.232.8.2.2.6.1.13"	
	add_oid_entry "cpqSm2CntlrSelfTestErrors" "1.3.6.1.4.1.232.9.2.2.9"
	add_oid_entry "cpqSm2CntlrBadLoginAttemptsThresh" "1.3.6.1.4.1.232.9.2.2.14"
	add_oid_entry "cpqMeAlarmVariable" "1.3.6.1.4.1.232.10.2.2.2.1.3"
	add_oid_entry "cpqMeAlarmSampleType" "1.3.6.1.4.1.232.10.2.2.2.1.4"
	add_oid_entry "cpqMeAlarmValue" "1.3.6.1.4.1.232.10.2.2.2.1.5"
	add_oid_entry "cpqMeAlarmRisingThreshold" "1.3.6.1.4.1.232.10.2.2.2.1.7"
	add_oid_entry "cpqMeAlarmFallingThreshold" "1.3.6.1.4.1.232.10.2.2.2.1.8"
	add_oid_entry "cpqMeAlarmOwner" "1.3.6.1.4.1.232.10.2.2.2.1.10"
	add_oid_entry "cpqMeAlarmSeverity" "1.3.6.1.4.1.232.10.2.2.2.1.12"
	add_oid_entry "cpqMeAlarmExtendedDescription" "1.3.6.1.4.1.232.10.2.2.2.1.13"
	add_oid_entry "cpqHoIfPhysMapSlot" "1.3.6.1.4.1.232.11.2.5.1.1.2"
	add_oid_entry "cpqHoIfPhysMapSlot1" "1.3.6.1.4.1.232.11.2.5.1.1.2.1"
	add_oid_entry "cpqHoIfPhysMapSlot2" "1.3.6.1.4.1.232.11.2.5.1.1.2.2"
	add_oid_entry "cpqHoIfPhysMapPort" "1.3.6.1.4.1.232.11.2.5.1.1.7"
	add_oid_entry "cpqHoIfPhysMapPort1" "1.3.6.1.4.1.232.11.2.5.1.1.7.1"
	add_oid_entry "cpqHoIfPhysMapPort2" "1.3.6.1.4.1.232.11.2.5.1.1.7.2"
	add_oid_entry "cpqHoSwRunningTrapDesc" "1.3.6.1.4.1.232.11.2.6.2"
	add_oid_entry "cpqHoGenericData" "1.3.6.1.4.1.232.11.2.8.1"
	add_oid_entry "cpqHoCriticalSoftwareUpdateData" "1.3.6.1.4.1.232.11.2.8.2"
	add_oid_entry "cpqHoSwPerfAppErrorDesc" "1.3.6.1.4.1.232.11.2.9.1"
	add_oid_entry "cpqUpsEstimatedBatteryLife" "1.3.6.1.4.1.232.12.2.2.3"
	add_oid_entry "cpqUpsAlarm" "1.3.6.1.4.1.232.12.2.2.6"
	add_oid_entry "cpqIdeIdentIndex" "1.3.6.1.4.1.232.14.2.2.1.1.1"
	add_oid_entry "cpqIdeControllerModel" "1.3.6.1.4.1.232.14.2.3.1.1.3"
	add_oid_entry "cpqIdeControllerSlot" "1.3.6.1.4.1.232.14.2.3.1.1.5"
	add_oid_entry "cpqIdeAtaDiskControllerIndex" "1.3.6.1.4.1.232.14.2.4.1.1.1"
	add_oid_entry "cpqIdeAtaDiskIndex" "1.3.6.1.4.1.232.14.2.4.1.1.2"
	add_oid_entry "cpqIdeAtaDiskModel" "1.3.6.1.4.1.232.14.2.4.1.1.3"
	add_oid_entry "cpqIdeAtaDiskFwRev" "1.3.6.1.4.1.232.14.2.4.1.1.4"
	add_oid_entry "cpqIdeAtaDiskSerialNumber" "1.3.6.1.4.1.232.14.2.4.1.1.5"
	add_oid_entry "cpqIdeAtaDiskStatus" "1.3.6.1.4.1.232.14.2.4.1.1.6"
	add_oid_entry "cpqIdeAtaDiskChannel" "1.3.6.1.4.1.232.14.2.4.1.1.11"
	add_oid_entry "cpqIdeAtaDiskNumber" "1.3.6.1.4.1.232.14.2.4.1.1.12"
	add_oid_entry "cpqIdeLogicalDriveControllerIndex" "1.3.6.1.4.1.232.14.2.6.1.1.1"
	add_oid_entry "cpqIdeLogicalDriveIndex" "1.3.6.1.4.1.232.14.2.6.1.1.2"
	add_oid_entry "cpqIdeLogicalDriveStatus" "1.3.6.1.4.1.232.14.2.6.1.1.5"	
	add_oid_entry "cpqClusterNodeName" "1.3.6.1.4.1.232.15.2.3.1.1.2"
	add_oid_entry "cpqClusterResourceName" "1.3.6.1.4.1.232.15.2.4.1.1.2"
	add_oid_entry "cpqClusterNetworkName" "1.3.6.1.4.1.232.15.2.6.1.1.2"
	add_oid_entry "cpqFcaCntlrBoxIoSlot" "1.3.6.1.4.1.232.16.2.2.1.1.2"
	add_oid_entry "cpqFcaCntlrModel" "1.3.6.1.4.1.232.16.2.2.1.1.3"
	add_oid_entry "cpqFcaCntlrStatus" "1.3.6.1.4.1.232.16.2.2.1.1.5"
	add_oid_entry "cpqFcaCntlrSerialNumber" "1.3.6.1.4.1.232.16.2.2.1.1.9"
	add_oid_entry "cpqFcaAccelBoxIoSlot" "1.3.6.1.4.1.232.16.2.2.2.1.2"
	add_oid_entry "cpqFcaAccelStatus" "1.3.6.1.4.1.232.16.2.2.2.1.3"
	add_oid_entry "cpqFcaAccelErrCode" "1.3.6.1.4.1.232.16.2.2.2.1.5"
	add_oid_entry "cpqFcaAccelSerialNumber" "1.3.6.1.4.1.232.16.2.2.2.1.12"
	add_oid_entry "cpqFcaAccelTotalMemory" "1.3.6.1.4.1.232.16.2.2.2.1.13"
      	add_oid_entry "cpqFcaLogDrvBoxIndex" "1.3.6.1.4.1.232.16.2.3.1.1.1"
	add_oid_entry "cpqFcaLogDrvIndex" "1.3.6.1.4.1.232.16.2.3.1.1.2"
      	add_oid_entry "cpqFcaLogDrvFaultTol" "1.3.6.1.4.1.232.16.2.3.1.1.3"
	add_oid_entry "cpqFcaLogDrvStatus" "1.3.6.1.4.1.232.16.2.3.1.1.4"
      	add_oid_entry "cpqFcaLogDrvSize" "1.3.6.1.4.1.232.16.2.3.1.1.9"
      	add_oid_entry "cpqFcaLogDrvOsName" "1.3.6.1.4.1.232.16.2.3.1.1.13"
	add_oid_entry "cpqFcaSpareStatus" "1.3.6.1.4.1.232.16.2.4.1.1.3"
	add_oid_entry "cpqFcaSpareBusNumber" "1.3.6.1.4.1.232.16.2.4.1.1.7"
	add_oid_entry "cpqFcaSpareBay" "1.3.6.1.4.1.232.16.2.4.1.1.8"
	add_oid_entry "cpqFcaPhyDrvModel" "1.3.6.1.4.1.232.16.2.5.1.1.3"
	add_oid_entry "cpqFcaPhyDrvFWRev" "1.3.6.1.4.1.232.16.2.5.1.1.4"
	add_oid_entry "cpqFcaPhyDrvBay" "1.3.6.1.4.1.232.16.2.5.1.1.5"
	add_oid_entry "cpqFcaPhyDrvStatus" "1.3.6.1.4.1.232.16.2.5.1.1.6"
	add_oid_entry "cpqFcaPhyDrvBusNumber" "1.3.6.1.4.1.232.16.2.5.1.1.42"
	add_oid_entry "cpqFcaPhyDrvSerialNum" "1.3.6.1.4.1.232.16.2.5.1.1.43"
	add_oid_entry "cpqFcaPhyDrvFailureCode" "1.3.6.1.4.1.232.16.2.5.1.1.47"
	add_oid_entry "cpqFcaHostCntlrIndex" "1.3.6.1.4.1.232.16.2.7.1.1.1"
	add_oid_entry "cpqFcaHostCntlrSlot" "1.3.6.1.4.1.232.16.2.7.1.1.2"
	add_oid_entry "cpqFcaHostCntlrModel" "1.3.6.1.4.1.232.16.2.7.1.1.3"
	add_oid_entry "cpqFcaHostCntlrStatus" "1.3.6.1.4.1.232.16.2.7.1.1.4"
	add_oid_entry "cpqFcaHostCntlrWorldWideName" "1.3.6.1.4.1.232.16.2.7.1.1.6"
	add_oid_entry "cpqFcaHostCntlrSerialNumber" "1.3.6.1.4.1.232.16.2.7.1.1.10"
	add_oid_entry "cpqFcaHostCntlrHwLocation" "1.3.6.1.4.1.232.16.2.7.1.1.11"
	add_oid_entry "cpqFcaHostCntlrWorldWidePortName" "1.3.6.1.4.1.232.16.2.7.1.1.12"
	add_oid_entry "cpqFcTapeCntlrStatus" "1.3.6.1.4.1.232.16.3.1.1.1.2"
	add_oid_entry "cpqFcTapeCntlrWWN" "1.3.6.1.4.1.232.16.3.1.1.1.5"
      	add_oid_entry "cpqFcTapeLibraryCntlrIndex" "1.3.6.1.4.1.232.16.3.2.1.1.1"
	add_oid_entry "cpqFcTapeLibraryScsiBus" "1.3.6.1.4.1.232.16.3.2.1.1.2"
	add_oid_entry "cpqFcTapeLibraryScsiTarget" "1.3.6.1.4.1.232.16.3.2.1.1.3"
	add_oid_entry "cpqFcTapeLibraryScsiLun" "1.3.6.1.4.1.232.16.3.2.1.1.4"
      	add_oid_entry "cpqFcTapeLibrarySerialNumber" "1.3.6.1.4.1.232.16.3.2.1.1.5"
      	add_oid_entry "cpqFcTapeLibraryModel" "1.3.6.1.4.1.232.16.3.2.1.1.6"
      	add_oid_entry "cpqFcTapeLibraryFWRev" "1.3.6.1.4.1.232.16.3.2.1.1.7"
	add_oid_entry "cpqFcTapeLibraryStatus" "1.3.6.1.4.1.232.16.3.2.1.1.8"
	add_oid_entry "cpqFcTapeLibraryDoorStatus" "1.3.6.1.4.1.232.16.3.2.1.1.9"
      	add_oid_entry "cpqFcTapeLibraryCondition" "1.3.6.1.4.1.232.16.3.2.1.1.10"
      	add_oid_entry "cpqFcTapeLibraryOverallCondition" "1.3.6.1.4.1.232.16.3.2.1.1.11"
      	add_oid_entry "cpqFcTapeLibraryLastError" "1.3.6.1.4.1.232.16.3.2.1.1.12"
      	add_oid_entry "cpqFcTapeLibraryStatHours" "1.3.6.1.4.1.232.16.3.2.1.1.13"
      	add_oid_entry "cpqFcTapeLibraryStatMoves" "1.3.6.1.4.1.232.16.3.2.1.1.14"
      	add_oid_entry "cpqFcTapeLibraryDriveList" "1.3.6.1.4.1.232.16.3.2.1.1.15"
      	add_oid_entry "cpqFcTapeLibraryLocation" "1.3.6.1.4.1.232.16.3.2.1.1.16"
      	add_oid_entry "cpqFcTapeLibraryTemperature" "1.3.6.1.4.1.232.16.3.2.1.1.17"
      	add_oid_entry "cpqFcTapeLibraryRedundancy" "1.3.6.1.4.1.232.16.3.2.1.1.18"
      	add_oid_entry "cpqFcTapeLibraryHotSwap" "1.3.6.1.4.1.232.16.3.2.1.1.19"
      	add_oid_entry "cpqFcTapeDriveCntlrIndex" "1.3.6.1.4.1.232.16.3.3.1.1.1"
	add_oid_entry "cpqFcTapeDriveScsiBus" "1.3.6.1.4.1.232.16.3.3.1.1.2"
	add_oid_entry "cpqFcTapeDriveScsiTarget" "1.3.6.1.4.1.232.16.3.3.1.1.3"
	add_oid_entry "cpqFcTapeDriveScsiLun" "1.3.6.1.4.1.232.16.3.3.1.1.4"
      	add_oid_entry "cpqFcTapeDriveSerialNumber" "1.3.6.1.4.1.232.16.3.3.1.1.5"
      	add_oid_entry "cpqFcTapeDriveModel" "1.3.6.1.4.1.232.16.3.3.1.1.6"
      	add_oid_entry "cpqFcTapeDriveFWRev" "1.3.6.1.4.1.232.16.3.3.1.1.7"
	add_oid_entry "cpqFcTapeDriveStatus" "1.3.6.1.4.1.232.16.3.3.1.1.10"
      	add_oid_entry "cpqFcTapeDriveLocation" "1.3.6.1.4.1.232.16.3.3.1.1.16" 
	add_oid_entry "cpqNicIfLogMapAdapterOKCount" "1.3.6.1.4.1.232.18.2.2.1.1.6"
	add_oid_entry "cpqNicIfPhysAdapterSlot" "1.3.6.1.4.1.232.18.2.3.1.1.5"
	add_oid_entry "cpqNicIfPhysAdapterPort" "1.3.6.1.4.1.232.18.2.3.1.1.10"
      	add_oid_entry "cpqNicIfPhysAdapterStatus" "1.3.6.1.4.1.232.18.2.3.1.1.14"
      	add_oid_entry "cpqNicIfPhysAdapterPartNumber" "1.3.6.1.4.1.232.18.2.3.1.1.32"
      	add_oid_entry "cpqOsCpuIndex" "1.3.6.1.4.1.232.19.2.3.2.1.1"
      	add_oid_entry "cpqOsCpuInstance" "1.3.6.1.4.1.232.19.2.3.2.1.2"
      	add_oid_entry "cpqOsCpuInterruptsPerSec" "1.3.6.1.4.1.232.19.2.3.2.1.3"
      	add_oid_entry "cpqOsCpuTimePercent" "1.3.6.1.4.1.232.19.2.3.2.1.4"
      	add_oid_entry "cpqOsWarCpuTimePercent" "1.3.6.1.4.1.232.19.2.3.2.1.5"
      	add_oid_entry "cpqOsCriCpuTimePercent" "1.3.6.1.4.1.232.19.2.3.2.1.6"
      	add_oid_entry "cpqOsCpuUserTimePercent" "1.3.6.1.4.1.232.19.2.3.2.1.7"
      	add_oid_entry "cpqOsCpuPrivilegedTimePercent" "1.3.6.1.4.1.232.19.2.3.2.1.8"
     	add_oid_entry "cpqOsCpuCondition" "1.3.6.1.4.1.232.19.2.3.2.1.9"
      	add_oid_entry "cpqOsCacheIndex" "1.3.6.1.4.1.232.19.2.5.2.1.1"
      	add_oid_entry "cpqOsCacheInstance" "1.3.6.1.4.1.232.19.2.5.2.1.2"
      	add_oid_entry "cpqOsCacheCopyReadHitsPercent" "1.3.6.1.4.1.232.19.2.5.2.1.3"
      	add_oid_entry "cpqOsWarCacheCopyReadHitsPercent" "1.3.6.1.4.1.232.19.2.5.2.1.4"
      	add_oid_entry "cpqOsCriCacheCopyReadHitsPercent" "1.3.6.1.4.1.232.19.2.5.2.1.5"
      	add_oid_entry "cpqOsCacheCopyReadsPerSec" "1.3.6.1.4.1.232.19.2.5.2.1.6"
      	add_oid_entry "cpqOsCacheCondition" "1.3.6.1.4.1.232.19.2.5.2.1.7"
      	add_oid_entry "cpqOsPagingFileIndex" "1.3.6.1.4.1.232.19.2.6.2.1.1"
      	add_oid_entry "cpqOsPagingFileInstance" "1.3.6.1.4.1.232.19.2.6.2.1.2"
      	add_oid_entry "cpqOsPageFileUsagePercent" "1.3.6.1.4.1.232.19.2.6.2.1.3"
      	add_oid_entry "cpqOsWarPageFileUsagePercent" "1.3.6.1.4.1.232.19.2.6.2.1.4"
      	add_oid_entry "cpqOsCriPageFileUsagePercent" "1.3.6.1.4.1.232.19.2.6.2.1.5"
      	add_oid_entry "cpqOsPagingFileCondition" "1.3.6.1.4.1.232.19.2.6.2.1.6"
      	add_oid_entry "cpqOsLogicalDiskIndex" "1.3.6.1.4.1.232.19.2.8.2.1.1"
      	add_oid_entry "cpqOsLogicalDiskInstance" "1.3.6.1.4.1.232.19.2.8.2.1.2"
      	add_oid_entry "cpqOsLogicalDiskFreeSpaceMBytes" "1.3.6.1.4.1.232.19.2.8.2.1.3"
      	add_oid_entry "cpqOsLogicalDiskFreeSpacePercent" "1.3.6.1.4.1.232.19.2.8.2.1.4"
      	add_oid_entry "cpqOsLogicalDiskQueueLength" "1.3.6.1.4.1.232.19.2.8.2.1.5"
      	add_oid_entry "cpqOsLogicalDiskBusyTimePercent" "1.3.6.1.4.1.232.19.2.8.2.1.6"
      	add_oid_entry "cpqOsWarLogicalDiskBusyTimePercent" "1.3.6.1.4.1.232.19.2.8.2.1.7"
      	add_oid_entry "cpqOsCriLogicalDiskBusyTimePercent" "1.3.6.1.4.1.232.19.2.8.2.1.8"
      	add_oid_entry "cpqOsLogicalDiskCondition" "1.3.6.1.4.1.232.19.2.8.2.1.9"
      	add_oid_entry "cpqRackName" "1.3.6.1.4.1.232.22.2.2.1.1.2"
      	add_oid_entry "cpqRackUid" "1.3.6.1.4.1.232.22.2.2.1.1.3"
      	add_oid_entry "cpqRackSerialNum" "1.3.6.1.4.1.232.22.2.2.1.1.4"
      	add_oid_entry "cpqRackTrapSequenceNum" "1.3.6.1.4.1.232.22.2.2.1.1.5"
      	add_oid_entry "cpqRackCommonEnclosureModel" "1.3.6.1.4.1.232.22.2.3.1.1.1.3"
      	add_oid_entry "cpqRackCommonEnclosureSparePartNumber" "1.3.6.1.4.1.232.22.2.3.1.1.1.6"
      	add_oid_entry "cpqRackCommonEnclosureSerialNum" "1.3.6.1.4.1.232.22.2.3.1.1.1.7"
      	add_oid_entry "cpqRackCommonEnclosureName" "1.3.6.1.4.1.232.22.2.3.1.1.1.9"
      	add_oid_entry "cpqRackCommonEnclosureTrapSequenceNum" "1.3.6.1.4.1.232.22.2.3.1.1.1.15"
      	add_oid_entry "cpqRackCommonEnclosureTempLocation" "1.3.6.1.4.1.232.22.2.3.1.2.1.5"
      	add_oid_entry "cpqRackCommonEnclosureFanLocation" "1.3.6.1.4.1.232.22.2.3.1.3.1.6" 
      	add_oid_entry "cpqRackCommonEnclosureFanSparePartNumber" "1.3.6.1.4.1.232.22.2.3.1.3.1.7"
      	add_oid_entry "cpqRackCommonEnclosureFuseLocation" "1.3.6.1.4.1.232.22.2.3.1.4.1.5"
      	add_oid_entry "cpqRackPowerEnclosureName" "1.3.6.1.4.1.232.22.2.3.3.1.1.4"
      	add_oid_entry "cpqRackServerBladeName" "1.3.6.1.4.1.232.22.2.4.1.1.1.4"
      	add_oid_entry "cpqRackServerBladeEnclosureName" "1.3.6.1.4.1.232.22.2.4.1.1.1.5" 
      	add_oid_entry "cpqRackServerBladeSparePartNumber" "1.3.6.1.4.1.232.22.2.4.1.1.1.7"
      	add_oid_entry "cpqRackServerBladePosition" "1.3.6.1.4.1.232.22.2.4.1.1.1.8"
      	add_oid_entry "cpqRackPowerSupplyEnclosureName" "1.3.6.1.4.1.232.22.2.5.1.1.1.4"
      	add_oid_entry "cpqRackPowerSupplySerialNum" "1.3.6.1.4.1.232.22.2.5.1.1.1.5"
      	add_oid_entry "cpqRackPowerSupplySparePartNumber" "1.3.6.1.4.1.232.22.2.5.1.1.1.7"
      	add_oid_entry "cpqRackPowerSupplyFWRev" "1.3.6.1.4.1.232.22.2.5.1.1.1.8"
      	add_oid_entry "cpqRackPowerSupplyPosition" "1.3.6.1.4.1.232.22.2.5.1.1.1.11"
      	add_oid_entry "cpqRackPowerSupplyInputLineStatus" "1.3.6.1.4.1.232.22.2.5.1.1.1.15"
	add_oid_entry "cpqRackNetConnectorName" "1.3.6.1.4.1.232.22.2.6.1.1.1.5"
	add_oid_entry "cpqRackNetConnectorSerialNum" "1.3.6.1.4.1.232.22.2.6.1.1.1.7"
	add_oid_entry "cpqRackNetConnectorSparePartNumber" "1.3.6.1.4.1.232.22.2.6.1.1.1.9"
	add_oid_entry "cpqRackNetConnectorFWRev" "1.3.6.1.4.1.232.22.2.6.1.1.1.10"
	add_oid_entry "cpqRackNetConnectorLocation" "1.3.6.1.4.1.232.22.2.6.1.1.1.12"
	add_oid_entry "cpqSwccFibreDevName" "1.3.6.1.4.1.232.132.2.1"
	add_oid_entry "cpqSwccFibreDevState" "1.3.6.1.4.1.232.132.2.2"
	add_oid_entry "cpqSwccFibreEventDescription" "1.3.6.1.4.1.232.132.2.3"
	add_oid_entry "cpqSwccEmuDevDevName" "1.3.6.1.4.1.232.132.3.1"
	add_oid_entry "cpqSwccEmuDevDevState" "1.3.6.1.4.1.232.132.3.2"
	add_oid_entry "cpqSwccEmuDevEventDescription" "1.3.6.1.4.1.232.132.3.3"
	add_oid_entry "cpqSwccKzpccSystemName" "1.3.6.1.4.1.232.132.4.1.1"
	add_oid_entry "cpqSwccKzpccSubsystemName" "1.3.6.1.4.1.232.132.4.1.2"
	add_oid_entry "cpqSwccKzpccEventSeverity" "1.3.6.1.4.1.232.132.4.1.3"
	add_oid_entry "cpqSwccKzpccEventDescription" "1.3.6.1.4.1.232.132.4.1.4"
	add_oid_entry "cpqFcbBoxSerialNumber" "1.3.6.1.4.1.232.139.1.2.9"
	add_oid_entry "cpqFcbPowerSupplyIndex" "1.3.6.1.4.1.232.139.1.2.12.2.1.1"
	add_oid_entry "cpqFcbPowerSupplyStatus" "1.3.6.1.4.1.232.139.1.2.12.2.1.2"
	add_oid_entry "cpqFcbPowerSupplyLocation" "1.3.6.1.4.1.232.139.1.2.12.2.1.4"
	add_oid_entry "cpqFcbFanModuleIndex" "1.3.6.1.4.1.232.139.1.2.12.4.1.1"
	add_oid_entry "cpqFcbFanModuleStatus" "1.3.6.1.4.1.232.139.1.2.12.4.1.2"
	add_oid_entry "cpqFcbFanModuleLocation" "1.3.6.1.4.1.232.139.1.2.12.4.1.4"
	add_oid_entry "cpqFcbTempSensorIndex" "1.3.6.1.4.1.232.139.1.2.12.6.1.1"
	add_oid_entry "cpqFcbTempSensorStatus" "1.3.6.1.4.1.232.139.1.2.12.6.1.2"
	add_oid_entry "cpqFcbTempSensorLocation" "1.3.6.1.4.1.232.139.1.2.12.6.1.4"
	add_oid_entry "cpqFcbTempSensorCurrentValue" "1.3.6.1.4.1.232.139.1.2.12.6.1.5"
	add_oid_entry "cpqFcbTempSensorHWLimitValue" "1.3.6.1.4.1.232.139.1.2.12.6.1.6"
	add_oid_entry "cpqFcbTempSensorWarningValue" "1.3.6.1.4.1.232.139.1.2.12.6.1.7"
	add_oid_entry "cpqFcbCurrentMemoryConsumption" "1.3.6.1.4.1.232.139.1.2.13.2"
	add_oid_entry "cpqFcbMemoryLimit" "1.3.6.1.4.1.232.139.1.2.13.3"
      	add_oid_entry "cpqCrLogDrvCntlrIndex" "1.3.6.1.4.1.232.141.2.3.1.1.1"
      	add_oid_entry "cpqCrLogDrvIndex" "1.3.6.1.4.1.232.141.2.3.1.1.2"
      	add_oid_entry "cpqCrLogDrvRAIDLevel" "1.3.6.1.4.1.232.141.2.3.1.1.3"
      	add_oid_entry "cpqCrLogDrvStatus" "1.3.6.1.4.1.232.141.2.3.1.1.4"
      	add_oid_entry "cpqCrLogDrvRebuildPercentage" "1.3.6.1.4.1.232.141.2.3.1.1.5"
      	add_oid_entry "cpqCrLogDrvAvailSpares" "1.3.6.1.4.1.232.141.2.3.1.1.6"
      	add_oid_entry "cpqCrLogDrvSize" "1.3.6.1.4.1.232.141.2.3.1.1.7"
      	add_oid_entry "cpqCrLogDrvPhyDrvIDs" "1.3.6.1.4.1.232.141.2.3.1.1.8"
      	add_oid_entry "cpqCrLogDrvCondition" "1.3.6.1.4.1.232.141.2.3.1.1.9"
      	add_oid_entry "cpqCrLogDrvPartitionIDs" "1.3.6.1.4.1.232.141.2.3.1.1.10"
      	add_oid_entry "cpqCrSpareCntlrIndex" "1.3.6.1.4.1.232.141.2.4.1.1.1"  
     	add_oid_entry "cpqCrSparePhyDrvIndex" "1.3.6.1.4.1.232.141.2.4.1.1.2"
      	add_oid_entry "cpqCrSpareStatus" "1.3.6.1.4.1.232.141.2.4.1.1.3"
      	add_oid_entry "cpqCrSpareCondition" "1.3.6.1.4.1.232.141.2.4.1.1.4"
      	add_oid_entry "cpqCrSpareScsiID" "1.3.6.1.4.1.232.141.2.4.1.1.5"
      	add_oid_entry "cpqCrPhyDrvCntlrIndex" "1.3.6.1.4.1.232.141.2.5.1.1.1" 
      	add_oid_entry "cpqCrPhyDrvIndex" "1.3.6.1.4.1.232.141.2.5.1.1.2"
      	add_oid_entry "cpqCrPhyDrvVendor" "1.3.6.1.4.1.232.141.2.5.1.1.3"
      	add_oid_entry "cpqCrPhyDrvModel" "1.3.6.1.4.1.232.141.2.5.1.1.4"
      	add_oid_entry "cpqCrPhyDrvRevision" "1.3.6.1.4.1.232.141.2.5.1.1.5"
      	add_oid_entry "cpqCrPhyDrvStatus" "1.3.6.1.4.1.232.141.2.5.1.1.6"
      	add_oid_entry "cpqCrPhyDrvSize" "1.3.6.1.4.1.232.141.2.5.1.1.7"
      	add_oid_entry "cpqCrPhyDrvCondition" "1.3.6.1.4.1.232.141.2.5.1.1.8"
      	add_oid_entry "cpqCrPhyDrvScsiID" "1.3.6.1.4.1.232.141.2.5.1.1.9"
	add_oid_entry "swEventSequence" "1.3.6.1.4.1.232.151.2.1.2"
	add_oid_entry "swEventDescription" "1.3.6.1.4.1.232.151.2.1.3"
	add_oid_entry "swEventType" "1.3.6.1.4.1.232.151.2.1.4"
	add_oid_entry "swEventIndex" "1.3.6.1.4.1.232.151.2.1.5"
	add_oid_entry "swElementName" "1.3.6.1.4.1.232.151.4.1.1"
	add_oid_entry "swElementType" "1.3.6.1.4.1.232.151.4.1.2"
	add_oid_entry "swApplicationName" "1.3.6.1.4.1.232.151.6.1.2"
	add_oid_entry "swApplicationLocation" "1.3.6.1.4.1.232.151.6.1.3"
	add_oid_entry "swSystemName" "1.3.6.1.4.1.232.151.11.1"
	add_oid_entry "swSystemType" "1.3.6.1.4.1.232.151.11.2"
	add_oid_entry "swEventName" "1.3.6.1.4.1.232.151.11.3"
	add_oid_entry "swFailure" "1.3.6.1.4.1.232.151.11.4"
	add_oid_entry "swSequence" "1.3.6.1.4.1.232.151.11.5"
      	add_oid_entry "sanEventObj" "1.3.6.1.4.1.232.151.101"
      	add_oid_entry "sanEventEventCode" "1.3.6.1.4.1.232.151.101.1"
      	add_oid_entry "sanEventIPAddress" "1.3.6.1.4.1.232.151.101.2"
      	add_oid_entry "sanEventSeverity" "1.3.6.1.4.1.232.151.101.3"
      	add_oid_entry "sanEventCategory" "1.3.6.1.4.1.232.151.101.4"
      	add_oid_entry "sanEventGroup" "1.3.6.1.4.1.232.151.101.5"
      	add_oid_entry "sanEventSourceType" "1.3.6.1.4.1.232.151.101.6"
      	add_oid_entry "sanEventSourceSubtype" "1.3.6.1.4.1.232.151.101.7"
      	add_oid_entry "sanEventURL" "1.3.6.1.4.1.232.151.101.8"
      	add_oid_entry "cpqCmcStatusTemp1" "1.3.6.1.4.1.232.153.2.2.4.1"  
      	add_oid_entry "cpqCmcStatusTemp2" "1.3.6.1.4.1.232.153.2.2.4.2"  
      	add_oid_entry "cpqCmcStatusFan1" "1.3.6.1.4.1.232.153.2.2.4.3"  
      	add_oid_entry "cpqCmcStatusFan2" "1.3.6.1.4.1.232.153.2.2.4.4"  
      	add_oid_entry "cpqCmcStatusVoltage" "1.3.6.1.4.1.232.153.2.2.4.5"  
      	add_oid_entry "cpqCmcStatusHumidity" "1.3.6.1.4.1.232.153.2.2.4.6"  
      	add_oid_entry "cpqCmcStatusInput1" "1.3.6.1.4.1.232.153.2.2.4.7"  
      	add_oid_entry "cpqCmcStatusInput2" "1.3.6.1.4.1.232.153.2.2.4.8"  
      	add_oid_entry "cpqCmcStatusInput3" "1.3.6.1.4.1.232.153.2.2.4.9"  
      	add_oid_entry "cpqCmcStatusInput4" "1.3.6.1.4.1.232.153.2.2.4.10"  
      	add_oid_entry "cpqCmcStatusLock1Lock" "1.3.6.1.4.1.232.153.2.2.4.11" 
      	add_oid_entry "cpqCmcStatusLock2Lock" "1.3.6.1.4.1.232.153.2.2.4.12"
      	add_oid_entry "cpqCmcStatusSmoke" "1.3.6.1.4.1.232.153.2.2.4.13"
      	add_oid_entry "cpqCmcStatusShock" "1.3.6.1.4.1.232.153.2.2.4.14"
      	add_oid_entry "cpqCmcStatusAux1" "1.3.6.1.4.1.232.153.2.2.4.15"
      	add_oid_entry "cpqCmcStatusAux2" "1.3.6.1.4.1.232.153.2.2.4.16"
      	add_oid_entry "cpqCmcStatusAlarm1" "1.3.6.1.4.1.232.153.2.2.4.17"   
      	add_oid_entry "cpqCmcStatusAlarm2" "1.3.6.1.4.1.232.153.2.2.4.18"  
      	add_oid_entry "cpqCmcStatusLock1Dev" "1.3.6.1.4.1.232.153.2.2.4.19" 
      	add_oid_entry "cpqCmcStatusLock2Dev" "1.3.6.1.4.1.232.153.2.2.4.20"
	add_oid_entry "cpqRPMTrapDescription" "1.3.6.1.4.1.232.154.1.1"
	add_oid_entry "cpqRPMTrapDeviceId" "1.3.6.1.4.1.232.154.1.2"
	add_oid_entry "cpqRPMTrapDeviceName" "1.3.6.1.4.1.232.154.1.3"
	add_oid_entry "cpqRPMTrapDeviceAddress" "1.3.6.1.4.1.232.154.1.4"
	add_oid_entry "cpqRPMTrapType" "1.3.6.1.4.1.232.154.1.5"
	add_oid_entry "cpqRPMTrapSeverity" "1.3.6.1.4.1.232.154.1.6"
	add_oid_entry "cpqRPMTrapCode" "1.3.6.1.4.1.232.154.1.7"
	add_oid_entry "cpqRPMTrapURL" "1.3.6.1.4.1.232.154.1.8"
	add_oid_entry "agentBscSwFileAddr" "1.3.6.1.4.1.232.161.3.1.2.1.1.3"
      	add_oid_entry "agentBscSwFile" "1.3.6.1.4.1.232.161.3.1.2.1.1.4"
      	add_oid_entry "agentBscSwFileLoadType" "1.3.6.1.4.1.232.161.3.1.2.1.1.7"
      	add_oid_entry "agentBscSwFileStatus" "1.3.6.1.4.1.232.161.3.1.2.1.1.11"
      	add_oid_entry "agentSNTPServer1IPAddr" "1.3.6.1.4.1.232.161.3.1.7.3"
      	add_oid_entry "agentSNTPServer2IPAddr" "1.3.6.1.4.1.232.161.3.1.7.4"
   	add_oid_entry "agentSwitchCubeType" "1.3.6.1.4.1.232.161.3.3.1.1.1.1"
      	add_oid_entry "agentSwitchCubeSpareName" "1.3.6.1.4.1.232.161.3.3.1.1.1.2"
      	add_oid_entry "agentSwitchCubeSparePartNumber" "1.3.6.1.4.1.232.161.3.3.1.1.1.3"
      	add_oid_entry "agentSwitchPowerSupplyMaxPwrOutput" "1.3.6.1.4.1.232.161.3.3.2.1.1.2"
      	add_oid_entry "agentSwitchPowerSupplyCurPwrOutput" "1.3.6.1.4.1.232.161.3.3.2.1.1.3"
      	add_oid_entry "agentSwitchPowerSupplyIntakeTemp" "1.3.6.1.4.1.232.161.3.3.2.1.1.4"
      	add_oid_entry "agentSwitchPowerSupplyExhaustTemp" "1.3.6.1.4.1.232.161.3.3.2.1.1.5"
      	add_oid_entry "agentSwitchPowerSupplyStatus" "1.3.6.1.4.1.232.161.3.3.2.1.1.6"
      	add_oid_entry "agentSwitchPowerSupplyInputLineStatus" "1.3.6.1.4.1.232.161.3.3.2.1.1.7"
      	add_oid_entry "agentSwitchPowerSupplyCondition" "1.3.6.1.4.1.232.161.3.3.2.1.1.8"
      	add_oid_entry "agentSwitchFanIndex" "1.3.6.1.4.1.232.161.3.3.3.1.1.1"
      	add_oid_entry "agentSwitchFanCondition" "1.3.6.1.4.1.232.161.3.3.3.1.1.2"
       	add_oid_entry "agentSwitchTempSensorIndex" "1.3.6.1.4.1.232.161.3.3.4.1.1"
      	add_oid_entry "agentSwitchTempSensorCurrent"  "1.3.6.1.4.1.232.161.3.3.4.1.2"
      	add_oid_entry "agentSwitchTempSensorThreshold" "1.3.6.1.4.1.232.161.3.3.4.1.3"
      	add_oid_entry "agentSwitchTempSensorCondition" "1.3.6.1.4.1.232.161.3.3.4.1.4"
      	add_oid_entry "agentSwitchTempSensorTempType" "1.3.6.1.4.1.232.161.3.3.4.1.5"
      	add_oid_entry "swDiagResult" "1.3.6.1.4.1.1588.2.1.1.1.1.20"
      	add_oid_entry "swSensorIndex" "1.3.6.1.4.1.1588.2.1.1.1.1.22.1.1"
      	add_oid_entry "swSensorType" "1.3.6.1.4.1.1588.2.1.1.1.1.22.1.2"
      	add_oid_entry "swSensorStatus" "1.3.6.1.4.1.1588.2.1.1.1.1.22.1.3"
      	add_oid_entry "swSensorValue" "1.3.6.1.4.1.1588.2.1.1.1.1.22.1.4"
     	add_oid_entry "swSensorInfo" "1.3.6.1.4.1.1588.2.1.1.1.1.22.1.5"
      	add_oid_entry "swTrackChangesInfo" "1.3.6.1.4.1.1588.2.1.1.1.1.23"
      	add_oid_entry "swFCPortOpStatus" "1.3.6.1.4.1.1588.2.1.1.1.6.2.1.1"
      	add_oid_entry "swFCPortIndex" "1.3.6.1.4.1.1588.2.1.1.1.6.2.1.4"
      	add_oid_entry "swEventIndex" "1.3.6.1.4.1.1588.2.1.1.1.8.5.1.1"
      	add_oid_entry "swEventTimeInfo" "1.3.6.1.4.1.1588.2.1.1.1.8.5.1.2"
      	add_oid_entry "swEventLevel" "1.3.6.1.4.1.1588.2.1.1.1.8.5.1.3"
      	add_oid_entry "swEventRepeatCount" "1.3.6.1.4.1.1588.2.1.1.1.8.5.1.4"
      	add_oid_entry "swEventDescr" "1.3.6.1.4.1.1588.2.1.1.1.8.5.1.1.5"
      	add_oid_entry "swFwClassAreaIndex" "1.3.6.1.4.1.1588.2.1.1.1.10.2.1.1" 
      	add_oid_entry "swFwThresholdIndex" "1.3.6.1.4.1.1588.2.1.1.1.10.3.1.1"
      	add_oid_entry "swFwName" "1.3.6.1.4.1.1588.2.1.1.1.10.3.1.3"
      	add_oid_entry "swFwLabel" "1.3.6.1.4.1.1588.2.1.1.1.10.3.1.4"
      	add_oid_entry "swFwLastEvent" "1.3.6.1.4.1.1588.2.1.1.1.10.3.1.6"
      	add_oid_entry "swFwLastEventVal" "1.3.6.1.4.1.1588.2.1.1.1.10.3.1.7"
      	add_oid_entry "swFwLastEventTime" "1.3.6.1.4.1.1588.2.1.1.1.10.3.1.8"
      	add_oid_entry "swFwLastState" "1.3.6.1.4.1.1588.2.1.1.1.10.3.1.9"
	add_oid_entry "trapDevID" "1.3.6.1.4.1.1754.1.5.2"
	add_oid_entry "trapDevType" "1.3.6.1.4.1.1754.1.5.3"
	add_oid_entry "trapDevEnvironmentStatus" "1.3.6.1.4.1.1754.1.5.5"
	add_oid_entry "trapDevPortStatus" "1.3.6.1.4.1.1754.1.5.6"
	add_oid_entry "trapDevPortAttributes" "1.3.6.1.4.1.1754.1.5.7"
	add_oid_entry "trapDevConfigStatus" "1.3.6.1.4.1.1754.1.5.8"
	add_oid_entry "trapDevLIPStatus" "1.3.6.1.4.1.1754.1.5.9"

}

##################################################################################
#
#
if [ -n "" ]; then
  set -x
  DEBUG=true
fi

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="configsnmp.sh"

#
#	Set up some popular environment variables
#
source_etc_setup_env
BINDIR="`bindir`"; export BINDIR
INST_DIR="`inst_dir`"; export INST_DIR
MNNAME="`mnname`"; export MNNAME
TEMP="`temp`"; export TEMP
LCF_CACHEDIR="`echo $LCF_CACHEDIR | sed -e 's,\\\\,/,g'`"

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR="$TEMP/.plusdebug"
[ -d "$DEBUGDIR" ] \
  && echo "`get_message CFSNMP_DEBUG_RESULTSREDIRECTED "$DEBUGDIR/$THIS_SCRIPT"`" \
  && exec > "$DEBUGDIR/$THIS_SCRIPT" 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv
[ "$DEBUG" = true ] && set -xv

#
#	Set up variables for our basic directories, path
#
PLUSDIR="$INST_DIR/generic_unix/TME/PLUS"
LINKDIR="$PLUSDIR/LINK"
PRODDIR="$PLUSDIR/IM2"
PATH="$LINKDIR:$PRODDIR:$PATH"
export PATH

#
#	Source the PLUSproduct-info.sh file
#
#
source_product_info "$PRODDIR"

MODULE_TAG="IM2"

echo "`get_message CFSNMP_DEBUG_EXECUTING_SCRIPT "$THIS_SCRIPT" "$TASK_PROGPATH"`"

OPTIONAL_SNMP_ADAPTER_PATH=""

if [ ! -z "$1" ]; then
	# need to translate any DOS style back-slashes ('\') first
	OPTIONAL_SNMP_ADAPTER_PATH="`echo $1 | sed -e 's,\\\\,/,g'`"
fi

# ----------------------------------------------------
# Find the source ins_evt.cds file to use
if is_lcf_ep; then
	CPQTIV_CDS_PATH="$LCF_BINDIR/../TME/TEC/adapters/etc/ins_evt.cds"
else
	CPQTIV_CDS_PATH="$BINDIR/TME/TEC/adapters/etc/ins_evt.cds"
fi

# check for Non-TME SNMP adapter
	if [ ! -f "$CPQTIV_CDS_PATH" ]; then
	CPQTIV_CDS_PATH="C:/TECSNMP/ETC/ins_evt.cds"
	fi

if [ -f "$CPQTIV_CDS_PATH" ]; then
	echo "`get_message CFSNMP_CDS_FILE_USED "$CPQTIV_CDS_PATH"`"
else
	# Try PRODDIR
	PRODDIR_CPQTIV_CDS_PATH="$PRODDIR/ins_evt.cds"
	if [ ! -f "$PRODDIR_CPQTIV_CDS_PATH" ]; then
		errecho "`get_message CFSNMP_FILE_NOT_FOUND "$CPQTIV_CDS_PATH"`"
		errecho "`get_message CFSNMP_FILE_NOT_FOUND "$PRODDIR_CPQTIV_CDS_PATH"`"
		errecho "`get_message CFSNMP_DISTRIBUTE_UTILS_PACKAGE`"
		exit 1
	else
		CPQTIV_CDS_PATH="$PRODDIR_CPQTIV_CDS_PATH"		
	fi
fi		

#
# set up a list of paths to locate adapter files
#   NOTE: You may wish to modify this list to reflect other possible installations
#
dirs_to_check='"${LCF_CACHEDIR}/bin/${INTERP}/TME/TEC/adapters" "$BINDIR/TME/TEC/adapters" "$BINDIR/../../lcf/TME/TEC/adapters" "/usr/tecad"'

#
# Added c:/tecnt for the default location of the TEC 3.6 standalone NT snmp adapter.
#
if is_OS_NT; then
	dirs_to_check='"${LCF_CACHEDIR}/bin/${INTERP}/TME/TEC/adapters" "$BINDIR/TME/TEC/adapters" "$BINDIR/../../lcf/TME/TEC/adapters" "c:/tecsnmp"'
fi

if [ ! -z "$OPTIONAL_SNMP_ADAPTER_PATH" ]; then
	dirs_to_check=""${OPTIONAL_SNMP_ADAPTER_PATH}" "$dirs_to_check""
fi

# echo "dirs_to_check=$dirs_to_check"

for d in $dirs_to_check; do
  eval TECSNMP_DIR="$d"

  #
  # check the normal TECSNMP_DIR/bin first for the executable
  #
  TECSNMP_BINDIR="$TECSNMP_DIR/bin"
  if [ x\"$OS\" = x\"Windows_NT\" ] ; then
        TECSNMP_EXE="$TECSNMP_BINDIR/tecad_snmp.exe"
  else
        TECSNMP_EXE="$TECSNMP_BINDIR/tecad_snmp"
  fi
  if [ -f "$TECSNMP_EXE" ]; then
        break
  fi

  #
  # some installs may have the executable in TECSNMP_DIR/etc; check there now!
  #
  TECSNMP_BINDIR="$TECSNMP_DIR/etc"
  if [ x\"$OS\" = x\"Windows_NT\" ] ; then
        TECSNMP_EXE="$TECSNMP_BINDIR/tecad_snmp.exe"
  else
        TECSNMP_EXE="$TECSNMP_BINDIR/tecad_snmp"
  fi
  if [ -f "$TECSNMP_EXE" ]; then
        break
  fi
done

for d in $dirs_to_check; do
  eval TECSNMP_DIR="$d"
  TECSNMP_ETCDIR="$TECSNMP_DIR/etc"
  if [ -f "$TECSNMP_ETCDIR/tecad_snmp.cds" ]; then
        break
  fi
done

[ ! -d "$TECSNMP_BINDIR" ] &&  echo "`get_message CFSNMP_NODE_DOES_NOT_HAVE_SNMP_BIN`" >&2 && exit 1
[ ! -d "$TECSNMP_ETCDIR" ] &&  echo "`get_message CFSNMP_NODE_DOES_NOT_HAVE_SNMP_ETC`" >&2 && exit 1
[ ! -x "$TECSNMP_EXE" ] &&  echo "`get_message CFSNMP_NODE_DOES_NOT_HAVE_SNMP_ADAPTER`" >&2 && exit 1

if [ x\"$OS\" = x\"Windows_NT\" ] ; then
	TECSNMP_CDS="$TECSNMP_ETCDIR/tecad_snmp.cds"
	TECSNMP_OID="$TECSNMP_ETCDIR/tecad_snmp.oid"
	TECSNMP_START_CMD="net start TECSNMPadapter"
	TECSNMP_STOP_CMD="net stop TECSNMPadapter"
else
	TECSNMP_CDS="$TECSNMP_ETCDIR/tecad_snmp.cds"
	TECSNMP_OID="$TECSNMP_ETCDIR/tecad_snmp.oid"
	TECSNMP_START_CMD="$TECSNMP_BINDIR/init.tecad_snmp start"
	TECSNMP_STOP_CMD="$TECSNMP_BINDIR/init.tecad_snmp stop"
fi

echo "`get_message CFSNMP_FILE_PATH_IS "tecad_snmp.cds" "$TECSNMP_CDS"`"
echo "`get_message CFSNMP_FILE_PATH_IS "tecad_snmp.oid" "$TECSNMP_CDS"`"

#
# if we got this far, we really want to configure 
#

echo "`get_message CFSNMP_STOPPING_SNMP_ADAPTER`"
$TECSNMP_STOP_CMD
sleep 5

#
# Create an empty file if it does not exist.
#
if [ ! -f "$TECSNMP_OID" ]; then
	echo " " > "$TECSNMP_OID"
fi

#
# Preserve the .CDS and .OID files
#
[ -f "$TECSNMP_CDS" ] && \
	echo "`get_message CFSNMP_COPYING_FILE "$TECSNMP_CDS" "$TECSNMP_CDS.pre.$MODULE_TAG"`"
	cp "$TECSNMP_CDS" "$TECSNMP_CDS.pre.$MODULE_TAG"

[ -f "$TECSNMP_OID" ] && \
	echo "`get_message CFSNMP_COPYING_FILE "$TECSNMP_OID" "$TECSNMP_OID.pre.$MODULE_TAG"`"
	cp "$TECSNMP_OID" "$TECSNMP_OID.pre.$MODULE_TAG"

add_oid_entries

#
# Now write out the .cds entries:
#
echo " " >> "$TECSNMP_CDS"
echo "`get_message CFSNMP_WRITING_CDS_ENTRIES "$CPQTIV_CDS_PATH"`"
cat "$CPQTIV_CDS_PATH" >> "$TECSNMP_CDS"

restart_tecsnmp
sleep 5

exit 0