#!/bin/sh
#
# File:		_INI_File_Entry.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:	Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1997-2000
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
############ include msg function utilities here ... ##############
#
############
#
# File:		BourneShellMsgFunctions.skel
#
# Product:	Tivoli Module Builder
# Description:	Shell utilities for generating localized messages
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1999, 2000
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

outmsg() {

  ## turn off tracing for this routine
  ### d98443: this allows too much: if [ "$DEBUG" = true ]; then set +x; fi
  set +xv

  arg1=`echo "$1"`
  arg2=`echo "$2"`
  arg3=`echo "$3"`

  if [ ! "$arg3" ]; then
    eval echo '"$arg1"' '"$arg2"'
    ## turn tracing back on if applicable ...
    if [ "$DEBUG" = true ]; then set -x; fi
    return
  fi

  # got 3 or more args, we must be trying to wbindmsg ...
  file="$arg1"
  num="$arg2"
  string="`echo \"$arg3\" | sed -e 's/*/./g'`"
  shift;shift;shift
  afterstring="$*"

  ## handle up to 4 substitution args
  subarg1=`echo "$1"`; if [ "$subarg1" ]; then shift; fi
  subarg2=`echo "$1"`; if [ "$subarg2" ]; then shift; fi
  subarg3=`echo "$1"`; if [ "$subarg3" ]; then shift; fi
  subarg4=`echo "$1"`; if [ "$subarg4" ]; then shift; fi
  rest="$*"   ## not real graceful, but at least we're not throwing it away ...

  # use USER_LANG if it's set; so our wbindmsg will find the user's locale
  save_lang=$LANG
  if [ "$USER_LANG" ]; then
    LANG=$USER_LANG
  elif [ ! "$LANG" ]; then
    LANG=C
  fi

  if wbindmsg $file $num "$string" "$subarg1" "$subarg2" "$subarg3" "$subarg4" "$rest" 1> /dev/null 2>&1; then
    wbindmsg $file $num "$string" "$subarg1" "$subarg2" "$subarg3" "$subarg4" "$rest"
    echo   ## add a line ending to wbindmsg result
  else
    # couldn't use wbindmsg, but try and spit out something useful
    substitute_strings "$string" "$subarg1" "$subarg2" "$subarg3" "$subarg4" "$rest"
    if [ $? -ne 0 ]; then
      eval echo $string $afterstring
    fi
  fi

  # restore LANG
  LANG=$save_lang

  ## turn tracing back on if applicable ...
  if [ "$DEBUG" = true ]; then set -x; fi

}

errmsg() {

  ## turn off tracing for this routine ...
  ### d98443: this allows too much trace output: if [ "$DEBUG" = true ]; then set +x; fi
  set +xv

  # preserve arg format for call to outmsg()
  arg1=`echo "$1"`
  arg2=`echo "$2"`
  arg3=`echo "$3"`
  if [ "$arg3" ]; then 
    shift;shift;shift
    subarg1=`echo "$1"`; if [ "$subarg1" ]; then shift; fi
    subarg2=`echo "$1"`; if [ "$subarg2" ]; then shift; fi
    subarg3=`echo "$1"`; if [ "$subarg3" ]; then shift; fi
    subarg4=`echo "$1"`; if [ "$subarg4" ]; then shift; fi
    rest="$*"
  fi

  outmsg "$arg1" "$arg2" "$arg3" "$subarg1" "$subarg2" "$subarg3" "$subarg4" $rest >& 2

  ## turn tracing back on if applicable ...
  if [ "$DEBUG" = true ]; then set -x; fi

}

substitute_strings() {

  ## turn off tracing for this routine
  ### d98443: this allows too much trace output: if [ "$DEBUG" = true ]; then set +x; fi
  set +xv

  base="`echo \"$1\" | sed -e 's/*/./g'`"; if [ "$base" ]; then shift; fi
  sub1=`echo "$1"`; if [ "$sub1" ]; then shift; fi
  sub2=`echo "$1"`; if [ "$sub2" ]; then shift; fi
  sub3=`echo "$1"`; if [ "$sub3" ]; then shift; fi
  sub4=`echo "$1"`; if [ "$sub4" ]; then shift; fi
  xtra=`echo "$*"`


  base="`echo \"$base\" | sed -e 's/%1$s/$sub1/g'`"
  base="`echo \"$base\" | sed -e 's/%2$s/$sub2/g'`"
  base="`echo \"$base\" | sed -e 's/%3$s/$sub3/g'`"
  base="`echo \"$base\" | sed -e 's/%4$s/$sub4/g'`"
  base="`eval echo $base`"
  xtra="`eval echo $xtra`"
  eval echo '"$base"' '"$xtra"'
  retval=$?

  ## turn tracing back on if applicable ...
  if [ "$DEBUG" = true ]; then set -x; fi

  return $retval

}

#
#       xlate_var -- please pass in a var name, not its value!
#                    we construct variables appending var name 
#                    with _MSGFILE and _MSGID, and use those values
#
xlate_var() {
  varname="$1"
  eval default_val='"$'${varname}'"'
  if [ ! "$default_val" ]; then
    default_val="$1"
  fi
  eval msgid='"$'${varname}'_MSGID"'
  eval msgfile='"$'${varname}'_MSGFILE"'
  outmsg $msgfile $msgid "$default_val"
}

#
######## End of MsgUtilsInclude.skel
#
############     end of msg function utilities        ##############

if [ -n "" ]; then
	set -x
fi

rc=0
PROGNAME=`echo $0 | sed -e 's.\\\\./.g'`
PROGNAME=`basename $PROGNAME`

outmsg TMB_skel 16 "*** Executing %1\$s" "$PROGNAME"
I=1
while [ $# -gt 0 ]; do
	outmsg TMB_skel 22 "argument %1\$s: '%2\$s'" "$I" "$1"
	I=`expr $I + 1`
	shift
done
outmsg TMB_skel 17 "*** Exiting %1\$s with return code %2\$s" "$PROGNAME" "$rc"
exit $rc
