#!/bin/sh
#
# Component Name: TivoliPlus
#
# $Source: /tivoli/development/src/2.0/plus/Link/src/check_arch.sh,v $
#
# $Revision: 1.2 $
#
# Description:
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1995-2000
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

#This is a simple script to run before filepacks to see if the
#current mananged node is a valid target for the filepack
PATH=/bin:/usr/bin:$PATH
export PATH

ARCH=`odadmin | grep "Interpreter type" |awk '{print \$NF}'`

if [ x"$ARCH" = x"$TARGET" ] ; then
	exit 0
else
	MSG=`wbindmsg LinkCmdCat 27 "The interpreter type for this client (%1\\$s) does not match %2\\$s" "$ARCH" "$TARGET" 2> /dev/null`
	if [ ! "$MSG" ]; then
		MSG="The interpreter type for this client ($ARCH) does not match $TARGET"
	fi
	echo $MSG >& 2
	exit 1
fi
