#!/bin/sh
#
# File:		PLUSconfig.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

###
#
# is_managed_node
#
is_managed_node() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 0
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 1
  else
    return 0
  fi
}

###
#
# is_OS_NT
#
is_OS_NT() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ "`uname`" = "Windows_NT" ]; then
    return 0
  else
    return 1
  fi
}


###
#
#   Return value for BINDIR
#
bindir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    INTERP=`objcall $OSERV query interp`; export INTERP
    inst_dir="`objcall $OSERV query install_dir`"
    bindir="$inst_dir/$INTERP"
  else
    bindir="$LCF_BINDIR/.."
  fi
  bindir="`echo $bindir | sed -e 's,\\\\,/,g'`"
  echo $bindir
}

###
#
#   Return value for INST_DIR
#
inst_dir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    inst_dir="`objcall $OSERV query install_dir`"
  else
    inst_dir="$LCFROOT"
  fi
  inst_dir="`echo $inst_dir | sed -e 's,\\\\,/,g'`"
  echo $inst_dir
}

###
#
#   Return correct value for tmp directory
#
temp() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    temp=/tmp
    if is_OS_NT; then
	temp="$DBDIR/tmp"
    fi
  else
    if [ -n "$LCF_TEMPDIR" ]; then
      temp="$LCF_TEMPDIR"
    else
      temp="$LCF_DATDIR/tmp"
    fi
  fi
  if [ ! -d "$temp" ]; then
    mkdir -p "$temp"
  fi
  echo $temp
}

###
#
#    Find the Tivoli etc directory and source the right environment setup file
#
source_etc_setup_env() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    ETC=/etc/Tivoli

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/system32/drivers/etc/Tivoli
    fi

    # Look for the optional Plus override script, if not there use the standard one
    SETUP_SCRIPT=""
    if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
    fi
    . $ETC/$SETUP_SCRIPT
  else
    # not a managed node; find the most recent lcf_env.sh and source it
    ETC=/etc/Tivoli/lcf

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/Tivoli/lcf
    fi
	 if is_OS_WIN9X; then
		 thewindir="`echo $windir | sed -e 's,\\\\,/,g'`"
		 ETC=$thewindir/Tivoli/lcf
	 fi
    SETUP_SCRIPT=lcf_env.sh
    LCF_ETC_SCRIPT=`echo \`ls -td ${ETC}/*\` | awk '{print $1}'`/$SETUP_SCRIPT
    if [ -f "$LCF_ETC_SCRIPT" ]; then
       . $LCF_ETC_SCRIPT > /dev/null 2> /dev/null
    fi
  fi
}

###
#
# ironame
#
ironame() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    #
    #	Get the region name to avoid collisions
    #
    iro=`wlookup InterRegion`
    ironame=`idlattr -t -g $iro name string`
    ironame=`eval echo $ironame`
    echo $ironame
  else
    echo ""
  fi
}

###
#
# mnname
#
mnname() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    mnoid=`objcall 0.0.0 get_host_location`
    eval mnname=`idlattr -t -g $mnoid label string`
    echo $mnname
  else
    echo ""
  fi
}

###
#
# source_product_info
#
source_product_info() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -d "$1" ]; then
    cd "$1"
    if [ -f PLUSproduct-info.sh ]; then
      . ./PLUSproduct-info.sh
      export WINSTRUCTED
      export MODULE_VERSION
    else
      errecho "$1/PLUSproduct-info.sh not found!"
    fi
  else
    errecho "$1/PLUSproduct-info.sh not found!"
  fi
}

###
#
# get_install_opts
#
get_install_opts() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -n "$INSTALL_OPTS" ]; then
   if [ -f "$LINKDIR/PLUSget_install_opts.sh" ]; then
	. "$LINKDIR/PLUSget_install_opts.sh"
   fi
  fi
}

#----------------------------------------------------------
#	Used to determine if system is Windows 9x.
#
is_OS_WIN9X(){
  if [ "$DEBUG" = true ]; then set -x; fi
	if is_OS_NT; then
		return 1
	fi
	the_uname=""
	the_uname=`uname | grep -i windows_9`
  if [ ! -z "$the_uname" ]; then
    return 0
  else
    return 1
  fi

}


#----------------------------------------------------------
#	Used to determine if system is Windows 9x or NT
#
is_OS_WINDOWS()
{
	if is_OS_NT; then
		return 0
	fi
	
	if is_OS_WIN9X; then
		return 0
	fi
	return 1
}

#----------------------------------------------------------
#	Returns 0 if system is a UNIX box.
# 	Returns 1 otherwise.
#
is_OS_UNIX()
{
	if is_OS_WINDOWS; then
		return 1
	fi
	return 0
}

set_win_dir()
{
	#
	# Thuridion
	#
	if is_OS_WINDOWS; then
		THE_WIN_DIR=""
		if [ ! -z "$windir" ] ; then
			THE_WIN_DIR="`echo $windir | sed -e 's,\\\\,/,g'`"
		fi
	fi

}

#----------------------------------------------------------
#	If this is an NT TMA node, set MNNAME to be COMPUTERNAME
#
set_mnname()
{
	if is_OS_WIN9X; then
		return
	fi

	if is_OS_NT; then
		if [ -z "$MNNAME" ]; then
			MNNAME="$COMPUTERNAME"
		fi
	else
		MNNAME=`uname -n`
	fi
	export MNNAME
}

#-------------------------------------------------------------------
# Copy the w32-ix86 tools directory for Windows 9x TMA nodes
# This must be called prior to the call to set_dep_sets in PLUSinstall_after.sh
#
create_win9x_tools_directory()
{
	W32DIR="$BINDIR/../lcf_bundle/bin/w32-ix86"
	WIN95DIR="$BINDIR/../lcf_bundle/bin/win95"

	if [ ! -d "$W32DIR" ]; then
		return
	fi
	
	if is_OS_UNIX; then
		rcp -r "$W32DIR/tools" "$WIN95DIR"
		return
	fi

	if [ ! -d "/tmp" ]; then
		mkdir "/tmp"
	fi

	#
	# cp didn't work well during install for some reason
	# So let's try tar on the tools directory.
	#
	rm -f "/tmp/toolsfiles.tar"
	CWD=`pwd`
	cd "$W32DIR"
	tar cf "/tmp/toolsfiles.tar" "tools"
	cd "$WIN95DIR"
	tar xf "/tmp/toolsfiles.tar"
	rm -f "/tmp/toolsfiles.tar"
	cd "$CWD"

}


########################################################################

if [ -n "" ]; then
        DEBUG=true
fi
[ "$DEBUG" = true ] && set -x

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="PLUSconfig.sh"

#
#       Make sure we're running on a Managed Node
#
if is_lcf_ep; then
  errecho "Cannot run $THIS_SCRIPT: endpoint $ENDPOINT_OID is not a ManagedNode"
  exit 1
fi

#
#	The standard directory and the (optional) /Plus override script
#
ETC=/etc/Tivoli
SETUP_SCRIPT=""

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
fi

. $ETC/$SETUP_SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/IM2
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv

#
#	If there are install options from PLUSproduct-info.sh, bring them in!
#
if [ -n "$INSTALL_OPTS" ]; then
	. $LINKDIR/PLUSget_install_opts.sh
fi

rc=0

echo "*** Executing $THIS_SCRIPT ($TASK_PROGPATH)"

### At this point, you may wish to do some or all of the following:
###   - set and export environment variables based on task arg values
###   - set endpoint attributes (i.e., using wsetattrs based on task arg values
###   - perform other setup functions on this node depending on your app 

#----------------------------------------------------------
# copy the source ins_evt.cds file to use
#	(only on TEC server)
if wlookup -r Classes EventServer >/dev/null 2>&1; then
	if is_lcf_ep; then
		CPQTIV_CDS_PATH="$LCF_BINDIR/../TME/TEC/adapters/etc"
	else
		CPQTIV_CDS_PATH="$BINDIR/TME/TEC/adapters/etc"
	fi	
	if [ ! -d "$CPQTIV_CDS_PATH" ]; then
		mkdir -p "$CPQTIV_CDS_PATH"
	fi
	cp "$PRODDIR/ins_evt.cds" "$CPQTIV_CDS_PATH"

	#	If this is the TEC server, copy the interface script
	#	This will enable the Auto Action to invoke a job in response to FATAL events
	#	the scripts directory should be in the default path when the rule is executed.
	if [ -d "$BINDIR/TME/TEC/scripts" ]; then
		cp $PRODDIR/cim_exec_job.sh $BINDIR/TME/TEC/scripts/cim_exec_job.sh
	fi

fi

#----------------------------------------------------------
#	Gateways need to have a copy of the lcf_bundle tools for w32-ix86
#	in the win95 directory
#
create_win9x_tools_directory

echo "*** Exiting $THIS_SCRIPT ($TASK_PROGPATH) with return code $rc"
echo

exit $rc

