#!/bin/sh
#
# File:		plus_about.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

BUILDNUMBER=5
BUILDDATE="July 20, 2006"

###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

########################################################################

if [ -n "" ]; then
        DEBUG=true
fi
[ "$DEBUG" = true ] && set -x

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="plus_about.sh"

#
#       Make sure we're running on a Managed Node
#
if is_lcf_ep; then
  errecho "Cannot run $THIS_SCRIPT: endpoint $ENDPOINT_OID is not a ManagedNode"
  exit 1
fi

#
#	The standard directory and the (optional) /Plus override script
#
ETC=/etc/Tivoli
SETUP_SCRIPT=""

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
fi

. $ETC/$SETUP_SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/IM2
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv

#
#	If there are install options from PLUSproduct-info.sh, bring them in!
#
if [ -n "$INSTALL_OPTS" ]; then
	. $LINKDIR/PLUSget_install_opts.sh
fi

###############################################################################
###############################################################################

#
#	Display the product name and version, manufacturer, etc.
#

echo "HP Insight Integration for Tivoli"
echo "Revision 4.1"
echo "Copyright (c), @ 1999, 2006 Hewlett-Packard Development Company, L.P. All rights reserved."
echo ""
echo "http://www.hp.com/servers/manage"
echo "http://www.hp.com/servers/integration"
echo ""
echo "Build Number: $BUILDNUMBER"
echo "Build Date: $BUILDDATE"
exit 0

