#!/bin/sh
#
# File:		browser_location.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
#-----------------------------------
# custom variables needed throughout this script
#
SCRIPTNAME=browser_location
PLUS_PROD_DIR=IM2
PlusName=CPQ
CMD_ARGS=

#----------------------------------------------------------
#	Configure some variables and settings
#
init_this_script()
{
    TMP="/tmp"
	FPDIR="$TMP/$PlusName"
    LOGNAME="$SCRIPTNAME"
    LOGFILE=""
    HKLM=HKEY_LOCAL_MACHINE

    if is_OS_NT; then
        CMD=cmd.exe
    else
        CMD=command.com
    fi
    
    # Enable logging only if debugging is enabled.
	LOGFILE=""
	if [ -f "$TEMP/debug" -o -d "$DEBUGDIR" -o "$DEBUG" = "true" ]; then

		LOGFILE="$TEMP/$SCRIPTNAME.log"
		log_message_to_file "--------------------"
		log_message_to_file "$SCRIPTNAME"
		log_message_to_file

	fi

	set_mnname

}


#------------------------------------------------------------
#    Sets UTILSDIR to the path for where the utils files are
#
set_utils_dir()
{
    UtilsDir="$PRODDIR"
    UtilsPath=""

    log_message "BINDIR=$BINDIR"
    log_message "LCF_BINDIR=$LCF_BINDIR"

    #-------------------------------------------
    #    append Plus Module Name to appropriate directory
    #
    # if is_managed_node; then
        # UtilsDir="$BINDIR/$PlusName"
    # else
        # UtilsDir="$LCF_BINDIR/../$PlusName"
	# fi

	# -------------------------------------------
	# first make sure the UtilsDir is a unix-style path ('/' slashes)    
    UtilsDir="`echo $UtilsDir | sed -e 's,\\\\,/,g'`"
    log_message "UtilsDir = $UtilsDir"

	# -------------------------------------------
	# first make sure the UtilsPath is a dos-style path ('\' slashes)    
    UtilsPath="`echo $UtilsDir | sed -e 's,/,\\\\,g'`"
    log_message "UtilsPath = $UtilsPath"

    if [ ! -d "$UtilsDir" ]; then
 		log_message "mkdir -p UtilsDir $UtilsDir."
        mkdir -p "$UtilsDir"
    fi
    
	return 0
}


##################################################################################
#

#
##################################################################################
#
#	Logs a message to the script's logfile.
#
log_message_to_file()
{
	if [ ! -z "$LOGFILE" ]; then

		echo "$*" >> "$LOGFILE"
		
	fi
}
	
#----------------------------------------------------------
#
#	Logs a message to stdout
#
log_message()
{
	log_message_to_file "$*"

}

#----------------------------------------------------------
#
#	Logs an error message to a log file.
#
log_error()
{

	log_message_to_file "ERROR: $*"
	echo "ERROR: $*" >&2
}

#----------------------------------------------------------
#
# Call this for any exit.  Don't just exit from a script.
# Creates the file /exitval.sh that the parent sources in.
#
exitscript()
{
	echo "exitval=$1" > /exitval.sh
	log_message 
	exit $1
}

#----------------------------------------------------------
#
# Look for standard windows vars
# If none are set then assume UNIX.
# return 0 if on '9x.
# return 1 if on '9x.
#
silent_is_OS_WIN9X()
{
	if [ "$OS" = "Windows_NT" ]; then

		return 1

	fi

	# Try windir and comspec.
	if [ ! -z "$windir" -a ! -z "$COMSPEC" ]; then

		# Assume a windows '9x system
		return 0

	fi

	# Must be a non-windows system.
	return 1
}

#----------------------------------------------------------
#
#   errecho
#
errecho() {
  erroccurred=1
  log_error "$*"
}

#----------------------------------------------------------
#
#   errexit
#
errexit() {
  if [ ! -z "$*" ]; then
		echo "$*" >&2
  fi

  exitscript 1
}

#----------------------------------------------------------
#
# is_lcf_ep
#
is_lcf_ep() {

  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

#----------------------------------------------------------
# is_managed_node
#
is_managed_node() {

  if [ "$DEBUG" = true ]; then set -x; fi

  if [ -z "$ENDPOINT_OID" ]; then
    return 0
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 1
  else
    return 0
  fi
}

#----------------------------------------------------------
#
# is_OS_NT
#
is_OS_NT() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ "$theuname" = "Windows_NT" ]; then
    return 0
  else
    return 1
  fi
}

#----------------------------------------------------------
#	Returns 0 if system is a UNIX box.
# 	Returns 1 otherwise.
#
is_OS_UNIX()
{
	if is_OS_WINDOWS; then
		return 1
	fi
	return 0
}

#----------------------------------------------------------
#	Used to determine if system is Windows 9x or NT
#
is_OS_WINDOWS()
{
	if is_OS_NT; then
		return 0
	fi
	
	if is_OS_WIN9X; then
		return 0
	fi

	return 1
}

#----------------------------------------------------------
#	Used to determine if system is Windows 9x.
#
is_OS_WIN9X(){
	if [ "$DEBUG" = true ]; then set -x; fi

	if is_OS_NT; then
		return 1
	fi

	win9xcheck=""
	win9xcheck=`echo "$theuname" | grep -i windows_9`
	if [ ! -z "$win9xcheck" ]; then
		return 0
	else
		return 1
	fi
}

###
#
#   Return value for BINDIR
#
bindir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    INTERP=`objcall $OSERV query interp`; export INTERP
    inst_dir="`objcall $OSERV query install_dir`"
    bindir="$inst_dir/$INTERP"
  else
    bindir="$LCF_BINDIR/.."
  fi
  bindir="`echo $bindir | sed -e 's,\\\\,/,g'`"
  echo $bindir
}

###
#
#   Return value for INST_DIR
#
inst_dir() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    OSERV=`objcall 0.0.0 get_oserv`; export OSERV
    inst_dir="`objcall $OSERV query install_dir`"
  else
    inst_dir="$LCFROOT"
  fi
  inst_dir="`echo $inst_dir | sed -e 's,\\\\,/,g'`"
  echo $inst_dir
}

###
#
#   Return correct value for tmp directory
#
temp() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    temp=/tmp
    if is_OS_NT; then
	temp="$DBDIR/tmp"
    fi
  else
    if [ -n "$LCF_TEMPDIR" ]; then
      temp="$LCF_TEMPDIR"
    else
      temp="$LCF_DATDIR/tmp"
    fi
  fi
  if [ ! -d "$temp" ]; then
    mkdir -p "$temp"
  fi
  # echo $temp
  echo $temp | tr "\\\\\\\\" "/"
}

###
#
#    Find the Tivoli etc directory and source the right environment setup file
#
source_etc_setup_env() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    ETC=/etc/Tivoli

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/system32/drivers/etc/Tivoli
    fi

    # Look for the optional Plus override script, if not there use the standard one
    SETUP_SCRIPT=""
    if [ ! -f "$ETC/$SETUP_SCRIPT" ]; then
	SETUP_SCRIPT=setup_env.sh
    fi
    . $ETC/$SETUP_SCRIPT
  else
    # not a managed node; find the most recent lcf_env.sh and source it
    ETC=/etc/Tivoli/lcf

    # If this is NT, then the Tivoli etc directory is in a different location
    if is_OS_NT; then
       ETC=$SystemRoot/Tivoli/lcf
    fi
	 if is_OS_WIN9X; then
		 set_win_dir
		 ETC="$THE_WIN_DIR/Tivoli/lcf"
	 fi
    SETUP_SCRIPT=lcf_env.sh
    LCF_ETC_SCRIPT=`echo \`ls -td ${ETC}/*\` | awk '{print $1}'`/$SETUP_SCRIPT
    if [ -f "$LCF_ETC_SCRIPT" ]; then
       . $LCF_ETC_SCRIPT > /dev/null 2> /dev/null
    fi
  fi
}

###
#
# ironame
#
ironame() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    #
    #	Get the region name to avoid collisions
    #
    iro=`wlookup InterRegion`
    ironame=`idlattr -t -g $iro name string`
    ironame=`eval echo $ironame`
    echo $ironame
  else
    echo ""
  fi
}

###
#
# mnname
#
mnname() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if is_managed_node; then
    mnoid=`objcall 0.0.0 get_host_location`
    eval mnname=`idlattr -t -g $mnoid label string`
    echo $mnname
  else
    echo ""
  fi
}

###
#
# source_product_info
#
source_product_info() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -d "$1" ]; then
    cd "$1"
    if [ -f PLUSproduct-info.sh ]; then
      . ./PLUSproduct-info.sh
      export WINSTRUCTED
      export MODULE_VERSION
    fi
  fi
}

###
#
# get_install_opts
#
get_install_opts() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -n "$INSTALL_OPTS" ]; then
   if [ -f "$LINKDIR/PLUSget_install_opts.sh" ]; then
	. "$LINKDIR/PLUSget_install_opts.sh"
   fi
  fi
}

#----------------------------------------------------------
#	If this is an NT TMA node, set MNNAME to be COMPUTERNAME
#
set_mnname()
{
	if is_OS_WIN9X; then
		return
	fi

	if is_OS_NT; then
		if [ -z "$MNNAME" ]; then
			MNNAME="$COMPUTERNAME"
		fi
	else
		MNNAME=`uname -n`
	fi
	export MNNAME
}

#-----------------------------------------------------------------
#	Get the windows directory from $windir and store in THE_WIN_DIR
#
set_win_dir()
{
	[ ! -z "$THE_WIN_DIR" ] && return
	THE_WIN_DIR=""
	if is_OS_WINDOWS; then
		if [ ! -z "$windir" ] ; then
			THE_WIN_DIR="`echo "$windir" | sed -e 's,\\\\,/,g'`"
		fi
	fi

}

#-----------------------------------------------------------------
#	Invoke a minimized sh.exe and wait for processing to complete.
# 	Script exits at the end of this function.
#
start_child_shell()
{
	# Remove the exitval.sh script that exitscript writes out.
	if [ -f /exitval.sh ]; then
		rm -f /exitval.sh
	fi

	# Invoke the script and wait for it.
	if [ "$DEBUG" = "true" ]; then
		start /min /wait sh.exe -x "$THESCRIPT" "child" "$PATH" $NumParams "$@"
	else
		start /min /wait sh.exe "$THESCRIPT" "child" "$PATH" $NumParams "$@"
	fi

	# See if we have an exit value.
	if [ -f /exitval.sh ]; then
		. /exitval.sh
		rm -f /exitval.sh
		exit $exitval
	fi

	# Parent exit
	exit
}


#-----------------------------------------------------------------
#	Prepare the child shell by parsing off extra parameters passed
#	from the parent.
#
init_child_shell()
{
	THESCRIPT=$1
	#
	# Set PATH to $2.  Set NumParams to $3 for the number of parameters to the script.
	#
	PATH="$2"
	export PATH

	# $3 will be the number of command line parameters.
	NumParams=$3
	
	if [ -f /exitval.sh ]; then
		rm -f /exitval.sh
	fi

}


##################################################################################
# Put script specific functions here
#
##################################################################################


#------------------------------------------------------------
# Creates cpqsetvar.sh in the $UtilsDir directory.
#
create_cpqsetvars ()
{
	if [ -z "$UtilsDir" ] ; then
		log_message "Cannot determine where IMPlus Utils are installed on this node."
		return 1
	fi

	SETVARS_PATH="$UtilsDir/$SETVAR_SCRIPT"
	if [ -f "$SETVARS_PATH" ] ; then
		rm -f "$SETVARS_PATH"
	fi

	echo "#!/bin/sh" > "$SETVARS_PATH"
	echo "CIM_BROWSER=\"$CIM_BROWSER\"" >> "$SETVARS_PATH"
	echo " " >> "$SETVARS_PATH"
      log_message "INTERNET Browser is located at ."
	return 0
}


###########################
# Begin parent process here
###########################

#
# If on a '9x box then enter this if
#
if silent_is_OS_WIN9X; then
	
	#
	# If not running as child and we're not running a command line test on a '9x box then
	# kick off a child process.
	#
	if [ ! "$1" = "child" -a -z "$CMD9XTEST" ]; then

		NumParams=$#

		# $0 is the script name using forward slashes.
		THESCRIPT=$0

		start_child_shell "$@"

	fi

fi

##########################
# Begin child process here
##########################

#
# Set this to the number of command line parameters.  It will be reset on Windows '9x
#
NumParams=$#

#
# If running as a child process the parse the extra command line params sent by the parent process.
# Note that $1 will only be child if the parent invokes a shell or if one passes in child manually
# as $1 for the script from a command line.
#
if [ "$1" = "child" ]; then

	init_child_shell "$@"

	# Get rid of the 1st three parameters so that $1 is the first real parameter.
	# IE, get at $1 from the parent process.
	shift 3

fi

#
# If Running on '9x from a command line and CMD9XTEST is set, ENDPOINT_OID needs to be set
# so that output will reflect proper behavior.  This allows the is_lcf_ep function to work
# correctly.
#
if [ ! -z "$CMD9XTEST" ]; then

	if [ -z "$ENDPOINT_OID" ]; then

		ENDPOINT_OID="1234567890.1.123+#TMF_Endpoint::Endpoint#"

	fi

fi

# Get the uname and store it
theuname=`uname`


##################################################################################
#
#
##################################################################################
if [ -n "" ]; then
  set -x
  DEBUG=true
fi

TASK_PROGPATH="`echo $0 | sed -e 's.\\\\./.g'`"
THIS_SCRIPT="$SCRIPTNAME.sh"

#
#    Set up some popular environment variables
#
source_etc_setup_env
BINDIR="`bindir`"; export BINDIR
INST_DIR="`inst_dir`"; export INST_DIR
MNNAME="`mnname`"; export MNNAME
TEMP="`temp`"; export TEMP

#
#    Debugging code: by creating a directory called .plusdebug in
#        the appropriate TEMP directory, the output of scripts may be
#        redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR="$TEMP/.plusdebug"
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > "$DEBUGDIR/$THIS_SCRIPT" 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv
[ "$DEBUG" = true ] && set -xv

#
#    Set up variables for our basic directories, path
#
PLUSDIR="$INST_DIR/generic_unix/TME/PLUS"
LINKDIR="$PLUSDIR/LINK"
PRODDIR="$PLUSDIR/$PLUS_PROD_DIR"
PATH="$LINKDIR:$PRODDIR:$PATH"
export PATH


#----------------------------------------------------------
#    Setup local variables and log message file
#
init_this_script

cd "$TMP"
log_message "cd $TMP"

#----------------------------------------------------------
# Begin actual install specific operations
#
rc=0

log_message "Executing $THIS_SCRIPT ($TASK_PROGPATH)"


#----------------------------------------------------------
#  Get the directory where  utility files are installed
#
set_utils_dir
STATUS=$?
if [ $STATUS -ne 0 ] ; then
	log_error "Could not locate the Plus Utilities directory $UtilsDir."
    rc="$FATALRC"
    exit $rc
fi

#----------------------------------------------------------
#  add Utility directory to Path
#
#PATH="$UtilsDir:$PATH"
#export PATH

#----------------------------------------------------------
#  now run 
#
rc=0
SETVAR_SCRIPT="cpqsetvars.sh"

CIM_BROWSER=$1
CIM_BROWSER="`echo $CIM_BROWSER | sed -e 's,\\\\,/,g'`"
log_message "CIM_BROWSER=$CIM_BROWSER"

create_cpqsetvars
STATUS=$?
if [ $STATUS -ne 0 ] ; then
	log_error "Could not create script $SETVARS_PATH."
    rc=$STATUS
fi

#----------------------------------------------------------
#    Last, dont forget to cleanup before leaving 
#
# delete_temp_files

log_message "Exiting with return code $rc"

exit $rc

