#!/bin/sh
# $Id: $
#
# Component:	TivoliPlus Generic Installation Script.
#
# $Source: $
# $Revision: $
#
# Description:  
#		
#
# Author:	Fran Costanzo
#		Tivoli Systems, Inc.
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1996-2000
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#


#
#	Setup Tivoli environment variables and call script
#	to set up product specific stuff.
#

#
# make sure this script runs in the C locale, but outmsg funcs will look at USER_LANG
#
SAVE_LANG=$LANG
if [ "$LANG" != C ]; then
  USER_LANG=$LANG; export USER_LANG
  LANG=C; export LANG
fi

#
#	Set up environment (similar to old /etc/Tivoli/setup_env.sh)
#
OSERV=`objcall 0.0.0 get_oserv`; export OSERV
INST_DIR=`objcall $OSERV query install_dir | tr "\\\\\\\\" "/"`; export INST_DIR
INTERP=`objcall $OSERV query interp`; export INTERP
BINDIR=$INST_DIR/$INTERP; export BINDIR
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK; export LINKDIR
DBDIR=`objcall $OSERV query db_dir | tr "\\\\\\\\" "/"`; export DBDIR
TEMP=/tmp; export TEMP
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
fi
if [ ! -d $TEMP ]; then
	$LINKDIR/mkdir.sh $TEMP
fi
PATH=$LINKDIR:$PATH; export PATH


#	get all the common functions loaded
#
. $LINKDIR/PLUScommon-install.sh

check_apps_installed

if $TEC_INSTALLED; then
	TEC_SENTRY_INFORMATIONAL_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_RESET_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_NORMAL_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_FATAL_CLAUSE="-T FATAL EventServer"
	TEC_SENTRY_CRITICAL_CLAUSE="-T CRITICAL EventServer"
	TEC_SENTRY_SEVERE_CLAUSE="-T MINOR EventServer"
	TEC_SENTRY_MINOR_CLAUSE="-T MINOR EventServer"
	TEC_SENTRY_WARNING_CLAUSE="-T WARNING EventServer"
	TEC_SENTRY_HARMLESS_CLAUSE="-T HARMLESS EventServer"
fi

cd $PRODDIR
. ./PLUSproduct-info.sh

if [ "$WINSTRUCTED" = true ]; then
	log_failure `outmsg LinkInstallCat 117 "Informational script %1\\$s/PLUSproduct-info.sh was produced by winstruct and cannot be used for this install process." "$PRODDIR"`
	exit 
fi
WINSTRUCTED=false; export WINSTRUCTED

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR=$TEMP/.plusdebug
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
## just make it true always...
DEBUG=true
export DEBUG

#
# Set shell flags for trace, abort install if error
#
if $DEBUG; then set -xv; fi
set -e

#
# Start processing info here
#
common_init || exit 1

log_start_install

#
# Create the collection for this module in the TivoliPlus collection
#
create_plus_collection || exit 1

#
# Create application launch icons
#
if $DO_JOBS || $ALL ; then
  create_app_launch || exit 1
fi

#
#	set install options
#
if $DO_JOBS || $ALL ; then
  set_install_options || exit 1
fi

#
# Create subscription list profile managers;
# Determine to which subscription list, if any, this host should be added
# NOTE: Do this even if ALL is false, since tasks etc. may refer to these
#
create_subscription_lists || exit 1

add_host_to_subscription_lists || exit 1

if $DO_JOBS || $ALL ; then
  #
  # Create task collections and tasks
  #
  create_task_collections || exit 1

  #
  # Create application management tasks
  #
  create_administrative_tasks || exit 1

  #
  # Create /Plus configuration tasks.
  #
  create_plus_config_tasks || exit 1

  #
  # Create the Logfile adapter configuration task
  #
  create_log_config_tasks || exit 1

  #
  # Create the custom adapter configuration task
  #
  create_adapter_config_tasks || exit 1

  #
  # Create hidden tasks to be called from
  #	sentry monitors
  #
  create_sentry_hidden_tasks || exit 1

  #
  # Create hidden tasks
  #
  create_tec_hidden_tasks || exit 1

fi

#
# If Sentry is installed, then create the profile managers and indicator
#	collections
#
if $SENTRY_INSTALLED ; then
  if $DO_SENTRIES || $ALL ; then
	#
	# Create the sentry profiles and monitors
	#
	create_sentry_profiles || exit 1
  fi
else
	errmsg LinkInstallCat 26 "Tivoli Distributed Monitoring NOT installed!"
fi

#
# If Courier is installed, then create the file packages
#
if $COURIER_INSTALLED ; then
  if $DO_FILEPACKS || $ALL ; then
	create_file_packages || exit 1
  fi
else
	errmsg LinkInstallCat 25 "Tivoli Software Distribution NOT installed!"
fi

#
# If TEC is installed, then create the events and load rule bases
#
if $TEC_INSTALLED ; then
  if $DO_JOBS || $ALL ; then

	#
	# Install TEC config task
	#
	create_tec_config_tasks || exit 1
  fi
else
	errmsg LinkInstallCat 27 "Tivoli Enterprise Console NOT installed!"
fi

#
# If TAPM is installed, then create the Mar profiles
#
if $TAPM_INSTALLED ; then
  if $DO_SENTRIES || $ALL ; then
	create_mar_profiles || exit 1
  fi
else
  	errmsg LinkInstallCat 206 "Tivoli Manager for Application Performance NOT installed!"
fi

#
# If Inventory is installed, then create file signatures
#
if $INVENTORY_INSTALLED ; then
  if $ALL ; then
	create_inventory_profiles || exit 1
  fi
else
  	errmsg LinkInstallCat 214 "Tivoli Inventory NOT installed!"
fi

#
# Configure TMA for LCF endpoint support
#
if [ "$TMA_ENABLED" = true ]; then
  do_configure_TMA
fi

#
# Run the configuration task, if it exists
#
if [ -f $PRODDIR/PLUSconfig.sh ]; then
	chmod +x $PRODDIR/PLUSconfig.sh
	$PRODDIR/PLUSconfig.sh
fi

touch $DBDIR/${SHORT_prodname}plus-installed

log_end_install

#
# Save the log files if $DEBUGDIR exists
#
if [ -d "$DEBUGDIR" ]; then
	if [ -n "${SHORT_PRODNAME}" ]; then
	  if cp $TEMP/${SHORT_PRODNAME}* $DEBUGDIR/. > /dev/null 2>&1; then : ; fi
	fi
	if [ -n "${PATCH_ID}" ]; then
	  if cp $TEMP/${PATCH_ID}* $DEBUGDIR/. > /dev/null 2>&1; then : ; fi
	fi
fi

# restore user's locale
LANG=$SAVE_LANG

###return 0  # (can't return from function)
