#!/bin/sh
#
# File:		PLUScreate_sublist_task.sh
#
# Product:	Tivoli Module
# Description:	Shell Script to create a subscription list
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997-2000
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
[ "$DEBUG" = true ] && set -xv

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT=PLUScreate_sublist_task.sh

THIS_DIR=`dirname $0`
PATH=$THIS_DIR:$PATH; export PATH


#
#	Set up environment (similar to old /etc/Tivoli/setup_env.sh)
#
OSERV=`objcall 0.0.0 get_oserv`; export OSERV
INST_DIR=`objcall $OSERV query install_dir | tr "\\\\\\\\" "/"`; export INST_DIR
INTERP=`objcall $OSERV query interp`; export INTERP
BINDIR=$INST_DIR/$INTERP; export BINDIR

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK; export LINKDIR
DBDIR=`objcall $OSERV query db_dir | tr "\\\\\\\\" "/"`; export DBDIR
TEMP=/tmp; export TEMP
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
fi
if [ ! -d $TEMP ]; then
	$LINKDIR/mkdir.sh $TEMP
fi
PATH=$LINKDIR:$PATH; export PATH

#
#	Set up some popular environment variables.
#
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts may be
#		redirected to a file in TEMP by the same name as the script.

EXEC_MSG=`wbindmsg LinkCmdCat 23 "... Executing %1\\$s (%2\\$s)" "$THIS_SCRIPT" "$TASK_PROGPATH" 2> /dev/null`
if [ ! "$EXEC_MSG" ]; then
	EXEC_MSG="... Executing $THIS_SCRIPT ($TASK_PROGPATH)"
fi

USAGE=`wbindmsg LinkCmdCat 24 "Usage: %1\\$s module_name sublist_name [dataless_ep_boolean]" "$THIS_SCRIPT" 2> /dev/null`
if [ ! "$USAGE" ]; then
	USAGE="Usage: $THIS_SCRIPT module_name sublist_name [dataless_ep_boolean]"
fi

DEBUGDIR=$TEMP/.plusdebug
RESULTS_MSG=`wbindmsg LinkCmdCat 22 "... Results redirected to %1\\$s/%2\\$s" "$DEBUGDIR" "$THIS_SCRIPT" 2> /dev/null`
if [ ! "$RESULTS_MSG" ]; then
	RESULTS_MSG="... Results redirected to $DEBUGDIR/$THIS_SCRIPT"
fi
[ -d "$DEBUGDIR" ] \
  && echo $RESULTS_MSG \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv && DEBUG=true && export DEBUG
[ -f "$DEBUGDIR" ] && set -xv && DEBUG=true && export DEBUG

rc=0

echo $EXEC_MSG

MODULE_NAME="$1"
SUBLIST_NAME="$2"
DATALESS_EP="$3"

if [  $# -lt 2 -o -z "$SUBLIST_NAME" ] ; then
	echo $USAGE
	exit 1
fi

if wlookup -ar Gateway > /dev/null 2>& 1; then
  :
else
  DATALESS_EP=false
  MSG=`wbindmsg LinkCmdCat 25 "WARNING: This version of the Framework does not support dataless endpoints ..." 2> /dev/null`
  if [ ! "$MSG" ]; then
    MSG="WARNING: This version of the Framework does not support dataless endpoints ..."
  fi
  echo $MSG
fi

PMDSL=$INST_DIR/generic_unix/TME/PLUS/LINK/PM_icon.d
if [ "$DATALESS_EP" = true ]; then
  PMSTATE=TSPMD
  PMXPM=$INST_DIR/generic_unix/TME/PLUS/LINK/PM_icon_dataless.xpm  
else
  PMSTATE=TSPM
  PMXPM=$INST_DIR/generic_unix/TME/PLUS/LINK/PM_icon.xpm
fi

if wlsicon -r ProfileManager | grep "^$PMSTATE$" > /dev/null; then
  :
else
  wputicon -r ProfileManager $PMSTATE $PMDSL $PMXPM
fi


wcrtsprfmgr "$MODULE_NAME" "$SUBLIST_NAME" $PMSTATE $DATALESS_EP
rc=$?

if [ "$DATALESS_EP" = true ]; then
	wsetpm -d  "@ProfileManager:$SUBLIST_NAME#$IRONAME"
fi

EXITMSG=`wbindmsg LinkCmdCat 26 "... Exiting %1\\$s (%2\\$s) with return code %3\\$s" "$THIS_SCRIPT" "$TASK_PROGPATH" "$rc" 2> /dev/null`
if [ ! "$EXITMSG" ]; then
	EXITMSG="... Exiting $THIS_SCRIPT ($TASK_PROGPATH) with return code $rc"
fi
echo $EXITMSG
echo

exit $rc

