Language = "en|US|iso8859-1"

Start Component

   Name = "Insight TEC Configuration"

   Description = "Configure rule base for HP Insight Integration for Tivoli."

   Start Group
      Name = "Component Type"
      Class = "AMS|ComponentType|001"
      ID = 90
      Description = "This group provides the information required to identifythe application management building block represented bya particular application definition file"
      Start Attribute
         Name = "Component Type"
         ID = 1
         Description = "This attribute identifies the type of application management building block that a particular application definition file is for."
         Type = 
            Start Enum
               0 = "other"
               1 = "Business System Mapping"
               2 = "Business System Component"
               3 = "Business Subsystem"
               4 = "Business System"
               5 = "Reserved For Future Use"
               6 = "Software Component"
               7 = "Application or Suite"
               8 = "Maintenance"
            End Enum
         Value = 6
      End Attribute
      Start Attribute
         Name = "Component Type String"
         ID = 2
         Description = "Identifies the type of application description file when the 'other' value is used for the Component Type attribute."
         Type = String(64)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Application Management Specification Level"
      Class = "AMS|Application Management Specification Level|001"
      ID = 40
      Description = "This group identifies the level or version of the AMS that was used to construct this building block."
      Start Attribute
         Name = "AMS Level"
         ID = 1
         Description = "This attribute identifies the level of AMS being used to construct a particular building block."
         Type = 
            Start Enum
               1 = "AMS 1.0"
               2 = "AMS 1.1"
               3 = "AMS 2.0"
            End Enum
         Value = 3
      End Attribute
   End Group

   Start Group
      Name = "ComponentID"
      Class = "DMTF|ComponentID|001"
      ID = 1
      Description = "This group defines a set of attributes used to identify a particular component or building block."
      Start Attribute
         Name = "Manufacturer"
         ID = 1
         Description = "Name of building block's manufacturer."
         Type = String(64)
         Value = "HPQ"
      End Attribute
      Start Attribute
         Name = "Product"
         ID = 2
         Description = "Product name for this component."
         Type = String(64)
         Value = "Insight TEC Configuration"
      End Attribute
      Start Attribute
         Name = "Version"
         ID = 3
         Description = "Version number of this component."
         Type = String(64)
         Value = "4.1.0"
      End Attribute
      Start Attribute
         Name = "Serial Number"
         ID = 4
         Description = "Serial Number for this component."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Installation"
         ID = 5
         Description = "The installation date and time of this component."
         Type = Date
         Value = ""
      End Attribute
      Start Attribute
         Name = "Verify"
         ID = 6
         Description = "A code that provides a level of verification that the component is installed and working."
         Type = 
            Start Enum
               0 = "An error occurred; check status code"
               1 = "This component does not exist"
               2 = "The verify is not supported"
               3 = "Reserved"
               4 = "This component exists, but the functionality is untested"
               5 = "This component exists, but the functionality is unknown"
               6 = "This component exists, and is not functioning correctly"
               7 = "This component exists, and is functioning correctly"
            End Enum
         Value = 2
      End Attribute
   End Group

   Start Group
      Name = "Location"
      Class = "DMTF|Location|001"
      Description = "This group identifies the various locations where parts of a software product have been installed."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "Index of this location entry."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Location Type"
         ID = 2
         Description = "The type of this location."
         Type = 
            Start Enum
               1 = "Unknown"
               2 = "Other"
               3 = "Product base directory"
               4 = "Product executables directory"
               5 = "Product library directory"
               6 = "Product configuration directory"
               7 = "Product include directory"
               8 = "Product working directory"
               9 = "Product log directory"
               10 = "Shared base directory"
               11 = "Shared executables directory"
               12 = "Shared library directory"
               13 = "Shared include directory"
               14 = "System base directory"
               15 = "System executables directory"
               16 = "System library directory"
               17 = "System configuration directory"
               18 = "System include directory"
               19 = "System log directory"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Path"
         ID = 3
         Description = "The path to this location."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Icon"
      Class = "AMS|ICON|001"
      Description = "This group identifies files with icons that can be used to display a business system component on a screen"
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "Unique number used to identify thie icon."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "File Name"
         ID = 2
         Description = "File name or path to the icon file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "File Location"
         ID = 3
         Description = "Location index."
         Type = Integer
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Software Component Information"
      Class = "DMTF|Software Component Information|002"
      ID = 2
      Description = "This group defines a set of attributes used to identify a particular software component or building block."
      Start Attribute
         Name = "Major Version"
         ID = 1
         Description = "Major version of this software component"
         Type = String(64)
         Value = "4"
      End Attribute
      Start Attribute
         Name = "Minor Version"
         ID = 2
         Description = "Minor version of this software component"
         Type = String(64)
         Value = "1"
      End Attribute
      Start Attribute
         Name = "Revision"
         ID = 3
         Description = "Revision of this software component"
         Type = String(64)
         Value = "0"
      End Attribute
      Start Attribute
         Name = "Build"
         ID = 4
         Description = "Manufacturer's internal identifier for this compilation."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Target Operating System"
         ID = 5
         Description = "The operating system for which this software component is intended"
         Type = 
            Start Enum
               0 = "other"
               1 = "DOS"
               2 = "MACOS"
               3 = "OS2"
               4 = "UNIX"
               5 = "WIN16"
               6 = "WIN32"
               7 = "OPENVMS"
               8 = "NetWare"
               9 = "WIN9x"
               10 = "WINNT"
            End Enum
         Value = 0
      End Attribute
      Start Attribute
         Name = "Language Edition"
         ID = 6
         Description = "This identifies the language edition of this component. The language codes defined in ISO 639 should be used. Where the software componentrepresents a multi-lingual or international version of a product, the string 'multilingual' should be used."
         Type = String(32)
         Value = "en"
      End Attribute
      Start Attribute
         Name = "Identification Code"
         ID = 7
         Description = "The value of this attribute is the software publisher's identifier for this software component. Often this will be stock keeping unit or a part number."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Installable State"
         ID = 8
         Description = "Specifies whether this component describes a software product installed for the purpose of further distribution."
         Type = 
            Start Enum
               1 = "Unknown"
               2 = "Installable"
               3 = "Not Installable"
            End Enum
         Value = 1
      End Attribute
      Start Attribute
         Name = "Executable State"
         ID = 9
         Description = "This attribute indicates the executable state of a software component."
         Type = 
            Start Enum
               1 = "Unknown"
               2 = "Executable"
               3 = "Not Executable"
            End Enum
         Value = 1
      End Attribute
   End Group

   Start Group
      Name = "Distributed Component Information"
      Class = "AMS|DistComponent|002"
      ID = 78
      Description = "This group identifies information for a distributed software component."
      Start Attribute
         Name = "Component Function"
         ID = 1
         Description = "Function of this component within the application"
         Type = String(64)
         Value = "TEC Configuration"
      End Attribute
      Start Attribute
         Name = "Operating System Identification"
         ID = 6
         Description = "A string uniquely identifying a specific operating system name and major version."
         Type = String(64)
         Value = "unknown"
      End Attribute
      Start Attribute
         Name = "Is Server"
         ID = 7
         Description = "Whether this component is a server of some other application component(s)."
         Type = 
            Start Enum
               0 = "no"
               1 = "yes"
            End Enum
         Value = 0
      End Attribute
   End Group

   Start Group
      Name = "Software Source Location"
      Class = "AMS|SourceLocation|001"
      Description = "This group identifies the location where a software product resides on a distribution server."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "Index of this location entry."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Type"
         ID = 2
         Description = "The type of this location."
         Type = 
            Start Enum
               1 = "Unknown"
               2 = "Other"
               3 = "Product base directory"
               4 = "Product executables directory"
               5 = "Product library directory"
               6 = "Product configuration directory"
               7 = "Product include directory"
               8 = "Product working directory"
               9 = "Product log directory"
               10 = "Shared base directory"
               11 = "Shared executables directory"
               12 = "Shared library directory"
               13 = "Shared include directory"
               14 = "System base directory"
               15 = "System executables directory"
               16 = "System library directory"
               17 = "System configuration directory"
               18 = "System include directory"
               19 = "System log directory"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Path"
         ID = 3
         Description = "The path to this location."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Asynchronous Monitor"
      Class = "AMS|AsynchMonitor|002"
      Description = "Specifies an event or status generated by this component."
      Key = 1
      Start Attribute
         Name = "Name"
         ID = 1
         Description = "Name for this monitor"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Value Description"
         ID = 2
         Description = "Description of the event type that is generated"
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Description"
         ID = 3
         Description = "A textual description of this monitor"
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Name"
         ID = 4
         Description = "File name or path to the help file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Location"
         ID = 5
         Description = "Location index."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format"
         ID = 6
         Description = "The format used in the help file format."
         Type = 
            Start Enum
               0 = "other"
               1 = "HTML"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format String"
         ID = 7
         Description = "Used when Help File format is other."
         Type = String(32)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Connection Type"
      Class = "AMS|ConnectionType|001"
      Description = "This group provides a way to identify connection types."
      Key = 1,2
      Start Attribute
         Name = "Type Name"
         ID = 1
         Description = ""
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Direction"
         ID = 2
         Description = "Connection direction"
         Type = 
            Start Enum
               1 = "origin"
               2 = "destination"
               3 = "conversational"
            End Enum
      End Attribute
      Start Attribute
         Name = "Query Contact Task"
         ID = 3
         Description = "Reference to the task that queries contact information."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Discover Connection Task"
         ID = 4
         Description = "Reference to the task that discovers connections."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Select Connection Task"
         ID = 5
         Description = "Reference to a task that accepts a list of contact details."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Add Connection Task"
         ID = 6
         Description = "Reference to a task that adds a connection for a specified contact."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Remove Connection Task"
         ID = 7
         Description = "Reference to the task that removes connections."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Name"
         ID = 8
         Description = "File name or path to the help file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Location"
         ID = 9
         Description = "Location index."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format"
         ID = 10
         Description = "The format used in the help file format."
         Type = 
            Start Enum
               0 = "other"
               1 = "HTML"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format String"
         ID = 11
         Description = "Used when Help File format is other."
         Type = String(32)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Generic Dependency Instance"
      Class = "AMS|GenDepInst|001"
      Description = "This group lists dependencies for this component."
      Key = 1,2
      Start Attribute
         Name = "Type Name"
         ID = 1
         Description = "The type of dependency"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Argument Value List"
         ID = 2
         Description = "List of argument strings"
         Type = String(1024)
      End Attribute
   End Group

   Start Group
      Name = "Generic Dependency Type"
      Class = "AMS|GenDepType|001"
      Description = "Generic dependencies of this application component."
      Key = 1
      Start Attribute
         Name = "Name"
         ID = 1
         Description = "Name for this dependency type."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "File Name"
         ID = 2
         Description = "File name (or full path) for dependency script."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 3
         Description = "Location index of source directory for dependency script."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Description"
         ID = 4
         Description = "A textual description of this dependency type."
         Type = String(1024)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Generic Dependency Arguments"
      Class = "AMS|GenDepArg|001"
      Description = "This group describes the argument declaration for generic dependencies."
      Key = 1,2
      Start Attribute
         Name = "Type Name"
         ID = 1
         Description = "Which dependency type script this argument is for."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Argument Position"
         ID = 2
         Description = "Position of this argument on the script command line with 1=first argument."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Label"
         ID = 3
         Description = "Text describing the purpose of this argument."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Synchronous Monitor"
      Class = "AMS|SynchMonitor|002"
      Description = "Specifies an entry in this component that can be monitored."
      Key = 1
      Start Attribute
         Name = "Name"
         ID = 1
         Description = "A name for this monitor."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Value Type"
         ID = 2
         Description = "The type of data returned by this monitor."
         Type = 
            Start Enum
               0 = "Integer"
               1 = "String"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Value Description"
         ID = 3
         Description = "Describes the information returned by this monitor."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Suggested Polling Interval"
         ID = 4
         Description = "Recommended interval between polls to this monitor in seconds."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Program Name"
         ID = 5
         Description = "File Name (or full path) of program that returns the monitor value."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Description"
         ID = 6
         Description = "A textual description of this monitor."
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 7
         Description = "Location index of the program."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Event Classification"
         ID = 8
         Description = "The name of the event type to generate if the monitor value exceeds assigned thresholds."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Name"
         ID = 9
         Description = "File name or path to the help file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Location"
         ID = 10
         Description = "Location index."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format"
         ID = 11
         Description = "The format used in the help file format."
         Type = 
            Start Enum
               0 = "other"
               1 = "HTML"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format String"
         ID = 12
         Description = "Used when Help File format is other."
         Type = String(32)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Synchronous Monitor Arguments"
      Class = "AMS|SynchMonitorArg|002"
      Description = "Argument declarations for synchronous monitors."
      Key = 1,2
      Start Attribute
         Name = "Monitor Name"
         ID = 1
         Description = "Name of the monitor that has these arguments"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Argument Position"
         ID = 2
         Description = "Position of this argument on the program command line with 1=first argument"
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Label"
         ID = 3
         Description = ""
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "AMS Symbolic Name"
         ID = 4
         Description = "The name of the AMS construct that can be a legal value for this argument."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Tool Specific Symbolic Name"
         ID = 5
         Description = "A symbolic name understood by the management tool identified by the Tool Name attribute."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Tool Name"
         ID = 6
         Description = "The manufacturer, product name, and version of the tool that understands the symbolic name specified for the Tool Specific Symbolic Name attribute."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Synchronous Monitor Instance"
      Class = "AMS|SynchMonitorInstance|001"
      Description = "Provides parameterization for a specific instance of a synchronous monitor."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "A unique identifier for this instance."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Monitor Name"
         ID = 2
         Description = "The monitor type"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Argument Value List"
         ID = 3
         Description = "Argument Value List"
         Type = String(1024)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Monitor Threshold"
      Class = "AMS|SynchMonitorThreshold|001"
      Description = "Specifies a threshold and associated response for a synchronous monitor instance."
      Key = 1,2,3
      Start Attribute
         Name = "Instance Index"
         ID = 1
         Description = "Index identifying the monitor instance"
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Threshold Value"
         ID = 2
         Description = "Threshold value to check against"
         Type = String(256)
      End Attribute
      Start Attribute
         Name = "Threshold Relative Operator"
         ID = 3
         Description = "Defines how the monitor value should be compared to the threshold."
         Type = 
            Start Enum
               0 = "greater than"
               1 = "greater than or equal"
               2 = "less than"
               3 = "less than or equal"
               4 = "equal"
               5 = "not equal"
               6 = "changes to"
               7 = "changes from"
               8 = "crosses above"
               9 = "crosses below"
               10 = "matches"
               11 = "does not match"
            End Enum
      End Attribute
      Start Attribute
         Name = "Severity"
         ID = 4
         Description = "Severity associated with this threshold"
         Type = 
            Start Enum
               0 = "Normal"
               1 = "Informational"
               2 = "Warning"
               3 = "Severe"
               4 = "Critical"
               5 = "Fatal"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Response Task"
         ID = 5
         Description = "Name of Task to execute if the threshold condition is met."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Response Task Argument List"
         ID = 6
         Description = "List of argument strings to be passed"
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Generate Event"
         ID = 7
         Description = "Whether to generate an event when this threshold condition is met"
         Type = 
            Start Enum
               0 = "no"
               1 = "yes"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Monitor Icon"
      Class = "AMS|MonitorIcon|001"
      Description = "This group allows a provider to specify ICON for a monitor list display."
      Key = 1,2
      Start Attribute
         Name = "Monitor Name"
         ID = 1
         Description = "The name of the monitor this ICON can be used for."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Index"
         ID = 2
         Description = "An integer to uniquely identify the ICON."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "File Name"
         ID = 3
         Description = "File name or path to the icon file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "File Location"
         ID = 4
         Description = "Location Index"
         Type = Integer
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "ARM Transaction"
      Class = "AMS|ARMTransaction|002"
      Description = "This group provides basic information about a transaction supported by an application."
      Key = 1,2
      Start Attribute
         Name = "Transaction Context"
         ID = 1
         Description = "The application context in which this transaction exists."
         Type = String(128)
      End Attribute
      Start Attribute
         Name = "Transaction Name"
         ID = 2
         Description = "Defines the name of the transaction that will be passed on the arm_getid to the ARM API.  Must be unique."
         Type = String(128)
      End Attribute
      Start Attribute
         Name = "Version"
         ID = 3
         Description = "The version string of the ARM API."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Transaction Description"
         ID = 4
         Description = "A textual description of the function of th is transaction."
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Universal Transaction ID"
         ID = 5
         Description = "A unique identifier assigned to the transaction definition (not each instance of the transaction at runtime)."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Universal Transaction ID Format"
         ID = 6
         Description = "Defines which of the several possible formats the Universal Transaction ID is in.Refer to the ARM API Guide (when it will be available) for the allowable values."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Is User ID Provided"
         ID = 7
         Description = "True if the User ID is provided in the arm_init call."
         Type = 
            Start Enum
               0 = "false"
               1 = "true"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Is Correlator Received"
         ID = 8
         Description = "True if the correlators received from parent transactions are passed on arm_start call."
         Type = 
            Start Enum
               0 = "false"
               1 = "true"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Is Correlator Requested"
         ID = 9
         Description = "True if the correlators are requested when this transaction is initiated."
         Type = 
            Start Enum
               0 = "false"
               1 = "true"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Is ARM Settable"
         ID = 10
         Description = "True if calls to the ARM API can be turned on/off with a mechanism provided in the software component."
         Type = 
            Start Enum
               0 = "false"
               1 = "true"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Response Time Boundaries"
      Class = "AMS|ResponseTimeBoundaries|001"
      Description = "This group is a table for setting defaule response time boundaries. "
      Key = 1,2,3
      Start Attribute
         Name = "Transaction Context"
         ID = 1
         Description = "The application context in which this transaction boundary exists."
         Type = String(128)
      End Attribute
      Start Attribute
         Name = "Transaction Name"
         ID = 2
         Description = "The name of the transaction that this boundary applies to."
         Type = String(128)
      End Attribute
      Start Attribute
         Name = "Boundary Position"
         ID = 3
         Description = "The ordered position of the boundary, which defines the interval.  In ARM 2.0, this value is between 1 and 6."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Boundary Value"
         ID = 4
         Description = "The actual boundary value, in milliseconds."
         Type = Integer
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Transaction Metrics"
      Class = "AMS|TransactionMetrics|001"
      Description = "This group provides basic information about a transaction supported by an application."
      Key = 1,2,3
      Start Attribute
         Name = "Transaction Context"
         ID = 1
         Description = "The application context in which this transaction boundary exists."
         Type = String(128)
      End Attribute
      Start Attribute
         Name = "Transaction Name"
         ID = 2
         Description = "The name of the transaction that this boundary applies to."
         Type = String(128)
      End Attribute
      Start Attribute
         Name = "Metric Position"
         ID = 3
         Description = "The ordered position of the metric. In ARM 2.0, the value is between 1 and 7."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Metric Name"
         ID = 4
         Description = "The application-defined name of the metric.  This should match the name passed in the metadata on the arm_getid call."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Metric Format"
         ID = 5
         Description = "The type of metric provided.  The values 1..9 are valid only for metrics #1-#6, and value 10 is valid only for metric #7."
         Type = 
            Start Enum
               0 = "other"
               1 = "ARM_Counter32"
               2 = "ARM_Counter64"
               3 = "ARM_CntrDivr32"
               4 = "ARM_Gauge32"
               5 = "ARM_Gauge64"
               6 = "ARM_GaugeDivr32"
               7 = "ARM_NumericID32"
               8 = "ARM_NumericID64"
               9 = "ARM_String8"
               10 = "ARM_String32"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Metric Description"
         ID = 6
         Description = "A description of the metric and how it is used."
         Type = String(1024)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Transaction Signature"
      Class = "AMS|TransactionSignature|001"
      Description = "This group provides basic information about a transaction signature."
      Key = 1
      Start Attribute
         Name = "Signature Name"
         ID = 1
         Description = "The name or label assigned to the signature."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Signature Description"
         ID = 2
         Description = "A description of the signature's purpose or function."
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 3
         Description = "The directory where the file resides. All the files in a signature must reside in the same location.Usage Rule: See Location Reference Rule on page 162."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Transaction Context"
         ID = 4
         Description = "The application context of the transaction that this signature identifies."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Transaction Name"
         ID = 5
         Description = "The name of the transaction that this signature identifies."
         Type = String(128)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Transaction Signature File"
      Class = "AMS|TransactionSignatureFile|001"
      Description = "This group provides information about the files in a transaction signature."
      Key = 1,2
      Start Attribute
         Name = "Signature Name"
         ID = 1
         Description = "The name or label assigned to the signature that this file describes."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "File Name"
         ID = 2
         Description = "The name of a file needed to configure an agent to recognize an event pattern."
         Type = String(256)
      End Attribute
   End Group

   Start Group
      Name = "Transaction Signature Transaction"
      Class = "AMS|TransactionSignatureTransaction|001"
      Description = "This group links the signature to the transaction or set of transactions that it identifies."
      Key = 1,2,3
      Start Attribute
         Name = "Signature Name"
         ID = 1
         Description = "The name or label assigned to the signature that this file describes."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Transaction Context"
         ID = 2
         Description = "The application context in which this transaction exists.\nUsage Rule: The Transaction Context and Transaction Name Pair must match a definition of an ARM Transaction Group."
         Type = String(256)
      End Attribute
      Start Attribute
         Name = "Transaction Name"
         ID = 3
         Description = "The name of the transaction as known at the ARM API.\nUsage Rule: The Transaction Context and Transaction Name Pair must match a definition of an ARM Transaction Group"
         Type = String(256)
      End Attribute
   End Group

   Start Group
      Name = "Virtual User Script"
      Class = "AMS|VirtualUserScript|001"
      Description = "This group provides basic information about a virtual user script."
      Key = 1
      Start Attribute
         Name = "Virtual User Script Name"
         ID = 1
         Description = "The name or label assigned to the script."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Virtual User Script Description"
         ID = 2
         Description = "A description of the script's purpose or function."
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 3
         Description = "The directory where the script resides. All files in the script must be in the same location.Usage Rule: See Location Reference Rule on page 162."
         Type = Integer
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Virtual User Script Argument"
      Class = "AMS|VirtualUserScriptArgument|001"
      Description = "This group provides information about each argument used to invoke the virtual user script."
      Key = 1,2
      Start Attribute
         Name = "Virtual User Script Name"
         ID = 1
         Description = "The name or label assigned to the script. "
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Argument Position"
         ID = 2
         Description = "The position of this argument on the program command line.Usage Rule: The first position has a value of 1."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Label"
         ID = 3
         Description = "This attribute describes the argument."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Argument Binding"
         ID = 4
         Description = "The program command line string that can be used to determine the value of the argument (including any argument string passed)."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Argument Value"
         ID = 5
         Description = "The value to be used for this argument when no binding is provided."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Virtual User Script File"
      Class = "AMS|VirtualUserScriptFile|001"
      Description = "This group provides information about each file used to describe the virtual user script."
      Key = 1,2
      Start Attribute
         Name = "Virtual User Script Name"
         ID = 1
         Description = "The name or label assigned to the script that this file implements. "
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "File Name"
         ID = 2
         Description = "The name of a file needed to configure an agent to execute a script that simulates a virtual user."
         Type = String(256)
      End Attribute
   End Group

   Start Group
      Name = "Virtual User Script Transaction"
      Class = "AMS|VirtualUserScriptTransaction|001"
      Description = "This group links the virtual user script to the transaction or set of transactions that it simulates."
      Key = 1,2,3
      Start Attribute
         Name = "Virtual User Script Name"
         ID = 1
         Description = "The name or label assigned to the script that this transaction is associated with."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Transaction Context"
         ID = 2
         Description = "The application context in which this transaction exists.Usage Rule: The Transaction Context and Transaction Name pair must match a definition of the ARM Transaction Group."
         Type = String(256)
      End Attribute
      Start Attribute
         Name = "Transaction Name"
         ID = 3
         Description = "The name of the transaction as known at the ARM API.\nUsage Rule:The Transaction Context and Transaction Name pair must match a definition of the ARM Transaction Group."
         Type = String(256)
      End Attribute
   End Group

   Start Group
      Name = "Distributed Installation"
      Class = "AMS|DistInstall|002"
      Description = "This group describes the installation programs for this component."
      Key = 1
      Start Attribute
         Name = "Program Name"
         ID = 1
         Description = "File name (or path) of this program on the distribution server."
         Type = String(256)
      End Attribute
      Start Attribute
         Name = "Purpose"
         ID = 2
         Description = "This attribute denotes when in the installation process that program should be executed."
         Type = 
            Start Enum
               0 = "Before install"
               1 = "After install"
               2 = "Commit"
               3 = "Before remove"
               4 = "After remove"
               5 = "On error"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Input File"
         ID = 3
         Description = "File name (or path) on distribution server of file to be passed as input to the program."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 4
         Description = "Location index of source directory for program and optional input file."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Install Tool"
         ID = 5
         Description = "This attribute describes the type of program being used"
         Type = 
            Start Enum
               0 = "Unknown or Application Defined"
               1 = "InstallShield"
               2 = "WinInstall"
               3 = "CID"
               4 = "InstallP"
               5 = "SMP/E"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Component Relationship"
      Class = "AMS|CompRelation|002"
      Description = "Relationship definitions for this component"
      Key = 1
      Start Attribute
         Name = "Name"
         ID = 1
         Description = "Relationship Name"
         Type = String(256)
      End Attribute
      Start Attribute
         Name = "Related Component Type"
         ID = 2
         Description = "The type of component that this relationship is related to."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Relationship Type"
         ID = 3
         Description = "Type of relationship."
         Type = 
            Start Enum
               0 = "Other"
               1 = "Connection"
               2 = "Replica"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Relationship Type String"
         ID = 4
         Description = "Relationship string if value of previous attribute is 'other'"
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Query Program Name"
         ID = 5
         Description = "File name (or path) of the program that returns the current value of this relationship."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Modify Program Name"
         ID = 6
         Description = "File name (or path) of the program that modifies the current value of this relationship."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 7
         Description = "Location index of directory on target system where query program (and change program) resides."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Minimum Version Major ID"
         ID = 8
         Description = "Minimum version of related component: major version id"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Minimum Version Minor ID"
         ID = 9
         Description = "Minimum version of related component: minor version id"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Minimum Version Revision ID"
         ID = 10
         Description = "Minimum version of related component: revision id"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Maximum Version Major ID"
         ID = 11
         Description = "Maximum version of related component: major version id"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Maximum Version Minor ID"
         ID = 12
         Description = "Maximum version of related component: minor version id"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Maximum Version Revision ID"
         ID = 13
         Description = "Maximum version of related component: revision id"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Name"
         ID = 14
         Description = "File name or path to the help file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Location"
         ID = 15
         Description = "Location index."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format"
         ID = 16
         Description = "The format used in the help file format."
         Type = 
            Start Enum
               0 = "other"
               1 = "HTML"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format String"
         ID = 17
         Description = "Used when Help File format is other."
         Type = String(32)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Help Information"
      Class = "AMS|HelpInformation|001"
      ID = 77
      Description = "Identifies the help file that describes a particular building block."
      Start Attribute
         Name = "Help File"
         ID = 1
         Description = "File name or path to the help file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Location"
         ID = 2
         Description = "Location index."
         Type = Integer
         Value = 0
      End Attribute
      Start Attribute
         Name = "Help File Format"
         ID = 3
         Description = "The format used in the help file format."
         Type = 
            Start Enum
               0 = "other"
               1 = "HTML"
            End Enum
         Value = 0
      End Attribute
      Start Attribute
         Name = "Help File Format String"
         ID = 4
         Description = "Used when Help File Format is other."
         Type = String(32)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Management Tool Extension"
      Class = "AMS|Management Tool Extension|001"
      Description = "Describes elements of management that pertain to a particular management tool"
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "A unique identifier for an entry."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Variable Name"
         ID = 2
         Description = "A label used to identify a particular variable or piece of management information."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Variable Data Type"
         ID = 3
         Description = "This attribute describes the intended data type of the value provided in the Value attribute"
         Type = 
            Start Enum
               0 = "Integer"
               1 = "String"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Value"
         ID = 4
         Description = "The value for the management variable specified in the Variable Name attribute."
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Tool Name"
         ID = 5
         Description = "The manufacturer, product name, and version of the tool that understands the Variable Name argument."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Operational Task"
      Class = "AMS|OpTask|002"
      Description = "Specifies a task that can be used to control this component."
      Key = 1
      Start Attribute
         Name = "Name"
         ID = 1
         Description = "name for this task"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Description"
         ID = 2
         Description = "description of what this task does"
         Type = String(1024)
         Value = ""
      End Attribute
      Start Attribute
         Name = "File Name"
         ID = 3
         Description = "File name (or full path name) of the task executable on the source system."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 4
         Description = "Location index to the directory on the source system where File Name exists."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Privilege"
         ID = 5
         Description = "User name under which the task must execute"
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Name"
         ID = 6
         Description = "File name or path to the help file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Help File Location"
         ID = 7
         Description = "Location index."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format"
         ID = 8
         Description = "The format used in the help file format."
         Type = 
            Start Enum
               0 = "other"
               1 = "HTML"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Help File Format String"
         ID = 9
         Description = "Used when Help File format is other."
         Type = String(32)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Execution Environment"
         ID = 10
         Description = "This optional attribute identifies the exectuionenvironment for the file specified by the File Name attribute"
         Type = 
            Start Enum
               0 = "other"
               1 = "native command line"
               2 = "JAVA"
               3 = "BMC"
               4 = "Netview CMD"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Operational Task Arguments"
      Class = "AMS|OpTaskArg|002"
      Description = "argument declaration for task executables"
      Key = 1,2
      Start Attribute
         Name = "Task Name"
         ID = 1
         Description = "which task this argument is for"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Argument Position"
         ID = 2
         Description = "position of this argument on the program command line with 1=first argument"
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Label"
         ID = 3
         Description = "Text describing the purpose of this argument"
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "AMS Symbolic Name"
         ID = 4
         Description = "The name of the AMS construct that can be a legal value for this argument"
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Tool Specific Symbolic Name"
         ID = 5
         Description = "A symbolic name understood by the management tool identified by the Tool Name attribute."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Tool Name"
         ID = 6
         Description = "The manufacturer, prouduct name, and version of the tool that understands the symbolic name specified for the Tool Specific Symbolic Name attribute."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Distribution File List"
      Class = "AMS|DistributionFileList|001"
      Description = "This group lists the files that make up this application component."
      Key = 1,2
      Start Attribute
         Name = "File Name"
         ID = 1
         Description = "File name (or full path) for this file on distribution server."
         Type = String(256)
      End Attribute
      Start Attribute
         Name = "Target Location"
         ID = 2
         Description = "Location where this file is installed on target system."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Source Relative Location"
         ID = 3
         Description = "Source Location Index to find source files on the distribution server if File Name is relative."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Target Location Fixed"
         ID = 4
         Description = "Whether the target location is fixed and cannot be changed."
         Type = 
            Start Enum
               0 = "False"
               1 = "True"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Software Signature"
      Class = "DMTF|SoftwareSignature|002"
      Description = "This group defines the attributes common to all components."
      Key = 1,7
      Start Attribute
         Name = "File Name"
         ID = 1
         Description = "The name of a file that can be examined to detect this software component."
         Type = String(256)
      End Attribute
      Start Attribute
         Name = "File Size"
         ID = 2
         Description = "The size in bytes of a file that can be examined to detect this software component."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "File Date and Time"
         ID = 3
         Description = "The date and time of a file that can be examined."
         Type = Date
         Value = ""
      End Attribute
      Start Attribute
         Name = "File Checksum"
         ID = 4
         Description = "The checksum for the first 32 bytes of this file."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "File CRC 1"
         ID = 5
         Description = "The 16-bit CRC (ITU-T) on the middle 512K of this file."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "File CRC 2"
         ID = 6
         Description = "The 16-bit CRC (ITU-T) on the middle 512K of this file, modulo 3"
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "File Location"
         ID = 7
         Description = "The location of the file, as an index into the location table."
         Type = Integer
      End Attribute
   End Group

   Start Group
      Name = "Relationship Monitor Mapping"
      Class = "AMS|RelMonitorMapping|001"
      Description = "This group allows a provider to identify monitors that watch a particular connection type"
      Key = 1,2,3
      Start Attribute
         Name = "Connection Type"
         ID = 1
         Description = "name specified in attribute of connection type group"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Direction"
         ID = 2
         Description = "Direction specified in connection type group"
         Type = 
            Start Enum
               1 = "origin"
               2 = "destination"
               3 = "conversational"
            End Enum
      End Attribute
      Start Attribute
         Name = "Monitor Name"
         ID = 3
         Description = "Name specified in attribute 1 of synchronous monitor group"
         Type = String(64)
      End Attribute
   End Group

   Start Group
      Name = "Relationship Monitor Instance Mapping"
      Class = "AMS|RelMonitorInstanceMapping|001"
      Description = "This group allows a provider to identify a monitor instance that watches a particular connection type"
      Key = 1,2,3
      Start Attribute
         Name = "Connection Type"
         ID = 1
         Description = "name specified in attribute of connection type group"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Direction"
         ID = 2
         Description = "Direction specified in connection type group"
         Type = 
            Start Enum
               1 = "origin"
               2 = "destination"
               3 = "conversational"
            End Enum
      End Attribute
      Start Attribute
         Name = "Monitor Index"
         ID = 3
         Description = "Reference to index in the Synchronous Monitor Instance groups."
         Type = Integer
      End Attribute
   End Group

   Start Group
      Name = "Monitor Tasks"
      Class = "GEM|MonTasks|001"
      Description = "Identifies the tasks used with a monitor."
      Key = 1,2
      Start Attribute
         Name = "Name"
         ID = 1
         Description = "Monitor name"
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Instance ID"
         ID = 2
         Description = "The identifier of the instance of this monitor."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Query Task Name"
         ID = 3
         Description = "Task name that retrieves the monitor value(s)."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Polling Interval Task Name"
         ID = 4
         Description = "Task name that sets the monitor polling interval."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Threshold Task Name"
         ID = 5
         Description = "Task name that sets the monitor threshold(s)."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Level Task Name"
         ID = 6
         Description = "Task name that retrieves the monitor threshold level(s)."
         Type = String(64)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Windows INI Settings"
      Class = "AMS|WinINISettings|001"
      Description = "This group allows a provider to define items that a component requires to be in the Windows INI file."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "Unique index for row in table"
         Type = Integer
      End Attribute
      Start Attribute
         Name = "INI Name"
         ID = 2
         Description = "The name of the INI file that you want to place the entry in."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Section"
         ID = 3
         Description = "The section of the INI file the entry belongs in."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Keyword"
         ID = 4
         Description = "Item to the left of the equals sign in a line in the INI file entry."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Value"
         ID = 5
         Description = "Item to the right of the equals sign in a line in the INI file entry."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 6
         Description = "This attribute references the table entry for the directory containing the INI file."
         Type = Integer
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Windows Registry Settings"
      Class = "AMS|WinRegistrySettings|001"
      Description = "This group allows a provider to define items that a component requires to be in the Windows Registry."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "Unique index for row in table"
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Base Key"
         ID = 2
         Description = "The Base Registry key such as: HKEY_USERS, HKEY_CLASSES_ROOT, HKEY_LOCAL_MACHINE, HKEY_CURRENT_USER, HKEY_CURRENT_CONFIG and HKEY_DYN_DATA."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Registry Key"
         ID = 3
         Description = "The key (fully qualified) in the registry that this item belongs in."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Registry Item"
         ID = 4
         Description = "The actual Item that a value is assigned to."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Registry Value"
         ID = 5
         Description = "The value that the item is to be set to."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Value Type"
         ID = 6
         Description = "The type of the data value string."
         Type = 
            Start Enum
               0 = "REG_BINARY"
               1 = "REG_DWORD"
               2 = "REG_DWORD_BIG_ENDIAN"
               3 = "REG_EXPAND_SZ"
               4 = "REG_LINK"
               5 = "REG_MULTI_SZ"
               6 = "REG_NONE"
               7 = "REG_RESOURCE_LIST"
               8 = "REG_SZ"
               9 = "REG_FULL_RESOURCE_DESCRIPTOR"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Windows Desktop Settings"
      Class = "AMS|WindowsDesktopSettings|001"
      Description = "This group allows a provider to define descriptive Icon names and command lines for the Desktop environment."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "Unique index for row in table"
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Program Group Name"
         ID = 2
         Description = "The name of the Program Group."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Icon File Name"
         ID = 3
         Description = "To allow for something other than the default resource in the executable as an icon. May be NULL to use the default."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Descriptive Icon Name"
         ID = 4
         Description = "This name is the name that will be placed below the program icon.  This field corresponds to the Description field in the Program Item Properties dialog box in the program manager."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Command Line"
         ID = 5
         Description = "This is the path and executable name that used to start the program.  This corresponds to the Command Line field in the Program Item Properties dialog box in the program manager."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Location"
         ID = 6
         Description = "A field for the directory to be run from (i.e. 'Start In' field in shortcuts directory)."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Start Type"
         ID = 7
         Description = "What context to start the program in with respect to view."
         Type = 
            Start Enum
               0 = "Normal"
               1 = "Maximized"
               2 = "Minimized"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Folder Type"
         ID = 8
         Description = "Should the folder be a common system folder or just for the current user."
         Type = 
            Start Enum
               0 = "Common"
               1 = "Local"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Windows NT Application Services"
      Class = "AMS|WinNTServices|001"
      Description = "This group allows a provider to define NT application services."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "Unique index for row in table"
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Service Name"
         ID = 2
         Description = "Internal name of the Windows NT service"
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Service Description"
         ID = 3
         Description = "This attribute describes the NT service."
         Type = String(128)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Service Startup Setting"
         ID = 4
         Description = "This attribute describes the standard startup option for the service."
         Type = 
            Start Enum
               0 = "unknown"
               1 = "Boot"
               2 = "System"
               3 = "Automatic"
               4 = "Manual"
               5 = "Disabled"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Service Stop Supported"
         ID = 5
         Description = "This attribute indicates if the service can be stopped while the system is running."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Service Start Supported"
         ID = 6
         Description = "This attribute indicates if the service can be started or restarted while the system is running."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Service Pause Supported"
         ID = 7
         Description = "This attribute indicates if the service can be paused while the system is running."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Service Resume Supported"
         ID = 8
         Description = "This attribute indicates if the service can be resumed while the system is running."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Service Startup Account Supported"
         ID = 9
         Description = "This attribute indicates if the service can be set to run under an account other that the LocalSystem account."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Service LocalSystem Account Supported"
         ID = 10
         Description = "This attribute indicates if the service can be set to run under the LocalSystem account."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Event Classification"
         ID = 11
         Description = "This attribute is the name of the event type to generate if a problem is found with the service."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Resource"
      Class = "AMS|Resource|001"
      Description = "Allows a provider to identify the resources introduced by a software component that has default access control."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = ""
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Resource Type"
         ID = 2
         Description = "Identifies the type of resources that ought to have their access controlled"
         Type = 
            Start Enum
               0 = "File"
               1 = "Directory"
               2 = "File Set"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Default Access Right"
         ID = 3
         Description = ""
         Type = 
            Start Enum
               1 = "read"
               2 = "write"
               3 = "execute"
               4 = "delete"
               5 = "update"
               6 = "full control"
               7 = "access"
               8 = "no access"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Audit Control"
         ID = 4
         Description = "describes the recommended audit control"
         Type = 
            Start Enum
               1 = "all"
               2 = "none"
               3 = "success"
               4 = "failure"
            End Enum
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "File Name Reference"
         ID = 5
         Description = "Combined with File Location Reference, identifies the entry in the distributed file list table for the controlled file."
         Type = String(256)
         Value = ""
      End Attribute
      Start Attribute
         Name = "File Location Reference"
         ID = 6
         Description = "Combined With File Name Reference, identifies the entry in the distributed file list table for the controlled file."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "Directory Reference"
         ID = 7
         Description = "References an entry in the location table for the directory being controlled."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "File Set Directory Reference"
         ID = 8
         Description = "References an entry in the location table for the directory containing the set of files being controlled."
         Type = Integer
         Value = Unknown
      End Attribute
      Start Attribute
         Name = "File Mask"
         ID = 9
         Description = "Identifies a file mask that identifies the files within a directory that have the pertinent access control."
         Type = String(256)
         Value = ""
      End Attribute
   End Group

   Start Group
      Name = "Component Information"
      Class = "AMS|CompInfo|001"
      Description = "This group labels and identifies operational tasks that return information abouta software component."
      Key = 1
      Start Attribute
         Name = "Index"
         ID = 1
         Description = "This attribute is a unique index."
         Type = Integer
      End Attribute
      Start Attribute
         Name = "Name"
         ID = 2
         Description = "This attribute is a label assigned to this componentinformation."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Task Reference"
         ID = 3
         Description = "The software component task that is used to retrievethe component information."
         Type = String(64)
         Value = ""
      End Attribute
      Start Attribute
         Name = "Value"
         ID = 4
         Description = "This attribute indicates whether the returned information is a single value or a set of values."
         Type = 
            Start Enum
               0 = "single"
               1 = "multiple"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Group
      Name = "Monitor Priority"
      Class = "AMS|MonitorPriority|001"
      Description = "This group is used to assign priority to monitors."
      Key = 1
      Start Attribute
         Name = "Monitor Reference"
         ID = 1
         Description = "The name that identifies the monitor."
         Type = String(64)
      End Attribute
      Start Attribute
         Name = "Priority"
         ID = 2
         Description = "This attribute assigns a priority to the referenced monitor."
         Type = 
            Start Enum
               0 = "Low"
               1 = "High"
            End Enum
         Value = Unknown
      End Attribute
   End Group

   Start Table
      Name = "Location"
      Class = "DMTF|Location|001"
      ID = 4
      { 0,1,"" }
      { 1,3,"" }
   End Table

   Start Table
      Name = "Software Source Location"
      Class = "AMS|SourceLocation|001"
      ID = 2001
      { 0,1,"" }
      { 1,3,"top/bin/generic_unix/TME/PLUS/IM2" }
   End Table

   Start Table
      Name = "Generic Dependency Instance"
      Class = "AMS|GenDepInst|001"
      ID = 2004
      { "OS version",",,,,,," }
      { "TEC_Server_Check","" }
   End Table

   Start Table
      Name = "Generic Dependency Type"
      Class = "AMS|GenDepType|001"
      ID = 2005
      { "TEC_Server_Check","check_tec_server.sh",1,"Checks if a node is the TEC server." }
   End Table

   Start Table
      Name = "Management Tool Extension"
      Class = "AMS|Management Tool Extension|001"
      ID = 2024
      { 1,"MODULE_TYPE",1,"PLUS","TIVOLI_PLUS_4_0" }
      { 2,"ComponentID_Manufacturer_File_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 3,"ComponentID_Manufacturer_ISym_CDF",1,"1,Manufacturer","Tivoli_i18n" }
      { 4,"ComponentID_Name_File_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 5,"ComponentID_Name_ISym_CDF",1,"2,Name","Tivoli_i18n" }
      { 6,"ComponentID_Version_File_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 7,"ComponentID_Version_ISym_CDF",1,"3,Version","Tivoli_i18n" }
      { 8,"ComponentID_Description_File_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 9,"ComponentID_Description_ISym_CDF",1,"4,Description","Tivoli_i18n" }
      { 10,"SoftwareComponentInform_MajorVersion_File_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 11,"SoftwareComponentInform_MajorVersion_ISym_CDF",1,"5,MajorVersion","Tivoli_i18n" }
      { 12,"SoftwareComponentInform_MinorVersion_File_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 13,"SoftwareComponentInform_MinorVersion_ISym_CDF",1,"6,MinorVersion","Tivoli_i18n" }
      { 14,"SoftwareComponentInform_Revision_File_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 15,"SoftwareComponentInform_Revision_ISym_CDF",1,"7,Revision","Tivoli_i18n" }
      { 16,"OperationalTask_Name_File_347_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 17,"OperationalTask_Name_ISym_347_CDF",1,"8,Name_Setup_TEC_Event_Server","Tivoli_i18n" }
      { 18,"OperationalTask_Description_File_347_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 19,"OperationalTask_Description_ISym_347_CDF",1,"9,Description_Setup_TEC_Event_Server","Tivoli_i18n" }
      { 20,"OperationalTask_Key_347_CDF",1,"Setup TEC Event Server","Tivoli_i18n" }
      { 21,"OperationalTaskArguments_Label_File_348_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 22,"OperationalTaskArguments_Label_ISym_348_CDF",1,"10,Label_Setup_TEC_Event_Server_4","Tivoli_i18n" }
      { 23,"OperationalTaskArguments_Key_348_CDF",1,"Setup TEC Event Server.4","Tivoli_i18n" }
      { 24,"OperationalTaskArguments_Label_File_349_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 25,"OperationalTaskArguments_Label_ISym_349_CDF",1,"11,Label_Setup_TEC_Event_Server_2","Tivoli_i18n" }
      { 26,"OperationalTaskArguments_Key_349_CDF",1,"Setup TEC Event Server.2","Tivoli_i18n" }
      { 27,"OperationalTaskArguments_Label_File_350_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 28,"OperationalTaskArguments_Label_ISym_350_CDF",1,"12,Label_Setup_TEC_Event_Server_3","Tivoli_i18n" }
      { 29,"OperationalTaskArguments_Key_350_CDF",1,"Setup TEC Event Server.3","Tivoli_i18n" }
      { 30,"OperationalTaskArguments_Label_File_351_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 31,"OperationalTaskArguments_Label_ISym_351_CDF",1,"13,Label_Setup_TEC_Event_Server_1","Tivoli_i18n" }
      { 32,"OperationalTaskArguments_Key_351_CDF",1,"Setup TEC Event Server.1","Tivoli_i18n" }
      { 33,"GenericDependencyType_Name_File_354_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 34,"GenericDependencyType_Name_ISym_354_CDF",1,"14,Name_TEC_Server_Check","Tivoli_i18n" }
      { 35,"GenericDependencyType_Description_File_354_CDF",1,"TMB_MODULE_AppName_Insight_TEC_Configuration","Tivoli_i18n" }
      { 36,"GenericDependencyType_Description_ISym_354_CDF",1,"15,Description_TEC_Server_Check","Tivoli_i18n" }
      { 37,"GenericDependencyType_Key_354_CDF",1,"TEC_Server_Check","Tivoli_i18n" }
   End Table

   Start Table
      Name = "Operational Task"
      Class = "AMS|OpTask|002"
      ID = 2025
      { "Setup TEC Event Server","Configure the TEC Server to recognize the rules for this application.","config_tec.sh",1,"","",0,0,"",0 }
   End Table

   Start Table
      Name = "Operational Task Arguments"
      Class = "AMS|OpTaskArg|002"
      ID = 2026
      { "Setup TEC Event Server",4,"Name of Event Console to configure (optional):","","","" }
      { "Setup TEC Event Server",2,"Rule Base to clone (if new):","","","" }
      { "Setup TEC Event Server",3,"Path for Rule Base (if new):","","","" }
      { "Setup TEC Event Server",1,"Rule Base Name (new or existing):","","","" }
   End Table

   Start Table
      Name = "Distribution File List"
      Class = "AMS|DistributionFileList|001"
      ID = 2027
      { "tecad_snmp.baroc",0,1,0 }
      { "ins_correl",0,1,0 }
      { "ins_evt.rls",0,1,0 }
      { "user_predicates",0,1,0 }
      { "ins_evt.baroc",0,1,0 }
      { "ins_start.rls",0,1,0 }
      { "ins_correl.wic",0,1,0 }
   End Table


End Component

