# Property of Hewlett-Packard Development Company, L.P.
# HP Insight Integration for Tivoli, revision 4.1
#
#  Component	: ins_evt.cds, rev 4.1
#  
#  Description	: HP Insight set of class definition statements for the
#		  SNMP TEC Adapter Events.
#

#########################################################
###  Compaq Cluster Management Information
#########################################################
CLASS IM_15003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 15003;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqClusterNodeName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_ClusterNodeName = $V4;
    hpq_eventID = $V2;
    msg = "Cluster Node Degraded";
    hpq_info = PRINTF ( "Cluster service on %s has become degraded.", $V4);
END

########################################################################################

CLASS IM_15004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 15004;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqClusterNodeName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_ClusterNodeName = $V4;
    hpq_eventID = $V2;
    msg = "Cluster Node Failed";
    hpq_info = PRINTF ( "Cluster service on %s has failed.", $V4);
END

########################################################################################

CLASS IM_15005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 15005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqClusterResourceName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_ClusterResourceName = $V4;
    hpq_eventID = $V2;
    msg = "Cluster Resource Degraded";
    hpq_info = PRINTF ( "Cluster resource %s has become degraded.", $V4);
END

########################################################################################

CLASS IM_15006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 15006;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqClusterResourceName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_ClusterResourceName = $V4;
    hpq_eventID = $V2;
    msg = "Cluster Resource Failed";
    hpq_info = PRINTF ( "Cluster resource %s has failed.", $V4);
END

########################################################################################

CLASS IM_15007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 15007;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqClusterNetworkName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_ClusterNetworkName = $V4;
    hpq_eventID = $V2;
    msg = "Cluster Network Degraded";
    hpq_info = PRINTF ( "Cluster network %s has become degraded.", $V4);
END

########################################################################################

CLASS IM_15008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 15008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqClusterNetworkName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_ClusterNetworkName = $V4;
    hpq_eventID = $V2;
    msg = "Cluster Network Failed";
    hpq_info = PRINTF ( "Cluster network %s has failed.", $V4);
END

#########################################################
#####   Compaq ConsoleManagementController- (CMC) MIB
#########################################################
CLASS IM_153001_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153001;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp1"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153001_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 1: Normal";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153001_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153001;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp1"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153001_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 1:  exceeds warning threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153001_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153001;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp1"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153001_4;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 1: exceeds max. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153001_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153001;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp1"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153001_5;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 1: drops under min. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153001_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153001;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp1"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153001_6;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 1: no sensor connected, not available";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153001_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153001;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp1"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153001_7;
    severity = FATAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 1: error, sensor disconnected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

############################################
CLASS IM_153002_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153002;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp2"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153002_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 2: Normal";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153002_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153002;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp2"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153002_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 2:  exceeds warning threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153002_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153002;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp2"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153002_4;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 2: exceeds max. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153002_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153002;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp2"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153002_5;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 2: drops under min. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153002_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153002;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp2"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153002_6;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 2: no sensor connected, not available";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153002_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153002;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusTemp2"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153002_7;
    severity = FATAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusTemp2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController temperature 2: error, sensor disconnected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#####################################
CLASS IM_153003_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: switched off by temperature sensor 1";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153003_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_3;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: switched on by temperature sensor 1";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153003_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_4;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: switched off by Manual Control (cpqCmcSetFan1)";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153003_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_5;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: switched on by Manual Control (cpqCmcSetFan1";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153003_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_6;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: switched off because of smoke alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153003_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_7;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: switched off because door is open";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153003_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_8;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: no fan";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153003_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153003;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan1"), VALUE(=,9);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153003_9;
    severity = FATAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 1: fan error, current monitoring";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#############################################
CLASS IM_153004_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: switched off by temperature sensor 1";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153004_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_3;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: switched on by temperature sensor 1";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153004_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_4;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: switched off by Manual Control (cpqCmcSetFan2)";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153004_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_5;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: switched on by Manual Control (cpqCmcSetFan2";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153004_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_6;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: switched off because of smoke alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153004_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_7;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: switched off because door is open";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153004_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_8;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: no fan";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153004_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153004;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusFan2"), VALUE(=,9);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153004_9;
    severity = FATAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusFan2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Fan 2: fan error, current monitoring";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

##############################################
CLASS IM_153005_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153005;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusVoltage"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153005_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusVoltage = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The voltage-status of Compaq ConsoleManagementController : normal";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153005_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153005;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusVoltage"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153005_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusVoltage = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The voltage-status of Compaq ConsoleManagementController : exceeds max. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153005_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153005;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusVoltage"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153005_4;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusVoltage = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The voltage-status of Compaq ConsoleManagementController : drops under min. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153005_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153005;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusVoltage"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153005_5;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusVoltage = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The voltage-status of Compaq ConsoleManagementController : no power connected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

 #########################################
CLASS IM_153006_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153006;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusHumidity"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153006_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusHumidity = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The humidity_status of Compaq ConsoleManagementController : normal";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153006_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153006;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusHumidity"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153006_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusHumidity = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The humidity_status of Compaq ConsoleManagementController : exceeds max. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153006_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153006;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusHumidity"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153006_4;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusHumidity = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The humidity_status of Compaq ConsoleManagementController : drops under min. threshold";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153006_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153006;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusHumidity"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153006_5;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusHumidity = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The humidity_status of Compaq ConsoleManagementController : no sensor connected, not availble";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153006_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153006;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusHumidity"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153006_6;
    severity = FATAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusHumidity = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The humidity_status of Compaq ConsoleManagementController : error, sensor disonnected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

##########################################
CLASS IM_153007_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153007;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput1"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153007_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 1 of Compaq ConsoleManagementController : closed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153007_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153007;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput1"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153007_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 1 of Compaq ConsoleManagementController : open";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153007_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153007;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput1"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153007_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 1 of Compaq ConsoleManagementController : no Sensor";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

##########################################
CLASS IM_153008_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153008;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput2"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153008_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 2 of Compaq ConsoleManagementController : closed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153008_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153008;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput2"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153008_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 2 of Compaq ConsoleManagementController : open";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153008_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153008;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput2"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153008_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 2 of Compaq ConsoleManagementController : no Sensor";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

###################################
CLASS IM_153009_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153009;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput3"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153009_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput3 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 3 of Compaq ConsoleManagementController : closed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153009_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153009;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput3"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153009_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput3 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 3 of Compaq ConsoleManagementController : open";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153009_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153009;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput3"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153009_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput3 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 3 of Compaq ConsoleManagementController : no Sensor";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#######################################
CLASS IM_153010_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153010;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput4"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153010_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput4 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 4 of Compaq ConsoleManagementController : closed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153010_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153010;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput4"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153010_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput4 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 4 of Compaq ConsoleManagementController : open";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153010_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153010;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusInput4"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153010_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusInput4 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of door/sidepanel 4 of Compaq ConsoleManagementController : no Sensor";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#####################################
CLASS IM_153011_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is activated, door is locked";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is not activated, door is unlocked by Network Management";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is not activated for x sec, time see cpqCmcSetupLock1Time, door is unlocked by Network Management";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_5;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is not activated, door is unlocked because of Smoke alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_6;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door is unlocked from remote-signal";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_7;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is not activated, door is unlocked because of Power Fail of locking device";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_8;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is not activated, door is unlocked because of low Battery of locking device";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,9);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_9;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is not activated, door is unlocked because of Network Fail";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#################################
CLASS IM_153011_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,10);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_10;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is not activated, door is unlocked because of connection fail, no connection locking device";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,11);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is ready to lock, lock will be activated after doors are closed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,12);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_12;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1 is activated but door is not locked, alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,13);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_13;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Configuration error, association door to locking-device missing";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153011_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153011;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Lock"), VALUE(=,14);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153011_14;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Lock not installed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

########################################
CLASS IM_153012_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is activated, door is locked";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_3;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is not activated, door is unlocked by Network Management";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is not activated for x sec, time see cpqCmcSetupLock1Time, door is unlocked by Network Management";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_5;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is not activated, door is unlocked because of Smoke alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_6;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door is unlocked from remote-signal";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_7;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is not activated, door is unlocked because of Power Fail of locking device";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_8;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is not activated, door is unlocked because of low Battery of locking device";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,9);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_9;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is not activated, door is unlocked because of Network Fail";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END


CLASS IM_153012_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,10);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_10;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is not activated, door is unlocked because of connection fail, no connection locking device";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,11);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_11;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is ready to lock, lock will be activated after doors are closed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,12);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_12;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2 is activated but door is not locked, alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,13);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_13;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Configuration error, association door to locking-device missing";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153012_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153012;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Lock"), VALUE(=,14);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153012_14;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Lock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Lock not installed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

######################################
CLASS IM_153013_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153013;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusSmoke"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153013_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusSmoke = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController smoke-sensor, cleared ";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153013_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153013;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusSmoke"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153013_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusSmoke = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController smoke-sensor smoke detected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153013_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153013;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusSmoke"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153013_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusSmoke = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController smoke-sensor: no senser connected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

######################################
CLASS IM_153014_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153014;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusShock"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153014_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusShock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController skock-sensor, OK ";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153014_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153014;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusShock"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153014_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusShock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController skock-sensor smoke detected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153014_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153014;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusShock"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153014_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusShock = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController shock-sensor: no senser connected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#################################
CLASS IM_153015_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153015;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAux1"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153015_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAux1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController aux. digital input, OK ";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153015_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153015;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAux1"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153015_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAux1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController aux. digital input alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153015_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153015;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAux1"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153015_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAux1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController aux. digital input: no senser connected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

######################################
CLASS IM_153016_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153016;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAux2"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153016_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAux2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController aux. digital input, OK ";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153016_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153016;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAux2"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153016_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAux2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController aux. digital input alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153016_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153016;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAux2"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153016_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAux2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController aux. digital input: no senser connected";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#######################################
CLASS IM_153017_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153017;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAlarm1"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153017_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAlarm1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController alarm 1, OK ";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153017_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153017;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAlarm1"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153017_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAlarm1 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController alarm 1, alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

######################################
CLASS IM_153018_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153018;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAlarm2"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153018_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAlarm2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController alarm 2, see cmpCmcsetAlarm1. This alarm can be set from the Network management system. A descriptional text for this alarm can be set in cpqCmcSetupAlarm1Description., OK ";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153018_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153018;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusAlarm2"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153018_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusAlarm2 = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController alarm 2, see cmpCmcsetAlarm1. This alarm can be set from the Network management system. A descriptional text for this alarm can be set in cpqCmcSetupAlarm1Description., alarm";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

####################################
CLASS IM_153019_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153019;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Dev"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153019_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1, OK";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153019_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153019;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Dev"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153019_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device, Power fail";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153019_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153019;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Dev"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153019_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1,Low Battery";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153019_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153019;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Dev"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153019_5;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Battery of door locking device needs to be replaced";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153019_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153019;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Dev"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153019_6;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door is, Battery missing, insert all batteries";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153019_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153019;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Dev"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153019_7;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1, Connection CMC->door locking device lost";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153019_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153019;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock1Dev"), VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153019_8;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock1Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 1, Lock not installed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

#######################################
CLASS IM_153020_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153020;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Dev"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153020_2;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2, OK";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153020_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153020;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Dev"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153020_3;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device, Power fail";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153020_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153020;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Dev"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153020_4;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2,Low Battery";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153020_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153020;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Dev"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153020_5;
    severity = CRITICAL;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Battery of door locking device needs to be replaced";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153020_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153020;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Dev"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153020_2;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door is, Battery missing, insert all batteries";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153020_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153020;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Dev"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153020_7;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2, Connection CMC->door locking device lost";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

CLASS IM_153020_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153020;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(PREFIX, "cpqCmcStatusLock2Dev"), VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153020_8;
    severity = WARNING;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    hpq_CmcStatusLock2Dev = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The status of Compaq ConsoleManagementController Door locking-device 2, Lock not installed";
    hpq_info = PRINTF ( "Location: %s, Message: %s from: %s, contact %s", $V6, $V7, $V5, $V4);
END

###############################################
CLASS IM_153100
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.153" ) ;
    2: $SPECIFIC = 153100;
    3: ATTR(=, "sysDescr") ;
    4: ATTR(=, "sysContact");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 153100;
    severity = HARMLESS;
    hpq_contact = $V4;
    hostname=$V5;
    hpq_location = $V6;
    msg = "The status of Compaq ConsoleManagementController, setup of CMC has changed";
    hpq_info = PRINTF ( "Location: %s, Name: %s, contact %s", $V6, $V5, $V4);
END

#########################################################
#####   Compaq CR3500 RAID Controller
#########################################################
CLASS IM_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.2" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1;
    severity = FATAL;
    hostname=$V3;
    msg = "The primary controller in the subsytem has failed.";
    hpq_info = "The primary Controller has failed.";
END

################################
CLASS IM_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.2" ) ;
    2: $SPECIFIC = 2;
    3: ATTR(=, "sysName") ;
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2;
    severity = HARMLESS;
    hostname=$V3;
    msg = "The primary controller in the subsytem has recovered.";
    hpq_info =  "The primary controller in the subsytem has recovered.";
END

################################
CLASS IM_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.2" ) ;
    2: $SPECIFIC = 3;
    3: ATTR(=, "sysName") ;
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3;
    severity = FATAL;
    hostname=$V3;
    msg = "The secondary controller in the subsytem has failed.";
    hpq_info =  "The secondary controller has failed.";
END

################################
CLASS IM_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.2" ) ;
    2: $SPECIFIC = 4;
    3: ATTR(=, "sysName") ;
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 4;
    severity = HARMLESS;
    hostname=$V3;
    msg = "The secondary controller in the subsytem has recovered.";
    hpq_info =  "The secondary controller has recovered.";
END

################################
CLASS IM_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.3" ) ;
    2: $SPECIFIC = 5;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrLogDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CrLogDrvIndex = $V4;	
    msg = "A RAIDset has become optimal.";
    hpq_info =  "A RAIDset has become optimal due to a successful completion of the reconstruction process.";
END

################################
CLASS IM_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.3" ) ;
    2: $SPECIFIC = 6;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrLogDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6;
    severity = FATAL;
    hostname=$V3;
    hpq_CrLogDrvIndex = $V4;	
    msg = "A RAIDset has failed.";
    hpq_info =  "The RAIDset has failed and is off-line.";
END

################################
CLASS IM_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.3" ) ;
    2: $SPECIFIC = 7;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrLogDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 7;
    severity = WARNING;
    hostname=$V3;
    hpq_CrLogDrvIndex = $V4;	
    msg = "A RAIDset has started the reconstruction process.";
    hpq_info =  "The RAIDset has started the reconstruction process but is available for normal use.";
END

################################
CLASS IM_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.3" ) ;
    2: $SPECIFIC = 8;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrLogDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8;
    severity = CRITICAL;
    hostname=$V3;
    hpq_CrLogDrvIndex = $V4;	
    msg = "A RAIDset has become degraded.";
    hpq_info =  "A RAIDset has become degraded due to a member disk device failure.";
END

################################
CLASS IM_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.3" ) ;
    2: $SPECIFIC = 9;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrLogDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9;
    severity = WARNING;
    hostname=$V3;
    hpq_CrLogDrvIndex = $V4;	
    msg = "A RAIDset is initializing.";
    hpq_info =  "A RAIDset is in the process of being intialized.";
END

################################
CLASS IM_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 10;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvCntlrIndex");
    5: ATTR(=, "cpqCrPhyDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 10;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CrPhyDrvCntlrIndex = $V4;	
    hpq_CrPhyDrvIndex = $V5;
    msg = "A disk drive has recovered.";
    hpq_info =  "A disk drive has recovered.";
END

################################
CLASS IM_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 11;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvCntlrIndex");
    5: ATTR(=, "cpqCrPhyDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 11;
    severity = FATAL;
    hostname=$V3;
    hpq_CrPhyDrvCntlrIndex = $V4;	
    hpq_CrPhyDrvIndex = $V5;
    msg = "A disk drive has failed.";
    hpq_info =  "A disk drive has failed.";
END

################################
CLASS IM_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 12;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12;
    severity = WARNING;
    hostname=$V3;
    hpq_CrPhyDrvIndex = $V4;
    msg = "A disk drive has started the reconstruction process.";
    hpq_info =  "A disk member of a logical drive has begun the reconstruction process and will be available for use when reconstruction is complete.";
END

################################
CLASS IM_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 13;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 13;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CrPhyDrvIndex = $V4;
    msg = "A disk drive has been made available for use.";
    hpq_info =  "A disk drive has been physically added or set to the Available state.";
END

################################
CLASS IM_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 14;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 14;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CrPhyDrvIndex = $V4;
    msg = "A disk drive has been made a Spare.";
    hpq_info =  "A disk drive has been set to Spare status from Available.";
END

################################
CLASS IM_15
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 15;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 15;
    severity = HARMLESS;
    hostname=$V3;
    msg = "Primary enclosure state is normal.";
    hpq_info =  "The overall condition of the primary enclosure has returned to normal.";
END

################################
CLASS IM_16
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 16;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16;
    severity = FATAL;
    hostname=$V3;
    msg = "Fan has failed.";
    hpq_info =  "One of the cooling fans in the primary enclosure has failed.";
END

################################
CLASS IM_17
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 17;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 17;
    severity = HARMLESS;
    hostname=$V3;
    msg = "The fan has recovered.";
    hpq_info =  "The cooling fan in the primary enclosure has recovered.";
END

################################
CLASS IM_18
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 18;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 18;
    severity = FATAL;
    hostname=$V3;
    msg = "Power supply has failed.";
    hpq_info =  "One of the power supplies in the primary enclosure has failed.";
END

################################
CLASS IM_19
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 19;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19;
    severity = HARMLESS;
    hostname=$V3;
    msg = "The power supply has recovered.";
    hpq_info =  "The power supply in the primary enclosure has recovered.";
END

#################################################################
CLASS IM_20
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.8" ) ;
    2: $SPECIFIC = 20;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20;
    severity = FATAL;
    hostname=$V3;
    msg = "Fan has failed in expansion cabinet.";
    hpq_info =  "One of the cooling fans in the expansion cabinet has failed.";
END

#################################################################
CLASS IM_21
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.8" ) ;
    2: $SPECIFIC = 21;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21;
    severity = HARMLESS;
    hostname=$V3;
    msg = "Fan has recovered.";
    hpq_info =  "A cooling fan in the expansion cabinet has returned to a normal state.";
END

#################################################################
CLASS IM_22
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.8" ) ;
    2: $SPECIFIC = 22;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22;
    severity = FATAL;
    hostname=$V3;
    msg = "Power supply has failed.";
    hpq_info =  "One of the power supplies in the expansion cabinet has failed.";
END

#################################################################
CLASS IM_29
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.8" ) ;
    2: $SPECIFIC = 29;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 29;
    severity = HARMLESS;
    hostname=$V3;
    msg = "The power supply has recovered.";
    hpq_info = "The power supply in the expansion cabinet has recovered.";
END

#################################################################
CLASS IM_23
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 23;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 23;
    severity = WARNING;
    hostname=$V3;
    msg = "Primary enclosure temperature warning.";
    hpq_info =  "The temperature in the primary enclosure has triggered a warning condition detected by the controller.";
END

#################################################################
CLASS IM_24
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 24;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 24;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Primary enclosure temperature critical.";
    hpq_info =  "The temperature in the primary enclosure has triggered a critical condition.";
END

#################################################################
CLASS IM_25
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.7" ) ;
    2: $SPECIFIC = 25;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 25;
    severity = HARMLESS;
    hostname=$V3;
    msg = "Primary enclosure temperature normal.";
    hpq_info =  "The temperature in the primary enclosure has returned to normal.";
END

#################################################################
CLASS IM_26
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.8" ) ;
    2: $SPECIFIC = 26;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 26;
    severity = WARNING;
    hostname=$V3;
    msg = "Expansion cabinet temperature warning.";
    hpq_info =  "The temperature in the expansion cabinet has triggered a warning condition detected by the controller.";
END

#################################################################
CLASS IM_27
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.8" ) ;
    2: $SPECIFIC = 27;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 27;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Expansion cabinet temperature Critical.";
    hpq_info =  "The temperature in the expansion cabinet has triggered a critical condition detected by the controller.";
END

#################################################################
CLASS IM_28
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.8" ) ;
    2: $SPECIFIC = 28;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 28;
    severity = HARMLESS;
    hostname=$V3;
    msg = "Expansion cabinet temperature normal.";
    hpq_info =  "The temperature in the expansion cabinet has returned to normal.";
END


#################################################################
CLASS IM_30
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 30;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvScsiID");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 30;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CrPhyDrvScsiID = $V4;
    msg = "A disk drive has recovered.";
    hpq_info =  "A disk drive has recovered.";
END

#################################################################
CLASS IM_31
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 31;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvScsiID");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 31;
    severity = FATAL;
    hostname=$V3;
    hpq_CrPhyDrvScsiID = $V4;
    msg = "A disk drive has failed.";
    hpq_info =  "A disk drive has failed.";
END

#################################################################
CLASS IM_32
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 32;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvScsiID");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 32;
    severity = WARNING;
    hostname=$V3;
    hpq_CrPhyDrvScsiID = $V4;
    msg = "A disk drive has started the reconstruction process.";
    hpq_info =  "A disk member of a logical drive has begun the reconstruction process.";
END

#################################################################
CLASS IM_33
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 33;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrPhyDrvScsiID");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 33;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CrPhyDrvScsiID = $V4;
    msg = "A disk drive has been made available for use.";
    hpq_info =  "A disk drive has been physically added or set to the Available state. It can be used as a RAIDset member or as a Spare.";
END

#################################################################
CLASS IM_34
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.141.3.5" ) ;
    2: $SPECIFIC = 34;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCrSpareScsiID");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 34;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CrSpareScsiID = $V4;
    msg = "A disk drive has been made a Spare.";
    hpq_info =  "A disk drive has been set to Spare status from available.";
END


#########################################################
#####   Compaq Fibre Channel Array
#########################################################

CLASS IM_16001_02
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_2;
    severity = HARMLESS;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: ok";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_03
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_3;
    severity = FATAL;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: failed";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_04
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_4;
    severity = WARNING;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: unconfigured";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_05
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_5;
    severity = WARNING;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: recovering";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_06
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_6;
    severity = WARNING;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: readyForRebuild";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_07
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_7;
    severity = WARNING;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: rebuilding";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_08
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_8;
    severity = CRITICAL;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: wrongDrive";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_09
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,9);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_9;
    severity = CRITICAL;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: badConnect";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,10);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_10;
    severity = CRITICAL;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: overHeating";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,11);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_11;
    severity = CRITICAL;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: shutdown";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,12);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_12;
    severity = WARNING;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: expanding";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,13);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_13;
    severity = WARNING;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: notAvailable";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,14);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_14;
    severity = WARNING;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: queuedForExpansion";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

CLASS IM_16001_15
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvIndex");
    7: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,15);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16001_15;
    severity = CRITICAL;
    hostname=$V3;
    sub_origin=$K7;
    hpq_val=$V7;
    hpq_SsChassisName = $V4;
    hpq_FcaLogDrvIndex = $V6;
    hpq_FcaLogDrvStatus = $V7;
    msg = "Logical Drive Status: hardError";
    hpq_info = PRINTF ( "The logical drive (%s) on %s is in %s operation mode.", $V6, $V3, $V7 );
END

########################################################################################

CLASS IM_16002_02
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16002;
    3: ATTR(=, "sysName") ; 
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaSpareBusNumber");
    7: ATTR(=, "cpqFcaSpareBay");
    8: ATTR(PREFIX, "cpqFcaSpareStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16002_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaSpareBusNumber = $V6;
    hpq_FcaSpareBay = $V7;
    hpq_FcaSpareStatus = $V8;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Spare Status: Inactive";
    hpq_info = PRINTF ( "Spare Status is now %s on bus %d.", $V8, $V6);
END

CLASS IM_16002_03
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16002;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaSpareBusNumber");
    7: ATTR(=, "cpqFcaSpareBay");
    8: ATTR(PREFIX, "cpqFcaSpareStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16002_3;
    severity = FATAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaSpareBusNumber = $V6;
    hpq_FcaSpareBay = $V7;
    hpq_FcaSpareStatus = $V8;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Spare Status: failed";
    hpq_info = PRINTF ( "Spare Status is now %s on bus %d.", $V8, $V6);
END

CLASS IM_16002_04
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16002;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaSpareBusNumber");
    7: ATTR(=, "cpqFcaSpareBay");
    8: ATTR(PREFIX, "cpqFcaSpareStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16002_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaSpareBusNumber = $V6;
    hpq_FcaSpareBay = $V7;
    hpq_FcaSpareStatus = $V8;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Spare Status: building";
    hpq_info = PRINTF ( "Spare Status is now %s on bus %d.", $V8, $V6);
END

CLASS IM_16002_05
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16002;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaSpareBusNumber");
    7: ATTR(=, "cpqFcaSpareBay");
    8: ATTR(PREFIX, "cpqFcaSpareStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16002_5;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaSpareBusNumber = $V6;
    hpq_FcaSpareBay = $V7;
    hpq_FcaSpareStatus = $V8;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Spare Status: active";
    hpq_info = PRINTF ( "Spare Status is now %s on bus %d.", $V8, $V6);
END

#################################################################
############################################################
CLASS IM_16008_02
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeCntlrWWN");
    5: ATTR(PREFIX, "cpqFcTapeCntlrStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16008_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcTapeCntlrWWN = $V4;
    hpq_FcTapeCntlrStatus = $V5;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "Fibre Channel Tape Controller Status: ok";
    hpq_info = PRINTF ( "Status is now %s for tape controller %s.", $V5, $V4);
END

CLASS IM_16008_03
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeCntlrWWN");
    5: ATTR(PREFIX, "cpqFcTapeCntlrStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16008_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_FcTapeCntlrWWN = $V4;
    hpq_FcTapeCntlrStatus = $V5;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "Fibre Channel Tape Controller Status: offline";
    hpq_info = PRINTF ( "Status is now %s for tape controller %s.", $V5, $V4);
END

############################################################
#############################################################
##############################################################
CLASS IM_16014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16014;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaCntlrBoxIoSlot");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16014;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaCntlrBoxIoSlot = $V6;
    msg = "A backup array controller in a duplexed pair has switched over to the active role";
    hpq_info = PRINTF ( "Controller in slot %d is now active on chassis %s.", $V6, %V4);
END

################################################################
##############################################################
CLASS IM_16016_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16016;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaPhyDrvBusNumber");
    7: ATTR(=, "cpqFcaPhyDrvBay");
    8: ATTR(PREFIX, "cpqFcaPhyDrvStatus"), VALUE(=,2);
    9: ATTR(=, "cpqFcaPhyDrvModel");
    10: ATTR(=, "cpqFcaPhyDrvSerialNum");
    11: ATTR(=, "cpqFcaPhyDrvFWRev");
    12: ATTR(=, "cpqFcaPhyDrvFailureCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16016_2;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaPhyDrvBusNumber = $V6;
    hpq_FcaPhyDrvBay = $V7;
    hpq_FcaPhyDrvStatus = $V8;
    hpq_FcaPhyDrvModel = $V9;
    hpq_FcaPhyDrvSerialNum = $V10;
    hpq_FcaPhyDrvFWRev = $V11;
    hpq_FcaPhyDrvFailureCode = $V12;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Fibre Channel Physical Drive is present, but is not part of any logical drive configuration";
    hpq_info = PRINTF ( "Status is now %s for a physical drive on bus %d, bay %d.", $V8, $V6, $V7);
END

CLASS IM_16016_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16016;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaPhyDrvBusNumber");
    7: ATTR(=, "cpqFcaPhyDrvBay");
    8: ATTR(PREFIX, "cpqFcaPhyDrvStatus"), VALUE(=,3);
    9: ATTR(=, "cpqFcaPhyDrvModel");
    10: ATTR(=, "cpqFcaPhyDrvSerialNum");
    11: ATTR(=, "cpqFcaPhyDrvFWRev");
    12: ATTR(=, "cpqFcaPhyDrvFailureCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16016_3;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaPhyDrvBusNumber = $V6;
    hpq_FcaPhyDrvBay = $V7;
    hpq_FcaPhyDrvStatus = $V8;
    hpq_FcaPhyDrvModel = $V9;
    hpq_FcaPhyDrvSerialNum = $V10;
    hpq_FcaPhyDrvFWRev = $V11;
    hpq_FcaPhyDrvFailureCode = $V12;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Fibre Channel Physical Drive is functioning properly";
    hpq_info = PRINTF ( "Status is now %s for a physical drive on bus %d, bay %d.", $V8, $V6, $V7);
END

CLASS IM_16016_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16016;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaPhyDrvBusNumber");
    7: ATTR(=, "cpqFcaPhyDrvBay");
    8: ATTR(PREFIX, "cpqFcaPhyDrvStatus"), VALUE(=,4);
    9: ATTR(=, "cpqFcaPhyDrvModel");
    10: ATTR(=, "cpqFcaPhyDrvSerialNum");
    11: ATTR(=, "cpqFcaPhyDrvFWRev");
    12: ATTR(=, "cpqFcaPhyDrvFailureCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16016_4;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaPhyDrvBusNumber = $V6;
    hpq_FcaPhyDrvBay = $V7;
    hpq_FcaPhyDrvStatus = $V8;
    hpq_FcaPhyDrvModel = $V9;
    hpq_FcaPhyDrvSerialNum = $V10;
    hpq_FcaPhyDrvFWRev = $V11;
    hpq_FcaPhyDrvFailureCode = $V12;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Fibre Channel Physical Drive has a threshold exceeded error and should be replaced.";
    hpq_info = PRINTF ( "Status is now %s for a physical drive on bus %d, bay %d.", $V8, $V6, $V7);
END

CLASS IM_16016_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16016;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaPhyDrvBusNumber");
    7: ATTR(=, "cpqFcaPhyDrvBay");
    8: ATTR(PREFIX, "cpqFcaPhyDrvStatus"), VALUE(=,5);
    9: ATTR(=, "cpqFcaPhyDrvModel");
    10: ATTR(=, "cpqFcaPhyDrvSerialNum");
    11: ATTR(=, "cpqFcaPhyDrvFWRev");
    12: ATTR(=, "cpqFcaPhyDrvFailureCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16016_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaPhyDrvBusNumber = $V6;
    hpq_FcaPhyDrvBay = $V7;
    hpq_FcaPhyDrvStatus = $V8;
    hpq_FcaPhyDrvModel = $V9;
    hpq_FcaPhyDrvSerialNum = $V10;
    hpq_FcaPhyDrvFWRev = $V11;
    hpq_FcaPhyDrvFailureCode = $V12;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Fibre Channel Physical Drive has a predictive failure error and should be replaced.";
    hpq_info = PRINTF ( "Status is now %s for a physical drive on bus %d, bay %d.", $V8, $V6, $V7);
END

CLASS IM_16016_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16016;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaPhyDrvBusNumber");
    7: ATTR(=, "cpqFcaPhyDrvBay");
    8: ATTR(PREFIX, "cpqFcaPhyDrvStatus"), VALUE(=,6);
    9: ATTR(=, "cpqFcaPhyDrvModel");
    10: ATTR(=, "cpqFcaPhyDrvSerialNum");
    11: ATTR(=, "cpqFcaPhyDrvFWRev");
    12: ATTR(=, "cpqFcaPhyDrvFailureCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16016_6;
    severity = FATAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaPhyDrvBusNumber = $V6;
    hpq_FcaPhyDrvBay = $V7;
    hpq_FcaPhyDrvStatus = $V8;
    hpq_FcaPhyDrvModel = $V9;
    hpq_FcaPhyDrvSerialNum = $V10;
    hpq_FcaPhyDrvFWRev = $V11;
    hpq_FcaPhyDrvFailureCode = $V12;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Fibre Channel Physical Drive is no longer operating and should be replaced.";
    hpq_info = PRINTF ( "Status is now %s for a physical drive on bus %d, bay %d.", $V8, $V6, $V7);
END

#################################################################
CLASS IM_16017_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16017;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaAccelBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaAccelStatus"), VALUE(=,2);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaAccelSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
    11: ATTR(=, "cpqFcaAccelErrCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16017_2;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaAccelBoxIoSlot = $V6;
    hpq_FcaAccelStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaAccelSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    hpq_FcaAccelErrCode = $V11;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Accelerator Board board has not been installed in this system or is present but not configured.";
    hpq_info = PRINTF ( "The accelerator board, model %s, on host %s in slot %d has status %d.", $V8, $V3, $V6, $V7);
END

CLASS IM_16017_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16017;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaAccelBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaAccelStatus"), VALUE(=,3);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaAccelSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
    11: ATTR(=, "cpqFcaAccelErrCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16017_3;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaAccelBoxIoSlot = $V6;
    hpq_FcaAccelStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaAccelSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    hpq_FcaAccelErrCode = $V11;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The write cache operations are currently configured and enabled for at least one logical drive.";
    hpq_info = PRINTF ( "The accelerator board, model %s, on host %s in slot %d has status %d.", $V8, $V3, $V6, $V7);
END

CLASS IM_16017_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16017;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaAccelBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaAccelStatus"), VALUE(=,4);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaAccelSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
    11: ATTR(=, "cpqFcaAccelErrCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16017_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaAccelBoxIoSlot = $V6;
    hpq_FcaAccelStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaAccelSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    hpq_FcaAccelErrCode = $V11;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The write cache operations have been temporarily disabled.";
    hpq_info = PRINTF ( "The accelerator board, model %s, on host %s in slot %d has status %d.", $V8, $V3, $V6, $V7);
END

CLASS IM_16017_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16017;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaAccelBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaAccelStatus"), VALUE(=,5);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaAccelSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
    11: ATTR(=, "cpqFcaAccelErrCode");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16017_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaAccelBoxIoSlot = $V6;
    hpq_FcaAccelStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaAccelSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    hpq_FcaAccelErrCode = $V11;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "The write cache operations have been permanently disabled.";
    hpq_info = PRINTF ( "The accelerator board, model %s, on host %s in slot %d has status %d.", $V8, $V3, $V6, $V7);
END

###############################################################
CLASS IM_16018
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaAccelBoxIoSlot");
    7: ATTR(=, "cpqFcaCntlrModel");
    8: ATTR(=, "cpqFcaAccelSerialNumber");
    9: ATTR(=, "cpqFcaAccelTotalMemory");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16018;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaAccelBoxIoSlot = $V6;
    hpq_FcaCntlrModel = $V7;
    hpq_FcaAccelSerialNumber = $V8;
    hpq_FcaAccelTotalMemory = $V9;
    msg = "Accelerator lost battery power.";
    hpq_info = PRINTF ( "The accelerator battery, model %s, on host %s in slot %d has lost power", $V7, $V3, $V6);
END

#############################################################
CLASS IM_16019
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaAccelBoxIoSlot");
    7: ATTR(=, "cpqFcaCntlrModel");
    8: ATTR(=, "cpqFcaAccelSerialNumber");
    9: ATTR(=, "cpqFcaAccelTotalMemory");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16019;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaAccelBoxIoSlot = $V6;
    hpq_FcaCntlrModel = $V7;
    hpq_FcaAccelSerialNumber = $V8;
    hpq_FcaAccelTotalMemory = $V9;
    msg = "Accelerator battery has failed.";
    hpq_info = PRINTF ( "The accelerator battery, model %s, on %s in slot %s has failed", $V7, $V3, $V6);
END

################################################################
CLASS IM_16020_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaCntlrBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaCntlrStatus"), VALUE(=,2);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaCntlrSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16020_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;    
    hpq_FcaCntlrBoxIoSlot = $V6;
    hpq_FcaCntlrStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaCntlrSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "All paths to this controller are available.";
    hpq_info = PRINTF ( "The array controller, model %s, on host %s in slot %d is %d.", $V8, $V3, $V6, $V7);
END

CLASS IM_16020_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaCntlrBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaCntlrStatus"), VALUE(=,3);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaCntlrSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16020_3;
    severity = FATAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;    
    hpq_FcaCntlrBoxIoSlot = $V6;
    hpq_FcaCntlrStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaCntlrSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Compaq Fibre Channel Array Controller failed.";
    hpq_info = PRINTF ( "The array controller, model %s, on host %s in slot %d is %d.", $V8, $V3, $V6, $V7);
END

CLASS IM_16020_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaCntlrBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaCntlrStatus"), VALUE(=,4);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaCntlrSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16020_4;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;    
    hpq_FcaCntlrBoxIoSlot = $V6;
    hpq_FcaCntlrStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaCntlrSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "No paths are available to this controller.";
    hpq_info = PRINTF ( "The array controller, model %s, on host %s in slot %d is %d.", $V8, $V3, $V6, $V7);
END

CLASS IM_16020_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaCntlrBoxIoSlot");
    7: ATTR(PREFIX, "cpqFcaCntlrStatus"), VALUE(=,5);
    8: ATTR(=, "cpqFcaCntlrModel");
    9: ATTR(=, "cpqFcaCntlrSerialNumber");
    10: ATTR(=, "cpqFcaAccelTotalMemory");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16020_5;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;    
    hpq_FcaCntlrBoxIoSlot = $V6;
    hpq_FcaCntlrStatus = $V7;
    hpq_FcaCntlrModel = $V8;
    hpq_FcaCntlrSerialNumber = $V9;
    hpq_FcaAccelTotalMemory = $V10;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "At least one path to this controller is available and at least one path to this controller is unavailable.";
    hpq_info = PRINTF ( "The array controller, model %s, on host %s in slot %d is %d.", $V8, $V3, $V6, $V7);
END

############################################################
CLASS IM_16021_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrSlot");
    5: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,2);
    6: ATTR(=, "cpqFcaHostCntlrModel");
    7: ATTR(=, "cpqFcaHostCntlrWorldWideName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16021_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcaHostCntlrSlot = $V4;
    hpq_FcaHostCntlrStatus = $V5;
    hpq_FcaHostCntlrModel = $V6;
    hpq_FcaHostCntlrWorldWideName = $V7;
    hpq_val = $V5;
    sub_origin = $K5;
    msg = "Fibre Channel Host Controller is in normal operation mode.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in slot %d is %d", $V6, $V3, $V4, $V5);
END

CLASS IM_16021_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrSlot");
    5: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,3);
    6: ATTR(=, "cpqFcaHostCntlrModel");
    7: ATTR(=, "cpqFcaHostCntlrWorldWideName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16021_3;
    severity = FATAL;
    hostname=$V3;
    hpq_FcaHostCntlrSlot = $V4;
    hpq_FcaHostCntlrStatus = $V5;
    hpq_FcaHostCntlrModel = $V6;
    hpq_FcaHostCntlrWorldWideName = $V7;
    hpq_val = $V5;
    sub_origin = $K5;
    msg = "Fibre Channel Host Controller has failed and should be replaced.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in slot %d is %d", $V6, $V3, $V4, $V5);
END

CLASS IM_16021_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrSlot");
    5: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,4);
    6: ATTR(=, "cpqFcaHostCntlrModel");
    7: ATTR(=, "cpqFcaHostCntlrWorldWideName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16021_4;
    severity = WARNING;
    hostname=$V3;
    hpq_FcaHostCntlrSlot = $V4;
    hpq_FcaHostCntlrStatus = $V5;
    hpq_FcaHostCntlrModel = $V6;
    hpq_FcaHostCntlrWorldWideName = $V7;
    hpq_val = $V5;
    sub_origin = $K5;
    msg = "Fibre Channel Host Controller has been shutdown.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in slot %d is %d", $V6, $V3, $V4, $V5);
END

CLASS IM_16021_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrSlot");
    5: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,5);
    6: ATTR(=, "cpqFcaHostCntlrModel");
    7: ATTR(=, "cpqFcaHostCntlrWorldWideName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16021_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_FcaHostCntlrSlot = $V4;
    hpq_FcaHostCntlrStatus = $V5;
    hpq_FcaHostCntlrModel = $V6;
    hpq_FcaHostCntlrWorldWideName = $V7;
    hpq_val = $V5;
    sub_origin = $K5;
    msg = "Fibre Channel connection is degraded.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in slot %d is %d", $V6, $V3, $V4, $V5);
END

CLASS IM_16021_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrSlot");
    5: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,6);
    6: ATTR(=, "cpqFcaHostCntlrModel");
    7: ATTR(=, "cpqFcaHostCntlrWorldWideName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16021_6;
    severity = FATAL;
    hostname=$V3;
    hpq_FcaHostCntlrSlot = $V4;
    hpq_FcaHostCntlrStatus = $V5;
    hpq_FcaHostCntlrModel = $V6;
    hpq_FcaHostCntlrWorldWideName = $V7;
    hpq_val = $V5;
    sub_origin = $K5;
    msg = "Fibre Channel Host Controller is connection is failed.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in slot %d is %d", $V6, $V3, $V4, $V5);
END

#############################################################
CLASS IM_16022_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,2);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: in normal operation mode.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,3);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_3;
    severity = FATAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: more physical drives have failed than the fault tolerance mode of the logical drive can handle without data loss.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,4);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: the logical drive is not configured.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,5);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_5;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: is using Interim Recovery Mode. In Interim Recovery Mode, at least one physical drive has failed, but the logical drive's fault tolerance mode lets the drive continue to operate with no data loss.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,6);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_6;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: ready for Automatic Data Recovery. The physical drive that failed has been replaced, but the logical drive is still operating in Interim Recovery Mode.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,7);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_7;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: the logical drive is currently doing Automatic Data Recovery.  During Automatic Data Recovery, fault tolerance algorithms restore data to the replacement drive.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,8);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_8;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: the wrong physical drive was replaced after a physical drive failure.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,9);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_9;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: a physical drive is not responding.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,10);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_10;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: the storage box that contains the logical drive is overheating.  The array is still functioning, but should be shutdown.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,11);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_11;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: the storage box that contains the logical drive has overheated.  The logical drive is no longer functioning.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,12);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_12;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: is currently doing Automatic Data Expansion.  During Automatic Data Expansion, fault tolerance algorithms redistribute logical drive data to the newly added physical drive.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,13);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_13;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: is currently unavailable.  If a logical drive is expanding and the new configuration frees additional disk space, this free space can be configured into another logical volume.  If this is done, the new volume will be set to not available.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,14);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_14;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: in the queue, ready for Automatic Data Expansion.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

#############################################
CLASS IM_16022_15
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqFcaLogDrvBoxIndex");
    7: ATTR(=, "cpqFcaLogDrvIndex");
    8: ATTR(PREFIX, "cpqFcaLogDrvStatus"), VALUE(=,15);
    9: ATTR(=, "cpqFcaLogDrvOsName");
    10: ATTR(=, "cpqFcaLogDrvFaultTol");
    11: ATTR(=, "cpqFcaLogDrvSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16022_15;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_FcaLogDrvBoxIndex = $V6;
    hpq_FcaLogDrvIndex = $V7;
    hpq_FcaLogDrvStatus = $V8;
    hpq_FcaLogDrvOsName = $V9;
    hpq_FcaLogDrvFaultTol = $V10;
    hpq_FcaLogDrvSize = $V11;
    hpq_val = $V8;
    sub_origin = $K8;
    msg = "The logical drive Status: hard error occurred for this LUN.";
    hpq_info = PRINTF ( "The Logical Drive Status is now %d.", $V8);
END

############################################################
CLASS IM_16023_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
    12: ATTR(PREFIX, "cpqFcTapeDriveStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16023_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    hpq_FcTapeDriveStatus =$V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "Compaq External Tape Drive Status: in normal operation mode.";
    hpq_info = PRINTF ( "Status is now %d for a tape drive.", $V12);
END

#############################################
CLASS IM_16023_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
    12: ATTR(PREFIX, "cpqFcTapeDriveStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16023_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    hpq_FcTapeDriveStatus =$V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "Compaq External Tape Drive Status: has degraded in some manner.";
    hpq_info = PRINTF ( "Status is now %d for a tape drive.", $V12);
END

#############################################
CLASS IM_16023_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
    12: ATTR(PREFIX, "cpqFcTapeDriveStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16023_4;
    severity = FATAL;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    hpq_FcTapeDriveStatus =$V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "Compaq External Tape Drive Status: has failed and can no longer return data.  The tape drive may need to be replaced.";
    hpq_info = PRINTF ( "Status is now %d for a tape drive.", $V12);
END

#############################################
CLASS IM_16023_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
    12: ATTR(PREFIX, "cpqFcTapeDriveStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16023_5;
    severity = WARNING;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    hpq_FcTapeDriveStatus =$V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "Compaq External Tape Drive Status: the agent can no longer communicate with the tape drive.  This could be caused by a cabling problem or the tape drive may be powered off.";
    hpq_info = PRINTF ( "Status is now %d for a tape drive.", $V12);
END

#############################################
CLASS IM_16023_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
    12: ATTR(PREFIX, "cpqFcTapeDriveStatus"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16023_6;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    hpq_FcTapeDriveStatus =$V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "Compaq External Tape Drive Status: had a status of OK and is no longer present.  The drive has been removed.";
    hpq_info = PRINTF ( "Status is now %d for a tape drive.", $V12);
END

#############################################
CLASS IM_16023_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
    12: ATTR(PREFIX, "cpqFcTapeDriveStatus"), VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16023_7;
    severity = CRITICAL;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    hpq_FcTapeDriveStatus =$V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "Compaq External Tape Drive Status: had a status of OFFLINE and is no longer present.  The drive has been removed.";
    hpq_info = PRINTF ( "Status is now %d for a tape drive.", $V12);
END

#############################################
CLASS IM_16024
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16024;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16024;
    severity = WARNING;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    sub_origin = $K11;
    msg = "Compaq External Tape Drive Cleaning Required.";
    hpq_info = "Tape Drive Cleaning Required";
END

#############################################################
CLASS IM_16025
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeDriveCntlrIndex");
    5: ATTR(=, "cpqFcTapeDriveScsiBus");
    6: ATTR(=, "cpqFcTapeDriveScsiTarget");
    7: ATTR(=, "cpqFcTapeDriveScsiLun");
    8: ATTR(=, "cpqFcTapeDriveModel");
    9: ATTR(=, "cpqFcTapeDriveFWRev");
    10: ATTR(=, "cpqFcTapeDriveSerialNumber");
    11: ATTR(=, "cpqFcTapeDriveLocation");
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16025;
    severity = WARNING;
    hostname=$V3;
    hpq_FcTapeDriveCntlrIndex = $V4;
    hpq_FcTapeDriveScsiBus = $V5;
    hpq_FcTapeDriveScsiTarget = $V6;
    hpq_FcTapeDriveScsiLun = $V7;
    hpq_FcTapeDriveModel = $V8;
    hpq_FcTapeDriveFWRev = $V9;
    hpq_FcTapeDriveSerialNumber = $V10;
    hpq_FcTapeDriveLocation = $V11;
    sub_origin = $K11;
    msg = "Compaq External Tape Drive Cleaning Tape Needs Replacing.";
    hpq_info =  "External Tape Drive Cleaning Tape Needs Replacing.";
END

#############################################################
CLASS IM_16026_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqFcTapeLibraryScsiBus");
    6: ATTR(=, "cpqFcTapeLibraryScsiTarget");
    7: ATTR(=, "cpqFcTapeLibraryScsiLun");
    8: ATTR(=, "cpqFcTapeLibraryModel");
    9: ATTR(=, "cpqFcTapeLibraryFWRev");
    10: ATTR(=, "cpqFcTapeLibrarySerialNumber");
    11: ATTR(=, "cpqFcTapeLibraryLocation");
    12: ATTR(PREFIX, "cpqFcTapeLibraryStatus"), VALUE(=,2);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16026_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcTapeLibraryCntlrIndex = $V4;
    hpq_FcTapeLibraryScsiBus = $V5;
    hpq_FcTapeLibraryScsiTarget = $V6;
    hpq_FcTapeLibraryScsiLun = $V7;
    hpq_FcTapeLibraryModel = $V8;
    hpq_FcTapeLibraryFWRev = $V9;
    hpq_FcTapeLibrarySerialNumber = $V10;
    hpq_FcTapeLibraryLocation = $V11;
    hpq_FcTapeLibraryStatus = $V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "External Tape Library Status Change to ok.";
    hpq_info = PRINTF ( "Status is now %d for the tape library.", $V12);
END

CLASS IM_16026_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqFcTapeLibraryScsiBus");
    6: ATTR(=, "cpqFcTapeLibraryScsiTarget");
    7: ATTR(=, "cpqFcTapeLibraryScsiLun");
    8: ATTR(=, "cpqFcTapeLibraryModel");
    9: ATTR(=, "cpqFcTapeLibraryFWRev");
    10: ATTR(=, "cpqFcTapeLibrarySerialNumber");
    11: ATTR(=, "cpqFcTapeLibraryLocation");
    12: ATTR(PREFIX, "cpqFcTapeLibraryStatus"), VALUE(=,3);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16026_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_FcTapeLibraryCntlrIndex = $V4;
    hpq_FcTapeLibraryScsiBus = $V5;
    hpq_FcTapeLibraryScsiTarget = $V6;
    hpq_FcTapeLibraryScsiLun = $V7;
    hpq_FcTapeLibraryModel = $V8;
    hpq_FcTapeLibraryFWRev = $V9;
    hpq_FcTapeLibrarySerialNumber = $V10;
    hpq_FcTapeLibraryLocation = $V11;
    hpq_FcTapeLibraryStatus = $V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "External Tape Library Status Change to degraded.";
    hpq_info = PRINTF ( "Status is now %d for the tape library.", $V12);
END

CLASS IM_16026_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqFcTapeLibraryScsiBus");
    6: ATTR(=, "cpqFcTapeLibraryScsiTarget");
    7: ATTR(=, "cpqFcTapeLibraryScsiLun");
    8: ATTR(=, "cpqFcTapeLibraryModel");
    9: ATTR(=, "cpqFcTapeLibraryFWRev");
    10: ATTR(=, "cpqFcTapeLibrarySerialNumber");
    11: ATTR(=, "cpqFcTapeLibraryLocation");
    12: ATTR(PREFIX, "cpqFcTapeLibraryStatus"), VALUE(=,4);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16026_4;
    severity = FATAL;
    hostname=$V3;
    hpq_FcTapeLibraryCntlrIndex = $V4;
    hpq_FcTapeLibraryScsiBus = $V5;
    hpq_FcTapeLibraryScsiTarget = $V6;
    hpq_FcTapeLibraryScsiLun = $V7;
    hpq_FcTapeLibraryModel = $V8;
    hpq_FcTapeLibraryFWRev = $V9;
    hpq_FcTapeLibrarySerialNumber = $V10;
    hpq_FcTapeLibraryLocation = $V11;
    hpq_FcTapeLibraryStatus = $V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "External Tape Library Status Change to failed.";
    hpq_info = PRINTF ( "Status is now %d for the tape library.", $V12);
END

CLASS IM_16026_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqFcTapeLibraryScsiBus");
    6: ATTR(=, "cpqFcTapeLibraryScsiTarget");
    7: ATTR(=, "cpqFcTapeLibraryScsiLun");
    8: ATTR(=, "cpqFcTapeLibraryModel");
    9: ATTR(=, "cpqFcTapeLibraryFWRev");
    10: ATTR(=, "cpqFcTapeLibrarySerialNumber");
    11: ATTR(=, "cpqFcTapeLibraryLocation");
    12: ATTR(PREFIX, "cpqFcTapeLibraryStatus"), VALUE(=,5);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16026_5;
    severity = WARNING;
    hostname=$V3;
    hpq_FcTapeLibraryCntlrIndex = $V4;
    hpq_FcTapeLibraryScsiBus = $V5;
    hpq_FcTapeLibraryScsiTarget = $V6;
    hpq_FcTapeLibraryScsiLun = $V7;
    hpq_FcTapeLibraryModel = $V8;
    hpq_FcTapeLibraryFWRev = $V9;
    hpq_FcTapeLibrarySerialNumber = $V10;
    hpq_FcTapeLibraryLocation = $V11;
    hpq_FcTapeLibraryStatus = $V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "External Tape Library Status Change to offline.";
    hpq_info = PRINTF ( "Status is now %d for the tape library.", $V12);
END

#############################################################

CLASS IM_16027_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqFcTapeLibraryScsiBus");
    6: ATTR(=, "cpqFcTapeLibraryScsiTarget");
    7: ATTR(=, "cpqFcTapeLibraryScsiLun");
    8: ATTR(=, "cpqFcTapeLibraryModel");
    9: ATTR(=, "cpqFcTapeLibraryFWRev");
    10: ATTR(=, "cpqFcTapeLibrarySerialNumber");
    11: ATTR(=, "cpqFcTapeLibraryLocation");
    12: ATTR(PREFIX, "cpqFcTapeLibraryDoorStatus"), VALUE(=,2);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16027_2;
    severity = WARNING;
    hostname=$V3;
    hpq_FcTapeLibraryCntlrIndex = $V4;
    hpq_FcTapeLibraryScsiBus = $V5;
    hpq_FcTapeLibraryScsiTarget = $V6;
    hpq_FcTapeLibraryScsiLun = $V7;
    hpq_FcTapeLibraryModel = $V8;
    hpq_FcTapeLibraryFWRev = $V9;
    hpq_FcTapeLibrarySerialNumber = $V10;
    hpq_FcTapeLibraryLocation = $V11;
    hpq_FcTapeLibraryDoorStatus = $V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "External Tape Library Door Status Change.";
    hpq_info = PRINTF ( "The door is %d for tape library.", $V12);
END

CLASS IM_16027_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqFcTapeLibraryScsiBus");
    6: ATTR(=, "cpqFcTapeLibraryScsiTarget");
    7: ATTR(=, "cpqFcTapeLibraryScsiLun");
    8: ATTR(=, "cpqFcTapeLibraryModel");
    9: ATTR(=, "cpqFcTapeLibraryFWRev");
    10: ATTR(=, "cpqFcTapeLibrarySerialNumber");
    11: ATTR(=, "cpqFcTapeLibraryLocation");
    12: ATTR(PREFIX, "cpqFcTapeLibraryDoorStatus"), VALUE(=,3);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16027_3;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcTapeLibraryCntlrIndex = $V4;
    hpq_FcTapeLibraryScsiBus = $V5;
    hpq_FcTapeLibraryScsiTarget = $V6;
    hpq_FcTapeLibraryScsiLun = $V7;
    hpq_FcTapeLibraryModel = $V8;
    hpq_FcTapeLibraryFWRev = $V9;
    hpq_FcTapeLibrarySerialNumber = $V10;
    hpq_FcTapeLibraryLocation = $V11;
    hpq_FcTapeLibraryDoorStatus = $V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "External Tape Library Door Status Change.";
    hpq_info = PRINTF ( "The door is %d for tape library.", $V12);
END

CLASS IM_16027_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqFcTapeLibraryScsiBus");
    6: ATTR(=, "cpqFcTapeLibraryScsiTarget");
    7: ATTR(=, "cpqFcTapeLibraryScsiLun");
    8: ATTR(=, "cpqFcTapeLibraryModel");
    9: ATTR(=, "cpqFcTapeLibraryFWRev");
    10: ATTR(=, "cpqFcTapeLibrarySerialNumber");
    11: ATTR(=, "cpqFcTapeLibraryLocation");
    12: ATTR(PREFIX, "cpqFcTapeLibraryDoorStatus"), VALUE(=,4);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16027_4;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcTapeLibraryCntlrIndex = $V4;
    hpq_FcTapeLibraryScsiBus = $V5;
    hpq_FcTapeLibraryScsiTarget = $V6;
    hpq_FcTapeLibraryScsiLun = $V7;
    hpq_FcTapeLibraryModel = $V8;
    hpq_FcTapeLibraryFWRev = $V9;
    hpq_FcTapeLibrarySerialNumber = $V10;
    hpq_FcTapeLibraryLocation = $V11;
    hpq_FcTapeLibraryDoorStatus = $V12;
    hpq_val = $V12;
    sub_origin = $K12;
    msg = "External Tape Library Door Status Change.";
    hpq_info = PRINTF ( "The door is %d for tape library.", $V12);
END

#############################################################
CLASS IM_16028_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrHwLocation");
    5: ATTR(=, "cpqFcaHostCntlrIndex");
    6: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,2);
    7: ATTR(=, "cpqFcaHostCntlrModel");
    8: ATTR(=, "cpqFcaHostCntlrSerialNumber");
    9: ATTR(=, "cpqFcaHostCntlrWorldWideName");
    10: ATTR(=, "cpqFcaHostCntlrWorldWidePortName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16028_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_FcaHostCntlrHwLocation = $V4;
    hpq_FcaHostCntlrIndex = $V5;
    hpq_FcaHostCntlrStatus = $V6;
    hpq_FcaHostCntlrModel = $V7;
    hpq_FcaHostCntlrSerialNumber = $V8;
    hpq_FcaHostCntlrWorldWideName = $V9;
    hpq_FcaHostCntlrWorldWidePortName = $V10;
    hpq_val = $V6;
    sub_origin = $K6;
    msg = "Fibre Channel Host Controller is in normal operation mode.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in %s is %d", $V7, $V3, $V4, $V6);
END

#############################################
CLASS IM_16028_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrHwLocation");
    5: ATTR(=, "cpqFcaHostCntlrIndex");
    6: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,3);
    7: ATTR(=, "cpqFcaHostCntlrModel");
    8: ATTR(=, "cpqFcaHostCntlrSerialNumber");
    9: ATTR(=, "cpqFcaHostCntlrWorldWideName");
    10: ATTR(=, "cpqFcaHostCntlrWorldWidePortName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16028_3;
    severity = FATAL;
    hostname=$V3;
    hpq_FcaHostCntlrHwLocation = $V4;
    hpq_FcaHostCntlrIndex = $V5;
    hpq_FcaHostCntlrStatus = $V6;
    hpq_FcaHostCntlrModel = $V7;
    hpq_FcaHostCntlrSerialNumber = $V8;
    hpq_FcaHostCntlrWorldWideName = $V9;
    hpq_FcaHostCntlrWorldWidePortName = $V10;
    hpq_val = $V6;
    sub_origin = $K6;
    msg = "Fibre Channel Host Controller has failed and should be replaced.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in %s is %d", $V7, $V3, $V4, $V6);
END

#############################################
CLASS IM_16028_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrHwLocation");
    5: ATTR(=, "cpqFcaHostCntlrIndex");
    6: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,4);
    7: ATTR(=, "cpqFcaHostCntlrModel");
    8: ATTR(=, "cpqFcaHostCntlrSerialNumber");
    9: ATTR(=, "cpqFcaHostCntlrWorldWideName");
    10: ATTR(=, "cpqFcaHostCntlrWorldWidePortName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16028_4;
    severity = WARNING;
    hostname=$V3;
    hpq_FcaHostCntlrHwLocation = $V4;
    hpq_FcaHostCntlrIndex = $V5;
    hpq_FcaHostCntlrStatus = $V6;
    hpq_FcaHostCntlrModel = $V7;
    hpq_FcaHostCntlrSerialNumber = $V8;
    hpq_FcaHostCntlrWorldWideName = $V9;
    hpq_FcaHostCntlrWorldWidePortName = $V10;
    hpq_val = $V6;
    sub_origin = $K6;
    msg = "Fibre Channel Host Controller has been shutdown.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in %s is %d", $V7, $V3, $V4, $V6);
END

#############################################
CLASS IM_16028_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrHwLocation");
    5: ATTR(=, "cpqFcaHostCntlrIndex");
    6: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,5);
    7: ATTR(=, "cpqFcaHostCntlrModel");
    8: ATTR(=, "cpqFcaHostCntlrSerialNumber");
    9: ATTR(=, "cpqFcaHostCntlrWorldWideName");
    10: ATTR(=, "cpqFcaHostCntlrWorldWidePortName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16028_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_FcaHostCntlrHwLocation = $V4;
    hpq_FcaHostCntlrIndex = $V5;
    hpq_FcaHostCntlrStatus = $V6;
    hpq_FcaHostCntlrModel = $V7;
    hpq_FcaHostCntlrSerialNumber = $V8;
    hpq_FcaHostCntlrWorldWideName = $V9;
    hpq_FcaHostCntlrWorldWidePortName = $V10;
    hpq_val = $V6;
    sub_origin = $K6;
    msg = "Fibre Channel Host Controller connection is degraded.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in %s is %d", $V7, $V3, $V4, $V6);
END

#############################################
CLASS IM_16028_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 16028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqFcaHostCntlrHwLocation");
    5: ATTR(=, "cpqFcaHostCntlrIndex");
    6: ATTR(PREFIX, "cpqFcaHostCntlrStatus"), VALUE(=,6);
    7: ATTR(=, "cpqFcaHostCntlrModel");
    8: ATTR(=, "cpqFcaHostCntlrSerialNumber");
    9: ATTR(=, "cpqFcaHostCntlrWorldWideName");
    10: ATTR(=, "cpqFcaHostCntlrWorldWidePortName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 16028_6;
    severity = FATAL;
    hostname=$V3;
    hpq_FcaHostCntlrHwLocation = $V4;
    hpq_FcaHostCntlrIndex = $V5;
    hpq_FcaHostCntlrStatus = $V6;
    hpq_FcaHostCntlrModel = $V7;
    hpq_FcaHostCntlrSerialNumber = $V8;
    hpq_FcaHostCntlrWorldWideName = $V9;
    hpq_FcaHostCntlrWorldWidePortName = $V10;
    hpq_val = $V6;
    sub_origin = $K6;
    msg = "Fibre Channel Host Controller connection is failed.";
    hpq_info = PRINTF ( "The fibre channel host controller, model %s, on host %s in %s is %d", $V7, $V3, $V4, $V6);
END


#########################################################
#####   Compaq Server Health Features
#########################################################
###########################################################
CLASS IM_6016_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6016;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeCorrMemLogStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6016_2;
    severity = WARNING;
    hostname=$V3;
    hpq_HeCorrMemLogStatus = $V4;
    msg = "Memory error tracking has not been configured or is not supportted";
    hpq_info = PRINTF ("Memory tracking has %d status.", $V4);
END

CLASS IM_6016_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6016;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeCorrMemLogStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6016_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeCorrMemLogStatus = $V4;
    msg = "Memory error tracking has been disabled due to excessive alerts. This is a possible pre-failure warranty condition. the memory module should be replaced";
    hpq_info = PRINTF ("Memory tracking has %d status.", $V4);
END

CLASS IM_6016_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6016;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeCorrMemLogStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6016_4;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeCorrMemLogStatus = $V4;
    msg = "Memory error tracking has been enabled";
    hpq_info = PRINTF ("Memory tracking has %d status.", $V4);
END

##############################################################
CLASS IM_6017
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6017;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6017;
    severity = FATAL;
    hostname=$V3;
    msg = "Thermal Failure";
    hpq_info = PRINTF ("Temperature has been set to failed and %s will be shutdown." , $V3);
END

###############################################################
CLASS IM_6018_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6018;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeThermalDegradedAction"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6018_2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeThermalDegradedAction = $V4;
    msg = "The system should be allowed to continue";
    hpq_info =  PRINTF ("Temperature out of range.  The system should %d.", $V4);
END

CLASS IM_6018_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6018;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeThermalDegradedAction"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6018_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeThermalDegradedAction = $V4;
    msg = "The system should be shutdown";
    hpq_info =  PRINTF ("Temperature out of range.  The system should be %d.", $V4);
END

#################################################################
CLASS IM_6019
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6019;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6019;
    severity = HARMLESS;
    hostname=$V3;
    msg = "Temperature OK";
    hpq_info = "Temperature has returned to normal range.";
END

#################################################################
CLASS IM_6020_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeThermalDegradedAction"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6020_2;
    severity = FATAL;
    hostname=$V3;
    hpq_HeThermalDegradedAction = $V4;
    msg = "System Fan Failure";
    hpq_info = PRINTF ( "Required system fan not operating normally.  The system is set to %d. ", $V4);
END

CLASS IM_6020_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeThermalDegradedAction"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6020_3;
    severity = FATAL;
    hostname=$V3;
    hpq_HeThermalDegradedAction = $V4;
    msg = "System Fan Failure";
     hpq_info = PRINTF ( "Required system fan not operating normally.  The system is set to %d. ", $V4);
END

################################################################
CLASS IM_6021
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6021;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6021;
    severity = CRITICAL;
    hostname=$V3;
    msg = "System Fan Degraded";
    hpq_info = PRINTF ("An optional system fan on %s is not operating properly." , $V3 );
END

##################################################################

CLASS IM_6022
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6022;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6022;
    severity = HARMLESS;
    hostname=$V3;
    msg = "System fan ok";
    hpq_info = PRINTF ("A system fan on %s returned to a normal state." , $V3);
END

################################################################
CLASS IM_6023
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6023;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6023;
    severity = FATAL;
    hostname=$V3;
    msg = "CPU fan failed";
    hpq_info = PRINTF ("CPU fan on %s has failed. System will be shut down." , $V3 );
END

#################################################################

CLASS IM_6024
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6024;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6024;
    severity = HARMLESS;
    hostname=$V3;
    msg = "CPU fan ok";
    hpq_info = PRINTF ("CPU fan status is normal on %s." , $V3);
END

##################################################################
CLASS IM_6025
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6025;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6025;
    severity = WARNING;
    hostname=$V3;
    msg = "ASR shutdown confirmation";
    hpq_info = PRINTF ("A system reboot has occured on node %s due to an automatic server recovery shutdown." , $V3);
END

#################################################################
CLASS IM_6026
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6026;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6026;
    severity = WARNING;
    hostname=$V3;
    msg = "Thermal shutdown confirmation";
    hpq_info = PRINTF ("A system restart has occured on node %s following a thermal shutdown. The situation that resulted in the thermal shutdown must be corrected or another shutdown will occur." , $V3);
END

####################################################################
CLASS IM_6027
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6027;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6027;
    severity = WARNING;
    hostname=$V3;
    msg = "POST errors have occured";
    hpq_info = PRINTF ("Power-on self test errors have occured on %s." , $V3);
END

################################################################
CLASS IM_6028
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6028;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6028;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Fault tolerant power supply degraded";
    hpq_info = PRINTF ("Redundant power supply on %s is degraded." , $V3);
END

###############################################################
CLASS IM_6029
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6029;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6029;
    severity = WARNING;
    hostname=$V3;
    msg = "ECC memory module requires replacement";
    hpq_info = PRINTF ("The number of correctable memory errors on memory module on %s has exceeded threshold and the modules should be replaced." , $V3);
END

###############################################################
CLASS IM_6032
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6032;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolPowerSupplyChassis");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6032;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeFltTolPowerSupplyChassis = $V4;
    msg = "Power Redundancy Lost";
    hpq_info = PRINTF ("The Power Supplies are no longer redundant on Chassis %d.", $V4);
END

################################################################
CLASS IM_6033
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6033;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolPowerSupplyChassis");
    5: ATTR(=, "cpqHeFltTolPowerSupplyBay");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6033;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeFltTolPowerSupplyChassis = $V4;
    hpq_HeFltTolPowerSupplyBay = $V5;
    msg = "Power Supply Inserted";
    hpq_info = PRINTF ("The Power Supply Inserted on Chassis %d, Bay %d.", $V4, $V5);
END

#################################################################
CLASS IM_6034
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6034;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolPowerSupplyChassis");
    5: ATTR(=, "cpqHeFltTolPowerSupplyBay");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6034;
    severity = WARNING;
    hostname=$V3;
    hpq_HeFltTolPowerSupplyChassis = $V4;
    hpq_HeFltTolPowerSupplyBay = $V5;
    msg = "Power Supply Removed";
    hpq_info = PRINTF ("The Power Supply Removed on Chassis %d, Bay %d.", $V4, $V5);
END

##################################################################
CLASS IM_6035
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6035;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolFanChassis");
    5: ATTR(=, "cpqHeFltTolFanIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6035;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeFltTolFanChassis = $V4;
    hpq_HeFltTolFanIndex = $V5;
    msg = "Fan Degraded";
    hpq_info = PRINTF ("The Fan Degraded on Chassis %d, Fan %d.", $V4, $V5);
END

##############################################################
CLASS IM_6036
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6036;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolFanChassis");
    5: ATTR(=, "cpqHeFltTolFanIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6036;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeFltTolFanChassis = $V4;
    hpq_HeFltTolFanIndex = $V5;
    msg = "Fan Failed";
    hpq_info = PRINTF ("The Fan Failed on Chassis %d, Fan %d.", $V4, $V5);
END

##############################################################
CLASS IM_6037
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6037;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolFanChassis");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6037;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeFltTolFanChassis = $V4;
    msg = "Fan Redundancy Lost";
    hpq_info = PRINTF ("The Fans are no longer redundant on Chassis %d.", $V4);
END

#################################################################
CLASS IM_6038
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6038;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolFanChassis");
    5: ATTR(=, "cpqHeFltTolFanIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6038;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeFltTolFanChassis = $V4;
    hpq_HeFltTolFanIndex = $V5;
    msg = "Fan Inserted";
    hpq_info = PRINTF ("The Fan Inserted on Chassis %d, Fan %d.", $V4, $V5);
END

################################################################
CLASS IM_6039
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6039;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolFanChassis");
    5: ATTR(=, "cpqHeFltTolFanIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6039;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeFltTolFanChassis = $V4;
    hpq_HeFltTolFanIndex = $V5;
    msg = "Fan Removed";
    hpq_info = PRINTF ("The Fan Removed on Chassis %d, Fan %d.", $V4, $V5);
END

##################################################################
CLASS IM_6040
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6040;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeTemperatureChassis");
    5: ATTR(=, "cpqHeTemperatureLocale");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6040;
    severity = FATAL;
    hostname=$V3;
    hpq_HeTemperatureChassis = $V4;
    hpq_HeTemperatureLocale = $V5;
    msg = "Thermal Failure";
    hpq_info = PRINTF ("Temperature Exceeded on Chassis %d, Location %d.", $V4, $V5);
END

#############################################################
CLASS IM_6041_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6041;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeThermalDegradedAction"), VALUE(=,2);
    5: ATTR(=, "cpqHeTemperatureChassis");
    6: ATTR(=, "cpqHeTemperatureLocale");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6041_2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeThermalDegradedAction = $V4;
    hpq_HeTemperatureChassis = $V5;
    hpq_HeTemperatureLocale = $V6;
    msg = "Thermal Status Degraded";
    hpq_info = PRINTF ("Temperature out of range on Chassis %d, Location %d. The system is %d.", $V5, $V6, $V4);
END

CLASS IM_6041_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6041;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqHeThermalDegradedAction"), VALUE(=,3);
    5: ATTR(=, "cpqHeTemperatureChassis");
    6: ATTR(=, "cpqHeTemperatureLocale");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6041_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HeThermalDegradedAction = $V4;
    hpq_HeTemperatureChassis = $V5;
    hpq_HeTemperatureLocale = $V6;
    msg = "Thermal Status Degraded";
    hpq_info = PRINTF ("Temperature out of range on Chassis %d, Location %d. The system is %d.", $V5, $V6, $V4);
END

################################################################
CLASS IM_6042
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6042;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeTemperatureChassis");
    5: ATTR(=, "cpqHeTemperatureLocale");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6042;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeTemperatureChassis = $V4;
    hpq_HeTemperatureLocale = $V5;
    msg = "Thermal Status OK";
    hpq_info = PRINTF ("Temperature Normal on Chassis %d, Location %d.", $V4, $V5);
END

##################################################################
CLASS IM_6043
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6043;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHePwrConvChassis");
    5: ATTR(=, "cpqHePwrConvSlot");
    6: ATTR(=, "cpqHePwrConvSocket");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6043;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HePwrConvChassis = $V4;
    hpq_HePwrConvSlot = $V5;
    hpq_HePwrConvSocket = $V6;
    msg = "Power Converter Degraded";
    hpq_info = PRINTF ("The Power Converter Degraded on Chassis %d, Slot %d, Socket %d.", $V4, $V5, $V6);
END

##############################################################
CLASS IM_6044
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6044;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHePwrConvChassis");
    5: ATTR(=, "cpqHePwrConvSlot");
    6: ATTR(=, "cpqHePwrConvSocket");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6044;
    severity = FATAL;
    hostname=$V3;
    hpq_HePwrConvChassis = $V4;
    hpq_HePwrConvSlot = $V5;
    hpq_HePwrConvSocket = $V6;
    msg = "Power Converter Failed";
    hpq_info = PRINTF ("The Power Converter Failed on Chassis %d, Slot %d, Socket %d.", $V4, $V5, $V6);
END

################################################################
CLASS IM_6045
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6045;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHePwrConvChassis");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6045;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HePwrConvChassis = $V4;
    msg = "Power Converter Redundancy Lost";
    hpq_info = PRINTF ("The Power Converters are no longer redundant on Chassis %d.", $V4);
END

#################################################################
CLASS IM_6046
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6046;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6046;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Cache Accel Parity Errors may require a module.";
    hpq_info = "Cache Accelerator errors may require a replacement module.";
END

################################################################
CLASS IM_6047
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6047;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6047;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Cache Accel TEST ADD CLASS.";
    hpq_info = "Cache Accelerator TEST ADD CLASS.";
END

#################################################################
CLASS IM_6048
  SELECT
    1: ATTR(=,$ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6048;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqHeFltTolPowerSupplyChassis");
    5: ATTR(=, "cpqHeFltTolPowerSupplyBay");
    6: ATTR(=, "cpqHeFltTolPowerSupplyStatus");
    7: ATTR(=, "cpqHeFltTolPowerSupplyModel");
    8: ATTR(=, "cpqHeFltTolPowerSupplySerialNumber");
    9: ATTR(=, "cpqHeFltTolPowerSupplyAutoRev");
   10: ATTR(=, "cpqHeFltTolPowerSupplyFirmwareRev");
   11: ATTR(=, "cpqHeFltTolPowerSupplySparePartNum");
   12: ATTR(=, "cpqSiServerSystemId");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6048;
    severity = HARMLESS;
    hostname = $V3; 
    hpq_HeFltTolPSChassis = $V4;
    hpq_HeFltTolPSBay = $V5;
    hpq_HeFltTolPowerSupplyStatus = $V6;
    hpq_HeFltTolPSModel = $V7;
    hpq_HeFltTolPSSerial = $V8;
    hpq_HeFltTolPSAutoRev = $V9;
    hpq_HeFltTolPSFirmwareRev = $V10;
    hpq_HeFltTolPSSparePartNum = $V11;
    hpq_SiServerSystemId = $V12;
    msg = "Power Supply status: ok";
    hpq_info =  PRINTF("The Power Supply is OK on Chassis %d, Bay %d, Status %d, Model %s, Serial %s, Firmware %s.", $V4, $V5, $V6, $V7, $V8, $V10 );
END

#################################################################
CLASS IM_6049
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6049;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqHeFltTolPowerSupplyChassis");
    5: ATTR(=, "cpqHeFltTolPowerSupplyBay");
    6: ATTR(=, "cpqHeFltTolPowerSupplyStatus");
    7: ATTR(=, "cpqHeFltTolPowerSupplyModel");
    8: ATTR(=, "cpqHeFltTolPowerSupplySerialNumber");
    9: ATTR(=, "cpqHeFltTolPowerSupplyAutoRev");
   10: ATTR(=, "cpqHeFltTolPowerSupplyFirmwareRev");
   11: ATTR(=, "cpqHeFltTolPowerSupplySparePartNum");
   12: ATTR(=, "cpqSiServerSystemId");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6049;
    severity = CRITICAL;
    hostname = $V3; 
    hpq_HeFltTolPSChassis = $V4;
    hpq_HeFltTolPSBay = $V5;
    hpq_HeFltTolPowerSupplyStatus = $V6;
    hpq_HeFltTolPSModel = $V7;
    hpq_HeFltTolPSSerial = $V8;
    hpq_HeFltTolPSAutoRev = $V9;
    hpq_HeFltTolPSFirmwareRev = $V10;
    hpq_HeFltTolPSSparePartNum = $V11;
    hpq_SiServerSystemId = $V12;
    msg = "Power Supply status: DEGRADED";
    hpq_info =  PRINTF("The Power Supply is DEGRADED on Chassis %d, Bay %d, Status %d, Model %s, Serial Num %s, Firmware %s", $V4, $V5, $V6, $V7, $V8, $V10 );
END

#################################################################
CLASS IM_6050
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6050;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqHeFltTolPowerSupplyChassis");
    5: ATTR(=, "cpqHeFltTolPowerSupplyBay");
    6: ATTR(=, "cpqHeFltTolPowerSupplyStatus");
    7: ATTR(=, "cpqHeFltTolPowerSupplyModel");
    8: ATTR(=, "cpqHeFltTolPowerSupplySerialNumber");
    9: ATTR(=, "cpqHeFltTolPowerSupplyAutoRev");
   10: ATTR(=, "cpqHeFltTolPowerSupplyFirmwareRev");
   11: ATTR(=, "cpqHeFltTolPowerSupplySparePartNum");
   12: ATTR(=, "cpqSiServerSystemId");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6050;
    severity = CRITICAL;
    hostname = $V3; 
    hpq_HeFltTolPSChassis = $V4;
    hpq_HeFltTolPSBay = $V5;
    hpq_HeFltTolPowerSupplyStatus = $V6;
    hpq_HeFltTolPSModel = $V7;
    hpq_HeFltTolPSSerial = $V8;
    hpq_HeFltTolPSAutoRev = $V9;
    hpq_HeFltTolPSFirmwareRev = $V10;
    hpq_HeFltTolPSSparePartNum = $V11;
    hpq_SiServerSystemId = $V12;
    msg = "Power Supply status: Failed";
    hpq_info =  PRINTF("The Power Supply is Failed on Chassis %d, Bay %d, Status %d, Model %s, Serial Num %s, Firmware %s", $V4, $V5, $V6, $V7, $V8, $V10 );
END

#############################################
CLASS IM_6051
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6051;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6051;
    severity = CRITICAL;
    hostname=$V3;
    msg = "The Advanced Memory Protection subsystem has engaged the online spare memory.";
    hpq_info = "The Advanced Memory Protection subsystem has detected a memory fault.  Mirrored Memory has been activated.";
END

#############################################
CLASS IM_6052
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6052;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6052;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Advanced Memory Protection Advanced ECC Memory Engaged.";
    hpq_info = "The Advanced Memory Protection subsystem has engaged the advanced ECC memory.";
END

#############################################
CLASS IM_6053
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6053;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6053;
    severity = CRITICAL;
    hostname=$V3;
    msg = "The Advanced Memory Protection subsystem has engaged the XOR memory.";
    hpq_info = "The Advanced Memory Protection subsystem has engaged the XOR memory.";
END

###############################################################
CLASS IM_6054
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6054;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolPowerSupplyChassis");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6054;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeFltTolPowerSupplyChassis = $V4;
    msg = "The Fault Tolerant Power Supplies have returned to a redundant state for the specified chassis";
    hpq_info = PRINTF ("The Power Supplies are now redundant on Chassis %d.", $V4);
END

##############################################################
CLASS IM_6055
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6055;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeFltTolFanChassis");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6055;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeFltTolFanChassis = $V4;
    msg = "The Fault Tolerant Fans have returned to a redundant state for the specified chassis";
    hpq_info = PRINTF ("The Fans are now redundant on Chassis %d.", $V4);
END

#################################################################
CLASS IM_6056
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6056;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqHeResMemBoardIndex");
    5: ATTR(=, "cpqHeResMemModuleIndex");
    6: ATTR(=, "cpqHeResMemModuleSparePartNo");
    7: ATTR(=, "cpqSiMemModuleSize");
    8: ATTR(=, "cpqSiServerSystemId");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6056;
    severity = CRITICAL;
    hostname = $V3; 
    hpq_HeResMemBoardIndex = $V4;
    hpq_HeResMemModuleIndex = $V5;
    hpq_HeResMemModuleSparePartNo = $V6;
    hpq_SiMemModuleSize = $V7;
    hpq_SiServerSystemId = $V8;
    msg = "Corrected Memory Errors Detected. The errors have been corrected, but the memory module should be replaced.";
    hpq_info =  PRINTF("Correctable memory errors require a replacement of the memory module in slot %d, socket %d.", $V4, $V5);
END

##############################################################
CLASS IM_6057
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6057;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeResMemBoardSlotIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6057;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeResMemBoardSlotIndex = $V4;
    msg = "An Advanced Memory Protection sub-system board or cartridge has been removed from the system.";
    hpq_info = PRINTF ("Memory Board or Cartridge Removed from Slot %d.", $V4);
END

##############################################################
CLASS IM_6058
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6058;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeResMemBoardSlotIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6058;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeResMemBoardSlotIndex = $V4;
    msg = "An Advanced Memory Protection sub-system board or cartridge has been inserted into the system.";
    hpq_info = PRINTF ("Memory Board or Cartridge Inserted into Slot %d.", $V4);
END

##############################################################
CLASS IM_6059
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6059;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeResMemBoardSlotIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6059;
    severity = FATAL;
    hostname=$V3;
    hpq_HeResMemBoardSlotIndex = $V4;
    msg = "An Advanced Memory Protection sub-system board or cartridge bus error has been detected.";
    hpq_info = PRINTF ("Memory Board or Cartridge Bus Error Detected in Slot %d.", $V4);
END

##############################################################
CLASS IM_6060
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 6060;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHeEventLogEntryNumber");
    5: ATTR(=, "cpqHeEventLogEntrySeverity");
    6: ATTR(=, "cpqHeEventLogUpdateTime");
    7: ATTR(=, "cpqHeEventLogErrorDesc");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6060;
    severity = HARMLESS;
    hostname=$V3;
    hpq_HeEventLogEntryNumber = $V4;
    hpq_HeEventLogEntrySeverity = $V5;
    hpq_HeEventLogUpdateTime = $V6;
    hpq_HeEventLogErrorDesc = $V7;
    msg = "An event has occurred.";
    hpq_info = PRINTF ("EVent %s has occurred. Severity is %d.", $V7, $V5);
END
###########################################################################
CLASS IM_6061
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 6061;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6061;
    severity = WARNING;
    hostname = $V3;
    msg = "The Management Processor is currently in the process of being reset.";
    hpq_info = PRINTF ("The Management Processor is in the process being reset on %s", $V3);
END

###########################################################################
CLASS IM_6062
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 6062;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6062;
    severity = HARMLESS;
    hostname = $V3;
    msg = "The Management Processor has successfully reset and is now ready.";
    hpq_info = PRINTF ("The Management Processor is ready after a successfull reset on %s", $V3);
END
############################################################################### 
CLASS IM_6063
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 6063;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 6063;
    severity = FATAL;
    hostname = $V3;
    msg = "The Management Processor has failed to reset.";
    hpq_info = PRINTF ("The Management Processor is failed to reset on %s", $V3);
END

#########################################################
#####   Compaq Host Operating System Information
#########################################################
CLASS IM_11003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 11003;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHoGenericData");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 11003;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HoGenericData=$V4;
    msg = "Generic Trap";
    hpq_info = "Generic Trap" ;
END

###########################################################
CLASS IM_11004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 11004;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHoSwPerfAppErrorDesc");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 11004;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HoSwPerfAppErrorDesc=$V4;
    msg = "Application error";
    hpq_info = PRINTF ( "An application has generated an exception on %s. Specific error information: %s.", $V3, $V4 ) ;
END

##############################################################
CLASS IM_11011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 11011;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHoSwRunningTrapDesc");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 11011;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HoSwRunningTrapDesc = $V4;
    msg = "Process Monitor Event Trap";
    hpq_info = PRINTF ( "%s", $V4);
END

##################################################################
CLASS IM_11014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 11014;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHoCriticalSoftwareUpdateData");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 11014;
    severity = CRITICAL;
    hostname=$V3;
    hpq_HoCriticalSoftwareUpdateData = $V4;
    msg = "Critical Software update Notification Trap";
    hpq_info = PRINTF ( "There is a critical software update on %s", $V3);
END
###########################################################################

CLASS IM_11015
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 11015;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHoCrashDumpState");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 11015;
    severity = WARNING;
    hostname = $V3;
    hpq_HoCrashDumpState = $V4;
    msg = "Crash Dump is not enabled.";
    hpq_info = PRINTF ( "Crash Dump is not enabled on %s", $V3);
END
###########################################################################
CLASS IM_11016
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 11016;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqHoCrashDumpState");
    5: ATTR(=, "cpqHoBootPagingFileSize");
    6: ATTR(=, "cpqHoBootPagingFileMinimumSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 11016;
    severity = WARNING;
    hostname = $V3;
    hpq_HoCrashDumpState = $V4;
    hpq_HoBootPagingFileSize = $V5;
    hpq_HoBootPagingFileMinimumSize = $V6;
    msg = "The Boot Paging File size Or Memory Dump Target Volume is too small to hold the crash dump.";
    hpq_info = PRINTF ( "The Paging file size of the boot volume %s or the target volume of the memory dump file %s is not large enough to hold a crash dump in the event of a system crash", $V5, $V6);
END

#########################################################
#####   Compaq Intelligent Drive Array
#########################################################
CLASS IM_3008_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX , "cpqDaLogDrvStatus"), VALUE(=, 2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_2;
    severity = HARMLESS;
    hostname = $V3; 
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: ok";
    hpq_info =  PRINTF("Drive Array Controller on %s has returned to a normal condition. ControllerId.Drive:  %s", $V3, $K4 ) ;
END

CLASS IM_3008_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX , "cpqDaLogDrvStatus"), VALUE(=, 3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_3;
    severity = FATAL;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: failed ";
    hpq_info =  PRINTF("Failed logical drive on %s. ControllerId.Drive:  %s", $V3, $K4 ) ;
END

CLASS IM_3008_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX , "cpqDaLogDrvStatus"), VALUE(=, 4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_4;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: unconfigured ";
    hpq_info =  PRINTF("Failed logical drive on %s. ControllerId.Drive:  %s", $V3, $K4 ) ;
END

CLASS IM_3008_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=, 5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_5;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg ="Logical drive status: recovering";
    hpq_info =  PRINTF("Physical Drive on %s failed. Drive Array is now in recovery mode. Replace failed drive. ControllerId.Drive: %s", $V3, $K4) ;
END

CLASS IM_3008_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=, 6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_6;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: ready for rebuild";
    hpq_info =  PRINTF("Failed Drive on %s has been repaired or replaced. System is now ready to begin Automatic Data Recovery. ControllerId.Drive: %s ", $V3, $K4);
END

CLASS IM_3008_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=, 7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_7;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: rebuilding ";
    hpq_info =  PRINTF("Drive Array on %s is rebuilding. Automatic Data Recovery is underway. ControllerId.Drive: %s ", $V3, $K4);
END

CLASS IM_3008_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=, 8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_8;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: wrong drive";
    hpq_info =  PRINTF("Incorrect Physical Drive has been replaced in drive array on %s. ControllerId.Drive: %s", $V3,$K4);
END

CLASS IM_3008_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=, 9);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_9;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: bad connection";
    hpq_info =  PRINTF("Bad Drive connection on %s. Physical Drive not responding to Drive Array controller. ControllerId.Drive: %s", $V3, $K4);
END

CLASS IM_3008_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008;
    3: ATTR(=, "sysName" );
    4: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=, 10) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_10;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical drive status: overheating";
    hpq_info =  PRINTF("Drive array enclosure on %s is overheating. The drive array should be shut down. ControllerId.Drive: %s", $V3,$K4);
END

CLASS IM_3008_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=, 11);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_11;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg ="Logical drive status: shutdown";
    hpq_info =  PRINTF("Drive Array enclosure on %s has overheated. Logical drive has been shut down. ControllerId.Drive: %s", $V3, $K4);
END

CLASS IM_3008_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX , "cpqDaLogDrvStatus"), VALUE(=, 12) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_12;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "Logical drive status: expanding";
    hpq_info = PRINTF("Logical drive on %s is currently doing Automatic Data Expansion. ControllerId.Drive: %s", $V3, $K4);
END
      
CLASS IM_3008_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX , "cpqDaLogDrvStatus"), VALUE(=, 13) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_13;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "Logical drive status: Not Available";
    hpq_info = PRINTF("Logical drive on %s is currently unavailable. ControllerId.Drive: %s", $V3, $K4);
END
      
CLASS IM_3008_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3008 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX , "cpqDaLogDrvStatus"), VALUE(=, 14) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3008_14;
    severity = WARNING;
    hostname = $V3;
    hpq_DaLogDrvStatus = $V4;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "Logical drive status: Queued For Expansion";
    hpq_info = PRINTF("Logical drive on %s is ready for Automatic Data Expansion. ControllerId.Drive: %s", $V3, $K4);
END
      
####################################################################
#################################################################
CLASS IM_3016
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3016;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqDaCntlrSlot" );
    5: ATTR(=, "cpqDaCntlrPartnerSlot" );
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3016;
    severity = WARNING;
    hostname= $V3;    
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrPartnerSlot = $V5;
    msg = "Duplex Controller Active";
    hpq_info = PRINTF("Controller in slot %d is now active.", $V4);
END

##############################################################
CLASS IM_3017_02
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3017;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaSpareStatus" ), VALUE(=,2);   
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSpareBusNumber");
    7: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3017_2;
    severity = WARNING;
    hostname = $V3;
    hpq_DaSpareStatus = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSpareBusNumber = $V6;
    hpq_DaSpareBay = $V7;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "Spare Drive Status: invalid";
    hpq_info = PRINTF("The on-line spare on %s in controller index %d bay %d  bus %d is %d.", $V3, $V5, $V7, $V6, $V4);
END

CLASS IM_3017_03
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3017;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaSpareStatus" ), VALUE(=,3);   
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSpareBusNumber");
    7: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3017_3;
    severity = FATAL;
    hostname= $V3;
    hpq_DaSpareStatus = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSpareBusNumber = $V6;
    hpq_DaSpareBay = $V7;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "The on-line spare has failed and is no longer available for use.";
    hpq_info = PRINTF("The on-line spare on %s in controller index %d bay %d  bus %d is %d.", $V3, $V5, $V7, $V6, $V4);
END

CLASS IM_3017_04
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3017;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaSpareStatus" ), VALUE(=,4);   
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSpareBusNumber");
    7: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3017_4;
    severity = HARMLESS;
    hostname= $V3;
    hpq_DaSpareStatus = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSpareBusNumber = $V6;
    hpq_DaSpareBay = $V7;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "The monitored system has an on-line spare configured, but is not currently in use";
    hpq_info = PRINTF("The on-line spare on %s in controller index %d bay %d  bus %d is %d.", $V3, $V5, $V7, $V6, $V4);
END

CLASS IM_3017_05
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3017;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaSpareStatus" ), VALUE(=,5);   
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSpareBusNumber");
    7: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3017_5;
    severity = WARNING;
    hostname= $V3;
    hpq_DaSpareStatus = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSpareBusNumber = $V6;
    hpq_DaSpareBay = $V7;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "A physical drive has failed. Automatic Data Recovery is in progress to recover data to the on-line spare";
    hpq_info = PRINTF("The on-line spare on %s in controller index %d bay %d  bus %d is %d.", $V3, $V5, $V7, $V6, $V4);
END

CLASS IM_3017_06
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3017;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(PREFIX, "cpqDaSpareStatus" ), VALUE(=,6);   
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSpareBusNumber");
    7: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3017_6;
    severity = WARNING;
    hostname= $V3;
    hpq_DaSpareStatus = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSpareBusNumber = $V6;
    hpq_DaSpareBay = $V7;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "A physical drive has failed. Automatic Data Recovery is complete.  The system is using the on-line spare as a replacement for the failed drive.";
    hpq_info = PRINTF("The on-line spare on %s in controller index %d bay %d  bus %d is %d.", $V3, $V5, $V7, $V6, $V4);
END

###############################################################
###############################################################
###############################################################
CLASS IM_3021_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3021;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqDaTapeLibraryScsiBus");
    6: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    7: ATTR(=, "cpqDaTapeLibraryScsiLun");
    8: ATTR(PREFIX, "cpqDaTapeLibraryDoorStatus"), VALUE(=,2);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3021_2;
    severity = WARNING;
    hostname= $V3;
    hpq_DaTapeLibraryCntlrIndex = $V4;
    hpq_DaTapeLibraryScsiBus = $V5;
    hpq_DaTapeLibraryScsiTarget = $V6;
    hpq_DaTapeLibraryScsiLun = $V7;
    hpq_DaTapeLibraryDoorStatus = $V8;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Tape Library Door Status: notSupported";
    hpq_info = PRINTF("The status of the tape library door on %s on SCSI bus %d cannot be displayed.  It is not supported", $V3, $V5);
END

CLASS IM_3021_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3021;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqDaTapeLibraryScsiBus");
    6: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    7: ATTR(=, "cpqDaTapeLibraryScsiLun");
    8: ATTR(PREFIX, "cpqDaTapeLibraryDoorStatus"), VALUE(=,3);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3021_3;
    severity = HARMLESS;
    hostname= $V3;
    hpq_DaTapeLibraryCntlrIndex = $V4;
    hpq_DaTapeLibraryScsiBus = $V5;
    hpq_DaTapeLibraryScsiTarget = $V6;
    hpq_DaTapeLibraryScsiLun = $V7;
    hpq_DaTapeLibraryDoorStatus = $V8;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Tape Library Door Status: closed";
    hpq_info = PRINTF("The tape library door on %s on SCSI bus %d is closed", $V3, $V5);
END

CLASS IM_3021_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3021;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqDaTapeLibraryScsiBus");
    6: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    7: ATTR(=, "cpqDaTapeLibraryScsiLun");
    8: ATTR(PREFIX, "cpqDaTapeLibraryDoorStatus"), VALUE(=,4);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3021_4;
    severity = WARNING;
    hostname= $V3;
    hpq_DaTapeLibraryCntlrIndex = $V4;
    hpq_DaTapeLibraryScsiBus = $V5;
    hpq_DaTapeLibraryScsiTarget = $V6;
    hpq_DaTapeLibraryScsiLun = $V7;
    hpq_DaTapeLibraryDoorStatus = $V8;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "Tape Library Door Status: open";
    hpq_info = PRINTF("The tape library door on %s on SCSI bus %d is open", $V3, $V5);
END

##############################################################
##################################################################
CLASS IM_3023
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3023;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3023;
    severity = CRITICAL;
    hostname= $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    msg = "Tape Drive Cleaning Required";
    hpq_info = PRINTF("The tape drive on %s on controller %d on bus %d needs cleaning", $V3, $V4, $V5);
END

##################################################################
CLASS IM_3024
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3024;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3024;
    severity = FATAL;
    hostname = $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    msg = "Tape Drive Cleaning Tape Needs Replacing";
    hpq_info = PRINTF("The tape drive cleaning tape on %s on controller %d on bus %d needs replacing", $V3, $V4, $V5);
END

################################################################
CLASS IM_3025_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3025;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelSerialNumber");
    7: ATTR(=, "cpqDaAccelTotalMemory");
    8: ATTR(=, "cpqDaAccelErrCode");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,2);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname = $V3;
    hpq_eventID = 3025_2;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelSerialNumber = $V6;
    hpq_DaAccelTotalMemory = $V7;
    hpq_DaAccelErrCode = $V8;
    hpq_val = $V9;
    sub_origin = $K9;
    hpq_DaAccelStatus = $V9;
    msg = "Accelerator Board Status: invalid";
    hpq_info = PRINTF("The accelerator board model %d on %s in slot %d gave error code %d. The status is invalid", $V5, $V3, $V4, $V8);
END

CLASS IM_3025_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3025;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelSerialNumber");
    7: ATTR(=, "cpqDaAccelTotalMemory");
    8: ATTR(=, "cpqDaAccelErrCode");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,3);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_eventID = 3025_3;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelSerialNumber = $V6;
    hpq_DaAccelTotalMemory = $V7;
    hpq_DaAccelErrCode = $V8;
    hpq_val = $V9;
    sub_origin = $K9;
    hpq_DaAccelStatus = $V9;
    msg = "Accelerator Board Status: enabled";
    hpq_info = PRINTF("The accelerator board model %d on %s in slot %d gave error code %d. The board is enabled", $V5, $V3, $V4, $V8);
END

CLASS IM_3025_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3025;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelSerialNumber");
    7: ATTR(=, "cpqDaAccelTotalMemory");
    8: ATTR(=, "cpqDaAccelErrCode");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,4);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname = $V3;
    hpq_eventID = 3025_4;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelSerialNumber = $V6;
    hpq_DaAccelTotalMemory = $V7;
    hpq_DaAccelErrCode = $V8;
    hpq_val = $V9;
    sub_origin = $K9;
    hpq_DaAccelStatus = $V9;
    msg = "Accelerator Board Status: tmpDisabled";
    hpq_info = PRINTF("The accelerator board model %d on %s in slot %d gave error code %d. The board is temporarily disabled", $V5, $V3, $V4, $V8);
END

CLASS IM_3025_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3025;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelSerialNumber");
    7: ATTR(=, "cpqDaAccelTotalMemory");
    8: ATTR(=, "cpqDaAccelErrCode");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,5);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname = $V3;
    hpq_eventID = 3025_5;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelSerialNumber = $V6;
    hpq_DaAccelTotalMemory = $V7;
    hpq_DaAccelErrCode = $V8;
    hpq_val = $V9;
    sub_origin = $K9;
    hpq_DaAccelStatus = $V9;
    msg = "Accelerator Board Status: permDisabled";
    hpq_info = PRINTF("The accelerator board model %d on %s in slot %d gave error code %d. The board is permanently disabled", $V5, $V3, $V4, $V8);
END

#################################################################
CLASS IM_3026
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3026;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelSerialNumber");
    7: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3026;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelSerialNumber = $V6;
    hpq_DaAccelTotalMemory = $V7;
    msg = "Accelerator lost battery power.  Data loss possible.";
    hpq_info = PRINTF("The accelerator board model %d on %s in slot %d has lost battery power.", $V5, $V3, $V4);
END

####################################################################
CLASS IM_3027
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3027;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelSerialNumber");
    7: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3027;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelSerialNumber = $V6;
    hpq_DaAccelTotalMemory = $V7;
    msg = "Accelerator board battery failed.";
    hpq_info = PRINTF("The battery on accelerator board model %d on %s in slot %d has failed.", $V5, $V3, $V4);
END

###################################################################
CLASS IM_3028_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3028;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,2);
    6: ATTR(=, "cpqDaCntlrModel");
    7: ATTR(=, "cpqDaCntlrSerialNumber");
    8: ATTR(=, "cpqDaCntlrFWRev");
    9: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3028_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrBoardStatus = $V5;
    hpq_DaCntlrModel = $V6;
    hpq_DaCntlrSerialNumber = $V7;
    hpq_DaCntlrFWRev = $V8;
    hpq_DaAccelTotalMemory = $V9;
    sub_origin = $K5;
    hpq_val = $V5;
    msg = "Controller Status: ok";
    hpq_info = PRINTF("The controller board model %d on %s in slot %d is ok.", $V6, $V3, $V4);
END

CLASS IM_3028_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3028;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,3);
    6: ATTR(=, "cpqDaCntlrModel");
    7: ATTR(=, "cpqDaCntlrSerialNumber");
    8: ATTR(=, "cpqDaCntlrFWRev");
    9: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3028_3;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrBoardStatus = $V5;
    hpq_DaCntlrModel = $V6;
    hpq_DaCntlrSerialNumber = $V7;
    hpq_DaCntlrFWRev = $V8;
    hpq_DaAccelTotalMemory = $V9;
    sub_origin = $K5;
    hpq_val = $V5;
    msg = "Controller Status: failure";
    hpq_info = PRINTF("The controller board model %d on %s in slot %d is failed.", $V6, $V3, $V4);
END

CLASS IM_3028_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3028;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,4);
    6: ATTR(=, "cpqDaCntlrModel");
    7: ATTR(=, "cpqDaCntlrSerialNumber");
    8: ATTR(=, "cpqDaCntlrFWRev");
    9: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3028_4;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrBoardStatus = $V5;
    hpq_DaCntlrModel = $V6;
    hpq_DaCntlrSerialNumber = $V7;
    hpq_DaCntlrFWRev = $V8;
    hpq_DaAccelTotalMemory = $V9;
    sub_origin = $K5;
    hpq_val = $V5;
    msg = "Controller Status: cable problem.";
    hpq_info = PRINTF("The controller board model %d on %s in slot %d has %d.", $V6, $V3, $V4, $V5);
END

CLASS IM_3028_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3028;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrSlot");
    5: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,5);
    6: ATTR(=, "cpqDaCntlrModel");
    7: ATTR(=, "cpqDaCntlrSerialNumber");
    8: ATTR(=, "cpqDaCntlrFWRev");
    9: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3028_5;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrSlot = $V4;
    hpq_DaCntlrBoardStatus = $V5;
    hpq_DaCntlrModel = $V6;
    hpq_DaCntlrSerialNumber = $V7;
    hpq_DaCntlrFWRev = $V8;
    hpq_DaAccelTotalMemory = $V9;
    sub_origin = $K5;
    hpq_val = $V5;
    msg = "Controller Status: poweredOff";
    hpq_info = PRINTF("The controller board model %d on %s in slot %d is poweredOff.", $V6, $V3, $V4);
END

################################################################
CLASS IM_3029_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3029;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(PREFIX, "cpqDaPhyDrvStatus"), VALUE(=,2);
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvBusNumber");
    7: ATTR(=, "cpqDaPhyDrvBay");
    8: ATTR(=, "cpqDaPhyDrvModel");
    9: ATTR(=, "cpqDaPhyDrvFWRev");
    10: ATTR(=, "cpqDaPhyDrvSerialNum");
    11: ATTR(=, "cpqDaPhyDrvFailureCode");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3029_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaPhyDrvStatus = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvBusNumber = $V6;
    hpq_DaPhyDrvBay = $V7;
    hpq_DaPhyDrvModel = $V8;
    hpq_DaPhyDrvFWRev = $V9;
    hpq_DaPhyDrvSerialNum= $V10;
    hpq_DaPhyDrvFailureCode = $V11;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "Physical Drive Status: ok";
    hpq_info = PRINTF("The physical drive, model %s, on %s in bay %d on bus %d status is %d.",  $V8, $V3, $V7, $V6, $V4);
END

CLASS IM_3029_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3029;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(PREFIX, "cpqDaPhyDrvStatus"), VALUE(=,3);
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvBusNumber");
    7: ATTR(=, "cpqDaPhyDrvBay");
    8: ATTR(=, "cpqDaPhyDrvModel");
    9: ATTR(=, "cpqDaPhyDrvFWRev");
    10: ATTR(=, "cpqDaPhyDrvSerialNum");
    11: ATTR(=, "cpqDaPhyDrvFailureCode");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3029_3;
    severity = FATAL;
    hostname = $V3;
    hpq_DaPhyDrvStatus = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvBusNumber = $V6;
    hpq_DaPhyDrvBay = $V7;
    hpq_DaPhyDrvModel = $V8;
    hpq_DaPhyDrvFWRev = $V9;
    hpq_DaPhyDrvSerialNum= $V10;
    hpq_DaPhyDrvFailureCode = $V11;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "Physical Drive Status: failed";
    hpq_info = PRINTF("The physical drive, model %s, on %s in bay %d on bus %d status is %d.",  $V8, $V3, $V7, $V6, $V4);
END

CLASS IM_3029_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3029;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(PREFIX, "cpqDaPhyDrvStatus"), VALUE(=,4);
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvBusNumber");
    7: ATTR(=, "cpqDaPhyDrvBay");
    8: ATTR(=, "cpqDaPhyDrvModel");
    9: ATTR(=, "cpqDaPhyDrvFWRev");
    10: ATTR(=, "cpqDaPhyDrvSerialNum");
    11: ATTR(=, "cpqDaPhyDrvFailureCode");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3029_4;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaPhyDrvStatus = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvBusNumber = $V6;
    hpq_DaPhyDrvBay = $V7;
    hpq_DaPhyDrvModel = $V8;
    hpq_DaPhyDrvFWRev = $V9;
    hpq_DaPhyDrvSerialNum= $V10;
    hpq_DaPhyDrvFailureCode = $V11;
    sub_origin = $K4;
    hpq_val = $V4;
    msg = "Physical Drive Status: predictiveFailure";
    hpq_info = PRINTF("The physical drive, model %s, on %s in bay %d on bus %d status is %d.",  $V8, $V3, $V7, $V6, $V4);
END

#################################################################
CLASS IM_3030
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3030;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    5: ATTR(=, "cpqDaPhyDrvBusNumber");
    6: ATTR(=, "cpqDaPhyDrvBay");
    7: ATTR(=, "cpqDaPhyDrvModel");
    8: ATTR(=, "cpqDaPhyDrvFWRev");
    9: ATTR(=, "cpqDaPhyDrvSerialNum");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3030;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaPhyDrvCntlrIndex = $V4;
    hpq_DaPhyDrvBusNumber = $V5;
    hpq_DaPhyDrvBay = $V6;
    hpq_DaPhyDrvModel = $V7;
    hpq_DaPhyDrvFWRev = $V8;
    hpq_DaPhyDrvSerialNum = $V9;
    msg = "Physical Drive Threshold Passed";
    hpq_info = PRINTF("The physical drive, model %s, on %s in bay %d on bus %d has passed a factory set threshold.", $V7, $V3, $V6, $V5);
END

#############################################################
CLASS IM_3031_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3031;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqDaTapeLibraryScsiBus");
    6: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    7: ATTR(=, "cpqDaTapeLibraryScsiLun");
    8: ATTR(=, "cpqDaTapeLibraryModel");
    9: ATTR(=, "cpqDaTapeLibraryFWRev");
    10: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,2);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3031_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaTapeLibraryCntlrIndex = $V4;
    hpq_DaTapeLibraryScsiBus = $V5;
    hpq_DaTapeLibraryScsiTarget = $V6;
    hpq_DaTapeLibraryScsiLun = $V7;
    hpq_DaTapeLibraryModel = $V8;
    hpq_DaTapeLibraryFWRev = $V9;
    hpq_DaTapeLibrarySerialNumber = $V10;
    hpq_DaTapeLibraryStatus = $V11;
    msg = "Tape Library Status Change to ok";
    hpq_info = PRINTF("Status is now %d for the tape library.", $V11);
END

CLASS IM_3031_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3031;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqDaTapeLibraryScsiBus");
    6: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    7: ATTR(=, "cpqDaTapeLibraryScsiLun");
    8: ATTR(=, "cpqDaTapeLibraryModel");
    9: ATTR(=, "cpqDaTapeLibraryFWRev");
    10: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,3);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3031_3;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaTapeLibraryCntlrIndex = $V4;
    hpq_DaTapeLibraryScsiBus = $V5;
    hpq_DaTapeLibraryScsiTarget = $V6;
    hpq_DaTapeLibraryScsiLun = $V7;
    hpq_DaTapeLibraryModel = $V8;
    hpq_DaTapeLibraryFWRev = $V9;
    hpq_DaTapeLibrarySerialNumber = $V10;
    hpq_DaTapeLibraryStatus = $V11;
    msg = "Tape Library Status Change to degraded";
    hpq_info = PRINTF("Status is now %d for the tape library.", $V11);
END

CLASS IM_3031_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3031;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqDaTapeLibraryScsiBus");
    6: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    7: ATTR(=, "cpqDaTapeLibraryScsiLun");
    8: ATTR(=, "cpqDaTapeLibraryModel");
    9: ATTR(=, "cpqDaTapeLibraryFWRev");
    10: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,4);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3031_4;
    severity = FATAL;
    hostname = $V3;
    hpq_DaTapeLibraryCntlrIndex = $V4;
    hpq_DaTapeLibraryScsiBus = $V5;
    hpq_DaTapeLibraryScsiTarget = $V6;
    hpq_DaTapeLibraryScsiLun = $V7;
    hpq_DaTapeLibraryModel = $V8;
    hpq_DaTapeLibraryFWRev = $V9;
    hpq_DaTapeLibrarySerialNumber = $V10;
    hpq_DaTapeLibraryStatus = $V11;
    msg = "Tape Library Status Change to failed";
    hpq_info = PRINTF("Status is now %d for the tape library.", $V11);
END

CLASS IM_3031_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3031;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqDaTapeLibraryScsiBus");
    6: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    7: ATTR(=, "cpqDaTapeLibraryScsiLun");
    8: ATTR(=, "cpqDaTapeLibraryModel");
    9: ATTR(=, "cpqDaTapeLibraryFWRev");
    10: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,5);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3031_4;
    severity = WARNING;
    hostname = $V3;
    hpq_DaTapeLibraryCntlrIndex = $V4;
    hpq_DaTapeLibraryScsiBus = $V5;
    hpq_DaTapeLibraryScsiTarget = $V6;
    hpq_DaTapeLibraryScsiLun = $V7;
    hpq_DaTapeLibraryModel = $V8;
    hpq_DaTapeLibraryFWRev = $V9;
    hpq_DaTapeLibrarySerialNumber = $V10;
    hpq_DaTapeLibraryStatus = $V11;
    msg = "Tape Library Status Change to offline";
    hpq_info = PRINTF("Status is now %d for the tape library.", $V11);
END

#############################################################
CLASS IM_3032_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3032;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
    8: ATTR(=, "cpqDaTapeDrvName");
    9: ATTR(=, "cpqDaTapeDrvFwRev");
    10: ATTR(=, "cpqDaTapeDrvSerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,2);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3032_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    hpq_DaTapeDrvName = $V8;
    hpq_DaTapeDrvFwRev = $V9;
    hpq_DaTapeDrvSerialNumber = $V10;
    hpq_DaTapeDrvStatus = $V11;
    msg = "Tape Drive Status Change to ok";
    hpq_info = PRINTF("Status is now %d for a tape drive.", $V11);
END

CLASS IM_3032_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3032;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
    8: ATTR(=, "cpqDaTapeDrvName");
    9: ATTR(=, "cpqDaTapeDrvFwRev");
    10: ATTR(=, "cpqDaTapeDrvSerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,3);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3032_3;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    hpq_DaTapeDrvName = $V8;
    hpq_DaTapeDrvFwRev = $V9;
    hpq_DaTapeDrvSerialNumber = $V10;
    hpq_DaTapeDrvStatus = $V11;
    msg = "Tape Drive Status Change to degraded";
    hpq_info = PRINTF("Status is now %d for a tape drive.", $V11);
END

CLASS IM_3032_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3032;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
    8: ATTR(=, "cpqDaTapeDrvName");
    9: ATTR(=, "cpqDaTapeDrvFwRev");
    10: ATTR(=, "cpqDaTapeDrvSerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,4);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3032_4;
    severity = FATAL;
    hostname = $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    hpq_DaTapeDrvName = $V8;
    hpq_DaTapeDrvFwRev = $V9;
    hpq_DaTapeDrvSerialNumber = $V10;
    hpq_DaTapeDrvStatus = $V11;
    msg = "Tape Drive Status Change to failed";
    hpq_info = PRINTF("Status is now %d for a tape drive.", $V11);
END

CLASS IM_3032_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3032;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
    8: ATTR(=, "cpqDaTapeDrvName");
    9: ATTR(=, "cpqDaTapeDrvFwRev");
    10: ATTR(=, "cpqDaTapeDrvSerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,5);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3032_5;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    hpq_DaTapeDrvName = $V8;
    hpq_DaTapeDrvFwRev = $V9;
    hpq_DaTapeDrvSerialNumber = $V10;
    hpq_DaTapeDrvStatus = $V11;
    msg = "Tape Drive Status Change to offline";
    hpq_info = PRINTF("Status is now %d for a tape drive.", $V11);
END

CLASS IM_3032_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3032;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
    8: ATTR(=, "cpqDaTapeDrvName");
    9: ATTR(=, "cpqDaTapeDrvFwRev");
    10: ATTR(=, "cpqDaTapeDrvSerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,6);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3032_6;
    severity = WARNING;
    hostname = $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    hpq_DaTapeDrvName = $V8;
    hpq_DaTapeDrvFwRev = $V9;
    hpq_DaTapeDrvSerialNumber = $V10;
    hpq_DaTapeDrvStatus = $V11;
    msg = "Tape Drive Status Change to missingWasOk";
    hpq_info = PRINTF("Status is now %d for a tape drive.", $V11);
END

CLASS IM_3032_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3032;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    5: ATTR(=, "cpqDaTapeDrvBusIndex");
    6: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    7: ATTR(=, "cpqDaTapeDrvLunIndex");
    8: ATTR(=, "cpqDaTapeDrvName");
    9: ATTR(=, "cpqDaTapeDrvFwRev");
    10: ATTR(=, "cpqDaTapeDrvSerialNumber");
    11: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,7);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3032_7;
    severity = WARNING;
    hostname = $V3;
    hpq_DaTapeDrvCntlrIndex = $V4;
    hpq_DaTapeDrvBusIndex = $V5;
    hpq_DaTapeDrvScsiIdIndex = $V6;
    hpq_DaTapeDrvLunIndex = $V7;
    hpq_DaTapeDrvName = $V8;
    hpq_DaTapeDrvFwRev = $V9;
    hpq_DaTapeDrvSerialNumber = $V10;
    hpq_DaTapeDrvStatus = $V11;
    msg = "Tape Drive Status Change to missingWasOffline";
    hpq_info = PRINTF("Status is now %d for a tape drive.", $V11);
END

###################################################################
CLASS IM_3033_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3033;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaCntlrIndex");
    6: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,2);
    7: ATTR(=, "cpqDaCntlrModel");
    8: ATTR(=, "cpqDaCntlrSerialNumber");
    9: ATTR(=, "cpqDaCntlrFWRev");
    10: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3033_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrIndex = $V5;
    hpq_DaCntlrBoardStatus = $V6;
    hpq_DaCntlrModel = $V7;
    hpq_DaCntlrSerialNumber = $V8;
    hpq_DaCntlrFWRev = $V9;
    hpq_DaAccelTotalMemory = $V10;
    sub_origin = $K6;
    hpq_val = $V6;
    msg = "Controller Status: ok";
    hpq_info = PRINTF("The controller board model %d on %s in %s is ok.", $V7, $V3, $V4);
END

CLASS IM_3033_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3033;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaCntlrIndex");
    6: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,3);
    7: ATTR(=, "cpqDaCntlrModel");
    8: ATTR(=, "cpqDaCntlrSerialNumber");
    9: ATTR(=, "cpqDaCntlrFWRev");
    10: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3033_3;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrIndex = $V5;
    hpq_DaCntlrBoardStatus = $V6;
    hpq_DaCntlrModel = $V7;
    hpq_DaCntlrSerialNumber = $V8;
    hpq_DaCntlrFWRev = $V9;
    hpq_DaAccelTotalMemory = $V10;
    sub_origin = $K6;
    hpq_val = $V6;
    msg = "Controller Status: failed";
    hpq_info = PRINTF("The controller board model %d on %s in %s is failed.", $V7, $V3, $V4);
END

CLASS IM_3033_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3033;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaCntlrIndex");
    6: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,4);
    7: ATTR(=, "cpqDaCntlrModel");
    8: ATTR(=, "cpqDaCntlrSerialNumber");
    9: ATTR(=, "cpqDaCntlrFWRev");
    10: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3033_4;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrIndex = $V5;
    hpq_DaCntlrBoardStatus = $V6;
    hpq_DaCntlrModel = $V7;
    hpq_DaCntlrSerialNumber = $V8;
    hpq_DaCntlrFWRev = $V9;
    hpq_DaAccelTotalMemory = $V10;
    sub_origin = $K6;
    hpq_val = $V6;
    msg = "Controller Status: cable problem";
    hpq_info = PRINTF("The controller board model %d on %s in %s has cable problem.", $V7, $V3, $V4);
END

CLASS IM_3033_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3033;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaCntlrIndex");
    6: ATTR(PREFIX, "cpqDaCntlrBoardStatus"), VALUE(=,5);
    7: ATTR(=, "cpqDaCntlrModel");
    8: ATTR(=, "cpqDaCntlrSerialNumber");
    9: ATTR(=, "cpqDaCntlrFWRev");
    10: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3033_5;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrIndex = $V5;
    hpq_DaCntlrBoardStatus = $V6;
    hpq_DaCntlrModel = $V7;
    hpq_DaCntlrSerialNumber = $V8;
    hpq_DaCntlrFWRev = $V9;
    hpq_DaAccelTotalMemory = $V10;
    sub_origin = $K6;
    hpq_val = $V6;
    msg = "Controller Status: powered off";
    hpq_info = PRINTF("The controller board model %d on %s in %s is powered off.", $V7, $V3, $V4);
END

#########################################################
CLASS IM_3034_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,2);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: ok";
    hpq_info = PRINTF("The status of logical drive (%d) of controller in %s on %s is %d. The logical drive is in normal operation mode.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,3);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_3;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: failed";
    hpq_info = PRINTF("The status of logical drive (%d) of controller in %s on %s is %d. The logical drive is failed.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,4);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_4;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: unconfigured";
    hpq_info = PRINTF("The status of logical drive (%d) of controller in %s on %s is %d. The logical drive is not configured.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,5);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_5;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: recovering";
    hpq_info = PRINTF("The logical drive (%d) of controller in %s on %s is %d. Replace the failed physical drive.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,6);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_6;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: ready for rebuild";
    hpq_info = PRINTF("The failed drive has been repaired or replaced. The logical drive (%d) of controller in %s on %s is %d. System is now ready to begin Automatic Data Recovery.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,7);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_7;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: rebuilding";
    hpq_info = PRINTF("The logical drive (%d) of controller in %s on %s is %d. Automatic Data Recovery is underway.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,8);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_8;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: wrong drive";
    hpq_info = PRINTF("The status of logical drive (%d) of controller in %s on %s is %d. Incorrect Physical Drive has been replaced in drive array.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,9);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_9;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: bad connection";
    hpq_info = PRINTF("The status of logical drive (%d) of controller in %s on %s is %d. Physical Drive not responding to Drive Array controller. Bad drive connection.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,10);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_10;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: overheating";
    hpq_info = PRINTF("The status of logical drive (%d) of controller in %s on %s is %d. The drive array enclosure is overheating and should be shut down.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,11);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_11;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: shutdown";
    hpq_info = PRINTF("The status of logical drive (%d) of controller in %s on %s is %d. The drive array enclosure has overheated and has been shut down.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,12);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_12;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: expanding";
    hpq_info = PRINTF("The logical drive (%d) of controller in %s on %s is %d. The logical drive is currently doing Automatic Data Expansion.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,13);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_13;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: not available";
    hpq_info = PRINTF("The logical drive (%d) of controller in %s on %s is %d.", $V6, $V4, $V3, $V7);
END

CLASS IM_3034_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3034;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaLogDrvCntlrIndex");
    6: ATTR(=, "cpqDaLogDrvIndex");
    7: ATTR(PREFIX, "cpqDaLogDrvStatus"), VALUE(=,14);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3034_14;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaLogDrvCntlrIndex = $V5;
    hpq_DaLogDrvIndex = $V6;
    hpq_DaLogDrvStatus = $V7;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Logical Drive Status: queued for expansion";
    hpq_info = PRINTF("The logical drive (%d) of controller in %s on %s is %d. The logical drive is ready for Automatic Data Expansion.", $V6, $V4, $V3, $V7);
END

#########################################################
CLASS IM_3035_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3035;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,2);
    8: ATTR(=, "cpqDaSpareBusNumber");
    9: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3035_2;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareBusNumber = $V8;
    hpq_DaSpareBay = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: invalid";
    hpq_info = PRINTF("A spare drive in a drive array on %s with SCSI bus number %d is now %d.", $V3, $V8, $V7);
END

CLASS IM_3035_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3035;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,3);
    8: ATTR(=, "cpqDaSpareBusNumber");
    9: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3035_3;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareBusNumber = $V8;
    hpq_DaSpareBay = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: failed";
    hpq_info = PRINTF("A spare drive in a drive array on %s with SCSI bus number %d is now %d.", $V3, $V8, $V7);
END

CLASS IM_3035_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3035;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,4);
    8: ATTR(=, "cpqDaSpareBusNumber");
    9: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3035_4;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareBusNumber = $V8;
    hpq_DaSpareBay = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: inactive";
    hpq_info = PRINTF("A spare drive in a drive array on %s with SCSI bus number %d is now %d.", $V3, $V8, $V7);
END

CLASS IM_3035_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3035;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,5);
    8: ATTR(=, "cpqDaSpareBusNumber");
    9: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3035_5;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareBusNumber = $V8;
    hpq_DaSpareBay = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: building";
    hpq_info = PRINTF("A spare drive on %s with SCSI bus number %d is %d due to the failure of a primary drive. Data is being restored.", $V3, $V8, $V7);
END

CLASS IM_3035_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3035;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,6);
    8: ATTR(=, "cpqDaSpareBusNumber");
    9: ATTR(=, "cpqDaSpareBay");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3035_6;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareBusNumber = $V8;
    hpq_DaSpareBay = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: active";
    hpq_info = PRINTF("Spare drive on %s with SCSI bus number %d is now %d. Data has been successfully restored.", $V3, $V8, $V7);
END

#############################################################

CLASS IM_3036_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3036;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvIndex");
    7: ATTR(=, "cpqDaPhyDrvBusNumber");
    8: ATTR(=, "cpqDaPhyDrvBay");
    9: ATTR(=, "cpqDaPhyDrvModel");
    10: ATTR(=, "cpqDaPhyDrvFWRev");
    11: ATTR(=, "cpqDaPhyDrvSerialNum");
    12: ATTR(=, "cpqDaPhyDrvFailureCode");
    13: ATTR(PREFIX, "cpqDaPhyDrvStatus") , VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3036_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvIndex = $V6;
    hpq_DaPhyDrvBusNumber = $V7;
    hpq_DaPhyDrvBay = $V8;
    hpq_DaPhyDrvModel = $V9;
    hpq_DaPhyDrvFWRev = $V10;
    hpq_DaPhyDrvSerialNum = $V11;
    hpq_DaPhyDrvFailureCode = $V12;
    hpq_DaPhyDrvStatus = $V13;
    sub_origin=$K13;
    hpq_val=$V13;
    msg = "Physical Drive Status: ok.";
    hpq_info = PRINTF ("Physical drive (%d) on drive array with bus number %d in bay %d is in normal operation mode.", $V6, $V7, $V8);
END

CLASS IM_3036_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3036;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvIndex");
    7: ATTR(=, "cpqDaPhyDrvBusNumber");
    8: ATTR(=, "cpqDaPhyDrvBay");
    9: ATTR(=, "cpqDaPhyDrvModel");
    10: ATTR(=, "cpqDaPhyDrvFWRev");
    11: ATTR(=, "cpqDaPhyDrvSerialNum");
    12: ATTR(=, "cpqDaPhyDrvFailureCode");
    13: ATTR(PREFIX, "cpqDaPhyDrvStatus") , VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3036_3;
    severity = FATAL;
    hostname=$V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvIndex = $V6;
    hpq_DaPhyDrvBusNumber = $V7;
    hpq_DaPhyDrvBay = $V8;
    hpq_DaPhyDrvModel = $V9;
    hpq_DaPhyDrvFWRev = $V10;
    hpq_DaPhyDrvSerialNum = $V11;
    hpq_DaPhyDrvFailureCode = $V12;
    hpq_DaPhyDrvStatus = $V13;
    sub_origin=$K13;
    hpq_val=$V13;
    msg = "Physical Drive Status: failed.";
    hpq_info = PRINTF ("Physical drive (%d) on drive array with bus number %d in bay %d has failed.", $V6, $V7, $V8);
END

CLASS IM_3036_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3036;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvIndex");
    7: ATTR(=, "cpqDaPhyDrvBusNumber");
    8: ATTR(=, "cpqDaPhyDrvBay");
    9: ATTR(=, "cpqDaPhyDrvModel");
    10: ATTR(=, "cpqDaPhyDrvFWRev");
    11: ATTR(=, "cpqDaPhyDrvSerialNum");
    12: ATTR(=, "cpqDaPhyDrvFailureCode");
    13: ATTR(PREFIX, "cpqDaPhyDrvStatus") , VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3036_4;
    severity = CRITICAL;
    hostname=$V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvIndex = $V6;
    hpq_DaPhyDrvBusNumber = $V7;
    hpq_DaPhyDrvBay = $V8;
    hpq_DaPhyDrvModel = $V9;
    hpq_DaPhyDrvFWRev = $V10;
    hpq_DaPhyDrvSerialNum = $V11;
    hpq_DaPhyDrvFailureCode = $V12;
    hpq_DaPhyDrvStatus = $V13;
    sub_origin=$K13;
    hpq_val=$V13;
    msg = "Physical Drive Status: predictiveFailure.";
    hpq_info = PRINTF ("Physical drive (%d) on drive array with bus number %d in bay %d has to be replaced.", $V6, $V7, $V8);
END

#################################################################

CLASS IM_3037
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3037;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvIndex");
    7: ATTR(=, "cpqDaPhyDrvBusNumber");
    8: ATTR(=, "cpqDaPhyDrvBay");
    9: ATTR(=, "cpqDaPhyDrvModel");
    10: ATTR(=, "cpqDaPhyDrvFWRev");
    11: ATTR(=, "cpqDaPhyDrvSerialNum");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3037;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvIndex = $V6;
    hpq_DaPhyDrvBusNumber = $V7;
    hpq_DaPhyDrvBay = $V8;
    hpq_DaPhyDrvModel = $V9;
    hpq_DaPhyDrvFWRev = $V10;
    hpq_DaPhyDrvSerialNum = $V11;
    msg = "Physical Drive Threshold Passed";
    hpq_info = PRINTF("The physical drive, model %s, on %s in bay %d on bus %d has passed a factory set threshold.", $V9, $V3, $V8, $V7);
END

################################################################
CLASS IM_3038_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3038;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqDaCntlrHwLocation"); 
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelCntlrIndex");
    7: ATTR(=, "cpqDaAccelSerialNumber");
    8: ATTR(=, "cpqDaAccelTotalMemory");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,2);
    10: ATTR(=, "cpqDaAccelErrCode");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname = $V3;
    hpq_eventID = 3038_2;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelCntlrIndex = $V6;
    hpq_DaAccelSerialNumber = $V7;
    hpq_DaAccelTotalMemory = $V8;
    hpq_DaAccelStatus = $V9;
    hpq_DaAccelErrCode = $V10;
    hpq_val = $V9;
    sub_origin = $K9;
    msg = "Accelerator Board Status: invalid";
    hpq_info = PRINTF("The accelerator board model %d on %s in %s has not been installed in this system or is present but not configured.", $V5, $V3, $V4);
END

CLASS IM_3038_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3038;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqDaCntlrHwLocation"); 
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelCntlrIndex");
    7: ATTR(=, "cpqDaAccelSerialNumber");
    8: ATTR(=, "cpqDaAccelTotalMemory");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,3);
    10: ATTR(=, "cpqDaAccelErrCode");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_eventID = 3038_3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelCntlrIndex = $V6;
    hpq_DaAccelSerialNumber = $V7;
    hpq_DaAccelTotalMemory = $V8;
    hpq_DaAccelStatus = $V9;
    hpq_DaAccelErrCode = $V10;
    hpq_val = $V9;
    sub_origin = $K9;
    msg = "Accelerator Board Status: enabled";
    hpq_info = PRINTF("The accelerator board model %d on %s in %s is enabled. The write cache operations are currently configured and enabled for at least one logical drive.", $V5, $V3, $V4);
END

CLASS IM_3038_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3038;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqDaCntlrHwLocation"); 
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelCntlrIndex");
    7: ATTR(=, "cpqDaAccelSerialNumber");
    8: ATTR(=, "cpqDaAccelTotalMemory");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,4);
    10: ATTR(=, "cpqDaAccelErrCode");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname = $V3;
    hpq_eventID = 3038_4;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelCntlrIndex = $V6;
    hpq_DaAccelSerialNumber = $V7;
    hpq_DaAccelTotalMemory = $V8;
    hpq_DaAccelStatus = $V9;
    hpq_DaAccelErrCode = $V10;
    hpq_val = $V9;
    sub_origin = $K9;
    msg = "Accelerator Board Status: tmpDisabled";
    hpq_info = PRINTF("The write cache operations on accelerator board model %d on %s in %s have been temporarily disabled.", $V5, $V3, $V4);
END

CLASS IM_3038_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3038;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqDaCntlrHwLocation"); 
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelCntlrIndex");
    7: ATTR(=, "cpqDaAccelSerialNumber");
    8: ATTR(=, "cpqDaAccelTotalMemory");
    9: ATTR(PREFIX, "cpqDaAccelStatus"), VALUE(=,5);
    10: ATTR(=, "cpqDaAccelErrCode");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname = $V3;
    hpq_eventID = 3038_5;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelCntlrIndex = $V6;
    hpq_DaAccelSerialNumber = $V7;
    hpq_DaAccelTotalMemory = $V8;
    hpq_DaAccelStatus = $V9;
    hpq_DaAccelErrCode = $V10;
    hpq_val = $V9;
    sub_origin = $K9;
    msg = "Accelerator Board Status: permDisabled";
    hpq_info = PRINTF("The write cache operations on accelerator board model %d on %s in %s have been permanently disabled.", $V5, $V3, $V4);
END

#################################################################
CLASS IM_3039
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3039;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelCntlrIndex");
    7: ATTR(=, "cpqDaAccelSerialNumber");
    8: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3039;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelCntlrIndex = $V6;
    hpq_DaAccelSerialNumber = $V7;
    hpq_DaAccelTotalMemory = $V8;
    msg = "Accelerator lost battery power.  Data loss possible.";
    hpq_info = PRINTF("The accelerator board model %d on %s in %s has lost battery power.", $V5, $V3, $V4);
END

####################################################################
CLASS IM_3040
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3040;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaCntlrModel");
    6: ATTR(=, "cpqDaAccelCntlrIndex");
    7: ATTR(=, "cpqDaAccelSerialNumber");
    8: ATTR(=, "cpqDaAccelTotalMemory");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3040;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaCntlrModel = $V5;
    hpq_DaAccelCntlrIndex = $V6;
    hpq_DaAccelSerialNumber = $V7;
    hpq_DaAccelTotalMemory = $V8;
    msg = "Accelerator board battery failed.";
    hpq_info = PRINTF("The battery on accelerator board model %d on %s in %s has failed.", $V5, $V3, $V4);
END

#############################################################
CLASS IM_3041_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3041;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    6: ATTR(=, "cpqDaTapeLibraryScsiBus");
    7: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    8: ATTR(=, "cpqDaTapeLibraryScsiLun");
    9: ATTR(=, "cpqDaTapeLibraryModel");
    10: ATTR(=, "cpqDaTapeLibraryFWRev");
    11: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,2);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3041_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeLibraryCntlrIndex = $V5;
    hpq_DaTapeLibraryScsiBus = $V6;
    hpq_DaTapeLibraryScsiTarget = $V7;
    hpq_DaTapeLibraryScsiLun = $V8;
    hpq_DaTapeLibraryModel = $V9;
    hpq_DaTapeLibraryFWRev = $V10;
    hpq_DaTapeLibrarySerialNumber = $V11;
    hpq_DaTapeLibraryStatus = $V12;
    msg = "Tape Library Status: ok";
    hpq_info = PRINTF("Status of the tape library is now %d.", $V12);
END

CLASS IM_3041_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3041;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    6: ATTR(=, "cpqDaTapeLibraryScsiBus");
    7: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    8: ATTR(=, "cpqDaTapeLibraryScsiLun");
    9: ATTR(=, "cpqDaTapeLibraryModel");
    10: ATTR(=, "cpqDaTapeLibraryFWRev");
    11: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,3);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3041_3;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeLibraryCntlrIndex = $V5;
    hpq_DaTapeLibraryScsiBus = $V6;
    hpq_DaTapeLibraryScsiTarget = $V7;
    hpq_DaTapeLibraryScsiLun = $V8;
    hpq_DaTapeLibraryModel = $V9;
    hpq_DaTapeLibraryFWRev = $V10;
    hpq_DaTapeLibrarySerialNumber = $V11;
    hpq_DaTapeLibraryStatus = $V12;
    msg = "Tape Library Status: degraded";
    hpq_info = PRINTF("Status of the tape library is now %d.", $V12);
END

CLASS IM_3041_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3041;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    6: ATTR(=, "cpqDaTapeLibraryScsiBus");
    7: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    8: ATTR(=, "cpqDaTapeLibraryScsiLun");
    9: ATTR(=, "cpqDaTapeLibraryModel");
    10: ATTR(=, "cpqDaTapeLibraryFWRev");
    11: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,4);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3041_4;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeLibraryCntlrIndex = $V5;
    hpq_DaTapeLibraryScsiBus = $V6;
    hpq_DaTapeLibraryScsiTarget = $V7;
    hpq_DaTapeLibraryScsiLun = $V8;
    hpq_DaTapeLibraryModel = $V9;
    hpq_DaTapeLibraryFWRev = $V10;
    hpq_DaTapeLibrarySerialNumber = $V11;
    hpq_DaTapeLibraryStatus = $V12;
    msg = "Tape Library Status: failed";
    hpq_info = PRINTF("Status of the tape library is now %d.", $V12);
END

CLASS IM_3041_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3041;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    6: ATTR(=, "cpqDaTapeLibraryScsiBus");
    7: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    8: ATTR(=, "cpqDaTapeLibraryScsiLun");
    9: ATTR(=, "cpqDaTapeLibraryModel");
    10: ATTR(=, "cpqDaTapeLibraryFWRev");
    11: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeLibraryStatus"), VALUE(=,5);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3041_5;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeLibraryCntlrIndex = $V5;
    hpq_DaTapeLibraryScsiBus = $V6;
    hpq_DaTapeLibraryScsiTarget = $V7;
    hpq_DaTapeLibraryScsiLun = $V8;
    hpq_DaTapeLibraryModel = $V9;
    hpq_DaTapeLibraryFWRev = $V10;
    hpq_DaTapeLibrarySerialNumber = $V11;
    hpq_DaTapeLibraryStatus = $V12;
    msg = "Tape Library Status: offline";
    hpq_info = PRINTF("Status of the tape library is now %d.", $V12);
END

###############################################################
CLASS IM_3042_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3042;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    6: ATTR(=, "cpqDaTapeLibraryScsiBus");
    7: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    8: ATTR(=, "cpqDaTapeLibraryScsiLun");
    9: ATTR(=, "cpqDaTapeLibraryModel");
    10: ATTR(=, "cpqDaTapeLibraryFWRev");
    11: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeLibraryDoorStatus"), VALUE(=,2);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3042_2;
    severity = WARNING;
    hostname= $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeLibraryCntlrIndex = $V5;
    hpq_DaTapeLibraryScsiBus = $V6;
    hpq_DaTapeLibraryScsiTarget = $V7;
    hpq_DaTapeLibraryScsiLun = $V8;
    hpq_DaTapeLibraryModel = $V9;
    hpq_DaTapeLibraryFWRev = $V10;
    hpq_DaTapeLibrarySerialNumber = $V11;
    hpq_DaTapeLibraryDoorStatus = $V12;
    sub_origin = $K12;
    hpq_val = $V12;
    msg = "Tape Library Door Status: notSupported";
    hpq_info = PRINTF("The status of the tape library door on %s on SCSI bus %d is not supported", $V3, $V6);
END

CLASS IM_3042_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3042;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    6: ATTR(=, "cpqDaTapeLibraryScsiBus");
    7: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    8: ATTR(=, "cpqDaTapeLibraryScsiLun");
    9: ATTR(=, "cpqDaTapeLibraryModel");
    10: ATTR(=, "cpqDaTapeLibraryFWRev");
    11: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeLibraryDoorStatus"), VALUE(=,3);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3042_3;
    severity = HARMLESS;
    hostname= $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeLibraryCntlrIndex = $V5;
    hpq_DaTapeLibraryScsiBus = $V6;
    hpq_DaTapeLibraryScsiTarget = $V7;
    hpq_DaTapeLibraryScsiLun = $V8;
    hpq_DaTapeLibraryModel = $V9;
    hpq_DaTapeLibraryFWRev = $V10;
    hpq_DaTapeLibrarySerialNumber = $V11;
    hpq_DaTapeLibraryDoorStatus = $V12;
    sub_origin = $K12;
    hpq_val = $V12;
    msg = "Tape Library Door Status: closed";
    hpq_info = PRINTF("The status of the tape library door on %s on SCSI bus %d is closed", $V3, $V6);
END

CLASS IM_3042_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3042;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeLibraryCntlrIndex");
    6: ATTR(=, "cpqDaTapeLibraryScsiBus");
    7: ATTR(=, "cpqDaTapeLibraryScsiTarget");
    8: ATTR(=, "cpqDaTapeLibraryScsiLun");
    9: ATTR(=, "cpqDaTapeLibraryModel");
    10: ATTR(=, "cpqDaTapeLibraryFWRev");
    11: ATTR(=, "cpqDaTapeLibrarySerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeLibraryDoorStatus"), VALUE(=,4);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3042_4;
    severity = WARNING;
    hostname= $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeLibraryCntlrIndex = $V5;
    hpq_DaTapeLibraryScsiBus = $V6;
    hpq_DaTapeLibraryScsiTarget = $V7;
    hpq_DaTapeLibraryScsiLun = $V8;
    hpq_DaTapeLibraryModel = $V9;
    hpq_DaTapeLibraryFWRev = $V10;
    hpq_DaTapeLibrarySerialNumber = $V11;
    hpq_DaTapeLibraryDoorStatus = $V12;
    sub_origin = $K12;
    hpq_val = $V12;
    msg = "Tape Library Door Status: open";
    hpq_info = PRINTF("The status of the tape library door on %s on SCSI bus %d is open", $V3, $V6);
END

############################################################
CLASS IM_3043_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3043;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,2);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3043_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    hpq_DaTapeDrvStatus = $V12;
    msg = "Tape Drive Status: ok";
    hpq_info = PRINTF("Status of tape drive %s is now %d.", $V9, $V12);
END

CLASS IM_3043_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3043;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,3);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3043_3;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    hpq_DaTapeDrvStatus = $V12;
    msg = "Tape Drive Status: degraded";
    hpq_info = PRINTF("Status of tape drive %s is now %d.", $V9, $V12);
END

CLASS IM_3043_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3043;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,4);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3043_4;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    hpq_DaTapeDrvStatus = $V12;
    msg = "Tape Drive Status: failed";
    hpq_info = PRINTF("Status of tape drive %s is now %d.", $V9, $V12);
END

CLASS IM_3043_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3043;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,5);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3043_5;
    severity = CRITICAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    hpq_DaTapeDrvStatus = $V12;
    msg = "Tape Drive Status: offline";
    hpq_info = PRINTF("Status of tape drive %s is now %d. Agents can no longer communicate with the tape drive.", $V9, $V12);
END

CLASS IM_3043_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3043;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,6);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3043_6;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    hpq_DaTapeDrvStatus = $V12;
    msg = "Tape Drive Status: missingWasOk";
    hpq_info = PRINTF("Status of tape drive %s is now %d. The tape drive had a status of OK but is no longer present. The drive has been removed.", $V9, $V12);
END

CLASS IM_3043_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3043;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
    12: ATTR(PREFIX, "cpqDaTapeDrvStatus"), VALUE(=,7);

   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3043_7;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    hpq_DaTapeDrvStatus = $V12;
    msg = "Tape Drive Status: missingWasOffline";
    hpq_info = PRINTF("Status of tape drive %s is now %d. The tape drive had a status of OFFLINE but is no longer present. The drive has been removed.", $V9, $V12);
END


############################################################
CLASS IM_3044
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3044;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3044;
    severity = CRITICAL;
    hostname= $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    msg = "Tape Drive Cleaning Required";
    hpq_info = PRINTF("The tape drive %s on %s on controller %d on bus %d needs cleaning.", $V9, $V3, $V5, $V6);
END

##################################################################
CLASS IM_3045
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3045;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaTapeDrvCntlrIndex");
    6: ATTR(=, "cpqDaTapeDrvBusIndex");
    7: ATTR(=, "cpqDaTapeDrvScsiIdIndex");
    8: ATTR(=, "cpqDaTapeDrvLunIndex");
    9: ATTR(=, "cpqDaTapeDrvName");
    10: ATTR(=, "cpqDaTapeDrvFwRev");
    11: ATTR(=, "cpqDaTapeDrvSerialNumber");
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3045;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaTapeDrvCntlrIndex = $V5;
    hpq_DaTapeDrvBusIndex = $V6;
    hpq_DaTapeDrvScsiIdIndex = $V7;
    hpq_DaTapeDrvLunIndex = $V8;
    hpq_DaTapeDrvName = $V9;
    hpq_DaTapeDrvFwRev = $V10;
    hpq_DaTapeDrvSerialNumber = $V11;
    msg = "Tape Drive Cleaning tape needs replacing";
    hpq_info = PRINTF("The cleaning tape on tape drive %s on %s on controller %d on bus %d needs replacing", $V9, $V3, $V5, $V6);
END

############################################################

CLASS IM_3046_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3046;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvIndex");
    7: ATTR(=, "cpqDaPhyDrvLocationString");
    8: ATTR(=, "cpqDaPhyDrvType");
    9: ATTR(=, "cpqDaPhyDrvModel");
   10: ATTR(=, "cpqDaPhyDrvFWRev");
   11: ATTR(=, "cpqDaPhyDrvSerialNum");
   12: ATTR(=, "cpqDaPhyDrvFailureCode");
   13: ATTR(PREFIX, "cpqDaPhyDrvStatus") , VALUE(=,2);
   14: ATTR(=, "cpqDaPhyDrvBusNumber");

  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3046_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvIndex = $V6;
    hpq_DaPhyDrvLocationString= $V7;
    hpq_DaPhyDrvType = $V8;
    hpq_DaPhyDrvModel = $V9;
    hpq_DaPhyDrvFWRev = $V10;
    hpq_DaPhyDrvSerialNum = $V11;
    hpq_DaPhyDrvFailureCode = $V12;
    hpq_DaPhyDrvStatus = $V13;
    hpq_DaPhyDrvBusNumber = $V14;
    sub_origin=$K13;
    hpq_val=$V13;
    msg = "Physical Drive Status: ok.";
    hpq_info = PRINTF ("Physical drive (%d) on drive array with bus number %d at location %s is in normal operation mode.", $V6, $V14, $V7);
END


CLASS IM_3046_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3046;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvIndex");
    7: ATTR(=, "cpqDaPhyDrvLocationString");
    8: ATTR(=, "cpqDaPhyDrvType");
    9: ATTR(=, "cpqDaPhyDrvModel");
    10: ATTR(=, "cpqDaPhyDrvFWRev");
    11: ATTR(=, "cpqDaPhyDrvSerialNum");
    12: ATTR(=, "cpqDaPhyDrvFailureCode");
    13: ATTR(PREFIX, "cpqDaPhyDrvStatus") , VALUE(=,3);
    14: ATTR(=, "cpqDaPhyDrvBusNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3046_3;
    severity = FATAL;
    hostname=$V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvIndex = $V6;
    hpq_DaPhyDrvLocationString= $V7;
    hpq_DaPhyDrvType= $V8;
    hpq_DaPhyDrvModel = $V9;
    hpq_DaPhyDrvFWRev = $V10;
    hpq_DaPhyDrvSerialNum = $V11;
    hpq_DaPhyDrvFailureCode = $V12;
    hpq_DaPhyDrvStatus = $V13;
    hpq_DaPhyDrvBusNumber = $V14;
    sub_origin=$K13;
    hpq_val=$V13;
    msg = "Physical Drive Status: failed.";
    hpq_info = PRINTF ("Physical drive (%d) on drive array with bus number %d at location %s has failed.", $V6, $V14, $V7);
END


CLASS IM_3046_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3046;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaPhyDrvCntlrIndex");
    6: ATTR(=, "cpqDaPhyDrvIndex");
    7: ATTR(=, "cpqDaPhyDrvLocationString");
    8: ATTR(=, "cpqDaPhyDrvType");
    9: ATTR(=, "cpqDaPhyDrvModel");
    10: ATTR(=, "cpqDaPhyDrvFWRev");
    11: ATTR(=, "cpqDaPhyDrvSerialNum");
    12: ATTR(=, "cpqDaPhyDrvFailureCode");
    13: ATTR(PREFIX, "cpqDaPhyDrvStatus") , VALUE(=,4);
    14: ATTR(=, "cpqDaPhyDrvBusNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3046_4;
    severity = CRITICAL;
    hostname=$V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaPhyDrvCntlrIndex = $V5;
    hpq_DaPhyDrvIndex = $V6;
    hpq_DaPhyDrvLocationString = $V7;
    hpq_DaPhyDrvType = $V8;
    hpq_DaPhyDrvModel = $V9;
    hpq_DaPhyDrvFWRev = $V10;
    hpq_DaPhyDrvSerialNum = $V11;
    hpq_DaPhyDrvFailureCode = $V12;
    hpq_DaPhyDrvStatus = $V13;
    hpq_DaPhyDrvBusNumber = $V14;
    sub_origin=$K13;
    hpq_val=$V13;
    msg = "Physical Drive Status: predictiveFailure.";
    hpq_info = PRINTF ("Physical drive (%d) on drive array with bus number %d at location %s has to be replaced.", $V6, $V14, $V7);
END 

#########################################################

CLASS IM_3047_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3047;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,2);
    8: ATTR(=, "cpqDaSpareLocationString");
    9: ATTR(=, "cpqDaSpareBusNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3047_2;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareLocationString = $V8;
    hpq_DaSpareBusNumber = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: invalid";
    hpq_info = PRINTF("A spare drive in a drive array on %s on bus %d at location %s is now invalid.", $V3, $V9, $V8);
END
 
CLASS IM_3047_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3047;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,3);
    8: ATTR(=, "cpqDaSpareLocationString");
    9: ATTR(=, "cpqDaSpareBusNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3047_3;
    severity = FATAL;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareLocationString = $V8;
    hpq_DaSpareBusNumber = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: failed";
    hpq_info = PRINTF("The on-line spare on %s on bus %d at location %s has failed and is no longer available for use.", $V3, $V9, $V8);
END

CLASS IM_3047_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3047;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,4);
    8: ATTR(=, "cpqDaSpareLocationString");
    9: ATTR(=, "cpqDaSpareBusNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3047_4;
    severity = HARMLESS;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareLocationString = $V8;
    hpq_DaSpareBusNumber = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: inactive";
    hpq_info = PRINTF("The on-line spare on %s on bus %d at location %s is configured, but is not currently in use.", $V3, $V9, $V8);
END

CLASS IM_3047_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3047;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,5);
    8: ATTR(=, "cpqDaSpareLocationString");
    9: ATTR(=, "cpqDaSpareBusNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3047_5;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareLocationString = $V8;
    hpq_DaSpareBusNumber = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: building";
    hpq_info = PRINTF("Data is being recovered to the on-line spare on %s on bus %d at location %s due to the failure of a primary drive.", $V3, $V9, $V8);
END

CLASS IM_3047_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 3047;
    3: ATTR(=, "sysName" ) ; 
    4: ATTR(=, "cpqDaCntlrHwLocation");
    5: ATTR(=, "cpqDaSpareCntlrIndex");
    6: ATTR(=, "cpqDaSparePhyDrvIndex");
    7: ATTR(PREFIX, "cpqDaSpareStatus"), VALUE(=,6);
    8: ATTR(=, "cpqDaSpareLocationString");
    9: ATTR(=, "cpqDaSpareBusNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 3047_6;
    severity = WARNING;
    hostname = $V3;
    hpq_DaCntlrHwLocation = $V4;
    hpq_DaSpareCntlrIndex = $V5;
    hpq_DaSparePhyDrvIndex = $V6;
    hpq_DaSpareStatus = $V7;
    hpq_DaSpareLocationString = $V8;
    hpq_DaSpareBusNumber = $V9;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Spare Drive Status: active";
    hpq_info = PRINTF("Automatic Data Recovery is complete. The system is using the on-line spare on %s on bus %d at location %s as a replacement for the failed drive.", $V3, $V9, $V8);
END

#########################################################
#####   Compaq Manegeable IDE Drive
#########################################################
CLASS IM_14001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeIdentIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 14001;
    severity = CRITICAL;
    hostname=$V3;
    hpq_IdeIdentIndex=$V4;
    msg = "Client IDE drive status degraded";
    hpq_info = PRINTF ( "IDE drive ID %d on %s has has become degraded.  Drive should be backed up and replaced." , $V4 , $V3 ) ;
END

#############################################################
CLASS IM_14002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14002;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeIdentIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 14002;
    severity = HARMLESS;
    hostname=$V3;
    hpq_IdeIdentIndex=$V4;
    msg = "Client IDE drive status ok";
    hpq_val=0;
    hpq_info = PRINTF ( "IDE drive ID %d on %s has returned to normal operating condition." , $V4 , $V3 ) ;
END

###########################################################
CLASS IM_14003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14003;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeIdentIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 14003;
    severity = CRITICAL;
    hostname=$V3;
    hpq_IdeIdentIndex = $V4;
    msg = "IDE Drive Ultra ATA Degraded";
    hpq_info = PRINTF ( "IDE drive %s has detected Ultra ATA errors.", $V4);
END

##############################################################
CLASS IM_14004_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14004;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeAtaDiskControllerIndex");
    5: ATTR(=, "cpqIdeAtaDiskIndex");
    6: ATTR(=, "cpqIdeAtaDiskModel");
    7: ATTR(=, "cpqIdeAtaDiskFwRev");
    8: ATTR(=, "cpqIdeAtaDiskSerialNumber");
    9: ATTR(PREFIX, "cpqIdeAtaDiskStatus"), VALUE(=, 2);
    10: ATTR(=, "cpqIdeAtaDiskChannel");
    11: ATTR(=, "cpqIdeAtaDiskNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 14004_2;
    hpq_IdeAtaDiskCtrIndex = $V4;
    hpq_IdeAtaDiskIndex = $V5;
    hpq_IdeAtaDiskModel = $V6;
    hpq_IdeAtaDiskFwRev = $V7;
    hpq_IdeAtaDiskSerialNumber = $V8;
    hpq_IdeAtaDiskStatus = $V9;
    hpq_IdeAtaDiskChannel = $V10;
    hpq_IdeAtaDiskNumber = $V11;
    sub_origin = $K9;
    hpq_val = $V9;
    msg = "Compaq ATA Disk Drive Status: ok";
    hpq_info = PRINTF ("Status is now %d for the ATA disk.", $V9);
END

##############################################################
CLASS IM_14004_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14004;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeAtaDiskControllerIndex");
    5: ATTR(=, "cpqIdeAtaDiskIndex");
    6: ATTR(=, "cpqIdeAtaDiskModel");
    7: ATTR(=, "cpqIdeAtaDiskFwRev");
    8: ATTR(=, "cpqIdeAtaDiskSerialNumber");
    9: ATTR(PREFIX, "cpqIdeAtaDiskStatus"), VALUE(=, 3);
    10: ATTR(=, "cpqIdeAtaDiskChannel");
    11: ATTR(=, "cpqIdeAtaDiskNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 14004_3;
    hpq_IdeAtaDiskCtrIndex = $V4;
    hpq_IdeAtaDiskIndex = $V5;
    hpq_IdeAtaDiskModel = $V6;
    hpq_IdeAtaDiskFwRev = $V7;
    hpq_IdeAtaDiskSerialNumber = $V8;
    hpq_IdeAtaDiskStatus = $V9;
    hpq_IdeAtaDiskChannel = $V10;
    hpq_IdeAtaDiskNumber = $V11;
    sub_origin = $K9;
    hpq_val = $V9;
    msg = "Compaq ATA Disk Drive Status: smartError";
    hpq_info = PRINTF ("Status is now %d for the ATA disk.", $V9);
END

############################################################
CLASS IM_14004_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" );
    2: $SPECIFIC = 14004;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqIdeAtaDiskControllerIndex");
    5: ATTR(=, "cpqIdeAtaDiskIndex");
    6: ATTR(=, "cpqIdeAtaDiskModel");
    7: ATTR(=, "cpqIdeAtaDiskFwRev");
    8: ATTR(=, "cpqIdeAtaDiskSerialNumber");
    9: ATTR(PREFIX, "cpqIdeAtaDiskStatus"), VALUE(=, 4);
    10: ATTR(=, "cpqIdeAtaDiskChannel");
    11: ATTR(=, "cpqIdeAtaDiskNumber");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 14004_4;
    hpq_IdeAtaDiskCtrIndex = $V4;
    hpq_IdeAtaDiskIndex = $V5;
    hpq_IdeAtaDiskModel = $V6;
    hpq_IdeAtaDiskFwRev = $V7;
    hpq_IdeAtaDiskSerialNumber = $V8;
    hpq_IdeAtaDiskStatus = $V9;
    hpq_IdeAtaDiskChannel = $V10;
    hpq_IdeAtaDiskNumber = $V11;
    sub_origin = $K9;
    hpq_val = $V9;
    msg = "Compaq ATA Disk Drive Status: FAILED";
    hpq_info = PRINTF ("Status is now %d for the ATA disk.", $V9);
END

##############################################################
CLASS IM_14005_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeControllerModel");
    5: ATTR(=, "cpqIdeControllerSlot");
    6: ATTR(=, "cpqIdeLogicalDriveControllerIndex");
    7: ATTR(=, "cpqIdeLogicalDriveIndex");
    8: ATTR(PREFIX, "cpqIdeLogicalDriveStatus"), VALUE(=, 2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 14005_2;
    hpq_IdeControllerModel = $V4;
    hpq_IdeControllerSlot = $V5;
    hpq_IdeLogicalDriveCtrIndex = $V6;
    hpq_IdeLogicalDriveIndex = $V7;
    hpq_IdeLogicalDriveStatus = $V8;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "IDE Logical Drive Status: ok";
    hpq_info = PRINTF ("Status is now %d for the IDE logical drive.", $V8);
END

############################
CLASS IM_14005_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeControllerModel");
    5: ATTR(=, "cpqIdeControllerSlot");
    6: ATTR(=, "cpqIdeLogicalDriveControllerIndex");
    7: ATTR(=, "cpqIdeLogicalDriveIndex");
    8: ATTR(PREFIX, "cpqIdeLogicalDriveStatus"), VALUE(=, 3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 14005_3;
    hpq_IdeControllerModel = $V4;
    hpq_IdeControllerSlot = $V5;
    hpq_IdeLogicalDriveCtrIndex = $V6;
    hpq_IdeLogicalDriveIndex = $V7;
    hpq_IdeLogicalDriveStatus = $V8;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "IDE Logical Drive Status: Degraded";
    hpq_info = PRINTF ("Status is now %s for the IDE logical drive.", $V8);
END

############################
CLASS IM_14005_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeControllerModel");
    5: ATTR(=, "cpqIdeControllerSlot");
    6: ATTR(=, "cpqIdeLogicalDriveControllerIndex");
    7: ATTR(=, "cpqIdeLogicalDriveIndex");
    8: ATTR(PREFIX, "cpqIdeLogicalDriveStatus"), VALUE(=, 4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname=$V3;
    hpq_eventID = 14005_4;
    hpq_IdeControllerModel = $V4;
    hpq_IdeControllerSlot = $V5;
    hpq_IdeLogicalDriveCtrIndex = $V6;
    hpq_IdeLogicalDriveIndex = $V7;
    hpq_IdeLogicalDriveStatus = $V8;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "IDE Logical Drive Status: Rebuilding";
    hpq_info = PRINTF ("Status is now %d for the IDE logical drive.", $V8);
END

##########################################################
CLASS IM_14005_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 14005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqIdeControllerModel");
    5: ATTR(=, "cpqIdeControllerSlot");
    6: ATTR(=, "cpqIdeLogicalDriveControllerIndex");
    7: ATTR(=, "cpqIdeLogicalDriveIndex");
    8: ATTR(PREFIX, "cpqIdeLogicalDriveStatus"), VALUE(=, 5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 14005_5;
    hpq_IdeControllerModel = $V4;
    hpq_IdeControllerSlot = $V5;
    hpq_IdeLogicalDriveCtrIndex = $V6;
    hpq_IdeLogicalDriveIndex = $V7;
    hpq_IdeLogicalDriveStatus = $V8;
    sub_origin = $K8;
    hpq_val = $V8;
    msg = "IDE Logical Drive Status: FAILED";
    hpq_info = PRINTF ("Status is now %s for the IDE logical drive.", $V8);
END

#########################################################
#####   Compaq Network Interface Card Information
#########################################################
CLASS IM_18005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 18005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqNicIfPhysAdapterSlot");
    5: ATTR(=, "cpqNicIfPhysAdapterPort");
    6: ATTR(=, "cpqSiServerSystemId");
    7: ATTR(=, "cpqNicIfPhysAdapterStatus");
    8: ATTR(=, "cpqSePciSlotBoardName");
    9: ATTR(=, "cpqNicIfPhysAdapterPartNumber");
    10: ATTR(=, "ipAdEntAddr");
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 18005;
    severity = HARMLESS;
    hostname=$V3;
    hpq_NicIfPhysAdapterSlot = $V4;
    hpq_NicIfPhysAdapterPort = $V5;
    hpq_SiServerSystemId = $V6;
    hpq_NicIfPhysAdapterStatus = $V7;
    hpq_SePciSlotBoardName = $V8;
    hpq_NicIfPhysAdapterPartNumber = $V9;
    hpq_ipAdEntAddr = $V10;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "This trap will be sent any time connectivity is restored to a logical adapter.  This occurs when the physical adapter in a single adapter configuration returns to the OK condition or at least one physical adapter in a logical adapter group returns to the OK condition.";
    hpq_info = PRINTF ( "Connectivity is changed for adapter in slot %d, port %d.", $V4, $V5);
END

############################################################
CLASS IM_18006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 18006;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqNicIfPhysAdapterSlot");
    5: ATTR(=, "cpqNicIfPhysAdapterPort");
    6: ATTR(=, "cpqSiServerSystemId");
    7: ATTR(=, "cpqNicIfPhysAdapterStatus");
    8: ATTR(=, "cpqSePciSlotBoardName");
    9: ATTR(=, "cpqNicIfPhysAdapterPartNumber");
    10: ATTR(=, "ipAdEntAddr");
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 18006;
    severity = FATAL;
    hostname=$V3;
    hpq_NicIfPhysAdapterSlot = $V4;
    hpq_NicIfPhysAdapterPort = $V5;
    hpq_SiServerSystemId = $V6;
    hpq_NicIfPhysAdapterStatus = $V7;
    hpq_SePciSlotBoardName = $V8;
    hpq_NicIfPhysAdapterPartNumber = $V9;
    hpq_ipAdEntAddr = $V10;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "This trap will be sent any time the status of a logical
adapter changes to the Failed condition.  This occurs when the adapter in a single adapter configuration fails, or when the last adapter in a redundant configuration fails.";
    hpq_info = PRINTF ( "Connectivity for adapter in slot %d, port %d is %d.", $V4, $V5, $V7);
END


################################################################
CLASS IM_18007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 18007;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqNicIfPhysAdapterSlot");
    5: ATTR(=, "cpqNicIfPhysAdapterPort");
    6: ATTR(=, "cpqSiServerSystemId");
    7: ATTR(=, "cpqNicIfPhysAdapterStatus");
    8: ATTR(=, "cpqSePciSlotBoardName");
    9: ATTR(=, "cpqNicIfPhysAdapterPartNumber");
    10: ATTR(=, "ipAdEntAddr");
    11: ATTR(=, "cpqNicIfLogMapAdapterOKCount");
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 18007;
    severity = HARMLESS;
    hostname=$V3;
    hpq_NicIfPhysAdapterSlot = $V4;
    hpq_NicIfPhysAdapterPort = $V5;
    hpq_SiServerSystemId = $V6;
    hpq_NicIfPhysAdapterStatus = $V7;
    hpq_SePciSlotBoardName = $V8;
    hpq_NicIfPhysAdapterPartNumber = $V9;
    hpq_ipAdEntAddr = $V10;
    hpq_NicIfLogMapAdapterOKCount = $V11;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "A status change occurs for physical adapter in a connected logical adapter group";
    hpq_info = PRINTF ( "Redundancy status change for adapter in slot %d, port %d.", $V4, $V5);
END

##################################################################
CLASS IM_18008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 18008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqNicIfPhysAdapterSlot");
    5: ATTR(=, "cpqNicIfPhysAdapterPort");
    6: ATTR(=, "cpqSiServerSystemId");
    7: ATTR(=, "cpqNicIfPhysAdapterStatus");
    8: ATTR(=, "cpqSePciSlotBoardName");
    9: ATTR(=, "cpqNicIfPhysAdapterPartNumber");
    10: ATTR(=, "ipAdEntAddr");
    11: ATTR(=, "cpqNicIfLogMapAdapterOKCount");
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 18008;
    severity = CRITICAL;
    hostname=$V3;
    hpq_NicIfPhysAdapterSlot = $V4;
    hpq_NicIfPhysAdapterPort = $V5;
    hpq_SiServerSystemId = $V6;
    hpq_NicIfPhysAdapterStatus = $V7;
    hpq_SePciSlotBoardName = $V8;
    hpq_NicIfPhysAdapterPartNumber = $V9;
    hpq_ipAdEntAddr = $V10;
    hpq_NicIfLogMapAdapterOKCount = $V11;
    sub_origin = $K7;
    hpq_val = $V7;
    msg = "Condition in a physical adapter in a logical adapter group changes, but at least one physical adapter remains in the OK condition.";
    hpq_info = PRINTF ( "Redundancy status changes for adapter in slot %d, port %d.", $V4, $V5);
END

##################################################################
CLASS IM_18009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 18009;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSiServerSystemId");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 18009;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SiServerSystemId = $V4;
    msg = "NIC Virus-like Activity Detected.";
    hpq_info = PRINTF ( "NIC Virus-like Activity Detected on %s.", $V3);
END

##################################################################
CLASS IM_18010
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 18010;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSiServerSystemId");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 18010;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SiServerSystemId = $V4;
    msg = "NIC Virus-like Activity no longer detected.";
    hpq_info = PRINTF ( "NIC Virus-like Activity no longer detected on %s.", $V3);
END
#########################################################
#####   Compaq Rack Information 
#########################################################
CLASS IM_22001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackSerialNum");
    7: ATTR(=, "cpqRackTrapSequenceNum");
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22001;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackSerialNum = $V6;
    hpq_RackTrapSequenceNum = $V7;
    msg = "Rack name has changed.";
    hpq_info = PRINTF ( "The rack name has changed to %s.", $V4);
END

#########################################################
CLASS IM_22002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22002;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureModel");
    8: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    9: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22002;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureModel = $V7;
    hpq_RackCommonEnclosureSerialNum = $V8;
    hpq_RackCommonEnclosureSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure name has changed.";
    hpq_info = PRINTF ( "The enclosure name has changed  to %s in rack %s.", $V6, $V4);
END

#########################################################
CLASS IM_22003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22003;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureModel");
    8: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    9: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22003;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureModel = $V7;
    hpq_RackCommonEnclosureSerialNum = $V8;
    hpq_RackCommonEnclosureSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure has been removed.";
    hpq_info = PRINTF ( "The enclosure %s has been removed from rack %s.", $V6, $V4);
END

##########################################################
CLASS IM_22004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22004;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureModel");
    8: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    9: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22004;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureModel = $V7;
    hpq_RackCommonEnclosureSerialNum = $V8;
    hpq_RackCommonEnclosureSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure has been inserted.";
    hpq_info = PRINTF ( "The enclosure %s has been inserted into rack %s.", $V6, $V4);
END

############################################################
CLASS IM_22005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureTempLocation");
    9: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22005;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureTempLocation = $V8;
    hpq_RackCommonEnclosureSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure temperature status has been set to failed.";
    hpq_info = PRINTF ( "The enclosure %s temperature sensor in rack %s has been set to failed.", $V6, $V4);
END

#############################################################
CLASS IM_22006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22006;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureTempLocation");
    9: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22006;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureTempLocation = $V8;
    hpq_RackCommonEnclosureSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure temperature status has been set to degraded.";
    hpq_info = PRINTF ( "The enclosure %s temperature sensor in rack %s has been set to degraded.", $V6, $V4);
END

##############################################################
CLASS IM_22007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22007;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureTempLocation");
    9: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22007;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureTempLocation = $V8;
    hpq_RackCommonEnclosureSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure temperature status has been set to ok.";
    hpq_info = PRINTF ( "The enclosure %s temperature sensor in rack %s has been set to ok.", $V6, $V4);
END

############################################################
CLASS IM_22008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureFanLocation");
    9: ATTR(=, "cpqRackCommonEnclosureFanSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22008;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureFanLocation = $V8;
    hpq_RackCommonEnclosureFanSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure fan status has been set to failed.";
    hpq_info = PRINTF ( "The enclosure %s fan in rack %s has been set to failed.", $V6, $V4);
END

##############################################################
CLASS IM_22009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22009;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureFanLocation");
    9: ATTR(=, "cpqRackCommonEnclosureFanSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22009;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureFanLocation = $V8;
    hpq_RackCommonEnclosureFanSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure fan has been set to degraded.";
    hpq_info = PRINTF ( "The enclosure %s fan in rack %s has been set to degraded.", $V6, $V4);
END

###############################################################
CLASS IM_22010
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22010;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureFanLocation");
    9: ATTR(=, "cpqRackCommonEnclosureFanSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22010;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureFanLocation = $V8;
    hpq_RackCommonEnclosureFanSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure fan has been set to ok.";
    hpq_info = PRINTF ( "The enclosure %s fan in rack %s has been set to ok.", $V6, $V4);
END

##############################################################
CLASS IM_22011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22011;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureFanLocation");
    9: ATTR(=, "cpqRackCommonEnclosureFanSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22011;
    severity = WARNING;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureFanLocation = $V8;
    hpq_RackCommonEnclosureFanSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure fan has been removed.";
    hpq_info = PRINTF ( "The enclosure %s fan in rack %s has been removed.", $V6, $V4);
END

###########################################################
CLASS IM_22012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22012;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureFanLocation");
    9: ATTR(=, "cpqRackCommonEnclosureFanSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22012;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureFanLocation = $V8;
    hpq_RackCommonEnclosureFanSparePartNumber = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The enclosure fan has been inserted.";
    hpq_info = PRINTF ( "The enclosure %s fan in rack %s has been inserted.", $V6, $V4);
END

#####################################
CLASS IM_22013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22013;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplySerialNum");
    8: ATTR(=, "cpqRackPowerSupplyPosition");
    9: ATTR(=, "cpqRackPowerSupplyFWRev");
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22013;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplySerialNum = $V7;
    hpq_RackPowerSupplyPosition = $V8;
    hpq_RackPowerSupplyFWRev = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The power supply status has been set to failed.";
    hpq_info = PRINTF ( "The power supply %d in enclosure %s in rack %s has been set to failed.", $V8, $V6, $V4);
END

#####################################
CLASS IM_22014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22014;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplySerialNum");
    8: ATTR(=, "cpqRackPowerSupplyPosition");
    9: ATTR(=, "cpqRackPowerSupplyFWRev");
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22014;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplySerialNum = $V7;
    hpq_RackPowerSupplyPosition = $V8;
    hpq_RackPowerSupplyFWRev = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The power supply status has been set to degraded.";
    hpq_info = PRINTF ( "The power supply %d in enclosure %s in rack %s has been set to degraded.", $V8, $V6, $V4);
END

#####################################
CLASS IM_22015
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22015;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplySerialNum");
    8: ATTR(=, "cpqRackPowerSupplyPosition");
    9: ATTR(=, "cpqRackPowerSupplyFWRev");
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22015;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplySerialNum = $V7;
    hpq_RackPowerSupplyPosition = $V8;
    hpq_RackPowerSupplyFWRev = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The power supply status has been set to ok.";
    hpq_info = PRINTF ( "The power supply %d in enclosure %s in rack %s has been set to ok.", $V8, $V6, $V4);
END

#############################################################
CLASS IM_22016
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22016;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplySerialNum");
    8: ATTR(=, "cpqRackPowerSupplyPosition");
    9: ATTR(=, "cpqRackPowerSupplyFWRev");
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22016;
    severity = WARNING;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplySerialNum = $V7;
    hpq_RackPowerSupplyPosition = $V8;
    hpq_RackPowerSupplyFWRev = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The power supply has been removed.";
    hpq_info = PRINTF ( "The power supply %d in enclosure %s in rack %s has been removed.", $V8, $V6, $V4);
END

#####################################
CLASS IM_22017
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22017;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplySerialNum");
    8: ATTR(=, "cpqRackPowerSupplyPosition");
    9: ATTR(=, "cpqRackPowerSupplyFWRev");
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22017;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplySerialNum = $V7;
    hpq_RackPowerSupplyPosition = $V8;
    hpq_RackPowerSupplyFWRev = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The power supply has been inserted.";
    hpq_info = PRINTF ( "The power supply %d in enclosure %s in rack %s has been inserted.", $V8, $V6, $V4);
END

#####################################
CLASS IM_22018
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22018;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureTrapSequenceNum = $V8;
    msg = "The rack power subsystem is no longer in a redundant state.";
    hpq_info = PRINTF ( "The power subsystem in enclosure %s in rack %s is no longer redundant.", $V6, $V4);
END

#####################################
CLASS IM_22019_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplyPosition");
    8: ATTR(=, "cpqRackPowerSupplyFWRev");
    9: ATTR(PREFIX, "cpqRackPowerSupplyInputLineStatus"), VALUE(=,1);
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22019_1;
    severity = HARMLESS;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplyPosition = $V7;
    hpq_RackPowerSupplyFWRev = $V8;
    hpq_RackPowerSupplyInputLineStatus = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The status of rack power supply input line voltage changes.";
    hpq_info = PRINTF ( "The rack power supply detected an input line voltage changes in power supply %d, enclosure %s, rack %s.", $V7, $V6, $V4);
END

CLASS IM_22019_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplyPosition");
    8: ATTR(=, "cpqRackPowerSupplyFWRev");
    9: ATTR(PREFIX, "cpqRackPowerSupplyInputLineStatus"), VALUE(=,2);
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22019_2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplyPosition = $V7;
    hpq_RackPowerSupplyFWRev = $V8;
    hpq_RackPowerSupplyInputLineStatus = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The status of rack power supply input line voltage changes.";
    hpq_info = PRINTF ( "The rack power supply detected an input line voltage changes in power supply %d, enclosure %s, rack %s.", $V7, $V6, $V4);
END

CLASS IM_22019_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplyPosition");
    8: ATTR(=, "cpqRackPowerSupplyFWRev");
    9: ATTR(PREFIX, "cpqRackPowerSupplyInputLineStatus"), VALUE(=,3);
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22019_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplyPosition = $V7;
    hpq_RackPowerSupplyFWRev = $V8;
    hpq_RackPowerSupplyInputLineStatus = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The status of rack power supply input line voltage changes.";
    hpq_info = PRINTF ( "The rack power supply detected an input line voltage changes in power supply %d, enclosure %s, rack %s.", $V7, $V6, $V4);
END

CLASS IM_22019_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplyPosition");
    8: ATTR(=, "cpqRackPowerSupplyFWRev");
    9: ATTR(PREFIX, "cpqRackPowerSupplyInputLineStatus"), VALUE(=,4);
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22019_4;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplyPosition = $V7;
    hpq_RackPowerSupplyFWRev = $V8;
    hpq_RackPowerSupplyInputLineStatus = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The status of rack power supply input line voltage changes.";
    hpq_info = PRINTF ( "The rack power supply detected an input line voltage changes in power supply %d, enclosure %s, rack %s.", $V7, $V6, $V4);
END

CLASS IM_22019_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplyPosition");
    8: ATTR(=, "cpqRackPowerSupplyFWRev");
    9: ATTR(PREFIX, "cpqRackPowerSupplyInputLineStatus"), VALUE(=,5);
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22019_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplyPosition = $V7;
    hpq_RackPowerSupplyFWRev = $V8;
    hpq_RackPowerSupplyInputLineStatus = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The status of rack power supply input line voltage changes.";
    hpq_info = PRINTF ( "The rack power supply detected an input line voltage changes in power supply %d, enclosure %s, rack %s.", $V7, $V6, $V4);
END

CLASS IM_22019_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerSupplyEnclosureName");
    7: ATTR(=, "cpqRackPowerSupplyPosition");
    8: ATTR(=, "cpqRackPowerSupplyFWRev");
    9: ATTR(PREFIX, "cpqRackPowerSupplyInputLineStatus"), VALUE(=,6);
    10: ATTR(=, "cpqRackPowerSupplySparePartNumber");
    11: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    12: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22019_6;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerSupplyEnclosureName = $V6;
    hpq_RackPowerSupplyPosition = $V7;
    hpq_RackPowerSupplyFWRev = $V8;
    hpq_RackPowerSupplyInputLineStatus = $V9;
    hpq_RackPowerSupplySparePartNumber = $V10;
    hpq_RackCommonEnclosureSerialNum = $V11;
    hpq_RackCommonEnclosureTrapSequenceNum = $V12;
    msg = "The status of rack power supply input line voltage changes.";
    hpq_info = PRINTF ( "The rack power supply detected an input line voltage changes in power supply %d, enclosure %s, rack %s.", $V7, $V6, $V4);
END

###############################################################
CLASS IM_22020
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackPowerEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    8: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    9: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22020;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackPowerEnclosureName = $V6;
    hpq_RackCommonEnclosureSparePartNumber = $V7;
    hpq_RackCommonEnclosureSerialNum = $V8;
    hpq_RackCommonEnclosureTrapSequenceNum = $V9;
    msg = "The rack power subsystem overload condition.";
    hpq_info = PRINTF ( "The power subsystem in enclosure %s in rack %s is in an overload condition.", $V6, $V4);
END

#############################################################
CLASS IM_22021
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladePosition");
    8: ATTR(=, "cpqRackServerBladeSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22021;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladePosition = $V7;
    hpq_RackServerBladeSparePartNumber = $V8;
    hpq_RackCommonEnclosureSerialNum = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "Server shutdown due to power shedding.";
    hpq_info = PRINTF ( "The server shutdown due to lack of power blade %s, in enclosure %s, in rack %s.", $V7, $V6, $V4);
END

##########################################################
CLASS IM_22022
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladePosition");
    8: ATTR(=, "cpqRackServerBladeSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22022;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladePosition = $V7;
    hpq_RackServerBladeSparePartNumber = $V8;
    hpq_RackCommonEnclosureSerialNum = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "There is not enough power to power on the server blade and maintain redundancy for the other blades in the enclosure.";
    hpq_info = PRINTF ( "Server power on prevented to preserve redundancy in blade %s, in enclosure %s, in rack %s.", $V7, $V6, $V4);
END

###########################################################
CLASS IM_22023
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladePosition");
    8: ATTR(=, "cpqRackServerBladeSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22023;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladePosition = $V7;
    hpq_RackServerBladeSparePartNumber = $V8;
    hpq_RackCommonEnclosureSerialNum = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "There is not enough power to power on the server blade.";
    hpq_info = PRINTF ( "Inadequate power to power on blade %s, in enclosure %s, in rack %s.", $V7, $V6, $V4);
END

#####################################
CLASS IM_22024
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 22024;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladePosition");
    8: ATTR(=, "cpqRackServerBladeSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22024;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladePosition = $V7;
    hpq_RackServerBladeSparePartNumber = $V8;
    hpq_RackCommonEnclosureSerialNum = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "There is not enough power to power on the server blade. The server enclosure micro-controller was not found";
    hpq_info = PRINTF ( "Inadequate power to power on blade %s, in enclosure %s, in rack %s.", $V7, $V6, $V4);
END

#############################################################
CLASS IM_22025
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232") ;
    2: $SPECIFIC = 22025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladePosition");
    8: ATTR(=, "cpqRackServerBladeSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22025;
    severity = FATAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladePosition = $V7;
    hpq_RackServerBladeSparePartNumber = $V8;
    hpq_RackCommonEnclosureSerialNum = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "There is not enough power to power on the server blade. The power enclosure micro-controller was not found";
    hpq_info = PRINTF ( "Inadequate power to power on blade %s, in enclosure %s, in rack %s.", $V7, $V6, $V4);
END

##############################################################
CLASS IM_22026
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232") ;
    2: $SPECIFIC = 22026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladePosition");
    8: ATTR(=, "cpqRackServerBladeSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22026;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladePosition = $V7;
    hpq_RackServerBladeSparePartNumber = $V8;
    hpq_RackCommonEnclosureSerialNum = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The server blade was powered on by a manual override.";
    hpq_info = PRINTF ( "Server power on via manual override on blade %s, in enclosure %s, in rack %s.", $V7, $V6, $V4);
END

###########################################################
CLASS IM_22027
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232") ;
    2: $SPECIFIC = 22027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureFuseLocation");
    8: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    10: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22027;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureFuseLocation = $V7;
    hpq_RackCommonEnclosureSparePartNumber = $V8;
    hpq_RackCommonEnclosureSerialNum = $V9;
    hpq_RackCommonEnclosureTrapSequenceNum = $V10;
    msg = "The fuse has been tripped.";
    hpq_info = PRINTF ( "Fuse open fuse %s, in enclosure %s, in rack %s.", $V7, $V6, $V4);
END

##############################################################
CLASS IM_22028
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232") ;
    2: $SPECIFIC = 22028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladeName");
    8: ATTR(=, "cpqRackServerBladePosition");
    9: ATTR(=, "cpqRackServerBladeSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    11: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22028;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladeName = $V7;
    hpq_RackServerBladePosition = $V8;
    hpq_RackServerBladeSparePartNumber = $V9;
    hpq_RackCommonEnclosureSerialNum = $V10;
    hpq_RackCommonEnclosureTrapSequenceNum = $V11;
    msg = "The server blade has been removed from the enclosure.";
    hpq_info = PRINTF ( "Server blade %s removed from position %s, in enclosure %s, in rack %s.", $V7, $V8, $V6, $V4);
END

#####################################
CLASS IM_22029
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232") ;
    2: $SPECIFIC = 22029;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackServerBladeEnclosureName");
    7: ATTR(=, "cpqRackServerBladeName");
    8: ATTR(=, "cpqRackServerBladePosition");
    9: ATTR(=, "cpqRackServerBladeSparePartNumber");
    10: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    11: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22029;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackServerBladeEnclosureName = $V6;
    hpq_RackServerBladeName = $V7;
    hpq_RackServerBladePosition = $V8;
    hpq_RackServerBladeSparePartNumber = $V9;
    hpq_RackCommonEnclosureSerialNum = $V10;
    hpq_RackCommonEnclosureTrapSequenceNum = $V11;
    msg = "The server blade has been inserted into the enclosure.";
    hpq_info = PRINTF ( "Server blade %s inserted into position %s, in enclosure %s, in rack %s.", $V7, $V8, $V6, $V4);
END

##############################################################
CLASS IM_22030
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22030;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22030;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureSparePartNumber = $V8;
    hpq_RackCommonEnclosureTrapSequenceNum = $V9;
    msg = "The power subsystem is out of balance for this power enclosure.";
    hpq_info = PRINTF ( "Power subsystem not load balanced in enclosure %s, in rack %s.", $V6, $V4);
END

##############################################################
CLASS IM_22031
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22031;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22031;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureSparePartNumber = $V8;
    hpq_RackCommonEnclosureTrapSequenceNum = $V9;
    msg = "Power subsystem AC facility input power exceeded.";
    hpq_info = PRINTF ( "Power subsystem DC power problem in enclosure %s, in rack %s.", $V6, $V4);
END

###############################################################
CLASS IM_22032
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22032;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22032;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureSparePartNumber = $V8;
    hpq_RackCommonEnclosureTrapSequenceNum = $V9;
    msg = "Power subsystem AC facility input power exceeded.";
    hpq_info = PRINTF ( "Power subsystem AC facility input power exceeded in enclosure %s, in rack %s.", $V6, $V4);
END

#############################################################
CLASS IM_22033
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22033;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    7: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22033;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureSerialNum = $V6;
    hpq_RackCommonEnclosureTrapSequenceNum = $V7;
    msg = "There is an unknown power consumer drawing power.";
    hpq_info = PRINTF ( "Unknown power consumption in rack %s.", $V4);
END

##############################################################
CLASS IM_22034
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22034;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22034;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureSparePartNumber = $V8;
    hpq_RackCommonEnclosureTrapSequenceNum = $V9;
    msg = "The power subsystem load balancing wire missing.";
    hpq_info = PRINTF ( "Power subsystem load balancing wire missing for enclosure %s, in rack %s.", $V6, $V4);
END

############################################################
CLASS IM_22035
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22035;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22035;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureTrapSequenceNum = $V8;
    msg = "The maximum number of power enclosures has been exceeded";
    hpq_info = PRINTF ( "Power subsystem has too may power enclosures %s, in rack %s.", $V6, $V4);
END

#####################################
CLASS IM_22036
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 22036;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqRackName");
    5: ATTR(=, "cpqRackUid");
    6: ATTR(=, "cpqRackCommonEnclosureName");
    7: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    8: ATTR(=, "cpqRackCommonEnclosureSparePartNumber");
    9: ATTR(=, "cpqRackCommonEnclosureTrapSequenceNum");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 22036;
    severity = CRITICAL;
    hostname=$V3;
    hpq_RackName = $V4;
    hpq_RackUid = $V5;
    hpq_RackCommonEnclosureName = $V6;
    hpq_RackCommonEnclosureSerialNum = $V7;
    hpq_RackCommonEnclosureSparePartNumber = $V8;
    hpq_RackCommonEnclosureTrapSequenceNum = $V9;
    msg = "The power subsystem has been improperly configured.";
    hpq_info = PRINTF ( "Power subsystem has been improperly configured in enclosure %s, in rack %s.", $V6, $V4);
END

#########################################################
#####   Compaq Recovery Server
#########################################################
CLASS IM_13001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 13001;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 13001;
    severity = FATAL;
    hostname=$V3;
    msg = "Recovery server partner failure";
    hpq_info = PRINTF ( "A Recovery server partner has failed. %s has taken over operations from the partner." , $V3 ) ;
END

###########################################################
CLASS IM_13002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 13002;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 13002;
    severity = FATAL;
    hostname=$V3;
    msg = "Recovery server serial interconnect failure";
    hpq_info = PRINTF ( "The Recovery server agent on %s has detected that the local serial interconnect is not connected or has failed. The primary server is being shutdown in anticipation of the startup of the standby server." , $V3 ) ;
END

#############################################################
CLASS IM_13003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 13003;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hpq_eventID = 13003;
    hostname=$V3;
    msg = "Recovery server standby server failure";
    hpq_val=0;
    hpq_info = PRINTF ( "The Recovery server agent on %s reports that the standby server has failed." , $V3 ) ;
END

##############################################################
CLASS IM_13004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 13004;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 13004;
    severity = CRITICAL;
    hostname=$V3;
    msg = "On-line recovery server serial interconnect failure";
    hpq_val=0;
    hpq_info = PRINTF ( "The on-line Recovery server agent on %s reports the local serial interconnect cable has been disconnected or failed but the standby server is still reachable over the network." , $V3 ) ;
END

###############################################################
CLASS IM_13005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 13005;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 13005;
    severity = FATAL;
    hostname=$V3;
    msg = "On-line recovery server switchover failure";
    hpq_val=0;
    hpq_info = PRINTF ( "A Recovery server switchover to %s has failed. It was not possible to mount the disks of the failed server." , $V3 ) ;
END

#########################################################
#####   Compaq SCSI Devices
#########################################################
CLASS IM_5005_2         
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5005;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiCntlrStatus" ) , VALUE(=,2) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5005_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_ScsiCntlrStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "SCSI controller status: ok";
    hpq_info = PRINTF ( "A SCSI controller has been replaced on %s. ControllerIndex.Bus: %d.", $V3, $K4);
END

CLASS IM_5005_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5005;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiCntlrStatus" ) , VALUE(=,3) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5005_2;
    severity = FATAL;
    hostname=$V3;
    hpq_ScsiCntlrStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "SCSI controller status: failed";
    hpq_info = PRINTF ( "A SCSI controller failed on %s. ControllerIndex.Bus: %d.", $V3, $K4);
END

#################################################################
#############################################################
CLASS IM_5008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCondition" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5008;
    severity = CRITICAL;
    hostname=$V3; 
    hpq_TapePhyDrvCondition = $V4;
    msg = "Tape Drive Cleaning Required";
    hpq_info = PRINTF ( "Status is now %d.", $V4);
END

##############################################################
CLASS IM_5009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5009;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCondition" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5009;
    severity = CRITICAL;
    hostname=$V3;
    hpq_TapePhyDrvCondition = $V4;
    msg = "Tape Drive Cleaning Tape Needs Replacing";
    hpq_info = PRINTF ( "Status is now %s.", $V4);
END

###############################################################
################################################################
CLASS IM_5013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5013;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapeLibrarySerialNumber" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5013;
    severity = CRITICAL;
    hostname=$V3;
    hpq_number = $V4;
    msg = "Tape Library Door Opened";
    hpq_info = PRINTF ( "Tape library %s door opened", $V4);
END

################################################################
CLASS IM_5014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5014;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapeLibrarySerialNumber" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5014;
    severity = HARMLESS;
    hostname=$V3;
    hpq_number = $V4;
    msg = "Tape Library Door Closed";
    hpq_info = PRINTF ( "Tape library %s door closed", $V4);
END

#################################################################
CLASS IM_5015_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5015;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCdLibraryCntlrIndex");
    5: ATTR(=, "cpqCdLibraryBusIndex");
    6: ATTR(=, "cpqCdLibraryScsiIdIndex");
    7: ATTR(PREFIX, "cpqCdLibraryStatus") , VALUE(=,2);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5015_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CdLibraryCntlrIndex = $V4;
    hpq_CdLibraryBusIndex = $V5;
    hpq_CdLibraryStatus = $V7;
    hpq_CdLibraryScsiIdIndex = $V6;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Compaq Library Status: ok";
    hpq_info = PRINTF ("The CD library fault light on %s is in an ok state.", $V3);
END

CLASS IM_5015_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5015;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCdLibraryCntlrIndex");
    5: ATTR(=, "cpqCdLibraryBusIndex");
    6: ATTR(=, "cpqCdLibraryScsiIdIndex");
    7: ATTR(PREFIX, "cpqCdLibraryStatus") , VALUE(=,3);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5015_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_CdLibraryCntlrIndex = $V4;
    hpq_CdLibraryBusIndex = $V5;
    hpq_CdLibraryScsiIdIndex = $V6;
    hpq_CdLibraryStatus = $V7;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Compaq Library Status: failed";
    hpq_info = PRINTF ("The CD library fault light on %s is in a failed state.", $V3);
END

CLASS IM_5015_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5015;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqCdLibraryCntlrIndex");
    5: ATTR(=, "cpqCdLibraryBusIndex");
    6: ATTR(=, "cpqCdLibraryScsiIdIndex");
    7: ATTR(PREFIX, "cpqCdLibraryStatus") , VALUE(=,4);
   MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5015_4;
    severity = HARMLESS;
    hostname=$V3;
    hpq_CdLibraryCntlrIndex = $V4;
    hpq_CdLibraryBusIndex = $V5;
    hpq_CdLibraryScsiIdIndex = $V6;
    hpq_CdLibraryStatus = $V7;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Compaq Library Status: offline";
    hpq_info = PRINTF ("The CD library on %s is not communicating with the Insight Agent.  Check the CD library power and cables.", $V3);
END

#################################################################
##############################################################
#########################################################
CLASS IM_5018_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqTapeLibraryBusIndex");
    6: ATTR(=, "cpqTapeLibraryScsiIdIndex");
    7: ATTR(=, "cpqTapeLibraryLunIndex");
    8: ATTR(=, "cpqTapeLibraryName");
    9: ATTR(=, "cpqTapeLibraryFwRev");
    10: ATTR(=, "cpqTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqTapeLibraryState") , VALUE(=,2);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5018_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_TapeLibraryCntlrIndex = $V4;
    hpq_TapeLibraryBusIndex = $V5;
    hpq_TapeLibraryScsiIdIndex = $V6;
    hpq_TapeLibraryLunIndex = $V7;
    hpq_TapeLibraryName = $V8;
    hpq_TapeLibraryFwRev = $V9;
    hpq_TapeLibrarySerialNumber = $V10;
    hpq_TapeLibraryState = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Library Status Change to ok.";
    hpq_info = PRINTF ("Status is now %d the Tape Library is in normal operation mode.", $V11);
END

CLASS IM_5018_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqTapeLibraryBusIndex");
    6: ATTR(=, "cpqTapeLibraryScsiIdIndex");
    7: ATTR(=, "cpqTapeLibraryLunIndex");
    8: ATTR(=, "cpqTapeLibraryName");
    9: ATTR(=, "cpqTapeLibraryFwRev");
    10: ATTR(=, "cpqTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqTapeLibraryState") , VALUE(=,3);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5018_3;
    severity = WARNING;
    hostname=$V3;
    hpq_TapeLibraryCntlrIndex = $V4;
    hpq_TapeLibraryBusIndex = $V5;
    hpq_TapeLibraryScsiIdIndex = $V6;
    hpq_TapeLibraryLunIndex = $V7;
    hpq_TapeLibraryName = $V8;
    hpq_TapeLibraryFwRev = $V9;
    hpq_TapeLibrarySerialNumber = $V10;
    hpq_TapeLibraryState = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Library Status Change to degraded.";
    hpq_info = PRINTF ("Status is now %d indicates that the library has degraded in some manner.", $V11);
END

CLASS IM_5018_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqTapeLibraryBusIndex");
    6: ATTR(=, "cpqTapeLibraryScsiIdIndex");
    7: ATTR(=, "cpqTapeLibraryLunIndex");
    8: ATTR(=, "cpqTapeLibraryName");
    9: ATTR(=, "cpqTapeLibraryFwRev");
    10: ATTR(=, "cpqTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqTapeLibraryState") , VALUE(=,4);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5018_4;
    severity = FATAL;
    hostname=$V3;
    hpq_TapeLibraryCntlrIndex = $V4;
    hpq_TapeLibraryBusIndex = $V5;
    hpq_TapeLibraryScsiIdIndex = $V6;
    hpq_TapeLibraryLunIndex = $V7;
    hpq_TapeLibraryName = $V8;
    hpq_TapeLibraryFwRev = $V9;
    hpq_TapeLibrarySerialNumber = $V10;
    hpq_TapeLibraryState = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Library Status Change to failed.";
    hpq_info = PRINTF ("Status is now %d Indicates that the library has failed and can no longer return data.", $V11);
END

CLASS IM_5018_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapeLibraryCntlrIndex");
    5: ATTR(=, "cpqTapeLibraryBusIndex");
    6: ATTR(=, "cpqTapeLibraryScsiIdIndex");
    7: ATTR(=, "cpqTapeLibraryLunIndex");
    8: ATTR(=, "cpqTapeLibraryName");
    9: ATTR(=, "cpqTapeLibraryFwRev");
    10: ATTR(=, "cpqTapeLibrarySerialNumber");
    11: ATTR(PREFIX, "cpqTapeLibraryState") , VALUE(=,5);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5018_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_TapeLibraryCntlrIndex = $V4;
    hpq_TapeLibraryBusIndex = $V5;
    hpq_TapeLibraryScsiIdIndex = $V6;
    hpq_TapeLibraryLunIndex = $V7;
    hpq_TapeLibraryName = $V8;
    hpq_TapeLibraryFwRev = $V9;
    hpq_TapeLibrarySerialNumber = $V10;
    hpq_TapeLibraryState = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Library Status Change to offline.";
    hpq_info = PRINTF ("Status is now %d indicates that the Insight Agents can no longer communicate with the library.", $V11);
END

##############################################################
CLASS IM_5019_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCntlrIndex");
    5: ATTR(=, "cpqTapePhyDrvBusIndex");
    6: ATTR(=, "cpqTapePhyDrvScsiIdIndex");
    7: ATTR(=, "cpqTapePhyDrvLunIndex");
    8: ATTR(=, "cpqTapePhyDrvName");
    9: ATTR(=, "cpqTapePhyDrvFwRev");
    10: ATTR(=, "cpqTapePhyDrvSerialNumber");
    11: ATTR(PREFIX, "cpqTapePhyDrvStatus") , VALUE(=,2);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5019_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_TapePhyDrvCntlrIndex = $V4;
    hpq_TapePhyDrvBusIndex = $V5;
    hpq_TapePhyDrvScsiIdIndex = $V6;
    hpq_TapePhyDrvLunIndex = $V7;
    hpq_TapePhyDrvName = $V8;
    hpq_TapePhyDrvFwRev = $V9;
    hpq_TapePhyDrvSerialNumber = $V10;
    hpq_TapePhyDrvStatus = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Drive Status Change to ok.";
    hpq_info = PRINTF ("Status is now %d the tape physical drive is in normal operation mode.", $V11);
END

CLASS IM_5019_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCntlrIndex");
    5: ATTR(=, "cpqTapePhyDrvBusIndex");
    6: ATTR(=, "cpqTapePhyDrvScsiIdIndex");
    7: ATTR(=, "cpqTapePhyDrvLunIndex");
    8: ATTR(=, "cpqTapePhyDrvName");
    9: ATTR(=, "cpqTapePhyDrvFwRev");
    10: ATTR(=, "cpqTapePhyDrvSerialNumber");
    11: ATTR(PREFIX, "cpqTapePhyDrvStatus") , VALUE(=,4);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5019_4;
    severity = FATAL;
    hostname=$V3;
    hpq_TapePhyDrvCntlrIndex = $V4;
    hpq_TapePhyDrvBusIndex = $V5;
    hpq_TapePhyDrvScsiIdIndex = $V6;
    hpq_TapePhyDrvLunIndex = $V7;
    hpq_TapePhyDrvName = $V8;
    hpq_TapePhyDrvFwRev = $V9;
    hpq_TapePhyDrvSerialNumber = $V10;
    hpq_TapePhyDrvStatus = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Drive Status Change to failed.";
    hpq_info = PRINTF ("Status is now %d the tape physical drive has failed and can no longer return data.", $V11);
END

CLASS IM_5019_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCntlrIndex");
    5: ATTR(=, "cpqTapePhyDrvBusIndex");
    6: ATTR(=, "cpqTapePhyDrvScsiIdIndex");
    7: ATTR(=, "cpqTapePhyDrvLunIndex");
    8: ATTR(=, "cpqTapePhyDrvName");
    9: ATTR(=, "cpqTapePhyDrvFwRev");
    10: ATTR(=, "cpqTapePhyDrvSerialNumber");
    11: ATTR(PREFIX, "cpqTapePhyDrvStatus") , VALUE(=,5);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5019_5;
    severity = WARNING;
    hostname=$V3;
    hpq_TapePhyDrvCntlrIndex = $V4;
    hpq_TapePhyDrvBusIndex = $V5;
    hpq_TapePhyDrvScsiIdIndex = $V6;
    hpq_TapePhyDrvLunIndex = $V7;
    hpq_TapePhyDrvName = $V8;
    hpq_TapePhyDrvFwRev = $V9;
    hpq_TapePhyDrvSerialNumber = $V10;
    hpq_TapePhyDrvStatus = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Drive Status Change to offline.";
    hpq_info = PRINTF ("Status is now %d the tape physical drive is offline and can no longer return data.", $V11);
END

CLASS IM_5019_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCntlrIndex");
    5: ATTR(=, "cpqTapePhyDrvBusIndex");
    6: ATTR(=, "cpqTapePhyDrvScsiIdIndex");
    7: ATTR(=, "cpqTapePhyDrvLunIndex");
    8: ATTR(=, "cpqTapePhyDrvName");
    9: ATTR(=, "cpqTapePhyDrvFwRev");
    10: ATTR(=, "cpqTapePhyDrvSerialNumber");
    11: ATTR(PREFIX, "cpqTapePhyDrvStatus") , VALUE(=,6);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5019_6;
    severity = WARNING;
    hostname=$V3;
    hpq_TapePhyDrvCntlrIndex = $V4;
    hpq_TapePhyDrvBusIndex = $V5;
    hpq_TapePhyDrvScsiIdIndex = $V6;
    hpq_TapePhyDrvLunIndex = $V7;
    hpq_TapePhyDrvName = $V8;
    hpq_TapePhyDrvFwRev = $V9;
    hpq_TapePhyDrvSerialNumber = $V10;
    hpq_TapePhyDrvStatus = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Drive Status Change to missingWasOk.";
    hpq_info = PRINTF ("Status is now %d the tape physical drive had a status of OK and is no longer present.", $V11);
END

CLASS IM_5019_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCntlrIndex");
    5: ATTR(=, "cpqTapePhyDrvBusIndex");
    6: ATTR(=, "cpqTapePhyDrvScsiIdIndex");
    7: ATTR(=, "cpqTapePhyDrvLunIndex");
    8: ATTR(=, "cpqTapePhyDrvName");
    9: ATTR(=, "cpqTapePhyDrvFwRev");
    10: ATTR(=, "cpqTapePhyDrvSerialNumber");
    11: ATTR(PREFIX, "cpqTapePhyDrvStatus") , VALUE(=,7);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5019_7;
    severity = CRITICAL;
    hostname=$V3;
    hpq_TapePhyDrvCntlrIndex = $V4;
    hpq_TapePhyDrvBusIndex = $V5;
    hpq_TapePhyDrvScsiIdIndex = $V6;
    hpq_TapePhyDrvLunIndex = $V7;
    hpq_TapePhyDrvName = $V8;
    hpq_TapePhyDrvFwRev = $V9;
    hpq_TapePhyDrvSerialNumber = $V10;
    hpq_TapePhyDrvStatus = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Drive Status Change to missingWasFailed.";
    hpq_info = PRINTF ("Status is now %d the tape physical drive had a status of FAILED and is no longer present.", $V11);
END

CLASS IM_5019_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqTapePhyDrvCntlrIndex");
    5: ATTR(=, "cpqTapePhyDrvBusIndex");
    6: ATTR(=, "cpqTapePhyDrvScsiIdIndex");
    7: ATTR(=, "cpqTapePhyDrvLunIndex");
    8: ATTR(=, "cpqTapePhyDrvName");
    9: ATTR(=, "cpqTapePhyDrvFwRev");
    10: ATTR(=, "cpqTapePhyDrvSerialNumber");
    11: ATTR(PREFIX, "cpqTapePhyDrvStatus") , VALUE(=,8);
 MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5019_8;
    severity = WARNING;
    hostname=$V3;
    hpq_TapePhyDrvCntlrIndex = $V4;
    hpq_TapePhyDrvBusIndex = $V5;
    hpq_TapePhyDrvScsiIdIndex = $V6;
    hpq_TapePhyDrvLunIndex = $V7;
    hpq_TapePhyDrvName = $V8;
    hpq_TapePhyDrvFwRev = $V9;
    hpq_TapePhyDrvSerialNumber = $V10;
    hpq_TapePhyDrvStatus = $V11;
    sub_origin=$K11;
    hpq_val=$V11;
    msg = "Tape Drive Status Change to missingWasOffline.";
    hpq_info = PRINTF ("Status is now %d the tape physical drive had a status of OFFLINE and is no longer present.", $V11);
END

##############################################################
CLASS IM_5020_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,2);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: ok.";
    hpq_info = PRINTF ("Status is now %d the physical drive is in normal operation mode.", $V4);
END

CLASS IM_5020_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,3);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_3;
    severity = FATAL;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: failed.";
    hpq_info = PRINTF ("Status is now %d indicates that the physical drive has failed and can no longer return data.", $V4);
END

CLASS IM_5020_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,4);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_4;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: notConfigured.";
    hpq_info = PRINTF ("Status is now %d indicates that the physical drive is not configured.", $V4);
END

CLASS IM_5020_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,5);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_5;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: not responding.";
    hpq_info = PRINTF ("Status is now %d a physical drive is not responding. You should check the cables connected to it.", $V4);
END

CLASS IM_5020_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,6);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_6;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: missingWasOk.";
    hpq_info = PRINTF ("Status is now %d a physical drive had a status of OK and is no longer present.", $V4);
END

CLASS IM_5020_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,7);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_7;
    severity = CRITICAL;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: missingWasFailed.";
    hpq_info = PRINTF ("Status is now %d a physical drive had a status of FAILED and is no longer present.", $V4);
END

CLASS IM_5020_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,8);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_8;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: predictiveFailure.";
    hpq_info = PRINTF ("Status is now %d the physical drive has exceeded a threshold value for one of it's predictive indicators.", $V4);
END

CLASS IM_5020_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,9);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_9;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: missingWasPredictiveFailure.";
    hpq_info = PRINTF ("Status is now %d a physical drive had a status of PREDICTIVE FAILURE and is no longer present.", $V4);
END

CLASS IM_5020_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,10);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_10;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: offline.";
    hpq_info = PRINTF ("Status is now %d the physical drive is offline and can no longer return data.", $V4);
END

CLASS IM_5020_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,11);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_11;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: missingWasOffline.";
    hpq_info = PRINTF ("Status is now %d a physical drive had a status of OFFLINE and is no longer present", $V4);
END

CLASS IM_5020_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5020;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiPhyDrvStatus") , VALUE(=,12);
    5: ATTR(=, "cpqScsiPhyDrvCntlrIndex");
    6: ATTR(=, "cpqScsiPhyDrvBusIndex");
    7: ATTR(=, "cpqScsiPhyDrvIndex");
    8: ATTR(=, "cpqScsiPhyDrvVendor");
    9: ATTR(=, "cpqScsiPhyDrvModel");
    10: ATTR(=, "cpqScsiPhyDrvFWRev");
    11: ATTR(=, "cpqScsiPhyDrvSerialNum");
    12: ATTR(=, "cpqScsiPhyDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5020_12;
    severity = CRITICAL;
    hostname=$V3;
    hpq_ScsiPhyDrvStatus = $V4;
    hpq_ScsiPhyDrvCntlrIndex = $V5;
    hpq_ScsiPhyDrvBusIndex = $V6;
    hpq_ScsiPhyDrvIndex = $V7;
    hpq_ScsiPhyDrvVendor = $V8;
    hpq_ScsiPhyDrvModel = $V9;
    hpq_ScsiPhyDrvFWRev = $V10;
    hpq_ScsiPhyDrvSerialNum = $V11;
    hpq_ScsiPhyDrvOsName = $V12;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Physical Drive Status: hardError.";
    hpq_info = PRINTF ("Status is now %d a hard error occurred for this physical drive.", $V4);
END

##############################################################
CLASS IM_5021_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,2);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: ok.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive is in normal operation mode.", $V7, $V4);
END

CLASS IM_5021_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,3);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_3;
    severity = FATAL;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: failed.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive has failed.", $V7, $V4);
END

CLASS IM_5021_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,4);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_4;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: unconfigured.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive has failed.", $V7, $V4);
END

CLASS IM_5021_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,5);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_5;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: recovering.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive is in interim recovery mode.", $V7, $V4);
END

CLASS IM_5021_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,6);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_6;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: ready for rebuild.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The failed drive has been repaired or replaced. System is now ready to begin Automatic Data Recovery.", $V7, $V4);
END

CLASS IM_5021_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,7);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_7;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: rebuilding.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive is rebuilding.", $V7, $V4);
END

CLASS IM_5021_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,8);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_8;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: wrong drive.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. Incorrect physical drive has been replaced.", $V7, $V4);
END

CLASS IM_5021_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,9);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_9;
    severity = CRITICAL;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: bad connection.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The physical drive is not responding to the controller. Bad drive connection.", $V7, $V4);
END

CLASS IM_5021_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,10);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_10;
    severity = WARNING;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: degraded.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive is in a degraded state.", $V7, $V4);
END

CLASS IM_5021_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5021;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqScsiLogDrvStatus") , VALUE(=,11);
    5: ATTR(=, "cpqScsiLogDrvCntlrIndex");
    6: ATTR(=, "cpqScsiLogDrvBusIndex");
    7: ATTR(=, "cpqScsiLogDrvIndex");
    8: ATTR(=, "cpqScsiLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5021_11;
    severity = CRITICAL;
    hostname=$V3;
    hpq_ScsiLogDrvStatus = $V4;
    hpq_ScsiLogDrvCntlrIndex = $V5;
    hpq_ScsiLogDrvBusIndex = $V6;
    hpq_ScsiLogDrvIndex = $V7;
    hpq_ScsiLogDrvOsName = $V8;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Logical Drive Status: disabled.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive has been disabled.", $V7, $V4);
END

##############################################################

CLASS IM_5022_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,2);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber= $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: ok.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s is in normal operation mode.", $V3, $V7, $V5);
END

CLASS IM_5022_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,3);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_3;
    severity = WARNING;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber = $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: predictiveFailure.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s has exceeded a threshold value for one of it's predictive indicators.", $V3, $V7, $V5);
END

CLASS IM_5022_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,4);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber = $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: offline.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s is offline and can no longer return data.", $V3, $V7, $V5);
END

CLASS IM_5022_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,5);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_5;
    severity = FATAL;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber = $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: failed.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s has failed and can no longer return data.", $V3, $V7, $V5);
END

CLASS IM_5022_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,6);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_6;
    severity = WARNING;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber = $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: missingWasOk.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s had a status of OK and is no longer present.", $V3, $V7, $V5);
END

CLASS IM_5022_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,7);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_7;
    severity = WARNING;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber = $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: missingWasPredictiveFailure.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s had a status of PREDICTIVE FAILURE and is no longer present.", $V3, $V7, $V5);
END

CLASS IM_5022_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,8);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_8;
    severity = WARNING;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber = $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: missingWasOffline.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s had a status of OFFLINE and is no longer present", $V3, $V7, $V5);
END

CLASS IM_5022_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasPhyDrvLocationString");
    6: ATTR(=, "cpqSasPhyDrvHbaIndex");
    7: ATTR(=, "cpqSasPhyDrvIndex");
    8: ATTR(PREFIX, "cpqSasPhyDrvStatus") , VALUE(=,9);
    9: ATTR(=, "cpqSasPhyDrvType");
   10: ATTR(=, "cpqSasPhyDrvModel");
   11: ATTR(=, "cpqSasPhyDrvFWRev");
   12: ATTR(=, "cpqSasPhyDrvSerialNumber");
   13: ATTR(=, "cpqSasPhyDrvSasAddress");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5022_9;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasPhyDrvLocationString = $V5;
    hpq_SasPhyDrvHbaIndex = $V6;
    hpq_SasPhyDrvIndex = $V7;
    hpq_SasPhyDrvStatus = $V8;
    hpq_SasPhyDrvType = $V9;
    hpq_SasPhyDrvModel = $V10;
    hpq_SasPhyDrvFWRev = $V11;
    hpq_SasPhyDrvSerialNumber = $V12;
    hpq_SasPhyDrvSasAddress = $V13;
    sub_origin=$K8;
    hpq_val=$V8;
    msg = "Physical Drive Status: missingWasFailed.";
    hpq_info = PRINTF ("The physical drive on %s with index %d at location %s had a status of FAILED and is no longer present.", $V3, $V7, $V5);
END

##############################################################

CLASS IM_5023_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasLogDrvHbaIndex");
    6: ATTR(=, "cpqSasLogDrvIndex");
    7: ATTR(PREFIX, "cpqSasLogDrvStatus") , VALUE(=,2);
    8: ATTR(=, "cpqSasLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5023_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasLogDrvHbaIndex = $V5;
    hpq_SasLogDrvIndex = $V6;
    hpq_SasLogDrvStatus = $V7;
    hpq_SasLogDrvOsName= $V8;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Logical Drive Status: ok.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive is in normal operation mode.", $V6, $V7);
END

CLASS IM_5023_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasLogDrvHbaIndex");
    6: ATTR(=, "cpqSasLogDrvIndex");
    7: ATTR(PREFIX, "cpqSasLogDrvStatus") , VALUE(=,3);
    8: ATTR(=, "cpqSasLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5023_3;
    severity = WARNING;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasLogDrvHbaIndex = $V5;
    hpq_SasLogDrvIndex = $V6;
    hpq_SasLogDrvStatus = $V7;
    hpq_SasLogDrvOsName= $V8;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Logical Drive Status: degraded.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive is in a degraded state.", $V6, $V7);
END

CLASS IM_5023_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasLogDrvHbaIndex");
    6: ATTR(=, "cpqSasLogDrvIndex");
    7: ATTR(PREFIX, "cpqSasLogDrvStatus") , VALUE(=,4);
    8: ATTR(=, "cpqSasLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5023_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasLogDrvHbaIndex = $V5;
    hpq_SasLogDrvIndex = $V6;
    hpq_SasLogDrvStatus = $V7;
    hpq_SasLogDrvOsName= $V8;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Logical Drive Status: rebuilding.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive is rebuilding.", $V6, $V7);
END

CLASS IM_5023_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 5023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSasHbaHwLocation");
    5: ATTR(=, "cpqSasLogDrvHbaIndex");
    6: ATTR(=, "cpqSasLogDrvIndex");
    7: ATTR(PREFIX, "cpqSasLogDrvStatus") , VALUE(=,5);
    8: ATTR(=, "cpqSasLogDrvOsName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 5023_5;
    severity = FATAL;
    hostname=$V3;
    hpq_SasHbaHwLocation = $V4;
    hpq_SasLogDrvHbaIndex = $V5;
    hpq_SasLogDrvIndex = $V6;
    hpq_SasLogDrvStatus = $V7;
    hpq_SasLogDrvOsName= $V8;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Logical Drive Status: failed.";
    hpq_info = PRINTF ("Status of logical drive (%d) is now %d. The logical drive has failed.", $V6, $V7);
END

#########################################################
#####   Compaq System Information
#########################################################
CLASS IM_2001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2001 ;
    3: ATTR(=, "sysName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2001;
    severity = CRITICAL;
    hostname = $V3;
    msg = "System hood is removed";
    hpq_info = "Hood is removed from unit." ;
END

##############################################################
CLASS IM_2002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2002 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiMonitorIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2002;
    severity = HARMLESS;
    hostname = $V3;
    hpq_SiMonitorIndex = $V4;
    msg = "Monitor Condition OK";
    hpq_info = "The monitor's condition has been set to OK." ;
END

#################################################################
CLASS IM_2003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2003 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiMonitorIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2003;
    severity = WARNING;
    hostname = $V3;
    hpq_SiMonitorIndex = $V4;
    msg = "Monitor Condition Degraded";
    hpq_info = "The monitor's condition has been set to degraded." ;
END

##################################################################
CLASS IM_2004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2004 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiMonitorIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2004;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiMonitorIndex = $V4;
    msg = "Monitor Condition Failed";
    hpq_info = "The monitor's condition has been set to failed." ;
END

##################################################################
CLASS IM_2005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2005 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiMemErrorIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2005;
    severity = WARNING;
    hostname = $V3;
    hpq_SiMemErrorIndex = $V4;
    msg = "Excessive Correctable Memory Errors";
    hpq_info = PRINTF("The Memory Module %d ECC status has been set to degraded.", $V4);
END

####################################################################
CLASS IM_2006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2006 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiMemErrorIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2006;
    severity = HARMLESS;
    hostname = $V3;
    hpq_SiMemErrorIndex = $V4;
    msg = "Correctable Memory Errors Count OK";
    hpq_info = PRINTF("The Memory Module %d ECC status has been set to OK.", $V4);
END

####################################################################
CLASS IM_2007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2007 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiMemConfigChangeData" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2007;
    severity = HARMLESS;
    hpq_SiMemConfigChangeData = $V4;
    hostname = $V3;
    msg = "Memory modules have changed";
    hpq_info = "The system memory configuration has changed." ;
END

#####################################################################
CLASS IM_2008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2008 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2008;
    severity = WARNING;
    hostname = $V3;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotChassis = $V4;
    msg = "Hot Plug Slot Board Removed";
    hpq_info = PRINTF("Hot Plug Slot Board Removed from Chassis %d, Slot %d.", $V4, $V5);
END

####################################################################
CLASS IM_2009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2009 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2009;
    severity = HARMLESS;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    msg = "Hot Plug Slot Board Inserted";
    hpq_info = PRINTF("Hot Plug Slot Board Inserted into Chassis %d, Slot %d.", $V4, $V5);
END

####################################################################
CLASS IM_2010_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,1);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_1;
    severity = HARMLESS;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_2;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_3;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_4;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_5;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_6;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,7);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_7;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,8);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_8;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

CLASS IM_2010_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2010 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiHotPlugSlotChassis" ) ;
    5: ATTR(=, "cpqSiHotPlugSlotIndex" ) ;
    6: ATTR(PREFIX, "cpqSiHotPlugSlotErrorStatus") , VALUE(=,9);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2010_9;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiHotPlugSlotChassis = $V4;
    hpq_SiHotPlugSlotIndex = $V5;
    hpq_SiHotPlugSlotErrorStatus = $V6;
    msg = "Hot Plug Slot Board Status Changes";
    hpq_info = PRINTF("Hot Plug Slot Board in Chassis %d, Slot %d, changes to %d.", $V4, $V5, $V6);
END

#####################################################################
CLASS IM_2011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2011 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiSysBatteryIndex" ) ;
    5: ATTR(=, "cpqSiSysBatterySerialNum" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2011;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiSysBatteryIndex = $V4;
    hpq_SiSysBatterySerialNum = $V5;
    msg = "Battery Failure";
    hpq_info = PRINTF("Battery %d has failed.", $V4);
END

######################################################################
CLASS IM_2012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2012 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiSysBatteryIndex" ) ;
    5: ATTR(=, "cpqSiSysBatterySerialNum" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2012;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiSysBatteryIndex = $V4;
    hpq_SiSysBatterySerialNum = $V5;
    msg = "Battery Charging Degradation";
    hpq_info = PRINTF("Battery %s has degraded charging capacity.", $V4);
END

######################################################################
CLASS IM_2013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 2013 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSiSysBatteryIndex" ) ;
    5: ATTR(=, "cpqSiSysBatterySerialNum" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 2013;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SiSysBatteryIndex = $V4;
    hpq_SiSysBatterySerialNum = $V5;
    msg = "Battery Calibration Error";
    hpq_info = PRINTF("Battery %s has calibration error.", $V4);
END

###############################################################
#####   Compaq Remote Insight/Integrated Lights-Out Information
###############################################################

CLASS IM_9001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9001;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9001;
    severity = WARNING;
    hostname=$V3;
    msg = "Server Reset Detected";
    hpq_info = "Server reset detected." ;
END

######################################################################
CLASS IM_9002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9002;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9002;
    severity = FATAL;
    hostname=$V3;
    msg = "Server Power Outage";
    hpq_info = "Server power outage detected." ;
END

######################################################################
CLASS IM_9003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9003;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSm2CntlrBadLoginAttemptsThresh");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9003;
    severity = WARNING;
    hostname=$V3;
    hpq_Sm2CntlrBadLoginAttemptsThresh = $V4;
    msg = "Remote Insight Unauthorized Login Attempts";
    hpq_info = PRINTF ( "The remote Insight board has detected more than %d bad login attempts on %s.", $V4, $V3);
END

######################################################################
CLASS IM_9004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9004;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9004;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Remote Insight board battery failed";
    hpq_info = PRINTF ( "The remote Insight board battery on %s has failed and needs to be replaced." , $V3 );
END

######################################################################
CLASS IM_9005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSm2CntlrSelfTestErrors");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9005;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Remote Insight board self test failed";
    hpq_info = PRINTF ( "The remote Insight board on %s has failed a diagnostic self test and should be replaced.", $V3);
END

######################################################################
CLASS IM_9006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9006;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9006;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Remote Insight board interface error";
    hpq_info = PRINTF ( "Remote Insight firmware on %s is not responding and will be reset by the Insight Agents. If this occurs frequently, the Insight software should be upgraded." , $V3 ) ;
END

######################################################################
CLASS IM_9007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9007;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9007;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Remote Insight board battery cable disconnected";
    hpq_info = PRINTF ( "The battery cable for the remote Insight board on %s has been disconnected." , $V3 ) ;
END

######################################################################
CLASS IM_9008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9008;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9008;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Remote Insight board keyboard cable disconnected";
    hpq_info = PRINTF ( "The keyboard cable for the remote Insight board on %s has been disconnected." , $V3 ) ;
END

######################################################################
CLASS IM_9009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9009;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9009;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Remote Insight board mouse cable disconnected";
    hpq_info = PRINTF ( "The mouse cable for the remote Insight board on %s has been disconnected." , $V3 ) ;
END

######################################################################
CLASS IM_9010
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9010;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9010;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Remote Insight external power cable disconnected";
    hpq_info = PRINTF ( "The external power cable for the remote Insight board on %s has been disconnected." , $V3 ) ;
END

######################################################################
CLASS IM_9011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9011;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9011;
    severity = WARNING;
    hostname=$V3;
    msg = "Remote Insight/ Integrated Lights-Out Logs Full.";
    hpq_info = "Remote Insight/ Integrated Lights-Out Logs Full." ;
END


######################################################################
CLASS IM_9012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9012;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9012;
    severity = WARNING;
    hostname=$V3;
    msg = "Security Override Engaged.";
    hpq_info = "Remote Insight/ Integrated Lights-Out firmware has detected the security override jumper has been engaged." ;
END

######################################################################
CLASS IM_9013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 9013;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 9013;
    severity = WARNING;
    hostname=$V3;
    msg = "Security Override Disengaged.";
    hpq_info = "Remote Insight/ Integrated Lights-Out firmware has detected the security override jumper has been disengaged." ;
END

#########################################################
#####   Compaq Standard PC equipment configuration
#########################################################
CLASS IM_1001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 1001 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSeCpuSlot" ) ;
    5: ATTR(=, "cpqSeCpuSocketNumber" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1001;
    severity = WARNING;
    hostname = $V3;
    hpq_SeCpuSlot = $V5;
    hpq_SeCpuSocketNumber = $V4;
    msg = "CPU error threshold passed";
    hpq_info = PRINTF("A CPU on %s, in slot %d, in socket %d, has passed a set threshold on internal corrected errors", $V3, $V4, $V5);
END

######################################################################
CLASS IM_1002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 1002 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSePCCardDeviceInfo" ) ;
    5: ATTR(=, "cpqSePCCardProductInfo" ) ;
    6: ATTR(=, "cpqSePCCardSlotIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1002;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SePCCardDeviceInfo = $V4;
    hpq_SePCCardProductInfo = $V5;
    hpq_SePCCardSlotIndex = $V6;
    msg = "PC Card Thermal Degraded Status";
    hpq_info = PRINTF("Safe PC Card %d Thermal operating conditions exceeded.", $V6);
END

######################################################################
CLASS IM_1003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 1003 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSePCCardDeviceInfo" ) ;
    5: ATTR(=, "cpqSePCCardProductInfo" ) ;
    6: ATTR(=, "cpqSePCCardSlotIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1003;
    severity = FATAL;
    hostname = $V3;
    hpq_SePCCardDeviceInfo = $V4;
    hpq_SePCCardProductInfo = $V5;
    hpq_SePCCardSlotIndex = $V6;
    msg = "PC Card Thermal Failure Status";
    hpq_info = PRINTF("Degraded PC Card %d Thermal operating conditions exceeded.", $V6);
END

######################################################################
CLASS IM_1004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 1004 ;
    3: ATTR(=, "sysName" ) ;
    4: ATTR(=, "cpqSePCCardSlotIndex" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1004;
    severity = HARMLESS;
    hostname = $V3;
    hpq_SePCCardSlotIndex = $V4;
    msg = "PC Card Thermal Safe Operations Status";
    hpq_info = PRINTF("Degraded/Failed PC Card %d Thermal conditions restored to Safe operations.", $V4);
END

######################################################################
CLASS IM_1005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 1005;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqSeCpuSlot");
    5: ATTR(=, "cpqSeCpuSocketNumber");
    6: ATTR(=, "cpqSeCpuSpeed");
    7: ATTR(=, "cpqSeCpuExtSpeed");
    8: ATTR(=, "cpqSeCpuCacheSize");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1005;
    severity = WARNING;
    hostname = $V3;
    hpq_SeCpuSlot = $V4;
    hpq_SeCpuSocketNumber = $V5;
    hpq_SeCpuSpeed = $V6;
    hpq_SeCpuExtSpeed = $V7;
    hpq_SeCpuCacheSize = $V8;
    msg = "CPU error threshold passed";
    hpq_info = PRINTF("Internal corrected errors for CPU in slot %d have passed a set threshold.", $V4);
END
###########################################################################
CLASS IM_1006_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 1006;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqSeCpuUnitIndex");
    5: ATTR(=, "cpqSeCpuSlot");
    6: ATTR(=, "cpqSeCpuName");
    7: ATTR(=, "cpqSeCpuSpeed");
    8: ATTR(=, "cpqSeCpuStep");
    9: ATTR(PREFIX, "cpqSeCpuStatus"), VALUE(=,2);
   10: ATTR(=, "cpqSeCpuExtSpeed");
   11: ATTR(=, "cpqSeCpuSocketNumber");
   12: ATTR(=, "cpqSeCpuHwLocation");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1006_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_SeCpuUnitIndex = $V4;
    hpq_SeCpuSlot = $V5;
    hpq_SeCpuName = $V6;
    hpq_SeCpuSpeed = $V7;
    hpq_SeCpuStep = $V8;
    hpq_SeCpuStatus = $V9;
    hpq_SeCpuExtSpeed = $V10;
    hpq_SeCpuSocketNumber = $V11;
    hpq_SeCpuHwLocation = $V12;
    sub_origin=$K9;
    hpq_val=$V9;
    msg = "The CPU is functioning normally.";
    hpq_info = PRINTF("Processor in Slot %d change to %d", $V5, $V9);
END

CLASS IM_1006_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 1006;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqSeCpuUnitIndex");
    5: ATTR(=, "cpqSeCpuSlot");
    6: ATTR(=, "cpqSeCpuName");
    7: ATTR(=, "cpqSeCpuSpeed");
    8: ATTR(=, "cpqSeCpuStep");
    9: ATTR(PREFIX, "cpqSeCpuStatus"), VALUE(=,3);
   10: ATTR(=, "cpqSeCpuExtSpeed");
   11: ATTR(=, "cpqSeCpuSocketNumber");
   12: ATTR(=, "cpqSeCpuHwLocation");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1006_3;
    severity = CRITICAL;
    hostname = $V3;
    hpq_SeCpuUnitIndex = $V4;
    hpq_SeCpuSlot = $V5;
    hpq_SeCpuName = $V6;
    hpq_SeCpuSpeed = $V7;
    hpq_SeCpuStep = $V8;
    hpq_SeCpuStatus = $V9;
    hpq_SeCpuExtSpeed = $V10;
    hpq_SeCpuSocketNumber = $V11;
    hpq_SeCpuHwLocation = $V12;
    sub_origin=$K9;
    hpq_val=$V9;
    msg = "The CPU is in a pre-failure warantee state.";
    hpq_info = PRINTF("Processor in Slot %d change to %d", $V5, $V9);
END

CLASS IM_1006_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 1006;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqSeCpuUnitIndex");
    5: ATTR(=, "cpqSeCpuSlot");
    6: ATTR(=, "cpqSeCpuName");
    7: ATTR(=, "cpqSeCpuSpeed");
    8: ATTR(=, "cpqSeCpuStep");
    9: ATTR(PREFIX, "cpqSeCpuStatus"), VALUE(=,4);
   10: ATTR(=, "cpqSeCpuExtSpeed");
   11: ATTR(=, "cpqSeCpuSocketNumber");
   12: ATTR(=, "cpqSeCpuHwLocation");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1006_4;
    severity = FATAL;
    hostname = $V3;
    hpq_SeCpuUnitIndex = $V4;
    hpq_SeCpuSlot = $V5;
    hpq_SeCpuName = $V6;
    hpq_SeCpuSpeed = $V7;
    hpq_SeCpuStep = $V8;
    hpq_SeCpuStatus = $V9;
    hpq_SeCpuExtSpeed = $V10;
    hpq_SeCpuSocketNumber = $V11;
    hpq_SeCpuHwLocation = $V12;
    sub_origin=$K9;
    hpq_val=$V9;
    msg = "The CPU is in a failed state.";
    hpq_info = PRINTF("Processor in Slot %d change to %d", $V5, $V9);
END

CLASS IM_1006_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 1006;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqSeCpuUnitIndex");
    5: ATTR(=, "cpqSeCpuSlot");
    6: ATTR(=, "cpqSeCpuName");
    7: ATTR(=, "cpqSeCpuSpeed");
    8: ATTR(=, "cpqSeCpuStep");
    9: ATTR(PREFIX, "cpqSeCpuStatus"), VALUE(=,5);
   10: ATTR(=, "cpqSeCpuExtSpeed");
   11: ATTR(=, "cpqSeCpuSocketNumber");
   12: ATTR(=, "cpqSeCpuHwLocation");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1006_5;
    severity = WARNING;
    hostname = $V3;
    hpq_SeCpuUnitIndex = $V4;
    hpq_SeCpuSlot = $V5;
    hpq_SeCpuName = $V6;
    hpq_SeCpuSpeed = $V7;
    hpq_SeCpuStep = $V8;
    hpq_SeCpuStatus = $V9;
    hpq_SeCpuExtSpeed = $V10;
    hpq_SeCpuSocketNumber = $V11;
    hpq_SeCpuHwLocation = $V12;
    sub_origin=$K9;
    hpq_val=$V9;
    msg = "The CPU has been disabled during power-on-self-test.";
    hpq_info = PRINTF("Processor in Slot %d change to %d", $V5, $V9);
END

###########################################################################
CLASS IM_1007_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 1007;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqSeCpuUnitIndex");
    5: ATTR(=, "cpqSeCpuSlot");
    6: ATTR(=, "cpqSeCpuName");
    7: ATTR(=, "cpqSeCpuSpeed");
    8: ATTR(=, "cpqSeCpuStep");
    9: ATTR(PREFIX, "cpqSeCpuPowerpodStatus"), VALUE(=,1);
   10: ATTR(=, "cpqSeCpuExtSpeed");
   11: ATTR(=, "cpqSeCpuSocketNumber");
   12: ATTR(=, "cpqSeCpuHwLocation");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1007_1;
    severity = HARMLESS;
    hostname = $V3;
    hpq_SeCpuUnitIndex = $V4;
    hpq_SeCpuSlot = $V5;
    hpq_SeCpuName = $V6;
    hpq_SeCpuSpeed = $V7;
    hpq_SeCpuStep = $V8;
    hpq_SeCpuPowerpodStatus = $V9;
    hpq_SeCpuExtSpeed = $V10;
    hpq_SeCpuSocketNumber = $V11;
    hpq_SeCpuHwLocation = $V12;
    sub_origin=$K9;
    hpq_val=$V9;
    msg = "The CPU Power Pod status: not failed.";
    hpq_info = PRINTF("Processor in Slot %d Power supply status is %d", $V5, $V9);
END

CLASS IM_1007_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232");
    2: $SPECIFIC = 1007;
    3: ATTR(=, "sysName" );
    4: ATTR(=, "cpqSeCpuUnitIndex");
    5: ATTR(=, "cpqSeCpuSlot");
    6: ATTR(=, "cpqSeCpuName");
    7: ATTR(=, "cpqSeCpuSpeed");
    8: ATTR(=, "cpqSeCpuStep");
    9: ATTR(PREFIX, "cpqSeCpuPowerpodStatus"), VALUE(=,2);
   10: ATTR(=, "cpqSeCpuExtSpeed");
   11: ATTR(=, "cpqSeCpuSocketNumber");
   12: ATTR(=, "cpqSeCpuHwLocation");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 1007_2;
    severity = FATAL;
    hostname = $V3;
    hpq_SeCpuUnitIndex = $V4;
    hpq_SeCpuSlot = $V5;
    hpq_SeCpuName = $V6;
    hpq_SeCpuSpeed = $V7;
    hpq_SeCpuStep = $V8;
    hpq_SeCpuPowerpodStatus = $V9;
    hpq_SeCpuExtSpeed = $V10;
    hpq_SeCpuSocketNumber = $V11;
    hpq_SeCpuHwLocation = $V12;
    sub_origin=$K9;
    hpq_val=$V9;
    msg = "The CPU Power Pod status: failed.";
    hpq_info = PRINTF("Processor in Slot %d Power supply status is %d", $V5, $V9);
END

#########################################################
#####   Compaq Storage Systems
#########################################################
CLASS IM_8008_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8008;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8008_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxFanStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Storage system fan status: ok";
    hpq_info = PRINTF ( "Storage subsystem internal fan on %s is now operational." , $V3 ) ;
END

CLASS IM_8008_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8008;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8008_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxFanStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Storage system fan status: failed";
    hpq_info = PRINTF ( "Storage subsystem internal fan on %s has failed." , $V3 ) ;
END

CLASS IM_8008_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8008;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8008_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxFanStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Storage system fan status: noFan";
    hpq_info = PRINTF ("%s does not support fan monitoring", $V3);
END

CLASS IM_8008_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8008;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8008_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxFanStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Storage system fan status: degraded";
    hpq_info = PRINTF ("At least one storage fan has failed on %s. Cooling is sufficient but the fan should be replaced", $V3);
END

######################################################################
CLASS IM_8009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8009;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxTempStatus");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8009;
    severity = FATAL;
    hostname=$V3;
    msg = "Storage system temperature status: failed";
    hpq_SsBoxTempStatus = $V4;
    hpq_info = PRINTF ( "Internal temperature for a storage system on %s has risen above factory preset levels. System will be shut down." , $V3 ) ;
END

######################################################################
CLASS IM_8010
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8010;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxTempStatus");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8010;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Storage system temperature status: degraded ";
    hpq_SsBoxTempStatus = $V4;
    hpq_info = PRINTF ( "Internal temperature for a storage system on %s is outside normal operating range." , $V3 ) ;
END

######################################################################
CLASS IM_8011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8011;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxTempStatus");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8011;
    severity = HARMLESS;
    hostname=$V3;
    msg = "Storage system temperature status: ok";
    hpq_SsBoxTempStatus = $V4;
    hpq_info = PRINTF ( "Previously abnormal internal temperature for a storage system on %s has returned to normal." , $V3 ) ;
END

######################################################################
CLASS IM_8012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8012;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxSidePanelStatus");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8012;
    severity = HARMLESS;
    hostname=$V3;
    msg = "Storage system side panel in place";
    hpq_SsBoxSidePanelStatus = $V4;
    hpq_info = PRINTF ( "Storage system side panel on %s has been replaced." , $V3 ) ;
END

######################################################################
CLASS IM_8013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8013;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxSidePanelStatus");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8013;
    severity = CRITICAL;
    hostname=$V3;
    msg = "Storage system side panel removed";
    hpq_SsBoxSidePanelStatus = $V4;
    hpq_info = PRINTF ( "Storage system side panel on %s has been removed. This may lead to an overheating condition." , $V3 ) ;
END

######################################################################
######################################################################
CLASS IM_8015_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8015;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8015_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxFltTolPwrSupplyStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Power supply status: ok";
    hpq_info = PRINTF ( "There are no detected power supply failures on %s", $V3);
END

CLASS IM_8015_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8015;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8015_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxFltTolPwrSupplyStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Power supply status: degraded";
    hpq_info = PRINTF ( "One of the power supply units in a fault tolernat power supply has failed on %s", $V3);
END

CLASS IM_8015_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8015;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8015_4;
    severity = FATAL;
    hostname=$V3;
    hpq_SsBoxFltTolPwrSupplyStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Power supply status: failed";
    hpq_info = PRINTF ( "A power supply unit has failed on %s. No failure conditions can currently be determined", $V3);
END

CLASS IM_8015_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8015;
    3: ATTR(=, "sysName") ;
    4: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8015_5;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxFltTolPwrSupplyStatus = $V4;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "Power supply status: noFltTolPower";
    hpq_info = PRINTF ( "%s does not support fault tolerant power supply monitoring", $V3);
END

######################################################################
######################################################################
CLASS IM_8018_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyUpsStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname=$V3;
    hpq_eventID = 8018_2;
    sub_origin = $K7;
    hpq_val = $V7;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    msg = "Storage System Power Supply UPS Status: noUps";
    hpq_info = PRINTF ( "No UPS is attacked to the power supply of %s", $V3);
END

CLASS IM_8018_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyUpsStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8018_3;
    sub_origin = $K7;
    hpq_val = $V7;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    msg = "Storage System Power Supply UPS Status: ok";
    hpq_info = PRINTF ( "A UPS is attached to the power supply of %s and is operating normally", $V3);
END

CLASS IM_8018_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyUpsStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8018_4;
    sub_origin = $K7;
    hpq_val = $V7;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    msg = "Storage System Power Supply UPS Status: powerFailed";
    hpq_info = PRINTF ( "A UPS is attached to the power supply of %s and the AC power has failed", $V3);
END

CLASS IM_8018_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8018;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyUpsStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname=$V3;
    hpq_eventID = 8018_5;
    sub_origin = $K7;
    hpq_val = $V7;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    msg = "Storage System Power Supply UPS Status: batteryLow";
    hpq_info = PRINTF ( "A UPS is attached to the power supply of %s, the AC power has failed and the UPS batter is low", $V3);
END

######################################################################
CLASS IM_8019_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsTempSensorLocation");
    7: ATTR(PREFIX, "cpqSsTempSensorStatus"), VALUE(=,2);
    8: ATTR(=, "cpqSsTempSensorCurrentValue");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8019_2;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsTempSensorLocation = $V6;
    hpq_SsTempSensorStatus = $V7;
    hpq_SsTempSensorCurrentValue = $V8;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Storage System Temperature Sensor Status: ok";
    hpq_info = PRINTF ( "The temperature on %s is ok.", $V3);
END

CLASS IM_8019_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsTempSensorLocation");
    7: ATTR(PREFIX, "cpqSsTempSensorStatus"), VALUE(=,3);
    8: ATTR(=, "cpqSsTempSensorCurrentValue");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8019_3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsTempSensorLocation = $V6;
    hpq_SsTempSensorStatus = $V7;
    hpq_SsTempSensorCurrentValue = $V8;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Storage System Temperature Sensor Status: degraded";
    hpq_info = PRINTF ( "The temperature on %s is degraded.", $V3);
END

CLASS IM_8019_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8019;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsTempSensorLocation");
    7: ATTR(PREFIX, "cpqSsTempSensorStatus"), VALUE(=,4);
    8: ATTR(=, "cpqSsTempSensorCurrentValue");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 8019_4;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsTempSensorLocation = $V6;
    hpq_SsTempSensorStatus = $V7;
    hpq_SsTempSensorCurrentValue = $V8;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Storage System Temperature Sensor Status: failed";
    hpq_info = PRINTF ( "The temperature on %s has failed.", $V3);
END

######################################################################
CLASS IM_8020_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsFanModuleLocation");
    7: ATTR(PREFIX, "cpqSsFanModuleStatus"), VALUE(=,2);
    8: ATTR(=, "cpqSsFanModuleSerialNumber");
    9: ATTR(=, "cpqSsFanModuleBoardRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8020_2;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsFanModuleLocation = $V6;
    hpq_SsFanModuleStatus = $V7;
    hpq_SsFanModuleSerialNumber = $V8;
    hpq_SsFanModuleBoardRevision = $V9;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Fan Status: notInstalled";
    hpq_info = PRINTF ( "The fan on %s is not installed", $V3);
END

CLASS IM_8020_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsFanModuleLocation");
    7: ATTR(PREFIX, "cpqSsFanModuleStatus"), VALUE(=,3);
    8: ATTR(=, "cpqSsFanModuleSerialNumber");
    9: ATTR(=, "cpqSsFanModuleBoardRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8020_3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsFanModuleLocation = $V6;
    hpq_SsFanModuleStatus = $V7;
    hpq_SsFanModuleSerialNumber = $V8;
    hpq_SsFanModuleBoardRevision = $V9;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Fan Status: ok";
    hpq_info = PRINTF ( "The fan on %s is ok", $V3);
END

CLASS IM_8020_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsFanModuleLocation");
    7: ATTR(PREFIX, "cpqSsFanModuleStatus"), VALUE(=,4);
    8: ATTR(=, "cpqSsFanModuleSerialNumber");
    9: ATTR(=, "cpqSsFanModuleBoardRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8020_4;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsFanModuleLocation = $V6;
    hpq_SsFanModuleStatus = $V7;
    hpq_SsFanModuleSerialNumber = $V8;
    hpq_SsFanModuleBoardRevision = $V9;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Fan Status: degraded";
    hpq_info = PRINTF ( "The fan on %s has degraded", $V3);
END

CLASS IM_8020_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8020;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsFanModuleLocation");
    7: ATTR(PREFIX, "cpqSsFanModuleStatus"), VALUE(=,5);
    8: ATTR(=, "cpqSsFanModuleSerialNumber");
    9: ATTR(=, "cpqSsFanModuleBoardRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 8020_5;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsFanModuleLocation = $V6;
    hpq_SsFanModuleStatus = $V7;
    hpq_SsFanModuleSerialNumber = $V8;
    hpq_SsFanModuleBoardRevision = $V9;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Fan Status: failed";
    hpq_info = PRINTF ( "The fan on %s has failed", $V3);
END

######################################################################
CLASS IM_8021_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyStatus"), VALUE(=,2);
    8: ATTR(=, "cpqSsPowerSupplySerialNumber");
    9: ATTR(=, "cpqSsPowerSupplyBoardRevision");
    10: ATTR(=, "cpqSsPowerSupplyFirmwareRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8021_2;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    hpq_SsPowerSupplySerialNumber = $V8;
    hpq_SsPowerSupplyBoardRevision = $V9;
    hpq_SsPowerSupplyFirmwareRevision = $V10;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Power Supply Status: notInstalled";
    hpq_info = PRINTF ( "The power supply on %s in bay %s is not installed", $V3, $V6);
END

#####################################################################
CLASS IM_8021_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyStatus"), VALUE(=,3);
    8: ATTR(=, "cpqSsPowerSupplySerialNumber");
    9: ATTR(=, "cpqSsPowerSupplyBoardRevision");
    10: ATTR(=, "cpqSsPowerSupplyFirmwareRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8021_3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    hpq_SsPowerSupplySerialNumber = $V8;
    hpq_SsPowerSupplyBoardRevision = $V9;
    hpq_SsPowerSupplyFirmwareRevision = $V10;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Power Supply Status: ok";
    hpq_info = PRINTF ( "The power supply on %s in bay %d is ok", $V3, $V6);
END

######################################################################
CLASS IM_8021_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyStatus"), VALUE(=,4);
    8: ATTR(=, "cpqSsPowerSupplySerialNumber");
    9: ATTR(=, "cpqSsPowerSupplyBoardRevision");
    10: ATTR(=, "cpqSsPowerSupplyFirmwareRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 8021_4;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    hpq_SsPowerSupplySerialNumber = $V8;
    hpq_SsPowerSupplyBoardRevision = $V9;
    hpq_SsPowerSupplyFirmwareRevision = $V10;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Power Supply Status: failed";
    hpq_info = PRINTF ( "The power supply on %s in bay %d has failed.", $V3, $V6);
END

CLASS IM_8021_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8021;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsPowerSupplyBay");
    7: ATTR(PREFIX, "cpqSsPowerSupplyStatus"), VALUE(=,5);
    8: ATTR(=, "cpqSsPowerSupplySerialNumber");
    9: ATTR(=, "cpqSsPowerSupplyBoardRevision");
    10: ATTR(=, "cpqSsPowerSupplyFirmwareRevision");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname=$V3;
    hpq_eventID = 8021_5;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsPowerSupplyBay = $V6;
    hpq_SsPowerSupplyStatus = $V7;
    hpq_SsPowerSupplySerialNumber = $V8;
    hpq_SsPowerSupplyBoardRevision = $V9;
    hpq_SsPowerSupplyFirmwareRevision = $V10;
    sub_origin=$K7;
    hpq_val=$V7;
    msg = "Power Supply Status: degraded";
    hpq_info = PRINTF ( "At least one power supply on %s has failed or lost power for composite power supplies.", $V3);
END


######################################################################
CLASS IM_8022_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" );
    2: $SPECIFIC = 8022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFanStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname=$V3;
    hpq_eventID = 8022_2;
    hpq_SschassisName = $V4;
    hpq_SschassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFanStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Fan Status Change: notInstalled";
    hpq_info = PRINTF ( "Storage System Fan Status Change to %d", $V10);
END

######################################################################
CLASS IM_8022_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFanStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8022_3;
    hpq_SschassisName = $V4;
    hpq_SschassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFanStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Fan Status Change: ok";
    hpq_info = PRINTF ( "Storage System Fan Status Change to %s", $V10);
END

######################################################################
CLASS IM_8022_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFanStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8022_4;
    hpq_SschassisName = $V4;
    hpq_SschassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFanStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Fan Status Change: degraded";
    hpq_info = PRINTF ( "Storage System Fan Status Change to %d", $V10);
END

######################################################################
CLASS IM_8022_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFanStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 8022_5;
    hpq_SschassisName = $V4;
    hpq_SschassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFanStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Fan Status Change: failed";
    hpq_info = PRINTF ( "Storage System Fan Status Change to %d", $V10);
END

CLASS IM_8022_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8022;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFanStatus"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8022_6;
    hpq_SschassisName = $V4;
    hpq_SschassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFanStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Fan Status Change: not supported";
    hpq_info = PRINTF ( "The Storage system on %s does not support reporting fan status through this backplane.", $V3);
END


######################################################################
CLASS IM_8023_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneTempStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname=$V3;
    hpq_eventID = 8023_2;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneTempStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Temperature Status Change: noTemp";
    hpq_info = PRINTF ( "Storage System Temperature Status Change to %d", $V10);
END

######################################################################
CLASS IM_8023_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneTempStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8023_3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneTempStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Temperature Status Change: ok";
    hpq_info = PRINTF ( "Storage System Temperature Status Change to %s", $V10);
END

######################################################################
CLASS IM_8023_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneTempStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8023_4;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneTempStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Temperature Status Change: degraded";
    hpq_info = PRINTF ( "Storage System Temperature Status Change to %s", $V10);
END

######################################################################
CLASS IM_8023_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneTempStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 8023_5;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneTempStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Temperature Status Change: failed";
    hpq_info = PRINTF ( "Storage System Temperature Status Change to %s", $V10);
END

CLASS IM_8023_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8023;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneTempStatus"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8023_6;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneTempStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Storage System Temperature Status Change: not supported";
    hpq_info = PRINTF ( "The Storage system on %s does not support reporting temperature status through this backplane.", $V3);
END


#####################################################################
CLASS IM_8024_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8024;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFtpsStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hostname=$V3;
    hpq_eventID = 8024_2;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFtpsStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Power Supply Status Change: noFltTolPower";
    hpq_info = PRINTF ( "Power Supply Status Change to %d", $V10);
END

######################################################################
CLASS IM_8024_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8024;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFtpsStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8024_3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFtpsStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Power Supply Status Change: ok";
    hpq_info = PRINTF ( "Power Supply Status Change to %d", $V10);
END

######################################################################
CLASS IM_8024_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8024;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFtpsStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = 8024_4;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFtpsStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Power Supply Status Change: degraded";
    hpq_info = PRINTF ( "Power Supply Status Change to %d", $V10);
END

#######################################################################
CLASS IM_8024_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8024;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFtpsStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = 8024_5;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFtpsStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Power Supply Status Change: failed";
    hpq_info = PRINTF("Power Supply Status Change to %s", $V10);
END

CLASS IM_8024_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8024;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(=, "cpqSsBackplaneIndex");
    7: ATTR(=, "cpqSsBackplaneVendor");
    8: ATTR(=, "cpqSsBackplaneModel");
    9: ATTR(=, "cpqSsBackplaneSerialNumber");
    10: ATTR(PREFIX, "cpqSsBackplaneFtpsStatus"), VALUE(=,6);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = 8024_6;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsBackplaneIndex = $V6;
    hpq_SsBackplaneVendor = $V7;
    hpq_SsBackplaneModel = $V8;
    hpq_SsBackplaneSerialNumber = $V9;
    hpq_SsBackplaneFtpsStatus = $V10;
    sub_origin=$K10;
    hpq_val=$V10;
    msg = "Power Supply Status Change: not supported";
    hpq_info = PRINTF("The Storage system on %s does not support reporting fault tolerant power supply status through this backplane.", $V3);
END


#######################################################################
CLASS IM_8025_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,2);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_2;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to notSupported";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,3);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_3;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to notConfigured.";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,4);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_4;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to disabled.";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,5);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to daemonDownDisabled";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,6);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_6;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to ok";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,7);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_7;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to daemonDownActive";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_8
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,8);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_8;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to noSecondary";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_9
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,9);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_9;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to daemonDownNoSecondary";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,10);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_10;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to linkDown";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,11);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_11;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to daemonDownLinkDown";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_12
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,12);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_12;
    severity = WARNING;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to secondaryRunningAuto";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_13
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,13);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_13;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to secondaryRunningUser";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

CLASS IM_8025_14
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8025;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsChassisName");
    5: ATTR(=, "cpqSsChassisTime");
    6: ATTR(PREFIX, "cpqSsChassisRsoStatus"), VALUE(=,14);
    7: ATTR(=, "cpqSsChassisIndex");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8025_14;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsChassisName = $V4;
    hpq_SsChassisTime = $V5;
    hpq_SsChassisRsoStatus = $V6;
    hpq_SsChassisIndex = $V7;
    hpq_val=$V6;
    msg = "Storage system recovery server option status change to evTimeoutError";
    hpq_info = PRINTF ( "Storage system recovery server option status changed to %d.", $V6);
END

#######################################################################
CLASS IM_8026_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8026_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFanStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system fan status changed to ok";
    hpq_info = PRINTF ( "All fans of storage system model %s on %s are working normally.", $V8, $V3);
END

CLASS IM_8026_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8026_3;
    severity = FATAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFanStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system fan status changed to failed";
    hpq_info = PRINTF ( "One or more fans of storage system model %s on %s have failed. The fan(s) should be replaced immediately to avoid hardware damage.", $V8, $V3);
END

CLASS IM_8026_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8026_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFanStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system fan status: noFan";
    hpq_info = PRINTF ( "Storage system model %s on %s does not support fan monitoring.", $V8, $V3);
END

CLASS IM_8026_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8026;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8026_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFanStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system fan status changed to degraded";
    hpq_info = PRINTF ( "At least one fan of storage system model %s on %s has failed, but there is sufficient cooling capacity to continue. The fan should be replaced.", $V8, $V3);
END


#######################################################################

CLASS IM_8027_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8027_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxTempStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system temperature status changed to ok";
    hpq_info = PRINTF ( "Temperature of storage system model %s on %s is within normal operating range.", $V8, $V3);
END

CLASS IM_8027_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8027_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxTempStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system temperature status changed to degraded";
    hpq_info = PRINTF ( "Temperature of storage system model %s on %s is outside of normal operating range.", $V8, $V3);
END

CLASS IM_8027_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8027_4;
    severity = FATAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxTempStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system temperature status changed to failed";
    hpq_info = PRINTF ( "The temperature could permanently damage the system. The storage system on %s will automatically shutdown if this condition is detected.", $V3);
END

CLASS IM_8027_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8027;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8027_5;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxTempStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system temperature status: noTemp";
    hpq_info = PRINTF ( "Storage system model %s on %s does not support temperature monitoring.", $V8, $V3);
END

#######################################################################
CLASS IM_8028_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8028_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFltTolPwrSupplyStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system power supply status changed to ok";
    hpq_info = PRINTF ( "There are no detected power supply failures on %s.", $V3);
END

CLASS IM_8028_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8028_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFltTolPwrSupplyStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system power supply status changed to degraded";
    hpq_info = PRINTF ( "One of the power supply units in a fault tolerant power supply on %s has failed.", $V3);
END

CLASS IM_8028_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8028_4;
    severity = FATAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFltTolPwrSupplyStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system power supply status changed to failed";
    hpq_info = PRINTF ( "A power supply unit has failed on %s. No failure conditions can currently be determined.", $V3);
END

CLASS IM_8028_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8028;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
    10: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8028_5;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxFltTolPwrSupplyStatus = $V10;
    hpq_val=$V10;
    msg = "Storage system power supply status: noFltTolPower";
    hpq_info = PRINTF ( "Storage system model %s on %s does not support fault tolerant power supply monitoring.", $V8, $V3);
END


#################################################################

CLASS IM_8029_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8029;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8029_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFanStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system fan status changed to ok";
    hpq_info = PRINTF ( "All fans of storage system at location %s on %s are working normally.", $V10, $V3);
END


CLASS IM_8029_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8029;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8029_3;
    severity = FATAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFanStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system fan status changed to failed";
    hpq_info = PRINTF ( "One or more fans of storage system at location %s on %s have failed. The fan(s) should be replaced immediately to avoid hardware damage.", $V10, $V3);
END

CLASS IM_8029_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8029;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8029_4;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFanStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system fan status: noFan";
    hpq_info = PRINTF ( "Storage system at location %s on %s does not support fan monitoring.", $V10, $V3);
END

CLASS IM_8029_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8029;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFanStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8029_5;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFanStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system fan status changed to degraded";
    hpq_info = PRINTF ( "At least one fan of storage system at location %s on %s has failed, but there is sufficient cooling capacity to continue. The fan should be replaced.", $V10, $V3);
END

######################################################################

CLASS IM_8030_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8030;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8030_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxTempStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system temperature status changed to ok";
    hpq_info = PRINTF ( "Temperature of storage system at location %s on %s is within normal operating range.", $V10, $V3);
END

CLASS IM_8030_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8030;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8030_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxTempStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system temperature status changed to degraded";
    hpq_info = PRINTF ( "Temperature of storage system at location %s on %s is outside of normal operating range.", $V10, $V3);
END


CLASS IM_8030_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8030;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8030_4;
    severity = FATAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxTempStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system temperature status changed to failed";
    hpq_info = PRINTF ( "The temperature could permanently damage the system. The storage system on %s at location %s will automatically shutdown if this condition is detected.", $V3, $V10);
END

CLASS IM_8030_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8030;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxTempStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8030_5;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxTempStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system temperature status: noTemp";
    hpq_info = PRINTF ( "Storage system at location %s on %s does not support temperature monitoring.", $V10, $V3);
END

#################################################################

CLASS IM_8031_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8031;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,2);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8031_2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFltTolPwrSupplyStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system power supply status changed to ok";
    hpq_info = PRINTF ( "There are no detected power supply failures on %s.", $V3);
END

CLASS IM_8031_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8031;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,3);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8031_3;
    severity = CRITICAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFltTolPwrSupplyStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system power supply status changed to degraded";
    hpq_info = PRINTF ( "One of the power supply units in a fault tolerant power supply on %s has failed.", $V3);
END

CLASS IM_8031_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8031;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,4);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8031_4;
    severity = FATAL;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFltTolPwrSupplyStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system power supply status changed to failed";
    hpq_info = PRINTF ( "A power supply unit has failed on %s. No failure conditions can currently be determined.", $V3);
END


CLASS IM_8031_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 8031;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSsBoxCntlrHwLocation");
    5: ATTR(=, "cpqSsBoxCntlrIndex");
    6: ATTR(=, "cpqSsBoxBusIndex");
    7: ATTR(=, "cpqSsBoxVendor");
    8: ATTR(=, "cpqSsBoxModel");
    9: ATTR(=, "cpqSsBoxSerialNumber");
   10: ATTR(=, "cpqSsBoxLocationString");
   11: ATTR(PREFIX, "cpqSsBoxFltTolPwrSupplyStatus"), VALUE(=,5);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 8031_5;
    severity = WARNING;
    hostname=$V3;
    hpq_SsBoxCntlrHwLocation = $V4;
    hpq_SsBoxCntlrIndex = $V5;
    hpq_SsBoxBusIndex = $V6;
    hpq_SsBoxVendor = $V7;
    hpq_SsBoxModel = $V8;
    hpq_SsBoxSerialNumber = $V9;
    hpq_SsBoxLocationString = $V10;
    hpq_SsBoxFltTolPwrSupplyStatus = $V11;
    hpq_val=$V11;
    msg = "Storage system power supply status: noFltTolPower";
    hpq_info = PRINTF ( "Storage system at location %s on %s does not support fault tolerant power supply monitoring.", $V10,$V3);
END




#########################################################
#####   Compaq Threshold Management Functions
#########################################################
CLASS IM_10005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 10005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqMeAlarmValue");
    5: ATTR(=, "cpqMeAlarmSampleType");
    6: ATTR(=, "cpqMeAlarmVariable");
    7: ATTR(=, "cpqMeAlarmRisingThreshold");
    8: ATTR(=, "cpqMeAlarmOwner");
    9: ATTR(=, "cpqMeAlarmSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 10005;
    severity = FATAL;
    hostname=$V3;
    hpq_value = $V4;
    hpq_variable = $V6;
    hpq_threshold = $V7;
    hpq_owner = $V8;
    msg = "Rising Threshold Passed";
    hpq_info = PRINTF ( "%s: Variable %s has value %s >= %s.", $V8, $V6, $V4, $V7);
END

######################################################################
CLASS IM_10006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 10006;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqMeAlarmValue");
    5: ATTR(=, "cpqMeAlarmSampleType");
    6: ATTR(=, "cpqMeAlarmVariable");
    7: ATTR(=, "cpqMeAlarmFallingThreshold");
    8: ATTR(=, "cpqMeAlarmOwner");
    9: ATTR(=, "cpqMeAlarmSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 10006;
    severity = FATAL;
    hostname=$V3;
    hpq_value = $V4;
    hpq_variable = $V6;
    hpq_threshold = $V7;
    hpq_owner = $V8;
    msg = "Falling Threshold Passed";
    hpq_info = PRINTF ( "%s: Variable %s has value %s <= %s.", $V8, $V6, $V4, $V7);
END

######################################################################
CLASS IM_10007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 10007;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqMeAlarmVariable");
    5: ATTR(=, "cpqMeAlarmSampleType");
    6: ATTR(=, "cpqMeAlarmValue");
    7: ATTR(=, "cpqMeAlarmRisingThreshold");
    8: ATTR(=, "cpqMeAlarmOwner");
    9: ATTR(=, "cpqMeAlarmSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 10007;
    severity = FATAL;
    hostname=$V3;
    hpq_MeAlarmVariable = $V4;
    hpq_MeAlarmSampleType = $V5;
    hpq_MeAlarmValue = $V6;
    hpq_MeAlarmRisingThreshold = $V7;
    hpq_MeAlarmOwner = $V8;
    hpq_MeAlarmSeverity = $V9;
    msg = "Critical Rising Threshold Passed";
    hpq_info = PRINTF ( "%s: Variable %s has value %d >= %d.", $V8, $V4, $V6, $V7);
END

######################################################################
CLASS IM_10008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 10008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqMeAlarmVariable");
    5: ATTR(=, "cpqMeAlarmSampleType");
    6: ATTR(=, "cpqMeAlarmValue");
    7: ATTR(=, "cpqMeAlarmFallingThreshold");
    8: ATTR(=, "cpqMeAlarmOwner");
    9: ATTR(=, "cpqMeAlarmSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 10008;
    severity = FATAL;
    hostname=$V3;
    hpq_MeAlarmVariable = $V4;
    hpq_MeAlarmSampleType = $V5;
    hpq_MeAlarmValue = $V6;
    hpq_MeAlarmFallingThreshold = $V7;
    hpq_MeAlarmOwner = $V8;
    hpq_MeAlarmSeverity = $V9;
    msg = "Critical Falling Threshold Passed";
    hpq_info = PRINTF ( "%s: Variable %s has value %d >= %d.", $V8, $V4, $V6, $V7);
END

#########################################################
#####   Compaq Uninterruptible Power Supply
#########################################################
CLASS IM_12006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12006;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqUpsEstimatedBatteryLife");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12006;
    severity = CRITICAL;
    hostname=$V3;
    hpq_UpsEstimatedBatteryLife = $V4;
    hpq_val = $V4;
    msg = "AC Line Failure";
    hpq_info = PRINTF ( "UPS has about %s minutes of power left.", $V4);
END

#######################################################################
CLASS IM_12007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12007;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12007;
    severity = HARMLESS;
    hostname=$V3;
    msg = "AC Line Power OK";
    hpq_info = "UPS reports AC line power has returned." ;
END

#######################################################################
CLASS IM_12008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12008;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12008;
    severity = CRITICAL;
    hostname=$V3;
    msg = "UPS Shutdown";
    hpq_info = "The UPS has initiated server shutdown." ;
END

#######################################################################
CLASS IM_12009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12009;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12009;
    severity = HARMLESS;
    hostname=$V3;
    msg = "UPS Confirmation";
    hpq_info = "Server now operational after UPS shutdown." ;
END

#######################################################################
CLASS IM_12010
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12010;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12010;
    severity = CRITICAL;
    hostname=$V3;
    msg = "UPS Battery Low";
    hpq_info = "Server will soon lose power." ;
END

#######################################################################
CLASS IM_12011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12011;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12011;
    severity = CRITICAL;
    hostname=$V3;
    msg = "UPS Overload";
    hpq_info = "The UPS has been overloaded." ;
END

#######################################################################
CLASS IM_12012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12012;
    3: ATTR(=, "sysName") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12012;
    severity = CRITICAL;
    hostname=$V3;
    msg = "UPS Pending Battery Failure";
    hpq_info = "The UPS battery is about to fail." ;
END

#######################################################################
CLASS IM_12013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12013;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqUpsAlarm") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12013;
    severity = CRITICAL;
    hostname=$V3;
    hpq_string = $V4;
    msg = "UPS Critical Alarm";
    hpq_info = PRINTF ( "%s", $V4);
END

#######################################################################
CLASS IM_12014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 12014;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqUpsAlarm") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 12014;
    severity = HARMLESS;
    hostname=$V3;
    hpq_string = $V4;
    msg = "Generic UPS informational alarm";
    hpq_info = PRINTF ( "%s", $V4);
END

#########################################################
#####   Compaq Operating System Management Functions
#########################################################
CLASS IM_19001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19001;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsCpuIndex");
    5: ATTR(=, "cpqOsCpuInstance");
    6: ATTR(=, "cpqOsCpuTimePercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19001;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsCpuIndex = $V4;
    hpq_OsCpuInstance = $V5;
    hpq_OsCpuTimePercent = $V6;
    msg = "The Processor Time performance property is set to degraded.";
    hpq_info = PRINTF ( "The Processor performance Instance, %s is degraded with Processor Time of %d percent.", $V5, $V6);
END

#####################################################################
CLASS IM_19002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19002;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsCpuIndex");
    5: ATTR(=, "cpqOsCpuInstance");
    6: ATTR(=, "cpqOsCpuTimePercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19002;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsCpuIndex = $V4;
    hpq_OsCpuInstance = $V5;
    hpq_OsCpuTimePercent = $V6;
    msg = "The Processor Time performance property is set to critical.";
    hpq_info = PRINTF ( "The Processor performance Instance, %s is critical with Processor Time of %d percent.", $V5, $V6);
END

#####################################################################
CLASS IM_19003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19003;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsCacheIndex");
    5: ATTR(=, "cpqOsCacheInstance");
    6: ATTR(=, "cpqOsCacheCopyReadHitsPercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19003;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsCacheIndex = $V4;
    hpq_OsCacheInstance = $V5;
    hpq_OsCacheCopyReadHitsPercent = $V6;
    msg = "The Cache CopyReadHits performance property is set to degraded.";
    hpq_info = PRINTF ( "The Cache performance property is degraded with CopyReadHits of %d percent.", $V5, $V6);
END

#####################################################################
CLASS IM_19004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19004;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsCacheIndex");
    5: ATTR(=, "cpqOsCacheInstance");
    6: ATTR(=, "cpqOsCacheCopyReadHitsPercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19004;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsCacheIndex = $V4;
    hpq_OsCacheInstance = $V5;
    hpq_OsCacheCopyReadHitsPercent = $V6;
    msg = "The Cache CopyReadHits performance property is set to critical.";
    hpq_info = PRINTF ( "The Cache performance property is critical with CopyReadHits of %d percent.", $V5, $V6);
END

#####################################################################
CLASS IM_19005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19005;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsPagingFileIndex");
    5: ATTR(=, "cpqOsPagingFileInstance");
    6: ATTR(=, "cpqOsPageFileUsagePercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19005;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsPagingFileIndex = $V4;
    hpq_OsPagingFileInstance = $V5;
    hpq_OsPageFileUsagePercent = $V6;
    msg = "The PagingFile Usage performance property is set to degraded.";
    hpq_info = PRINTF ( "The PagingFile performance instance, %s is degraded with PagingFile Usage of %d percent.", $V5, $V6);
END

#####################################################################
CLASS IM_19006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19006;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsPagingFileIndex");
    5: ATTR(=, "cpqOsPagingFileInstance");
    6: ATTR(=, "cpqOsPageFileUsagePercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19006;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsPagingFileIndex = $V4;
    hpq_OsPagingFileInstance = $V5;
    hpq_OsPageFileUsagePercent = $V6;
    msg = "The PagingFile Usage performance property is set to critical.";
    hpq_info = PRINTF ( "The PagingFile performance instance, %s is critical with PagingFile Usage of %d percent.", $V5, $V6);
END

#####################################################################
CLASS IM_19007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19007;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsLogicalDiskIndex");
    5: ATTR(=, "cpqOsLogicalDiskInstance");
    6: ATTR(=, "cpqOsLogicalDiskBusyTimePercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19007;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsLogicalDiskIndex = $V4;
    hpq_OsLogicalDiskInstance = $V5;
    hpq_OsLogicalDiskBusyTimePercent = $V6;
    msg = "The LogicalDisk BusyTime performance property is set to degraded.";
    hpq_info = PRINTF ( "The LogicalDisk performance instance, %s is degraded with DiskBusyTime of %d percent.", $V5, $V6);
END

#####################################################################
CLASS IM_19008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 19008;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqOsLogicalDiskIndex");
    5: ATTR(=, "cpqOsLogicalDiskInstance");
    6: ATTR(=, "cpqOsLogicalDiskBusyTimePercent");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 19008;
    severity = CRITICAL;
    hostname=$V3;
    hpq_OsLogicalDiskIndex = $V4;
    hpq_OsLogicalDiskInstance = $V5;
    hpq_OsLogicalDiskBusyTimePercent = $V6;
    msg = "The LogicalDisk BusyTime performance property is set to critical.";
    hpq_info = PRINTF ( "The LogicalDisk performance instance, %s is critical with DiskBusyTime of %d percent.", $V5, $V6);
END

#########################################################
#####   Common Cluster Management MIB version V2.0 
#########################################################
CLASS IM_100
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.18.22.4.1" ) ;
    2: $SPECIFIC = 100 ;
    3: ATTR(=, "svrCluMemberIndex" ) ;
    4: ATTR(=, "svrCluMemberName" ) ;
  FETCH
    1: IPNAME($AGENT_ADDR) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hostname = $F1;
    hpq_eventID = 100;
    severity = HARMLESS;
    hostname = $V4;
    hpq_svrCluMemberIndex = $V3;
    hpq_svrCluMemberName = $V4;
    msg = "A cluster member has been added";
    hpq_info = PRINTF("A cluster member named %s on index %d has been added", $V4, $V3);
END

#####################################################################
CLASS IM_101
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.18.22.4.1" ) ;
    2: $SPECIFIC = 101 ;
    3: ATTR(=, "svrCluMemberIndex" ) ;
    4: ATTR(=, "svrCluMemberName" ) ;
  FETCH
    1: IPNAME($AGENT_ADDR) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hostname = $F1;
    hpq_eventID = 101;
    severity = WARNING;
    hostname = $V4;
    hpq_svrCluMemberIndex = $V3;
    hpq_svrCluMemberName = $V4;
    msg = "A cluster member has been deleted";
    hpq_info = PRINTF("A cluster member named %s on index %d has been deleted", $V4, $V3);
END

# Insight extcds
#########################################################
#####   Compaq Steam = StorageWorks Enterprise Array Manager 
#########################################################
CLASS IM_Steam_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssDiskName" ) ;
    6: ATTR(=, "ssCabinetNumber" ) ;
    7: ATTR(=, "ssDiskPort" ) ;
    8: ATTR(=, "ssDiskTarget" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_1;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssDiskName = $V5;
    hpq_ssCabinetNumber = $V6;
    hpq_ssDiskPort = $V7;
    hpq_ssDiskTarget = $V8;
    sub_origin = $K5;
    msg = "Disk device has failed";
    hpq_info = PRINTF("Disk %s in cabinet %d located on port %d; target %d on host: %s; subsystem: %s has failed.", $V5, $V6, $V7, $V8, $V3, $V4);
END

######################################################################
CLASS IM_Steam_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 2;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssDiskName" ) ;
    6: ATTR(=, "ssCabinetNumber" ) ;
    7: ATTR(=, "ssDiskPort" ) ;
    8: ATTR(=, "ssDiskTarget" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_2;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssDiskName = $V5;
    hpq_ssCabinetNumber = $V6;
    hpq_ssDiskPort = $V7;
    hpq_ssDiskTarget = $V8;
    sub_origin = $K5;
    msg = "A disk drive has recovered";
    hpq_info = PRINTF("Disk %s in cabinet %d located on port %d; target %d on host: %s; subsystem: %s has recovered.", $V5, $V6, $V7, $V8, $V3, $V4);
END

######################################################################
CLASS IM_Steam_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 3;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
    6: ATTR(=, "ssPowerSupplyLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_3;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    hpq_ssPSLocation = $V6;
    sub_origin = $K6;
    msg = "Power supply device has failed";
    hpq_info = PRINTF("Power supply %s in cabinet %d on host: %s; subsystem: %s has failed.", $V6, $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 4;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
    6: ATTR(=, "ssPowerSupplyLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_4;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    hpq_ssPSLocation = $V6;
    sub_origin = $K6;
    msg = "Power supply has recovered";
    hpq_info = PRINTF("Power supply %s in cabinet %d on host: %s; subsystem: %s has recovered.", $V6, $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 5;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
    6: ATTR(=, "ssFanLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_5;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    hpq_ssFanLocation = $V6;
    sub_origin = $K6;
    msg = "Fan device has failed";
    hpq_info = PRINTF("Fan %s in cabinet %d on host: %s; subsystem: %s has failed.",  $V6, $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 6;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
    6: ATTR(=, "ssFanLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_6;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    hpq_ssFanLocation = $V6;
    sub_origin = $K6;
    msg = "Fan device has recovered";
    hpq_info = PRINTF("Fan %s in cabinet %d on host: %s; subsystem: %s has recovered.",  $V6, $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_7  
SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 7;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCacheBatteryLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_7;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCacheBattLoc = $V5;
    sub_origin = $K5;
    msg = "Cache battery device has failed";
    hpq_info = PRINTF("Cache Battery %s on host: %s; subsystem: %s has failed.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_8  
SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 8;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCacheBatteryLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_8;
    severity = WARNING;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCacheBattLoc = $V5;
    sub_origin = $K5;
    msg = "Cache battery device has LOW state";
    hpq_info = PRINTF("Cache Battery %s on host: %s; subsystem: %s has LOW state.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_9  
SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 9;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCacheBatteryLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_9;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCacheBattLoc = $V5;
    sub_origin = $K5;
    msg = "Cache battery device has good state";
    hpq_info = PRINTF("Cache Battery %s on host: %s; subsystem: %s has good state.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_10
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 10;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
    6: ATTR(=, "ssTemperatureSensorLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_10;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    hpq_ssTempSensorLoc = $V6;
    sub_origin = $K6;
    msg = "Temperature device has exceeded WARNING threshold limit";
    hpq_info = PRINTF("Temperature Sensor %s in cabinet %d on host: %s; subsystem: %s has exceeded WARNING threshold limit.", $V6, $V5, $V3, $V4);
END

###################################################################
CLASS IM_Steam_11
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 11;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
    6: ATTR(=, "ssTemperatureSensorLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_11;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    hpq_ssTempSensorLoc = $V6;
    sub_origin = $K6;
    msg = "Temperature device indicates below WARNING threshold limit";
    hpq_info = PRINTF("Temperature Sensor %s in cabinet %d on host: %s; subsystem: %s indicates below WARNING threshold limit.", $V6, $V5, $V3, $V4);
END

###################################################################
CLASS IM_Steam_12 
 SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 12;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_12;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    sub_origin = $K4;
    msg = "Agent communication with subsystem lost";
    hpq_info = PRINTF("Agent on host: %s; subsystem: %s has lost communication with subsystem.", $V3, $V4);
END

###################################################################
CLASS IM_Steam_13  
SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 13;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_13;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    sub_origin = $K4;
    msg = "Agent communication with subsystem recovered";
    hpq_info = PRINTF("Agent on host: %s; subsystem: %s has recovered communication with subsystem.", $V3, $V4);
END

######################################################################
CLASS IM_Steam_14 
 SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 14;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_14;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    sub_origin = $K4;
    msg = "The Secondary Controller has failed";
    hpq_info = PRINTF("The Secondary Controller on host: %s; subsystem: %s has failed.", $V3, $V4);
END

######################################################################
CLASS IM_Steam_15 
 SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 15;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_15;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    sub_origin = $K4;
    msg = "The Secondary Controller has recovered";
    hpq_info = PRINTF("The Secondary Controller on host: %s; subsystem: %s has recovered.", $V3, $V4);
END

######################################################################
CLASS IM_Steam_16 
 SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 16;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssLunName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_16;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssLunName = $V5;
    sub_origin = $K5;
    msg = "A LUN has failed";
    hpq_info = PRINTF("LUN %s on host: %s; subsystem: %s has failed.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_17 
 SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 17;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssLunName" ) ;
  MAP

    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_17;
    severity = WARNING;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssLunName = $V5;
    sub_origin = $K5;
    msg = "A LUN has started the reconstruction process";
    hpq_info = PRINTF("LUN %s on host: %s; subsystem: %s is now in reconstruct mode.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_18 
 SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 18;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssLunName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_18;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssLunName = $V5;
    sub_origin = $K5;
    msg = "A LUN has become degraded";
    hpq_info = PRINTF("LUN %s on host: %s; subsystem: %s is now degraded.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_19 
 SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 19;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssLunName" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_19;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssLunName = $V5;
    sub_origin = $K5;
    msg = "A LUN has become optimal";
    hpq_info = PRINTF("LUN %s on host: %s; subsystem: %s is now optimal.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_20
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 20;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_20;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    sub_origin = $K5;
    msg = "The External Input to the EMU indicates a failure";
    hpq_info = PRINTF("The External Input to the EMU in cabinet %d on host: %s; subsystem: %s indicates a failure.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_21
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 21;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCabinetNumber" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_21;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCabinetNumber = $V5;
    sub_origin = $K5;
    msg = "The External Input to the EMU indicates a recovery";
    hpq_info = PRINTF("The External Input to the EMU in cabinet %d on host: %s; subsystem: %s indicates a recovery.", $V5, $V3, $V4);
END

######################################################################
CLASS IM_Steam_22
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.36.2.15.21" ) ;
    2: $SPECIFIC = 22;
    3: ATTR(=, "agHostName" ) ;
    4: ATTR(=, "ssSubsysName" ) ;
    5: ATTR(=, "ssCacheBatteryLocation" ) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Steam_22;
    severity = WARNING;
    hostname = $V3;
    hpq_ssSubsysName = $V4;
    hpq_ssCacheBattLoc = $V5;
    sub_origin = $K5;
    msg = "Cache battery device has unknown state";
    hpq_info = PRINTF("Cache Battery %s on host: %s; subsystem: %s has unknown state.", $V5, $V3, $V4);
END

#########################################################
#####   Kzpcc, Compaq StorageWorks Command Console
#########################################################

CLASS IM_Kzpcc_1_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" );
    2: $SPECIFIC = 1;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,1) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_1_1;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Physical Device Event Trap: informational";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Kzpcc_1_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" );
    2: $SPECIFIC = 1;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,2) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Kzpcc_1_2;
    severity = WARNING;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_1_2;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Physical Device Event Trap: warning";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Kzpcc_1_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" );
    2: $SPECIFIC = 1;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,3) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_1_3;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Physical Device Event Trap: error";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

######################################################################
CLASS IM_Kzpcc_2_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" ) ;
    2: $SPECIFIC = 2;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,1) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_2_1;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Virtual Device Event Trap: informational";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Kzpcc_2_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" );
    2: $SPECIFIC = 2;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,2) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_2_2;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Virtual Device Event Trap: warning";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Kzpcc_2_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" );
    2: $SPECIFIC = 2;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,3) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_2_3;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Virtual Device Event Trap: error";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

######################################################################
CLASS IM_Kzpcc_3_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" ) ;
    2: $SPECIFIC = 3;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,1) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_3_1;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Subsystem Event Trap: informational";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Kzpcc_3_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" );
    2: $SPECIFIC = 3;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,2) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_3_2;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Subsystem Event Trap: warning";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Kzpcc_3_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.4.1" );
    2: $SPECIFIC = 3;
    3: ATTR(=, "cpqSwccKzpccSystemName") ;
    4: ATTR(=, "cpqSwccKzpccSubsystemName") ;
    5: ATTR(PREFIX, "cpqSwccKzpccEventSeverity"), VALUE(=,3) ;
    6: ATTR(=, "cpqSwccKzpccEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_eventID = Kzpcc_3_3;
    hpq_SwccKzpccSystemName = $V3;
    hpq_SwccKzpccSubsystemName = $V4;
    hpq_SwccKzpccEventSeverity = $V5;
    hpq_SwccKzpccEventDescription = $V6;
    msg = "Kzpcc Subsystem Event Trap: error";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

#########################################################
#####   StorgeWorks Fibre Device Status
#########################################################
CLASS IM_Fibre_1_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.2" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccFibreDevName") ;
    5: ATTR(PREFIX, "cpqSwccFibreDevState"), VALUE(=,2) ;
    6: ATTR(=, "cpqSwccFibreEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hostname=$V3;
    hpq_eventID = Fibre_1_2;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccFibreDevName = $V4;
    hpq_SwccFibreDevState = $V5;
    hpq_SwccFibreEventDescription = $V6;
    msg = "Fibre Device Status: ok";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Fibre_1_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.2" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccFibreDevName") ;
    5: ATTR(PREFIX, "cpqSwccFibreDevState"), VALUE(=,3) ;
    6: ATTR(=, "cpqSwccFibreEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hostname=$V3;
    hpq_eventID = Fibre_1_3;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccFibreDevName = $V4;
    hpq_SwccFibreDevState = $V5;
    hpq_SwccFibreEventDescription = $V6;
    msg = "Fibre Device Status: degraded";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Fibre_1_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.2" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccFibreDevName") ;
    5: ATTR(PREFIX, "cpqSwccFibreDevState"), VALUE(=,4) ;
    6: ATTR(=, "cpqSwccFibreEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hostname=$V3;
    hpq_eventID = Fibre_1_4;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccFibreDevName = $V4;
    hpq_SwccFibreDevState = $V5;
    hpq_SwccFibreEventDescription = $V6;
    msg = "Fibre Device Status: failed";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

#########################################################
#####   StorageWorks Tape Controller Status
#########################################################

CLASS IM_Tape_2_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.2" ) ;
    2: $SPECIFIC = 2;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccFibreDevName") ;
    5: ATTR(PREFIX, "cpqSwccFibreDevState"), VALUE(=,2) ;
    6: ATTR(=, "cpqSwccFibreEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hpq_eventID = Tape_2_2;
    hostname=$V3;
    hpq_SwccFibreDevName = $V4;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccFibreDevState = $V5;
    hpq_desc = $V6;
    msg = "Tape Controller Status: ok";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Tape_2_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.2" ) ;
    2: $SPECIFIC = 2;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccFibreDevName") ;
    5: ATTR(PREFIX, "cpqSwccFibreDevState"), VALUE(=,3) ;
    6: ATTR(=, "cpqSwccFibreEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hpq_eventID = Tape_2_3;
    hostname=$V3;
    hpq_SwccFibreDevName = $V4;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccFibreDevState = $V5;
    hpq_desc = $V6;
    msg = "Tape Controller Status: degraded";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Tape_2_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.2" ) ;
    2: $SPECIFIC = 2;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccFibreDevName") ;
    5: ATTR(PREFIX, "cpqSwccFibreDevState"), VALUE(=,4) ;
    6: ATTR(=, "cpqSwccFibreEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hpq_eventID = Tape_2_4;
    hostname=$V3;
    hpq_SwccFibreDevName = $V4;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccFibreDevState = $V5;
    hpq_desc = $V6;
    msg = "Tape Controller Status: failed";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

#########################################################
#####   EMU Device Manager Device
#########################################################
CLASS IM_Emu_1_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.3" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccEmuDevDevName") ;
    5: ATTR(PREFIX, "cpqSwccEmuDevDevState"), VALUE(=,2) ;
    6: ATTR(=, "cpqSwccEmuDevEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = HARMLESS;
    hpq_eventID = Emu_1_2;
    hostname=$V3;
    hpq_SwccEmuDevDevName = $V4;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccEmuDevDevState = $V5;
    hpq_desc = $V6;
    msg = "EMU Device Manager Device Status: ok";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Emu_1_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.3" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccEmuDevDevName") ;
    5: ATTR(PREFIX, "cpqSwccEmuDevDevState"), VALUE(=,3) ;
    6: ATTR(=, "cpqSwccEmuDevEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = CRITICAL;
    hpq_eventID = Emu_1_3;
    hostname=$V3;
    hpq_SwccEmuDevDevName = $V4;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccEmuDevDevState = $V5;
    hpq_desc = $V6;
    msg = "EMU Device Manager Device Status: degraded";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END

CLASS IM_Emu_1_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.132.3" ) ;
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "cpqSwccEmuDevDevName") ;
    5: ATTR(PREFIX, "cpqSwccEmuDevDevState"), VALUE(=,4) ;
    6: ATTR(=, "cpqSwccEmuDevEventDescription") ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = FATAL;
    hpq_eventID = Emu_1_4;
    hostname=$V3;
    hpq_SwccEmuDevDevName = $V4;
    hpq_val = $V5;
    sub_origin = $K5;
    hpq_SwccEmuDevDevState = $V5;
    hpq_desc = $V6;
    msg = "EMU Device Manager Device Status: failed";
    hpq_info = PRINTF ( "The following event occured on %s: %s", $V3, $V6 );
END
#######################################################################
###########	Power Device management (cpqpower.mib)		#######################
####################################################################### 

CLASS IM_Pwr_1 
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.165" );
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "trapCode");
    5: ATTR(=, "trapDescription");
    6: ATTR(=, "trapDeviceName");
    7: ATTR(=, "trapDeviceDetails");
    8: ATTR(=, "trapDeviceMgmtUrl");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Pwr_1;
    severity = FATAL;
    hostname = $V3;
    hpq_trapCode = $V4;
    hpq_trapDescription = $V5;
    hpq_trapDeviceName = $V6;
    hpq_trapDeviceDetails = $V7;
    hpq_trapDeviceMgmtUrl = $V8;
    msg = "A Critical Alarm has occured.";
    hpq_info = PRINTF ("A Critical Alarm has occured on %s", $V3);
END
###########################################################################

CLASS IM_Pwr_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.165" );
    2: $SPECIFIC = 2;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "trapCode");
    5: ATTR(=, "trapDescription");
    6: ATTR(=, "trapDeviceName");
    7: ATTR(=, "trapDeviceDetails");
    8: ATTR(=, "trapDeviceMgmtUrl");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID =Pwr_2;
    severity = WARNING;
    hostname = $V3;
    hpq_trapCode = $V4;
    hpq_trapDescription = $V5;
    hpq_trapDeviceName = $V6;
    hpq_trapDeviceDetails = $V7;
    hpq_trapDeviceMgmtUrl = $V8;
    msg = "A Warning Alarm has occured.";
    hpq_info = PRINTF ("A Warning Alarm has occured on %s", $V3);
END
###########################################################################

CLASS IM_Pwr_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.165" );
    2: $SPECIFIC = 3;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "trapCode");
    5: ATTR(=, "trapDescription");
    6: ATTR(=, "trapDeviceName");
    7: ATTR(=, "trapDeviceDetails");
    8: ATTR(=, "trapDeviceMgmtUrl");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Pwr_3;
    severity = HARMLESS;
    hostname=$V3;
    hpq_trapCode = $V4;
    hpq_trapDescription = $V5;
    hpq_trapDeviceName = $V6;
    hpq_trapDeviceDetails = $V7;
    hpq_trapDeviceMgmtUrl = $V8;
    msg = "An Informational Alarm has occured.";
    hpq_info = PRINTF ("An Informational Alarm has occured on %s", $V3);
END
###########################################################################

CLASS IM_Pwr_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.165" );
    2: $SPECIFIC = 4;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "trapCode");
    5: ATTR(=, "trapDescription");
    6: ATTR(=, "trapDeviceName");
    7: ATTR(=, "trapDeviceDetails");
    8: ATTR(=, "trapDeviceMgmtUrl");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Pwr_4;
    severity = HARMLESS;
    hostname = $V3;
    hpq_trapCode = $V4;
    hpq_trapDescription = $V5;
    hpq_trapDeviceName = $V6;
    hpq_trapDeviceDetails = $V7;
    hpq_trapDeviceMgmtUrl = $V8;
    msg = "An Alarm has cleared.";
    hpq_info = PRINTF ("An Alarm has cleared on %s", $V3);
END
###########################################################################

CLASS IM_Pwr_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.165" );
    2: $SPECIFIC = 5;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "trapCode");
    5: ATTR(=, "trapDescription");
    6: ATTR(=, "trapDeviceName");
    7: ATTR(=, "trapDeviceDetails");
    8: ATTR(=, "trapDeviceMgmtUrl");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Pwr_5;
    severity = HARMLESS;
    hostname = $V3;
    hpq_trapCode = $V4;
    hpq_trapDescription = $V5;
    hpq_trapDeviceName = $V6;
    hpq_trapDeviceDetails = $V7;
    hpq_trapDeviceMgmtUrl = $V8;
    msg = "Test Trap sent to a trap receiver to check proper reception of traps.";
    hpq_info = PRINTF ("Test Trap sent to a trap receiver to check proper reception of traps on %s", $V3);
END
###########################################################################

CLASS IM_Pwr_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.165" );
    2: $SPECIFIC = 6;
    3: ATTR(=, "sysName") ;
    4: ATTR(=, "deviceIdentName");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = Pwr_6;
    severity = HARMLESS;
    hostname = $V3;
    hpq_deviceIdentName = $V4;
    msg = "A power device is initialized.";
    hpq_info = PRINTF ("A power device is initialized on %s", $V3);
END

#########################################################
#####   Compaq STORAGEWORKS SanW
#########################################################

CLASS IM_SanW_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.151.11" );
    2: $SPECIFIC = 1;
    3: ATTR(=, "swSystemName" );
    4: ATTR(=, "swSystemType" );
    5: ATTR(=, "swEventName" );
    6: ATTR(=, "swFailure" );
    7: ATTR(=, "swSequence" );
  FETCH
    1: IPNAME($AGENT_ADDR) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = SanW_1;
    severity = CRITICAL;
    hostname = $F1;
    hpq_swSystemName = $V3;
    hpq_swSystemType = $V4;
    hpq_swEventName = $V5;
    hpq_swFailure = $V6;
    hpq_swSequence = $V7;
    sub_origin = $K4;
    msg = "Failure Event";
    hpq_info = PRINTF("Failure event detected - element %s of Type %d sent notification %s %s.", $V3, $V4, $V5, $V6);
END

###############################################################
CLASS IM_SanW_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.151.11" );
    2: $SPECIFIC = 2;
    3: ATTR(=, "swSystemName" );
    4: ATTR(=, "swSystemType" );
    5: ATTR(=, "swEventName" );
    6: ATTR(=, "swFailure" );
    7: ATTR(=, "swSequence" );
  FETCH
    1: IPNAME($AGENT_ADDR) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hostname = $F1;
    hpq_eventID = SanW_2;
    severity = WARNING;
    hostname = $V3;
    hpq_swSystemName = $V3;
    hpq_swSystemType = $V4;
    hpq_swEventName = $V5;
    hpq_swFailure = $V6;
    hpq_swSequence = $V7;
    sub_origin = $K4;
    msg = "Warning Event";
    hpq_info = PRINTF("Warning event detected - element %s of Type %d sent notification %s %s.", $V3, $V4, $V5, $V6);
END

###############################################################
CLASS IM_SanW_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.151.11" );
    2: $SPECIFIC = 4;
    3: ATTR(=, "swSystemName" );
    4: ATTR(=, "swSystemType" );
    5: ATTR(=, "swEventName" );
    6: ATTR(=, "swFailure" );
    7: ATTR(=, "swSequence" );
  FETCH
    1: IPNAME($AGENT_ADDR) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hostname = $F1;
    hpq_eventID = SanW_4;
    severity = HARMLESS;
    hostname = $V3;
    hpq_swSystemName = $V3;
    hpq_swSystemType = $V4;
    hpq_swEventName = $V5;
    hpq_swFailure = $V6;
    hpq_swSequence = $V7;
    sub_origin = $K4;
    msg = "Information Event";
    hpq_info = PRINTF("Information event detected - element %s of Type %d sent notification %s %s.", $V3, $V4, $V5, $V6);
END

#############################################################################
##############	     Rack and Power Manager (RPM) MIB		#############
##############################################################################
CLASS IM_RPM_1
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = RPM_1;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "Device connected";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_RPM_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 2;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = RPM_2;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "Connection Lost";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_RPM_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 3;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = RPM_3;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "CRPM failed to find an IP address for the device hostname";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_RPM_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 4;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = RPM_4;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "CRPM failed to connect to a drive";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_RPM_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 5;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = RPM_5;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "Device settings have been changed by an user";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20001;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20001;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting input voltage below minimum threshold";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20002;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20002;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting input voltage above maximum threshold";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20003;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20003;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting input voltage is normal";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20011;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20011;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting output voltage is below minimum threshold";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20012;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20012;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting output voltage above maximum threshold";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21020
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21020;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21020;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting output voltage is normal";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20014;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20014;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting an overload condition";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20015
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20015;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20015;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting an overload condition has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21055
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21055;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21055;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting low battery";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21056
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21056;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21056;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting low battery has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20022
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20022;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20022;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is a depleted battery";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20023
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20023;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20023;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting battery level is normal";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21063
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21063;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21063;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting on battery condition";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20032
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20032;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20032;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is being bypassed";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21029
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21029;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21029;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting an On Buck condition";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21031
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21031;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21031;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting an On Boost condition";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21064
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21064;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21064;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting on utility power condition";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20101
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20101;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20101;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting temperature below minimum threshold";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20102
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20102;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20102;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting temperature above maximum threshold";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20103
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20103;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20103;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting temperature is normal";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20111
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20111;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20111;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a general UPS failure";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20112
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20112;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20112;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a general UPS failure has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20121
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20121;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20121;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a battery failure";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20122
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20122;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20122;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a battery failure has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20131
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20131;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20131;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting a diagnostic test failed";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20132
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20132;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20132;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting a diagnostic test succeeded";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20141
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20141;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20141;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "Input (Utility) fault: measured input frequency is outside of either the upper or lower  frequency limit specification for normal operation.";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20142
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20142;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20142;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "A UPS device is reporting measured input frequency is normal";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_29998
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 29998;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 29998;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "The UPS has been started on battery when AC input power is not present";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_29999
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 29999;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 29999;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "The UPS has been started on utility while AC input power is present";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20161
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20161;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20161;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting bypass not available";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20162
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20162;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20162;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting bypass not available has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20171
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20171;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20171;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "Indicates that the utility input power is not within predetermined limits";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20172
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20172;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20172;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "Indicates that the utility input power is within predetermined limits";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20181
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20181;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20181;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "Indicates that the utility input is not present. The detected voltage is zero in this  case";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20182
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20182;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20182;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "Indicates that the utility input is present";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20191
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20191;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20191;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "The bypass has been given a manual turn on command";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20192
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20192;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20192;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    msg = "The bypass has been given a manual turn off command";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20201
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20201;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20201;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a fault in input wiring, other than Phase Rotation";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20202
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20202;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20202;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a site wiring fault has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21060
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21060;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21060;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting it is no longer in manual bypass mode";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21059
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21059;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21059;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is operating in manual bypass mode";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20152
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20152;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20152;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting utility power has been restored";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_20151
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 20151;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 20151;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device has been started while on battery power. AC input power is not present";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21022
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21022;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21022;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting input voltage is normal";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21021
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21021;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21021;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting input voltage is out of range";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21007;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21007;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting temperature is out of range";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21008;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21008;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting temperature is normal";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21047
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21047;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21047;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is operating in auto bypass mode";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21048
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21048;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21048;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting it is no longer on auto bypass";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21019
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21019;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21019;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting output voltage is out of range";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21053
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21053;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21053;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting batteries are not connected to the UPS";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21054
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21054;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21054;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting all UPS batteries have been reconnected";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21057
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21057;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21057;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting batteries are completely discharged";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21058
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21058;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21058;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting all UPS batteries have been charged";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21041
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21041;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21041;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting an output Breaker or Relay has failed or may be stuck open or  closed with this alarm";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21042
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21042;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21042;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting all Breakers are functioning normally";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21037
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21037;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21037;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting an Emergency Power Off (EPO) command has been received to  shutdown the UPS immediately with out delay. This command may come from a local control panel or  from a remote source";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21033
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21033;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21033;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "The UPS has been powered off with user interaction";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21034
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21034;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21034;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting UPS output has been restored";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21045
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21045;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21045;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a cover panel has been removed while utility power is  present";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21046
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21046;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21046;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a cover panel has been replaced";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21035
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21035;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21035;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a fan failure has occurred";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21036
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21036;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21036;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a fan failure has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21023
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21023;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21023;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a loss of redundancy";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21024
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21024;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21024;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a loss of redundancy cleared or configuration has changed from  N+1 to Capacity";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21013;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21013;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a shutdown imminent condition";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21014;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21014;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a shutdown imminent condition has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21011;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21011;
    severity = CRITICAL;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a shutdown pending condition";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_21012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 21012;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapDescription");
    5: ATTR(=, "cpqRPMTrapDeviceId");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapDeviceAddress");
    8: ATTR(=, "cpqRPMTrapType");
    9: ATTR(=, "cpqRPMTrapSeverity");
    10: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 21012;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapDescription = $V4;
    hpq_RPMTrapDeviceId = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapDeviceAddress = $V7;
    hpq_RPMTrapType = $V8;
    hpq_RPMTrapSeverity = $V9;
    hpq_RPMTrapURL = $V10;
    msg = "A UPS device is reporting a shutdown pending condition has been cleared";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_PM_1
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 1;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapCode");
    5: ATTR(=, "cpqRPMTrapDescription");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = PM_1;
    severity = FATAL;
    hostname = $V3;
    hpq_RPMTrapCode = $V4;
    hpq_RPMTrapDescription = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapURL = $V7;
    msg = "A critical alarm has occurred";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_PM_2
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 2;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapCode");
    5: ATTR(=, "cpqRPMTrapDescription");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = PM_2;
    severity = WARNING;
    hostname = $V3;
    hpq_RPMTrapCode = $V4;
    hpq_RPMTrapDescription = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapURL = $V7;
    msg = "A warning alarm has occurred";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_PM_3
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 3;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapCode");
    5: ATTR(=, "cpqRPMTrapDescription");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = PM_3;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapCode = $V4;
    hpq_RPMTrapDescription = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapURL = $V7;
    msg = "An information alarm has occurred";
    hpq_info = PRINTF("%s", $V4);
END

###########################################################################################
CLASS IM_PM_4
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.232.154");
    2: $SPECIFIC = 4;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqRPMTrapCode");
    5: ATTR(=, "cpqRPMTrapDescription");
    6: ATTR(=, "cpqRPMTrapDeviceName");
    7: ATTR(=, "cpqRPMTrapURL");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = PM_4;
    severity = HARMLESS;
    hostname = $V3;
    hpq_RPMTrapCode = $V4;
    hpq_RPMTrapDescription = $V5;
    hpq_RPMTrapDeviceName = $V6;
    hpq_RPMTrapURL = $V7;
    msg = "An alarm has cleared";
    hpq_info = PRINTF("%s", $V4);
END


#######################################################################
###########	Blade Type-2 (BT2) MIB		#######################
####################################################################### 
CLASS IM_BT2_1
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 1;
  FETCH
    1: IPNAME($AGENT_ADDR) ;
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_1;
    severity = FATAL;
    hostname = $F1;
    msg = "The primary power supply failed";
    hpq_info = PRINTF("Primary power supply failed on %s", $F1);
END

################################################################################
CLASS IM_BT2_2
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 2;
    3: ATTR(=, "ipCurCfgGwIndex");
    4: ATTR(=, "ipCurCfgGwAddr");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_2;
    severity = HARMLESS;
    hpq_ipCurCfgGwIndex = $V3;
    hpq_ipCurCfgGwAddr = $V4;
    hostname = $V5;
    hpq_contact = $V6;
    hpq_location = $V7;
    msg = "The default gateway is alive";
    hpq_info = PRINTF("The default gateway with address %s on %s is alive", $V4, $V5);
END

############################################################################### 
CLASS IM_BT2_3
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 3;
    3: ATTR(=, "ipCurCfgGwIndex");
    4: ATTR(=, "ipCurCfgGwAddr");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_3;
    severity = HARMLESS;
    hpq_ipCurCfgGwIndex = $V3;
    hpq_ipCurCfgGwAddr = $V4;
    hostname = $V5;
    hpq_contact = $V6;
    hpq_location = $V7;
    msg = "The default gateway is down";
    hpq_info = PRINTF("The default gateway with address %s on %s is down", $V4, $V5);
END

############################################################################### 
CLASS IM_BT2_4
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 4;
    3: ATTR(=, "ipCurCfgGwIndex");
    4: ATTR(=, "ipCurCfgGwAddr");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_4;
    severity = HARMLESS;
    hpq_ipCurCfgGwIndex = $V3;
    hpq_ipCurCfgGwAddr = $V4;
    hostname = $V5;
    hpq_contact = $V6;
    hpq_location = $V7;
    msg = "The default gateway is up and in service";
    hpq_info = PRINTF("The default gateway with address %s on %s is up and in service", $V4, $V5);
END

############################################################################### 
CLASS IM_BT2_5
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 5;
    3: ATTR(=, "ipCurCfgGwIndex");
    4: ATTR(=, "ipCurCfgGwAddr");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_5;
    severity = HARMLESS;
    hpq_ipCurCfgGwIndex = $V3;
    hpq_ipCurCfgGwAddr = $V4;
    hostname = $V5;
    hpq_contact = $V6;
    hpq_location = $V7;
    msg = "The default gateway is alive but not in service";
    hpq_info = PRINTF("The default gateway with address %s on %s is alive but not in service", $V4,  $V5);
END

############################################################################### 
CLASS IM_BT2_16
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 16;
    3: ATTR(=, "vrrpCurCfgVirtRtrIndx");
    4: ATTR(=, "vrrpCurCfgVirtRtrAddr");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_16;
    severity = HARMLESS;
    hpq_vrrpCurCfgVirtRtrIndx = $V3;
    hpq_vrrpCurCfgVirtRtrAddr = $V4;
    hostname = $V5;
    hpq_contact = $V6;
    hpq_location = $V7;
    msg = "The sending agent has transitioned to 'Master' state";
    hpq_info = PRINTF("The sending agent with index %d and address %s on %s has transitioned to  'Master' state", $V3, $V4, $V5);
END

############################################################################### 
CLASS IM_BT2_17
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 17;
    3: ATTR(=, "vrrpCurCfgVirtRtrIndx");
    4: ATTR(=, "vrrpCurCfgVirtRtrAddr");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_17;
    severity = HARMLESS;
    hpq_vrrpCurCfgVirtRtrIndx = $V3;
    hpq_vrrpCurCfgVirtRtrAddr = $V4;
    hostname = $V5;
    hpq_contact = $V6;
    hpq_location = $V7;
    msg = "The sending agent has transitioned to 'Backup' state";
    hpq_info = PRINTF("The sending agent with index %d and address %s on %s has transitioned to  'Backup' state", $V3, $V4, $V5);
END

############################################################################### 
CLASS IM_BT2_18
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 18;
    3: ATTR(=, "vrrpCurCfgIfIndx");
    4: ATTR(=, "vrrpCurCfgIfPasswd");
    5: ATTR(=, "sysName");
    6: ATTR(=, "sysLocation");
    7: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_18;
    severity = CRITICAL;
    hpq_vrrpCurCfgIfIndx = $V3;
    hpq_vrrpCurCfgIfPasswd = $V4;
    hostname = $V5;
    hpq_contact = $V6;
    hpq_location = $V7;
    msg = "Authentication failure";
    hpq_info = PRINTF("a packet has been received from a router whose authentication key or  authentication type conflicts with the authentication key or authentication type of the router on  %s", $V5);
END

############################################################################### 
CLASS IM_BT2_19
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 19;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_19;
    severity = CRITICAL;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "Login failure";
    hpq_info = PRINTF("A valid username/password combination was not entered on %s", $V4);
END

############################################################################### 
CLASS IM_BT2_22
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 22;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_22;
    severity = FATAL;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "The switch temperature has exceeded maximum safety limits";
    hpq_info = PRINTF("The switch temperature on %s has exceeded maximum safety limits", $V4);
END

############################################################################### 
CLASS IM_BT2_26
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 26;
    3: ATTR(=, "agRackId");
    4: ATTR(=, "agChassis");
    5: ATTR(=, "agSlotNumber");
    6: ATTR(=, "sysName");
    7: ATTR(=, "sysLocation");
    8: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_26;
    severity = HARMLESS;
    hpq_agRackId = $V3;
    hpq_agChassis = $V4;
    hpq_agSlotNumber = $V5;
    hostname = $V6;
    hpq_contact = $V7;
    hpq_location = $V8;
    msg = "The rack location has been changed";
    hpq_info = PRINTF("The location of rack with ID %s and slot %d on %s has changed", $V3, $V5,  $V6);
END

############################################################################### 
CLASS IM_BT2_27
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 27;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_27;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "A new configuration has been applied";
    hpq_info = PRINTF("A new configuration has been applied on %s", $V4);
END

############################################################################### 
CLASS IM_BT2_28
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 28;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_28;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "The new configuration has been saved";
    hpq_info = PRINTF("The new configuration has been saved on %s", $V4);
END

############################################################################### 
CLASS IM_BT2_29
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 29;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_29;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "The firmware has been downloaded";
    hpq_info = PRINTF("The firmware has been downloaded to [image1|image2|boot image] on %s", $V4);
END

############################################################################### 
CLASS IM_BT2_30
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 30;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_30;
    severity = WARNING;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "The firmware downloaded failed";
    hpq_info = PRINTF("The firmware downloaded failed to [image1|image2|boot image] on %s", $V4);
END

############################################################################### 
CLASS IM_BT2_31
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 31;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_31;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "The switch temperature has returned below maximum safety limits";
    hpq_info = PRINTF("The switch temperature on %s has returned below maximum safety limits",  $V4);
END

############################################################################### 
CLASS IM_BT2_32
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 32;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_32;
    severity = CRITICAL;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "A fan failure has been detected";
    hpq_info = PRINTF("A fan failure has been detected on %s", $V4);
END

############################################################################### 
CLASS IM_BT2_33
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 33;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_33;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_contact = $V5;
    hpq_location = $V6;
    msg = "The fan failure has been fixed";
    hpq_info = PRINTF("The fan failure has been fixed on %s", $V4);
END

##############################################################

CLASS IM_BT2_34
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 34;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_34;
    severity = CRITICAL;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The LtM link is down.";
    hpq_info = PRINTF("The LtM link is down on %s", $V4);
END

##############################################################

CLASS IM_BT2_35
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 35;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_35;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The LtM link is up.";
    hpq_info = PRINTF("The LtM link is up on %s", $V4);
END
############################################################################### 

CLASS IM_BT2_36
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 36;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_36;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The Global UFD is enabled.";
    hpq_info = PRINTF("The Global UFD is enabled on %s", $V4);
END
###########################################################################

CLASS IM_BT2_37
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 37;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_37;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The Global UFD is disabled.";
    hpq_info = PRINTF("The Global UFD is Disabled on %s", $V4);
END

###########################################################################

CLASS IM_BT2_38
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 38;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_38;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The Ltd Link is Auto Enabled.";
    hpq_info = PRINTF("The Ltd Link is Auto Enabled on %s", $V4);
END

###########################################################################

CLASS IM_BT2_39
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 39;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_39;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The Ltd Link is Auto Disabled.";
    hpq_info = PRINTF("The Ltd Link is Auto Disabled on %s", $V4);
END

###########################################################################
CLASS IM_BT2_40
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 40;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_40;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The Cube was inserted.";
    hpq_info = PRINTF("The Cube was inserted on %s", $V4);
END

###########################################################################
CLASS IM_BT2_41
  SELECT
    1: ATTR(=, $ENTERPRISE), VALUE(PREFIX, "1.3.6.1.4.1.11.2.3.7.11.33.1.2.7");
    2: $SPECIFIC = 41;
    3: ATTR(=, "bt2SwTrapDisplayString");
    4: ATTR(=, "sysName");
    5: ATTR(=, "sysLocation");
    6: ATTR(=, "sysContact");
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = BT2_41;
    severity = HARMLESS;
    hpq_bt2SwTrapDisplayString = $V3;
    hostname = $V4;
    hpq_location = $V5;
    hpq_contact = $V6;
    msg = "The Cube was removed.";
    hpq_info = PRINTF("The Cube was removed on %s", $V4);
END
########################################################################
######################     CIM TRAPS MIB		########################
########################################################################
CLASS IM_161001
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161001;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "agentBscSwFileAddr");
   11: ATTR(=, "agentBscSwFile");
   12: ATTR(=, "agentBscSwFileLoadType");
   13: ATTR(=, "cpqRackNetConnectorFWRev");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161001;
    severity = HARMLESS;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_agentBscSwFileAddr = $V10;
    hpq_agentBscSwFile = $V11;
    hpq_agentBscSwFileLoadType = $V12;
    hpq_RackNetConnectorFWRev = $V13;
    msg = "The firmware image successfully transferred";
    hpq_info = PRINTF ( "The firmware image of %s has been successfully transfered", $V8);
END

#########################################################

CLASS IM_161002
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161002;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "agentBscSwFileAddr");
   11: ATTR(=, "agentBscSwFile");
   12: ATTR(=, "agentBscSwFileLoadType");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161002;
    severity = HARMLESS;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_agentBscSwFileAddr = $V10;
    hpq_agentBscSwFile = $V11;
    hpq_agentBscSwFileLoadType = $V12;
    msg = "The Configuration File successfully transferred";
    hpq_info = PRINTF ( "The Switch has successfully transfered the Configuration file %s ", $V11);
END

#########################################################
CLASS IM_161003
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161003;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "agentBscSwFileAddr");
   11: ATTR(=, "agentBscSwFile");
   12: ATTR(=, "agentBscSwFileLoadType");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161003;
    severity = HARMLESS;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_agentBscSwFileAddr = $V10;
    hpq_agentBscSwFile = $V11;
    hpq_agentBscSwFileLoadType = $V12;
    msg = "The TFTP transfer completed successfully";
    hpq_info = PRINTF ( "The switch has successfully completed transfer of file %s", $V11);
 END
#########################################################
CLASS IM_161004
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161004;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "agentBscSwFileAddr");
   11: ATTR(=, "agentBscSwFile");
   12: ATTR(=, "agentBscSwFileLoadType");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161004;
    severity = WARNING;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_agentBscSwFileAddr = $V10;
    hpq_agentBscSwFile = $V11;
    hpq_agentBscSwFileLoadType = $V12;
    msg = "The switch has failed a TFTP transfer ";
    hpq_info = PRINTF ( "The switch has failed the TFTP transfer of %s", $V11);
 END

#########################################################

CLASS IM_161005
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161005;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "agentBscSwFileAddr");
   11: ATTR(=, "agentBscSwFile");
   12: ATTR(=, "agentBscSwFileLoadType");
   13: ATTR(=, "agentBscSwFileStatus");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    severity = WARNING;
    hpq_eventID = 161005;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_agentBscSwFileAddr = $V10;
    hpq_agentBscSwFile = $V11;
    hpq_agentBscSwFileLoadType = $V12;
    hpq_agentBscSwFileStatus = $V13;
    msg = "Invalid firmware or configuration image downloaded";
    hpq_info = PRINTF ( "The downloaded firmware / config image %s is invalid", $V11);
 END
#########################################################

CLASS IM_161006
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161006;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "cpqRackNetConnectorSparePartNumber");
   11: ATTR(=, "agentSwitchFanIndex");
   12: ATTR(=, "agentSwitchFanCondition");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161006;
    severity = FATAL;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_RackNetConnectorSparePartNumber = $V10;
    hpq_agentSwitchFanIndex = $V11;
    hpq_agentSwitchFanCondition = $V12;
    msg = "Condition of Switch Fan: Failed";
    hpq_info = PRINTF ( "The condition of Switch Fan %d is Failed", $V11);
 END
#########################################################
CLASS IM_161007
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161007;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "cpqRackNetConnectorSparePartNumber");
   11: ATTR(=, "agentSwitchFanIndex");
   12: ATTR(=, "agentSwitchFanCondition");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161007;
    severity = HARMLESS;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_RackNetConnectorSparePartNumber = $V10;
    hpq_agentSwitchFanIndex = $V11;
    hpq_agentSwitchFanCondition = $V12;
    msg = "Switch Fan has returned to Normal: Operation";
    hpq_info = PRINTF ( "The Switch Fan %d has returned to Normal Operation", $V11);
 END

#########################################################
CLASS IM_161008
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161008;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "cpqRackNetConnectorSparePartNumber");
   11: ATTR(=, "agentSwitchTempSensorIndex");
   12: ATTR(=, "agentSwitchTempSensorCurrent");
   13: ATTR(=, "agentSwitchTempSensorThreshold");
   14: ATTR(=, "agentSwitchTempSensorCondition");
   15: ATTR(=, "agentSwitchTempSensorTempType");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161008;
    severity = CRITICAL;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_RackNetConnectorSparePartNumber = $V10;
    hpq_agentSwitchTempSensorIndex = $V11;
    hpq_agentSwitchTempSensorCurrent = $V12;
    hpq_agentSwitchTempSensorThreshold = $V13;
    hpq_agentSwitchTempSensorCondition = $V14;
    msg = "The switch temperature sensor indicates High Temperature";
    hpq_info = PRINTF ( "The Switch Temp Sensor %d shows High Temp.", $V11);
END

#########################################################
CLASS IM_161009
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161009;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "cpqRackNetConnectorSparePartNumber");
   11: ATTR(=, "agentSwitchTempSensorIndex");
   12: ATTR(=, "agentSwitchTempSensorCurrent");
   13: ATTR(=, "agentSwitchTempSensorThreshold");
   14: ATTR(=, "agentSwitchTempSensorCondition");
   15: ATTR(=, "agentSwitchTempSensorTempType");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161009;
    severity = FATAL;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_RackNetConnectorSparePartNumber = $V10;
    hpq_agentSwitchTempSensorIndex = $V11;
    hpq_agentSwitchTempSensorCurrent = $V12;
    hpq_agentSwitchTempSensorThreshold = $V13;
    hpq_agentSwitchTempSensorCondition = $V14;
    msg = "The switch temperature sensor indicates an over Temperature";
    hpq_info = PRINTF ( "The Switch Temp Sensor %d shows an over Temp.", $V11);
END

#########################################################
CLASS IM_161010
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161010;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "cpqRackNetConnectorSparePartNumber");
   11: ATTR(=, "agentSwitchTempSensorIndex");
   12: ATTR(=, "agentSwitchTempSensorCurrent");
   13: ATTR(=, "agentSwitchTempSensorThreshold");
   14: ATTR(=, "agentSwitchTempSensorCondition");
   15: ATTR(=, "agentSwitchTempSensorTempType");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161010;
    severity = HARMLESS;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_RackNetConnectorSparePartNumber = $V10;
    hpq_agentSwitchTempSensorIndex = $V11;
    hpq_agentSwitchTempSensorCurrent = $V12;
    hpq_agentSwitchTempSensorThreshold = $V13;
    hpq_agentSwitchTempSensorCondition = $V14;
    msg = "The switch temperature sensor indicates Normal Temperature returning";
    hpq_info = PRINTF ( "The Switch Temp Sensor %d indicates Temp has returned to Normal", $V11);
END

#########################################################
CLASS IM_161011
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161011;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "cpqRackNetConnectorSparePartNumber");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161011;
    severity = WARNING;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_RackNetConnectorSparePartNumber = $V10;
    msg = "The switch has successfully completed POST";
    hpq_info = PRINTF ( "The Switch of %s has successfully completed POST.", $V8);
END

#########################################################
CLASS IM_161012
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161012;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161012;
    severity = WARNING;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    msg = "Switch has Rejected Login Attempt";
    hpq_info = PRINTF ( "The Switch of %s has Rejected Login Attempt", $V8);
END
#########################################################
CLASS IM_161013
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161013;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161013;
    severity = HARMLESS;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    msg = "The switch location has changed, Trap will be sent on next boot";
    hpq_info = PRINTF ( "The Switch has changed location to %s", $V9);
END

#########################################################
CLASS IM_161014
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161014;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "cpqRackNetConnectorSparePartNumber");
   11: ATTR(=, "agentSwitchCubeType");
   12: ATTR(=, "agentSwitchCubeSpareName");
   13: ATTR(=, "agentSwitchCubeSparePartNumber");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161014;
    severity = HARMLESS;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_RackNetConnectorSparePartNumber = $V10;
    hpq_agentSwitchCubeType = $V11;
    hpq_agentSwitchCubeSpareName = $V12;
    hpq_agentSwitchCubeSparePartNumber = $V13;
    msg = "The cube type is changed by customer since last boot";
    hpq_info = PRINTF("The cube type %d is changed, since last boot", $V11);
END

#########################################################
CLASS IM_161015
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232" ) ;
    2: $SPECIFIC = 161015;
    3: ATTR(=, "cpqRackUid");
    4: ATTR(=, "cpqRackCommonEnclosureSerialNum");
    5: ATTR(=, "cpqRackNetConnectorSerialNum");
    6: ATTR(=, "cpqRackName");
    7: ATTR(=, "cpqRackCommonEnclosureName");
    8: ATTR(=, "cpqRackNetConnectorName");
    9: ATTR(=, "cpqRackNetConnectorLocation");
   10: ATTR(=, "agentSNTPServer1IPAddr");
   11: ATTR(=, "agentSNTPServer2IPAddr");
  FETCH
    1: IPNAME($AGENT_ADDR);
  MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 161015;
    severity = WARNING;
    hostname=$F1;
    hpq_RackUid = $V3;
    hpq_RackCommonEnclosureSerialNum = $V4;
    hpq_RackNetConnectorSerialNum = $V5;
    hpq_RackName = $V6;
    hpq_RackCommonEnclosureName = $V7;
    hpq_RackNetConnectorName = $V8;
    hpq_RackNetConnectorLocation = $V9;
    hpq_agentSNTPServer1IPAddr = $V10;
    hpq_agentSNTPServer2IPAddr = $V11;
    msg = "The SNTP server was configured, but no SNTP servers were found";
    hpq_info = PRINTF("The SNTP servers %s and %s could not be found", $V10, $V11);
END

#########################################################
#####   Service Incident information (cpqservice.mib)
#########################################################

CLASS IM_164001_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164001;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqServiceIncidentSeverity");
    5: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,2);
    6: ATTR(=, "cpqServiceIncidentInformation");
    7: ATTR(=, "cpqServiceIncidentEvent");
    8: ATTR(=, "cpqServiceIncidentUniqueID");
    9: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
   10: ATTR(=, "cpqServiceIncidentSourceSystemName");
   11: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   12: ATTR(=, "cpqServiceISEEIncidentInformation");
   13: ATTR(=, "cpqServiceIncidentIdentifier");
   14: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   15: ATTR(=, "cpqServiceIncidentFilterOID");
   16: ATTR(=, "cpqServiceIncidentFilterValue");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164001_2;
    severity = WARNING;
    hostname = $V3;
    hpq_ServiceIncidentSeverity = $V4;
    hpq_ServiceIncidentStatus = $V5;
    hpq_ServiceIncidentInformation = $V6;
    hpq_ServiceIncidentEvent = $V7;
    hpq_ServiceIncidentUniqueID = $V8;
    hpq_ServiceIncidentTimeofOriginalEvent = $V9;
    hpq_ServiceIncidentSourceSystemName = $V10;
    hpq_ServiceIncidentIPAddessOfSource = $V11;
    hpq_ServiceISEEIncidentInformation = $V12;
    hpq_ServiceIncidentIdentifier = $V13;
    hpq_ServiceIncidentReceiveTrapOID = $V14;
    hpq_ServiceIncidentFilterOID = $V15;
    hpq_ServiceIncidentFilterValue = $V16;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "The status of the service incident: intransit.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s with a severity of %s, whose status is %s located at %s", $V10, $V4, $V5, $V6);
END

CLASS IM_164001_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164001;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqServiceIncidentSeverity");
    5: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,3);
    6: ATTR(=, "cpqServiceIncidentInformation");
    7: ATTR(=, "cpqServiceIncidentEvent");
    8: ATTR(=, "cpqServiceIncidentUniqueID");
    9: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
   10: ATTR(=, "cpqServiceIncidentSourceSystemName");
   11: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   12: ATTR(=, "cpqServiceISEEIncidentInformation");
   13: ATTR(=, "cpqServiceIncidentIdentifier");
   14: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   15: ATTR(=, "cpqServiceIncidentFilterOID");
   16: ATTR(=, "cpqServiceIncidentFilterValue");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164001_3;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentSeverity = $V4;
    hpq_ServiceIncidentStatus = $V5;
    hpq_ServiceIncidentInformation = $V6;
    hpq_ServiceIncidentEvent = $V7;
    hpq_ServiceIncidentUniqueID = $V8;
    hpq_ServiceIncidentTimeofOriginalEvent = $V9;
    hpq_ServiceIncidentSourceSystemName = $V10;
    hpq_ServiceIncidentIPAddessOfSource = $V11;
    hpq_ServiceISEEIncidentInformation = $V12;
    hpq_ServiceIncidentIdentifier = $V13;
    hpq_ServiceIncidentReceiveTrapOID = $V14;
    hpq_ServiceIncidentFilterOID = $V15;
    hpq_ServiceIncidentFilterValue = $V16;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "The status of service incident: delivered.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s with a severity of %s, whose status is %s located at %s", $V10, $V4, $V5, $V6);
END

CLASS IM_164001_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164001;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqServiceIncidentSeverity");
    5: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,4);
    6: ATTR(=, "cpqServiceIncidentInformation");
    7: ATTR(=, "cpqServiceIncidentEvent");
    8: ATTR(=, "cpqServiceIncidentUniqueID");
    9: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
   10: ATTR(=, "cpqServiceIncidentSourceSystemName");
   11: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   12: ATTR(=, "cpqServiceISEEIncidentInformation");
   13: ATTR(=, "cpqServiceIncidentIdentifier");
   14: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   15: ATTR(=, "cpqServiceIncidentFilterOID");
   16: ATTR(=, "cpqServiceIncidentFilterValue");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164001_4;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ServiceIncidentSeverity = $V4;
    hpq_ServiceIncidentStatus = $V5;
    hpq_ServiceIncidentInformation = $V6;
    hpq_ServiceIncidentEvent = $V7;
    hpq_ServiceIncidentUniqueID = $V8;
    hpq_ServiceIncidentTimeofOriginalEvent = $V9;
    hpq_ServiceIncidentSourceSystemName = $V10;
    hpq_ServiceIncidentIPAddessOfSource = $V11;
    hpq_ServiceISEEIncidentInformation = $V12;
    hpq_ServiceIncidentIdentifier = $V13;
    hpq_ServiceIncidentReceiveTrapOID = $V14;
    hpq_ServiceIncidentFilterOID = $V15;
    hpq_ServiceIncidentFilterValue = $V16;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "The status of service incident: undelivered.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s with a severity of %s, whose status is %s located at %s", $V10, $V4, $V5, $V6);
END

CLASS IM_164001_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164001;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqServiceIncidentSeverity");
    5: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,5);
    6: ATTR(=, "cpqServiceIncidentInformation");
    7: ATTR(=, "cpqServiceIncidentEvent");
    8: ATTR(=, "cpqServiceIncidentUniqueID");
    9: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
   10: ATTR(=, "cpqServiceIncidentSourceSystemName");
   11: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   12: ATTR(=, "cpqServiceISEEIncidentInformation");
   13: ATTR(=, "cpqServiceIncidentIdentifier");
   14: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   15: ATTR(=, "cpqServiceIncidentFilterOID");
   16: ATTR(=, "cpqServiceIncidentFilterValue");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164001_5;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentSeverity = $V4;
    hpq_ServiceIncidentStatus = $V5;
    hpq_ServiceIncidentInformation = $V6;
    hpq_ServiceIncidentEvent = $V7;
    hpq_ServiceIncidentUniqueID = $V8;
    hpq_ServiceIncidentTimeofOriginalEvent = $V9;
    hpq_ServiceIncidentSourceSystemName = $V10;
    hpq_ServiceIncidentIPAddessOfSource = $V11;
    hpq_ServiceISEEIncidentInformation = $V12;
    hpq_ServiceIncidentIdentifier = $V13;
    hpq_ServiceIncidentReceiveTrapOID = $V14;
    hpq_ServiceIncidentFilterOID = $V15;
    hpq_ServiceIncidentFilterValue = $V16;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "The status of service incident: assigend.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s with a severity of %s, whose status is %s located at %s", $V10, $V4, $V5, $V6);
END

CLASS IM_164001_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164001;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqServiceIncidentSeverity");
    5: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,6);
    6: ATTR(=, "cpqServiceIncidentInformation");
    7: ATTR(=, "cpqServiceIncidentEvent");
    8: ATTR(=, "cpqServiceIncidentUniqueID");
    9: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
   10: ATTR(=, "cpqServiceIncidentSourceSystemName");
   11: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   12: ATTR(=, "cpqServiceISEEIncidentInformation");
   13: ATTR(=, "cpqServiceIncidentIdentifier");
   14: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   15: ATTR(=, "cpqServiceIncidentFilterOID");
   16: ATTR(=, "cpqServiceIncidentFilterValue");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164001_6;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentSeverity = $V4;
    hpq_ServiceIncidentStatus = $V5;
    hpq_ServiceIncidentInformation = $V6;
    hpq_ServiceIncidentEvent = $V7;
    hpq_ServiceIncidentUniqueID = $V8;
    hpq_ServiceIncidentTimeofOriginalEvent = $V9;
    hpq_ServiceIncidentSourceSystemName = $V10;
    hpq_ServiceIncidentIPAddessOfSource = $V11;
    hpq_ServiceISEEIncidentInformation = $V12;
    hpq_ServiceIncidentIdentifier = $V13;
    hpq_ServiceIncidentReceiveTrapOID = $V14;
    hpq_ServiceIncidentFilterOID = $V15;
    hpq_ServiceIncidentFilterValue = $V16;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "The status of the service incident: closed.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s with a severity of %s, whose status is %s located at %s", $V10, $V4, $V5, $V6);
END

CLASS IM_164001_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164001;
    3: ATTR(=, "sysName");
    4: ATTR(=, "cpqServiceIncidentSeverity");
    5: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,7);
    6: ATTR(=, "cpqServiceIncidentInformation");
    7: ATTR(=, "cpqServiceIncidentEvent");
    8: ATTR(=, "cpqServiceIncidentUniqueID");
    9: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
   10: ATTR(=, "cpqServiceIncidentSourceSystemName");
   11: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   12: ATTR(=, "cpqServiceISEEIncidentInformation");
   13: ATTR(=, "cpqServiceIncidentIdentifier");
   14: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   15: ATTR(=, "cpqServiceIncidentFilterOID");
   16: ATTR(=, "cpqServiceIncidentFilterValue");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164001_7;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentSeverity = $V4;
    hpq_ServiceIncidentStatus = $V5;
    hpq_ServiceIncidentInformation = $V6;
    hpq_ServiceIncidentEvent = $V7;
    hpq_ServiceIncidentUniqueID = $V8;
    hpq_ServiceIncidentTimeofOriginalEvent = $V9;
    hpq_ServiceIncidentSourceSystemName = $V10;
    hpq_ServiceIncidentIPAddessOfSource = $V11;
    hpq_ServiceISEEIncidentInformation = $V12;
    hpq_ServiceIncidentIdentifier = $V13;
    hpq_ServiceIncidentReceiveTrapOID = $V14;
    hpq_ServiceIncidentFilterOID = $V15;
    hpq_ServiceIncidentFilterValue = $V16;
    sub_origin=$K5;
    hpq_val=$V5;
    msg = "The status of the service incident: submitted_to_ISEE.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s with a severity of %s whose status is %s located at %s", $V10, $V4, $V5, $V6);
END
###########################################################################

CLASS IM_164002_2
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164002;
    3: ATTR(=, "sysName");
    4: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,2);
    5: ATTR(=, "cpqServiceIncidentInformation");
    6: ATTR(=, "cpqServiceIncidentEvent");
    7: ATTR(=, "cpqServiceIncidentUniqueID");
    8: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
    9: ATTR(=, "cpqServiceIncidentSourceSystemName");
   10: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   11: ATTR(=, "cpqServiceISEEIncidentInformation");
   12: ATTR(=, "cpqServiceIncidentIdentifier");
   13: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   14: ATTR(=, "cpqServiceRecommendedAction1");
   15: ATTR(=, "cpqServiceRecommendedAction2");
   16: ATTR(=, "cpqServiceRecommendedAction3");
   17: ATTR(=, "cpqServiceCustomerSelfRepairInstructionURL");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164002_2;
    severity = WARNING;
    hostname = $V3;
    hpq_ServiceIncidentStatus = $V4;
    hpq_ServiceIncidentInformation = $V5;
    hpq_ServiceIncidentEvent = $V6;
    hpq_ServiceIncidentUniqueID = $V7;
    hpq_ServiceIncidentTimeofOriginalEvent = $V8;
    hpq_ServiceIncidentSourceSystemName = $V9;
    hpq_ServiceIncidentIPAddessOfSource = $V10;
    hpq_ServiceISEEIncidentInformation = $V11;
    hpq_ServiceIncidentIdentifier = $V12;
    hpq_ServiceIncidentReceiveTrapOID = $V13;
    hpq_ServiceRecommendedAction1 = $V14;
    hpq_ServiceRecommendedAction2 = $V15;
    hpq_ServiceRecommendedAction3 = $V16;
    sub_origin=$K4;
    hpq_val=$V4;
    hpq_ServiceCustomerSelfRepairInstructionURL = $V17;
    msg = "The status of the service incident: intransit.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s whose status is %s located at %s", $V9, $V4, $V5);
END

CLASS IM_164002_3
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164002;
    3: ATTR(=, "sysName");
    4: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,3);
    5: ATTR(=, "cpqServiceIncidentInformation");
    6: ATTR(=, "cpqServiceIncidentEvent");
    7: ATTR(=, "cpqServiceIncidentUniqueID");
    8: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
    9: ATTR(=, "cpqServiceIncidentSourceSystemName");
   10: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   11: ATTR(=, "cpqServiceISEEIncidentInformation");
   12: ATTR(=, "cpqServiceIncidentIdentifier");
   13: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   14: ATTR(=, "cpqServiceRecommendedAction1");
   15: ATTR(=, "cpqServiceRecommendedAction2");
   16: ATTR(=, "cpqServiceRecommendedAction3");
   17: ATTR(=, "cpqServiceCustomerSelfRepairInstructionURL");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164002_3;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentStatus = $V4;
    hpq_ServiceIncidentInformation = $V5;
    hpq_ServiceIncidentEvent = $V6;
    hpq_ServiceIncidentUniqueID = $V7;
    hpq_ServiceIncidentTimeofOriginalEvent = $V8;
    hpq_ServiceIncidentSourceSystemName = $V9;
    hpq_ServiceIncidentIPAddessOfSource = $V10;
    hpq_ServiceISEEIncidentInformation = $V11;
    hpq_ServiceIncidentIdentifier = $V12;
    hpq_ServiceIncidentReceiveTrapOID = $V13;
    hpq_ServiceRecommendedAction1 = $V14;
    hpq_ServiceRecommendedAction2 = $V15;
    hpq_ServiceRecommendedAction3 = $V16;
    hpq_ServiceCustomerSelfRepairInstructionURL = $V17;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "The status of service incident: delivered.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s whose status is %s located at %s", $V9, $V4, $V5);
END

CLASS IM_164002_4
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164002;
    3: ATTR(=, "sysName");
    4: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,4);
    5: ATTR(=, "cpqServiceIncidentInformation");
    6: ATTR(=, "cpqServiceIncidentEvent");
    7: ATTR(=, "cpqServiceIncidentUniqueID");
    8: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
    9: ATTR(=, "cpqServiceIncidentSourceSystemName");
   10: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   11: ATTR(=, "cpqServiceISEEIncidentInformation");
   12: ATTR(=, "cpqServiceIncidentIdentifier");
   13: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   14: ATTR(=, "cpqServiceRecommendedAction1");
   15: ATTR(=, "cpqServiceRecommendedAction2");
   16: ATTR(=, "cpqServiceRecommendedAction3");
   17: ATTR(=, "cpqServiceCustomerSelfRepairInstructionURL");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164002_4;
    severity = CRITICAL;
    hostname = $V3;
    hpq_ServiceIncidentStatus = $V4;
    hpq_ServiceIncidentInformation = $V5;
    hpq_ServiceIncidentEvent = $V6;
    hpq_ServiceIncidentUniqueID = $V7;
    hpq_ServiceIncidentTimeofOriginalEvent = $V8;
    hpq_ServiceIncidentSourceSystemName = $V9;
    hpq_ServiceIncidentIPAddessOfSource = $V10;
    hpq_ServiceISEEIncidentInformation = $V11;
    hpq_ServiceIncidentIdentifier = $V12;
    hpq_ServiceIncidentReceiveTrapOID = $V13;
    hpq_ServiceRecommendedAction1 = $V14;
    hpq_ServiceRecommendedAction2 = $V15;
    hpq_ServiceRecommendedAction3 = $V16;
    hpq_ServiceCustomerSelfRepairInstructionURL = $V17;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "The status of service incident: undelivered.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s whose status is %s located at %s", $V9, $V4, $V5);
END

CLASS IM_164002_5
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164002;
    3: ATTR(=, "sysName");
    4: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,5);
    5: ATTR(=, "cpqServiceIncidentInformation");
    6: ATTR(=, "cpqServiceIncidentEvent");
    7: ATTR(=, "cpqServiceIncidentUniqueID");
    8: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
    9: ATTR(=, "cpqServiceIncidentSourceSystemName");
   10: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   11: ATTR(=, "cpqServiceISEEIncidentInformation");
   12: ATTR(=, "cpqServiceIncidentIdentifier");
   13: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   14: ATTR(=, "cpqServiceRecommendedAction1");
   15: ATTR(=, "cpqServiceRecommendedAction2");
   16: ATTR(=, "cpqServiceRecommendedAction3");
   17: ATTR(=, "cpqServiceCustomerSelfRepairInstructionURL");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164002_5;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentStatus = $V4;
    hpq_ServiceIncidentInformation = $V5;
    hpq_ServiceIncidentEvent = $V6;
    hpq_ServiceIncidentUniqueID = $V7;
    hpq_ServiceIncidentTimeofOriginalEvent = $V8;
    hpq_ServiceIncidentSourceSystemName = $V9;
    hpq_ServiceIncidentIPAddessOfSource = $V10;
    hpq_ServiceISEEIncidentInformation = $V11;
    hpq_ServiceIncidentIdentifier = $V12;
    hpq_ServiceIncidentReceiveTrapOID = $V13;
    hpq_ServiceRecommendedAction1 = $V14;
    hpq_ServiceRecommendedAction2 = $V15;
    hpq_ServiceRecommendedAction3 = $V16;
    hpq_ServiceCustomerSelfRepairInstructionURL = $V17;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "The status of service incident: assigend.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s whose status is %s located at %s", $V9, $V4, $V5);
END

CLASS IM_164002_6
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164002;
    3: ATTR(=, "sysName");
    4: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,6);
    5: ATTR(=, "cpqServiceIncidentInformation");
    6: ATTR(=, "cpqServiceIncidentEvent");
    7: ATTR(=, "cpqServiceIncidentUniqueID");
    8: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
    9: ATTR(=, "cpqServiceIncidentSourceSystemName");
   10: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   11: ATTR(=, "cpqServiceISEEIncidentInformation");
   12: ATTR(=, "cpqServiceIncidentIdentifier");
   13: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   14: ATTR(=, "cpqServiceRecommendedAction1");
   15: ATTR(=, "cpqServiceRecommendedAction2");
   16: ATTR(=, "cpqServiceRecommendedAction3");
   17: ATTR(=, "cpqServiceCustomerSelfRepairInstructionURL");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164002_6;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentStatus = $V4;
    hpq_ServiceIncidentInformation = $V5;
    hpq_ServiceIncidentEvent = $V6;
    hpq_ServiceIncidentUniqueID = $V7;
    hpq_ServiceIncidentTimeofOriginalEvent = $V8;
    hpq_ServiceIncidentSourceSystemName = $V9;
    hpq_ServiceIncidentIPAddessOfSource = $V10;
    hpq_ServiceISEEIncidentInformation = $V11;
    hpq_ServiceIncidentIdentifier = $V12;
    hpq_ServiceIncidentReceiveTrapOID = $V13;
    hpq_ServiceRecommendedAction1 = $V14;
    hpq_ServiceRecommendedAction2 = $V15;
    hpq_ServiceRecommendedAction3 = $V16;
    hpq_ServiceCustomerSelfRepairInstructionURL = $V17;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "The status of the service incident: closed.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s whose status is %s located at %s", $V9, $V4, $V5);
END

CLASS IM_164002_7
  SELECT
    1: ATTR(=,$ENTERPRISE) , VALUE(PREFIX, "1.3.6.1.4.1.232.164" );
    2: $SPECIFIC = 164002;
    3: ATTR(=, "sysName");
    4: ATTR(PREFIX, "cpqServiceIncidentStatus"), VALUE(=,7);
    5: ATTR(=, "cpqServiceIncidentInformation");
    6: ATTR(=, "cpqServiceIncidentEvent");
    7: ATTR(=, "cpqServiceIncidentUniqueID");
    8: ATTR(=, "cpqServiceIncidentTimeofOriginalEvent");
    9: ATTR(=, "cpqServiceIncidentSourceSystemName");
   10: ATTR(=, "cpqServiceIncidentIPAddessOfSource");
   11: ATTR(=, "cpqServiceISEEIncidentInformation");
   12: ATTR(=, "cpqServiceIncidentIdentifier");
   13: ATTR(=, "cpqServiceIncidentReceiveTrapOID");
   14: ATTR(=, "cpqServiceRecommendedAction1");
   15: ATTR(=, "cpqServiceRecommendedAction2");
   16: ATTR(=, "cpqServiceRecommendedAction3");
   17: ATTR(=, "cpqServiceCustomerSelfRepairInstructionURL");
MAP
    sub_source = HP_Insight_Manager;
    specificTrap = $V2;
    hpq_eventID = 164002_7;
    severity = HARMLESS;
    hostname = $V3;
    hpq_ServiceIncidentStatus = $V4;
    hpq_ServiceIncidentInformation = $V5;
    hpq_ServiceIncidentEvent = $V6;
    hpq_ServiceIncidentUniqueID = $V7;
    hpq_ServiceIncidentTimeofOriginalEvent = $V8;
    hpq_ServiceIncidentSourceSystemName = $V9;
    hpq_ServiceIncidentIPAddessOfSource = $V10;
    hpq_ServiceISEEIncidentInformation = $V11;
    hpq_ServiceIncidentIdentifier = $V12;
    hpq_ServiceIncidentReceiveTrapOID = $V13;
    hpq_ServiceRecommendedAction1 = $V14;
    hpq_ServiceRecommendedAction2 = $V15;
    hpq_ServiceRecommendedAction3 = $V16;
    hpq_ServiceCustomerSelfRepairInstructionURL = $V17;
    sub_origin=$K4;
    hpq_val=$V4;
    msg = "The status of the service incident: submitted_to_ISEE.";
    hpq_info = PRINTF ("A service Incident trap has been reported by %s whose status is %s located at %s", $V9, $V4, $V5);
END

