/*****************************************************************************
 *****************************************************************************
 Copyright (c) 2001 - 2002, VIA Technologies, Inc.

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of VIA Technologies, Inc. nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/
#include "rhine_proc.h"

static char* RHINE_PROC_DIR="Rhine_Adapters";
static struct proc_dir_entry *rhine_dir = NULL;

static int rhine_proc_read(char *page, char **start, off_t off, int count, 
	int *eof, void *data) {
	PRHINE_INFO	pInfo=(PRHINE_INFO) data;
	int				len,i;
	char			*ptr=page;
	ptr+=sprintf(ptr,"MAC: ");
	
	for (i=0;i<5;i++)
		ptr+=sprintf(ptr, "%02hx:",readb(&(pInfo->pMacRegs->abyPAR[i])));
		
	ptr+=sprintf(ptr,"%02hx\n",readb(&(pInfo->pMacRegs->abyPAR[i])));
		
	ptr+=sprintf(ptr,"Tx_Threshold: %d\n",pInfo->sOpts.tx_thresh);
	ptr+=sprintf(ptr,"Rx_Threshold: %d\n",pInfo->sOpts.tx_thresh);
	ptr+=sprintf(ptr,"Tx_Queues: %d\n",pInfo->nTxQueues);
	
	for (i=0;i<pInfo->nTxQueues;i++)	
		ptr+=sprintf(ptr,"TDUsed[%d]: %d\n",i,pInfo->iTDUsed[i]);
				
	if (pInfo->flags & RHINE_FLAGS_TAGGING) {
		ptr+=sprintf(ptr,"8021Q_TAG: ENABLED\n");
		ptr+=sprintf(ptr,"VLAN_ID: %d\n", pInfo->sOpts.vid);
	}

	len=strlen(page);
	page[len++]='\n';

    if (len <= off + count)
    	*eof = 1;
    
    *start = page + off;
    len -= off;
    
    if (len > count)
    	len = count;
    
    if (len < 0)
    	len = 0;
	return len;
}
    

BOOL	rhine_create_proc_entry(PRHINE_INFO pInfo) {
	struct proc_dir_entry *ptr;

	pInfo->pProcDir=create_proc_entry(pInfo->dev->name,S_IFDIR,rhine_dir);
	ptr=create_proc_entry("info",S_IFREG, pInfo->pProcDir);	
	ptr->read_proc=rhine_proc_read;
	ptr->write_proc=NULL;
	ptr->data=pInfo;
	return TRUE;
}

void	rhine_free_proc_entry(PRHINE_INFO pInfo) {
    remove_proc_entry("info",pInfo->pProcDir);
	remove_proc_entry(pInfo->dev->name,rhine_dir);
}

BOOL	rhine_init_proc_fs(PRHINE_INFO pInfo) {
	int len=strlen(RHINE_PROC_DIR);

	if (rhine_dir==NULL) {
		for (rhine_dir = proc_net->subdir; rhine_dir;rhine_dir = rhine_dir->next) {
			if ((rhine_dir->namelen == len) &&
				(!memcmp(rhine_dir->name, RHINE_PROC_DIR, len)))
				break;
	    } 
    
	    if (rhine_dir==NULL)                      
			rhine_dir=create_proc_entry(RHINE_PROC_DIR,S_IFDIR,proc_net);	
	}

	if (rhine_dir==NULL)
		return FALSE;
			
	return TRUE;
}

void	rhine_free_proc_fs(PRHINE_INFO pInfo) {
	struct proc_dir_entry*	ptr;

//	remove_proc_entry(pInfo->pProcDir, rhine_dir);

	if (rhine_dir==NULL)
		return;
	
	//Check if other adapters's entry still exist
	for (ptr = rhine_dir->subdir; ptr; ptr = ptr->next) {
		if (*(ptr->name) != '.')
			break;
    }
    
    if (ptr) 
    	return;
    
	remove_proc_entry(RHINE_PROC_DIR,proc_net);

	rhine_dir=NULL;
}

