/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _PREFILTEREXAMPLEAGENT_H
#define _PREFILTEREXAMPLEAGENT_H

class	CRSPrefilterExampleAgent  
		: public CHXTConfigurationAgentHelper	
		, public IHXTConnectionAgent
		, public CRSPrefilterExampleFilter
{

public:

	CRSPrefilterExampleAgent();
	~CRSPrefilterExampleAgent();

	// override of filter methods
	STDMETHOD( SetFactory ) ( IHXCommonClassFactory* pCCF );
	STDMETHOD( Prime )( UINT32 ulOutputStreamID );
	STDMETHOD( Teardown )( UINT32 ulOutputStreamID );

	// CHXTConfigurationAgentHelper overrides
	STDMETHOD( OnSetBool )( const CHAR* szName, BOOL bValue );
	STDMETHOD( OnSetString )( const char* szName, const CHAR *cszValue );

	// IHXTConnectionAgent Output Format methods
	STDMETHOD_( UINT32, GetOutputStreamCount ) ();
	STDMETHOD ( GetSupportedOutputFormat )( UINT32 ulOutputStreamID, IHXTPropertyBag** ppSupportedFormats );
	STDMETHOD ( SetNegotiatedOutputFormat )( UINT32 ulOutputStreamID, IHXTPropertyBag* pConnectedFormat );
	
	// IHXTConnectionAgent Input Format methods
	STDMETHOD_( UINT32, GetInputStreamCount ) ();
	STDMETHOD ( GetSupportedInputFormat )( UINT32 ulInputStreamID, IHXTPropertyBag** ppSupportedFormats );	
	STDMETHOD ( SetNegotiatedInputFormat ) ( UINT32 ulInputStreamID, IHXTPropertyBag* pConnectedFormat );
	
	// reserved for future use
	STDMETHOD ( GetNegotiatedOutputFormat )( UINT32 ulOutputStreamID, IHXTPropertyBag** ppSupportedFormats ){return HXR_FAIL;}
	STDMETHOD ( GetNegotiatedInputFormat )( UINT32 ulInputStreamID, IHXTPropertyBag** ppSupportedFormats ) {return HXR_FAIL;}
	STDMETHOD ( GetPreferredInputFormat ) ( THIS_ UINT32 uIndex, UINT32 uPrefRank, IHXTPropertyBag** ppPreferredFormat ) {return HXR_FAIL;}	
	STDMETHOD ( GetPreferredOutputFormat ) ( THIS_ UINT32 uIndex, UINT32 uPrefRank, IHXTPropertyBag** ppPreferredFormat ) {return HXR_FAIL;}

	// IUnknown Interface Methods                         
    STDMETHOD(QueryInterface)		(THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)		(THIS);
    STDMETHOD_(ULONG32,Release)		(THIS);

private:

	HX_RESULT FillInPropertyBags();
	HX_RESULT PrepareList( UINT32 arr[], INT32 nCnt, const char *kProp );
	HX_RESULT PrepareRange( UINT32 uBeg, UINT32 uEnd, UINT32 uStep, const char *kProp );
	HX_RESULT PrepareDoubleRange( double dBeg, double dEnd, const char *kProp );

	// VARS
	IHXTPropertyBag*		m_pOutputFormat;			// Connection format
	IHXTPropertyBag*		m_pInputFormat;				// Connection format
	IHXTPropertyBag*		m_pConnectedOutputFormat;	// chosen Connection format
	IHXTPropertyBag*		m_pConnectedInputFormat;	// chosen Connection format
	BOOL					m_bEnabled;					// example enabled property
    LONG32					m_lRefCount;				// QI count

};

#endif // _PREFILTEREXAMPLEAGENT_H


		

