RM=rm -f
RM_DIR=rm -rf

MAKE_DEP=echo
MAKE_DEP_FLAGS=$(INCLUDES) $(DEFINES)

MAKE_LIB=ar cr
MAKE_LIB_FLAGS=
RANLIB=ranlib

CP=cp
MAKE=make

CC=gcc
CCFLAGS=--permissive -pipe -W -Wreturn-type -fno-rtti -fno-exceptions -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

CXX=g++
CXXFLAGS=-pipe --permissive -W -Wreturn-type -fno-rtti -fno-exceptions -march=pentium -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

INCLUDES=-I/usr/X11R6/include -I../../include -I./pub -I../logging
DEFINES=-D_UNIX -DFD_SETSIZE=2048 -D_LINUX -D_REENTRANT -D_RED_HAT_5_X_ -D_LITTLE_ENDIAN -D_UNIX_THREADED_NETWORK_IO -D_UNIX_THREADS_SUPPORTED
STATIC_LIBS=
DYNAMIC_LIBS=-lstdc++ -ldl -lpthread -lm -lc

SRCS=main.cpp guids.cpp mediasinkencoder.cpp

OBJS=$(COMPILED_OBJS) $(SOURCE_OBJS)
COMPILED_OBJS=dbg/main.o dbg/guids.o dbg/mediasinkencoder.o
SOURCE_OBJS=


.SUFFIXES: .cpp .so

.c.o: 
	$(CC) $(CCFLAGS) -o  $@ -c $<

.cpp.o: 
	$(CXX) $(CXXFLAGS) -o  $@ -c $<

dbg/mediasinkencoder: $(OBJS) $(STATIC_LIBS)
	if test -d dbg; then echo; else mkdir dbg; fi
	gcc -o dbg/mediasinkencoder $(OBJS)  -L/usr/X11R6/lib $(DYNAMIC_LIBS) $(STATIC_LIBS)

dbg/main.o: main.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	$(CXX) $(CXXFLAGS) -o dbg/main.o -c main.cpp

dbg/guids.o: guids.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	$(CXX) $(CXXFLAGS) -o dbg/guids.o -c guids.cpp

dbg/mediasinkencoder.o: mediasinkencoder.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	$(CXX) $(CXXFLAGS) -o dbg/mediasinkencoder.o -c mediasinkencoder.cpp

clean: 
	$(RM) dbg/mediasinkencoder dbg/lib  $(COMPILED_OBJS)

copy: 
	if test -d ../debug; then echo; else mkdir ../debug; fi
	cp dbg/mediasinkencoder ../../bin/mediasinkencoder

depend: 
	$(MAKE_DEP) $(MAKE_DEP_FLAGS) dbg/ $(SRCS)

