/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _INWAVREADER_H_
#define _INWAVREADER_H_

#include "ihxtlogsystem.h"
#define NO_TRANSLATE 0xffffffff		// 


// constant used for logging across all 3 classes
static const char kRealNetworks[] = "RealNetworks";


#define BIG_ENDIAN_WAV    0x52494646     // "RIFF"
#define LITTLE_ENDIAN_WAV 0x46464952     // "FFIR"

#define _MAX_LONG 0xffffffff

// constants for reader
const INT32 kInitFileBufSize = 4096;


// Structure to match 16 Bytes of wave format 
typedef struct {
	UINT16		wFormatTag;
	UINT16		wNumChannels;
	ULONG32     dwSamplesPerSec;
	ULONG32		dwAvgBytesPerSec;
	UINT16		wBlockAlign;
	UINT16		wBitsPerSample;
} PN_WAVE_FORMAT;


// API's values are, on each system.
#ifdef _WINDOWS
#define PN_WAVE_FORMAT_PCM	WAVE_FORMAT_PCM
#else
#define PN_WAVE_FORMAT_PCM  1
#endif

typedef INT64 HXT_TIME;

class	CRSInWAVReader 
{

public:	
	CRSInWAVReader();

	// primary functions
	HX_RESULT DoOpen( const char *szURL );
	BOOL IsValidSource();
	HX_RESULT Open();
	UINT32 ReadFile( UCHAR *pBuffer, UINT32 uBufferSize, HXT_TIME *pStart, HXT_TIME *pEnd );
	HX_RESULT ReaderClose();

	// getters
	UINT32 GetNumChannels()			{ return m_uChannels; }
	UINT32 GetBitsPerSample()		{ return m_uBitsPerSample; }
	UINT32 GetSampleRate()			{ return m_uSampleRate; }
	INT64 GetDuration()				{ return m_llTotalDuration; }

	// from pnaudwav
	HX_RESULT FindTag( const char* pcszTag, ULONG32* pulPos, int* pnDataLen );
	HX_RESULT GetLengthTagData( ULONG32 ulTagPos, int* pnDataLen );

	// from pnaudfil
	// Sets internal member to turn on byte swapping.  Returns previous value
	void	MySetPos( UINT32 uPos );

protected:

	~CRSInWAVReader();
	void ResetUncompAudioVars();

	HX_RESULT SetLogWriter(IHXTLogWriter* pILogWriter);
	IHXTLogWriter*						m_pLogWriter;

	UINT16 GetActualFrameSize()	{ return (UINT16)(m_uBitsPerSample * m_uChannels/8);}
	ULONG32 ByteOffsetToTime(ULONG32 cBytes);

	// Little to Big Endian word swap
	UINT16 WLToBEndian(UINT16 wHost); 
	// Little to Big Endian double word swap
	ULONG32 DwLToBEndian(ULONG32 dwHost) ;


	FILE		*m_fd;
	bool		m_bFileIsOpen;

	UINT32		m_uStreams;
	UINT32		m_uOneWAVFrameSize;

	UINT32		m_uPercentDone;
	INT64		m_llTotalDuration;			

	ULONG32		m_dwTotalBytes;			// length of data section
	ULONG32		m_dwCurrentPosition;	// offset from start of data
	BOOL		m_bByteSwap;

	UINT32		m_uChannels;
	UINT32		m_uBitsPerSample;
	UINT32		m_uSampleRate;

};

#endif // _INWAVREADER_H_

