/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#include "ihxtprofile.h"

#ifdef _MAC_UNIX
#include <Carbon/Carbon.h>
#endif

#include "hxcom.h"

// standard includes
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
using namespace std;

#include "ihxtencodingjob.h"
#include "encoder.h"

#ifdef _WINDOWS
#include <crtdbg.h>
#endif


const UINT32 MAX_BUFFER_SIZE = 255;
void initMemLeakCheck();

int main(int argc, char** argv)
{
    cout << "Helix Producer SDK Sample Application" << endl;
    
    HX_RESULT res = HXR_OK;

    // Debugging tool -- init memory leak checker for sample app
    initMemLeakCheck();    
    
    // Step 1: Set up DLL access paths and create class factory
    CEncoderApp encoderApp;
    if (SUCCEEDED(res))
	res = encoderApp.SetupDLLPaths();
    
    // Step 2: Initialize the logging system and create file observer
    if (SUCCEEDED(res))
	res = encoderApp.InitializeLogSystem();
    
    // Step 3: Create encoding job and set up the event sink
    if (SUCCEEDED(res))
	res = encoderApp.CreateJob();
    
    // Step 4: Create and configure the input source
    if (SUCCEEDED(res))
	res = encoderApp.SetupInput();
    
    // Step 5: Create and configure prefilters
    if (SUCCEEDED(res))
	res = encoderApp.SetupPrefilters();
    
    // Step 6: Create and configure destination
    if (SUCCEEDED(res))
	res = encoderApp.SetupDestination();
    
    // Step 7: Create and configure media profile
    if (SUCCEEDED(res))
	res = encoderApp.SetupMediaProfile();
    
    // Step 8: Select audiences
    if (SUCCEEDED(res))
	res = encoderApp.SetupAudiences();
    
    // Step 9: Configure job
    if (SUCCEEDED(res))
	res = encoderApp.SetupJob();
    
    // Step 10: Job is fully configured now -- serialize job (optional step)
    if (SUCCEEDED(res))
	res = encoderApp.SerializeJob();
    
    // Step 11: Start encoding
    if (SUCCEEDED(res))
	res = encoderApp.StartEncoding();
    
    // Step 12:  Log system requires an explicit shutdown call before main thread ends
    encoderApp.Shutdown();
    
    // Print result of encoding job
    if(FAILED(res))
    {
	cout << "Encoding failed!  Error code: " << res << endl;
	cout << "Please check the log file for diagnostic information" << endl;
    }
    else
    {
	cout << "Encoding successful!" << endl;
    }
    
    // wait for a carriage return
    char szTemp[MAX_BUFFER_SIZE];
    cout << endl << "Enter OK to continue: ";
    cin >> szTemp;
    
    return 0;

}



// Custom MSVCRT report handler
#ifdef _WINDOWS
static int CustomCRTReportHandler(int reportType, char *userMessage, int *retVal)
{
    // Do nothing for asserts -- return TRUE so _CrtDbgReport gets called
    if (reportType == _CRT_ASSERT)
    {
	return TRUE;
    } 
    
    // Otherwise, assert and print to screen / debugger
    else 
    {
	static UINT32 ulCount = 0;
	if (ulCount++ == 0)
	{
	    _ASSERT(FALSE);
	}
	
	printf("%s", userMessage);
	OutputDebugString(userMessage);
	
	return FALSE;
    }
}
#endif



void initMemLeakCheck()
{
#ifdef _WINDOWS
    // Use debug MSVCRT to report memory leaks upon application exit
    _CrtSetDbgFlag((_CRTDBG_LEAK_CHECK_DF) | _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG));
    _CrtSetReportHook( CustomCRTReportHandler );
#endif
}
