/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 



#ifndef _HXTEXTERNALPLUGINHELPER_H
#define _HXTEXTERNALPLUGINHELPER_H

#include "hxplugn.h"	// for IHXPlugin
#include "hxplgns.h"	// for IHXPluginProperties
#include "ihxpckts.h"	// for CLSID_IHXBuffer

template <class T>
class CHXTExternalPluginHelper
	: public IHXPlugin
    , public IHXPluginProperties
{

public:
	CHXTExternalPluginHelper( ) 
		: m_pContext( NULL )
		, m_lRefCount( 0 )
		, m_pAgent( NULL )
	{
	}

	~CHXTExternalPluginHelper( )
	{
		HX_RELEASE( m_pContext );
		HX_RELEASE( m_pAgent );
	}

	// IHXPlugin Interface Methods                         
	// called by plugin handler to get basic properties 
	STDMETHOD(GetPluginInfo) (THIS_ 
		  REF(BOOL)        bLoadMultiple,
		  REF(const char*) pDescription,
		  REF(const char*) pCopyright,
		  REF(const char*) pMoreInfoURL,
		  REF(UINT32)      versionNumber
		)
	{
		bLoadMultiple = FALSE;
		pDescription  = kValueDescription;
		pCopyright	  = kValueRealCopyright;
		pMoreInfoURL  = kValueGenericMoreInfoURL;
		versionNumber = kDefaultPluginVersion;
		return HXR_OK;
	}

	// called once by plugin handler, and later by session manager with RSMA factory
	STDMETHOD(InitPlugin) (THIS_ IUnknown* pContext )
	{
		if ( !pContext )
		{
			return HXR_POINTER;
		}
		HX_RELEASE(m_pContext);
		m_pContext = pContext;
		m_pContext->AddRef();
		return HXR_OK;
	}

	enum EPropType
	{
		eIntType = 1,
		eStringType,
		eBufferType, 
		eEndType
	};

	struct SValueEntry
	{
		EPropType eType;
		const char* pName;
		void* pData;
		UINT32 uDataSize;
	};

	STDMETHODIMP GetProperties( REF(IHXValues*) pOptions )
	{
		IHXCommonClassFactory  *pCCF = NULL;
		HX_RESULT res = m_pContext->QueryInterface(IID_IHXCommonClassFactory, (void **) &pCCF );
		if (SUCCEEDED(res))
			res = pCCF->CreateInstance( IID_IHXValues, (void **) &pOptions );
		
		if (FAILED(res))
			return res;

		// Count number of components, add appropriate entries to the CLSID->function list
		SValueEntry* pEntry = s_pPluginInfo;
		if( pEntry )
		{
			while( pEntry->eType != eEndType && SUCCEEDED(res) )
			{
				if( pEntry->eType == eStringType )
				{
					res = SetStringProperty( pOptions, pCCF, pEntry->pName, (const char*) pEntry->pData );
				} 
				else if ( pEntry->eType == eIntType )
				{
					res = pOptions->SetPropertyULONG32( pEntry->pName, (ULONG32) pEntry->pData );
				}	
				else if ( pEntry->eType == eBufferType )
				{
					AddBufferProperty( pCCF, pOptions, pEntry->pName, (const unsigned char*) pEntry->pData, pEntry->uDataSize );
				}
				pEntry++;
			}
		}
		HX_RELEASE( pCCF ); 
		return res;
	}
	
	// IUnknown Interface Methods                         
    STDMETHOD(QueryInterface)		(THIS_ REFIID riid, void** ppvObj)
	{
		if (IsEqualIID(riid, IID_IUnknown))
		{
			AddRef();
			*ppvObj = (IUnknown*) (IHXPlugin*) this;
			return HXR_OK;
		}
		else if (IsEqualIID(riid, IID_IHXPlugin))
		{
			AddRef();
			*ppvObj = (IHXPlugin*) this;
			return HXR_OK;
		}
		else if (IsEqualIID(riid, IID_IHXPluginProperties))
		{
			AddRef();
			*ppvObj = (IHXPluginProperties*) this;
			return HXR_OK;
		}
		else 
		{
			if (!m_pAgent)
			{
				m_pAgent = new T();
				if (m_pAgent)
					m_pAgent->AddRef();
			}
			return m_pAgent->QueryInterface( riid, ppvObj );
		}
		*ppvObj = NULL;
		return HXR_NOINTERFACE;
	}
    
	STDMETHOD_(ULONG32,AddRef)		(THIS)
	{
		return InterlockedIncrement(&m_lRefCount);
	}
    
	STDMETHOD_(ULONG32,Release)		(THIS)
	{
		if (InterlockedDecrement(&m_lRefCount) > 0)
		{
			return m_lRefCount;
		}	
		delete this;
		return 0;
	}

protected:
	
	// override for plugin properties
	STDMETHOD(OnGetProperties) ( THIS_ REF(IHXValues*) pIHXValuesProperties ) { return HXR_FAIL; }


	// helper for GetProperties
	HX_RESULT SetStringProperty( IHXValues* pOptions, IHXCommonClassFactory* pFactory, 
		const char* sName, const char* sValue)
	{
		IHXBuffer* pVal = NULL;
		HX_RESULT res = pFactory->CreateInstance( IID_IHXBuffer, (void **) &pVal );

		if (SUCCEEDED(res))
			res = pVal->Set((UCHAR *) sValue, strlen(sValue) +1 );	

		if (SUCCEEDED(res))
			res = pOptions->SetPropertyCString( sName, pVal );

		pVal->Release();
		return res;
	}
	
	void AddBufferProperty( IHXCommonClassFactory* pCCF, IHXValues* pValues, 
		const char* pName, const unsigned char* pValue, UINT32 dataLen )
	{
		IUnknown* pIUnk = NULL;
		if( SUCCEEDED( pCCF->CreateInstance( CLSID_IHXBuffer, (void**) &pIUnk ) ) )
		{
			IHXBuffer* pBuffer = NULL;
			pIUnk->QueryInterface( IID_IHXBuffer, (void**) &pBuffer );

			// NOTE:  We have to do this here, because the Set fails if the ref count is above 1
			HX_RELEASE( pIUnk );

			pBuffer->Set( (const unsigned char *) pValue, dataLen );
			pValues->SetPropertyBuffer( pName, pBuffer );

			HX_RELEASE( pBuffer );
		}
	}

	IUnknown*				m_pContext;					// context for accessing factory

private:    
	static SValueEntry		s_pPluginInfo[];
	LONG32					m_lRefCount;				// QI count
	T*						m_pAgent;
};


#endif // _HXTEXTERNALPLUGINHELPER_H
