/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _RMAFCOPY_H_
#define _RMAFCOPY_H_

struct IHXRMFileSink;
struct IHXValues;
struct IHXProgressSink;

// Prototype to create instance of RMFFCopy object and 
// typedef to get a pointer to this function from the dll
typedef HX_RESULT (HXEXPORT_PTR FPCREATEINSTANCE) (IUnknown** /*OUT*/ ppIUnknown);
STDAPI RMACreateRMFFCopy(IUnknown**  /*OUT*/	ppIUnknown);


/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMFFCopy
 *
 *  Purpose:
 *
 *	Interface to rmff copy module
 *
 *  IHXRMFFCopy
 *
 *  {A8E28270-1A8C-11d2-B65F-00C0F0312253}
 *
 */

class Content;

DEFINE_GUID(IID_IHXRMFFCopy, 
0xa8e28270, 0x1a8c, 0x11d2, 0xb6, 0x5f, 0x0, 0xc0, 0xf0, 0x31, 0x22, 0x53);

#define CLSID_IHXRMFFCopy IID_IHXRMFFCopy


#undef  INTERFACE
#define INTERFACE   IHXRMFFCopy

DECLARE_INTERFACE_(IHXRMFFCopy, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    // *** IHXRMFFCopy methods ***
 
	// ***	Basic Interface ***
 
	// sets the specified .rm file as the input file.
	// Also specifies the file name of an input file to paste to the end of the 
	// first input file
	STDMETHOD(AddInputFile) (THIS_
				const char* szFileName) PURE;  

	// sets the specified .rm file as the output file
	STDMETHOD(SetOutputFile) (THIS_
				const char* szFileName) PURE;  

	// sets the start time for the copy in milliseconds
	STDMETHOD(SetStartTime) (THIS_
				UINT32 ulStartTime) PURE;  

	// sets the end time for the copy in milliseconds. Use 0 to indicate EOF
	STDMETHOD(SetEndTime) (THIS_
				UINT32 ulEndTime) PURE;  

	// sets the content header
	STDMETHOD(SetContent) (THIS_
				Content* pContent) PURE;  

	// sets the content header
	STDMETHOD(SetPropertyFlags) (THIS_
				UINT16 unFlags) PURE;  

    STDMETHOD(SetRMFileSink)	(THIS_
				IHXRMFileSink* pRMFileSink) PURE;

	STDMETHOD(RemoveRMFileSink)	(THIS_
				IHXRMFileSink* pRMFileSink) PURE;

	STDMETHOD(SetMetaInformation) (THIS_
		IHXValues* pMetaInformation) PURE;

	// process the copy
	STDMETHOD(Process) (THIS) PURE;  
};


/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMFFCopy2
 *
 *  Purpose:
 *
 *	Interface to rmff copy module
 *
 *  IHXRMFFCopy2
 *
 *  {4AFA6991-ADC0-11d3-8660-42525E000000}
 *
 */

DEFINE_GUID(IID_IHXRMFFCopy2, 
0x4afa6991, 0xadc0, 0x11d3, 0x86, 0x60, 0x42, 0x52, 0x5e, 0x0, 0x0, 0x0);

#define CLSID_IHXRMFFCopy2 IID_IHXRMFFCopy2

#undef  INTERFACE
#define INTERFACE   IHXRMFFCopy2

DECLARE_INTERFACE_(IHXRMFFCopy2, IHXRMFFCopy)
{
	/************************************************************************
     *	Method:
     *	    IHXRMFFCopy2::AddSaveProgressSink
     *	Purpose:
     *		Add sink which receives callbacks with save progress
	 */	
    STDMETHOD(AddSaveProgressSink)(IHXProgressSink* pProgressSink) PURE;
    
	/************************************************************************
     *	Method:
     *	    IHXRMFFCopy2::RemoveSaveProgressSink
     *	Purpose:
     *		Remove progress-during-save sink
	 */	
    STDMETHOD(RemoveSaveProgressSink)(IHXProgressSink* pProgressSink) PURE;
};

#endif //_RMAFCOPY_H_
