/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 



#ifndef _HXTEVENTCODES_H
#define _HXTEVENTCODES_H

#include "hxtypes.h"

enum EHXTEvent
{   
    
    /*** Encoding SDK events ***/
    
    /* Encoding started/finished events  */
    eEventEncodingStarted = 0,
    eEventEncodingFinished,

    /* Two-pass encoding started/finished events  */
    eEventTwoPassAnalysisStarted,
    eEventTwoPassAnalysisFinished,
    eEventTwoPassEncodingUsingAnalysisStarted,
    eEventTwoPassEncodingUsingAnalysisFinished,
    
    /* Encoding progress */
    eEventEncodeProgress,           /* UINT32 field contains percentage (0-100), IUnknown field contains IHXTTimeDuration*  */
    eEventAnalysisProgress,         /* UINT32 field contains percentage (0-100), IUnknown field contains IHXTTimeDuration*  */
    
    /* Inputs */
    eEventInputStarted = 100,       /* IUnknown field contains IHXTInput*  */
    eEventInputFinished,            /* IUnknown field contains IHXTInput*  */
    eEventInputError,               /* UINT32 field contains error code, IUnknown field contains IHXTInput*  */

    /* Destinations */
    //eEventDestinationBroadcasting is send during rbs broadcast(kValuePluginTypeDestinationPushServer,kValuePluginTypeDestinationPullServer),
    //once connection is established with remote server.
    //eEventDestinationReconnecting is send if connection breaks and reconnect is supported.
    //eEventDestinationBroadcasting will be send again once connection is established.
    eEventDestinationStarted = 120, /* IUnknown field contains IHXTDestination*  */
    eEventDestinationMergeProgress,  /* UINT32 field contains percentage (0-100), IUnknown field contains IHXTDestination*  */
    eEventDestinationFinished,      /* IUnknown field contains IHXTDestination*  */
    eEventDestinationError,         /* UINT32 field contains error code, IUnknown field contains IHXTDestination*  */
    eEventDestinationCanceled,      /* IUnknown field contains IHXTDestination*  */
    eEventDestinationBroadcasting, /* IUnknown field contains IHXTConnectionAgent*  */
    eEventDestinationReconnecting, /* IUnknown field contains IHXTConnectionAgent*  */
    eEventDestinationListening, /* IUnknown field contains IHXTConnectionAgent*  */

    
    //	This event is sent by the codec whenever the complexity level on the
    //	codec changes as a result of a load level change
    eEventStreamConfigEncodingComplexityUpdate = 150,   /* UINT32 field contains Unscaled Load, const char* field contains low, medium, high and IUnknown field contains Pointer to Codec Plugin */

    /*** Filter events ***/
    
    /* Input filters */
    eEventInputFilterStarted = 200, /* IUnknown field contains IHXTConnectionAgent*  */
    eEventInputFilterFinished,      /* IUnknown field contains IHXTConnectionAgent*  */
    eEventInputFilterError,         /* UINT32 field contains error code, IUnknown field contains IHXTConnectionAgent*  */   

    /* Output filters */
    eEventOutputFilterStarted = 220,/* IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputFilterMergeProgress, /* UINT32 field contains percentage (0-100), IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputFilterFinished,     /* IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputFilterError,        /* UINT32 field contains error code, IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputFilterCanceled,     /* IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputFilterStreamDone,   /* used to be eEventStreamDone */
    eEventOutputFilterBroadcasting, /* IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputFilterReconnecting, /* IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputFilterListening,    /* IUnknown field contains IHXTConnectionAgent*  */
    eEventOutputTempFileCreated,    /* const char* field contains name of temp file */


    /* transform filters */
    eEventTransformFilterEncodingComplexityUpdate = 250,    /* UINT32 field contains Unscaled Load, const char* field contains low, medium, high and IUnknown field contains IHXTStreamConfig Pointer */
    eEventTransformFilterError,     /* UINT32 field contains error code, IUnknown field contains IHXTConnectionAgent*  */   
    
    eFirstPerformanceEvent = 1000,

    /*
     * eEventPerformanceOverload
     *
     * This event is sent by load observer to signal that the system has been
     * overloaded for a significant period of time.  The encoding job handles 
     * this event by aborting the encoding process.
     */

    eEventPerformanceOverload,

    /*
     * eEventPerformanceLoad
     *
     * This event is sent by the load observer to signal that the load
     * management system has updated the target load level.  It is meant to be
     * informational only and should not be used by load managed plugins.
     * Plugins should use the dedicated IHXTLoadAdjustment and observers
     * should use the IHXTLoadObserver interface.
     */

    eEventPerformanceLoad,


    eLastPerformanceEvent = 1100,


};


#endif // _HXTEVENTCODES_H
