/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 


#ifndef _HXTBASE_H
#define _HXTBASE_H

#include "ihxtpropertybag.h"	
#include "hxccf.h"	
#include "ihxteventcodes.h"
#include "ihxtconstants.h"
#include "hxevtype.h"
#include "ihxtaudioformat.h"



_INTERFACE IHXValues;
_INTERFACE IHXTMediaSample;
_INTERFACE IHXTServiceBroker;
_INTERFACE IHXTSampleAllocator;
_INTERFACE IHXTSampleSink;
_INTERFACE IHXTEventSink;
_INTERFACE IHXTEventManager;
_INTERFACE IHXTFilter;
_INTERFACE IHXTInputFilter;
_INTERFACE IHXTTransformFilter;
_INTERFACE IHXTConfigurationAgent;
_INTERFACE IHXTConnectionAgent;
_INTERFACE IHXTTime;
_INTERFACE IHXTCaptureDialogControl;
_INTERFACE IHXTAsmHeaderSource;
_INTERFACE IHXTAsmHeaderSink;
_INTERFACE IHXTMediaInputPin;
_INTERFACE IHXTVideoPinFormat;
_INTERFACE IHXTAudioPinFormat;


/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTConfigurationAgent
 *
 *  {4DEDAA51-1D00-4f85-B812-175A377E5964}
 *
 *  Purpose:
 *
 *  Used to configure an object
 *
 *
 *	Methods:
 *
 *	Initialize - Initializes an object with the properties specified in pPropBag.  Returns
 *		a SUCCESS code upon successful initialization.  Will return an error bag containing
 *		the failed property in the FAIL case if ppErrorBag is set.
 */

DEFINE_GUID( IID_IHXTConfigurationAgent, 
0x4dedaa51, 0x1d00, 0x4f85, 0xb8, 0x12, 0x17, 0x5a, 0x37, 0x7e, 0x59, 0x64);

#undef  INTERFACE
#define INTERFACE   IHXTConfigurationAgent

DECLARE_INTERFACE_( IHXTConfigurationAgent, IHXTPropertyBag )
{
	STDMETHOD( Initialize )(THIS_ IHXTPropertyBag* pPropBag, IHXTPropertyBag** ppErrorBag=NULL) PURE;	
};


/* typedefs */
typedef INT64	HXT_TIME;	/* each tick is 1 millisecond */

/* these constants are taken from values in the windows limits.h */
#if defined( WINDOWS ) || defined( WIN32 )
#define HXT_MAX_INT64   9223372036854775807i64
#define HXT_MIN_INT64 (-9223372036854775807i64 - 1)

#else
#define HXT_MAX_INT64   9223372036854775807ll
#define HXT_MIN_INT64 (-9223372036854775807ll - 1)

/* will probably need to defin mac constants here as well */
#endif


/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTMediaSample
 *
 *  {59B4B38B-9793-4178-89A2-918E38BA8F56}
 *
 *  Purpose:
 *
 *  Provides access to a data buffer, as well as flags, and fields, and times
 *	associated with the data buffer.
 *
 *
 *	Methods:
 *
 *	Initialize:
 *		Called to establish the buffer attributes for a given sample.  This method
 *		will be generally be called by allocators.  The sample does not take
 *		ownership of the data and will not free it when the sample is destroyed.  
 *		It is up to the owner of the sample to make sure that the buffer is
 *		properly managed.  As noted above, this is generally the allocator.
 *	Parameters:
 *		This method takes as arguments a pointer to the start of the buffer and
 *		the size of the buffer, measured in bytes.
 *	Threading Behavior:
 *		This method is non-blocking.  It returns only after updating internal
 *		state to reflect the buffer attributes specified by the parameters.
 *	Requirements:
 *		This method returns HXR_OK if the operation succeeded, HXR_FAIL if not.
 *		Although it may vary among different implementations, it is generally
 *		unlikely that this method will fail.  After this method is called, all
 *		subsequent calls to get buffer attributes should reflect the parameters
 *		specified in this call.
 *
 *	Clone - Creates an independent copy of the current media sample and returns
 *		it in ppMediaSample.
 *	CopyProperties - Copies flags, fields, and start/end time from pInSample
 *
 *	GetDataStartForReading - Gets a read-only pointer to the beginning of the data buffer.  The
 *		sdk's implementation of IHXTMediaSample uses a copy-on-write scheme, so users that
 *		intend to write to the data buffer should call GetDataStartForWriting.
 *	GetDataSize - Gets the size of the data buffer
 *	GetDataStartForWriting - Gets a read/write pointer to the beginning of the data buffer.
 *	SetDataStart - Sets the start of the data buffer.  pDataStart should not precede the
 *	start of the data buffer that was originally allocated (calling this method will not cause the
 *		data buffer to be re-allocated).
 *	SetDataSize - Sets the size of the data buffer.  uSize should not exceed the size of the
 *		data buffer that was originally allocated (calling this method will not cause the
 *		data buffer to be re-allocated).
 *	Get/SetSampleFlags - Gets/sets sample flags.  See EHXTSampleProperties.
 *	Get/SetSampleField - Gets/sets sample fields.  See EHXTSampleFieldId.
 *	Get/SetTime - Gets/sets start and end times
 *
 */

DEFINE_GUID( IID_IHXTMediaSample, 
0x59b4b38b, 0x9793, 0x4178, 0x89, 0xa2, 0x91, 0x8e, 0x38, 0xba, 0x8f, 0x56);

#undef  INTERFACE
#define INTERFACE   IHXTMediaSample

 DECLARE_INTERFACE_( IHXTMediaSample, IUnknown )
{
	/* construction and initialization */
	STDMETHOD( Initialize )( THIS_ UCHAR *pBuffer, UINT32 uSize ) PURE;
	STDMETHOD( Clone )( THIS_ IHXTMediaSample **ppMediaSample ) PURE;
	STDMETHOD( CopyProperties )( THIS_ IHXTMediaSample *pInSample ) PURE;	

	/* methods to get data attributes */
	STDMETHOD_( const UCHAR*, GetDataStartForReading )() PURE;
	STDMETHOD_( UINT32, GetDataSize )( THIS_ ) PURE;

	/* methods to set data attributes */
	STDMETHOD_( UCHAR*, GetDataStartForWriting )() PURE;
	STDMETHOD( SetDataStart )( THIS_ UCHAR *pDataStart ) PURE;
	STDMETHOD( SetDataSize )( UINT32 uSize ) PURE;

	/* sample flags  */
	STDMETHOD ( SetSampleFlags )( THIS_ UINT32 uFlags ) PURE;
	STDMETHOD_( UINT32, GetSampleFlags )( THIS ) PURE;
	
	/* sample fields */
    STDMETHOD( GetSampleField )( THIS_ UINT32 uFieldId, UINT32 *puFieldValue ) PURE;
    STDMETHOD( SetSampleField )( THIS_ UINT32 uFieldId, UINT32 uFieldValue ) PURE;
	
	/* media time */
	STDMETHOD( GetTime )( THIS_ HXT_TIME *ptmStart, HXT_TIME *ptmEnd ) PURE;	
	STDMETHOD( SetTime )( HXT_TIME tmStart, HXT_TIME tmEnd ) PURE;
};


typedef enum HXT_SAMPLE_PROPERTY_FLAGS
{ 
	HXT_SAMPLE_DATADISCONTINUITY  = 0x01,	/* Indicates the start of a new segment.  */
	HXT_SAMPLE_KEYFRAME        	 = 0x02,	/* Sample is a keyframe */
	HXT_SAMPLE_ENDOFSTREAM        = 0x04,	/* Last sample for the current stream  */
	HXT_STREAM_ACCURATE_END_TIME	 = 0x08,	/* Actual end time of a particular stream */
											/* (used when there is extraneous padding at the end of a stream */
	HXT_SAMPLE_ASM_HEADERS		 = 0x10		/* Sample contains ASM headers -- QI for IHXTAsmHeaderSource/IHXTAsmHeaderSink */


} EHXTSampleProperties;


/* typedef enum HXT_SAMPLE_FIELD_ID */
typedef enum HXT_SAMPLE_FIELD_ID
{ 
	HXT_FIELD_ASM_RULE = 0,			/* ASM rule number */
	HXT_FIELD_ASM_FLAGS,				/* ASM flags	 */
	HXT_FIELD_STREAM_ID,				/* Stream ID */
	HXT_FIELD_LOGICAL_STREAM_ID,		/* Logical stream ID */
	HXT_FIELD_MULTI_FRAME_SIZES,		/* reserved */
	HXT_FIELD_RTP_TIME,
	HXT_FIELD_SEQUENCE_NUMBER,		/* monotonically increasing number */ 
	HXT_FIELD_COUNT
} EHXTSampleFieldId;




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTSampleAllocator
 *
 *  {9F381347-2A99-4893-B0D6-85B1DEA29B5E}
 *
 *  Purpose:
 *
 *  Used to allocate IHXTMediaSamples
 *
 *
 *	Methods:
 *
 *	GetMediaSampleOfSize - Requests an IHXTMediaSample containing a data buffer of size uSize.
 *	Decommit - De-allocates resources.  Should not be called by filters.
 *	Commit - Allocates resources.  Should not be called by filters.
 */

DEFINE_GUID( IID_IHXTSampleAllocator, 
0x9f381347, 0x2a99, 0x4893, 0xb0, 0xd6, 0x85, 0xb1, 0xde, 0xa2, 0x9b, 0x5e);

#undef  INTERFACE
#define INTERFACE   IHXTSampleAllocator

DECLARE_INTERFACE_( IHXTSampleAllocator, IUnknown )
{
	STDMETHOD ( GetMediaSampleOfSize ) ( THIS_ UINT32 uSize, IHXTMediaSample** ppMediaSample ) PURE;
};




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTSampleSink
 *
 *  {BF6A6A7F-E77A-49cf-BE30-6063131ED0CF}
 *
 *  Purpose:
 *
 *  Used to receive IHXTMediaSamples
 *
 *
 *	Methods:
 *
 *	ReceiveSample - Called with a media sample.  Note: Do not reuse (e.g., read from or write 
 *  to the data buffer) the media sample after passing it to ReceiveSample.  The media sample 
 *  is not automatically memcpy'ed, so accessing it may result in undefined behavior.  For example, 
 *  some other object may have a refcount on it and modify the buffer on another thread.
 */

DEFINE_GUID( IID_IHXTSampleSink, 
0xbf6a6a7f, 0xe77a, 0x49cf, 0xbe, 0x30, 0x60, 0x63, 0x13, 0x1e, 0xd0, 0xcf);

#undef  INTERFACE
#define INTERFACE   IHXTSampleSink

DECLARE_INTERFACE_( IHXTSampleSink, IUnknown )
{
	STDMETHOD( ReceiveSample )( THIS_ IHXTMediaSample *pSample ) PURE;
};


/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTServiceBroker
 *
 *  {C53DF720-4A57-400c-A4F8-68C2CF08917A}
 *
 *  Purpose:
 *
 *  Used to request services by interface GUID
 *
 *
 *	Methods:
 *
 *	GetService - Requests an object that implements the interface specified by guid.
 */

DEFINE_GUID( IID_IHXTServiceBroker, 
0xc53df720, 0x4a57, 0x400c, 0xa4, 0xf8, 0x68, 0xc2, 0xcf, 0x8, 0x91, 0x7a);

#undef  INTERFACE
#define INTERFACE   IHXTServiceBroker

DECLARE_INTERFACE_( IHXTServiceBroker, IUnknown )
{
	STDMETHOD( GetService )( THIS_ const GUID &guid, IUnknown **ppUnknown ) PURE;
};





/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTEventSink
 *
 *  {7D8D5E8D-9A0D-459a-B9C8-739B9FEEA82F}
 *
 *  Purpose:
 *
 *  Used to receive events
 *
 *
 *	Methods:
 *
 *	HandleEvent - Sends an event to the event sink.  See ihxteventcodes.h for a list
 *		of EHXTEvent enums.  A NULL value for puValue, cszValue, or pUnknown indicates
 *		that the field is unused for that particular type of event.  Objects that
 *		implement this interface may process events synchronously or asynchronously.
 */

DEFINE_GUID( IID_IHXTEventSink, 
0x7d8d5e8d, 0x9a0d, 0x459a, 0xb9, 0xc8, 0x73, 0x9b, 0x9f, 0xee, 0xa8, 0x2f);

#undef  INTERFACE
#define INTERFACE   IHXTEventSink

DECLARE_INTERFACE_( IHXTEventSink, IUnknown )
{
	STDMETHOD( HandleEvent )( THIS_ EHXTEvent eEvent, UINT32 *puValue = NULL, const char *cszValue = NULL, IUnknown *pUnknown = NULL ) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTEventManager
 *
 *  {E897B731-B177-4c70-BE67-D6CF3D7E2973}
 *
 *  Purpose:
 *
 *  Used to subscribe/unsubscribe for events
 *
 *
 *	Methods:
 *
 *	Subscribe - Subscribes for events.  Caller must implement an event sink and pass
 *		a pointer to the event sink using pEventSink.  Subscription occurs asynchronously,
 *		and may not have happened by the time the call returns.
 *	Unsubscribe - Call this method to stop receiving events.  Unsubscription
 *		occurs asynchronously, and may not have happened by the time the call returns.
 */

DEFINE_GUID( IID_IHXTEventManager, 
0xe897b731, 0xb177, 0x4c70, 0xbe, 0x67, 0xd6, 0xcf, 0x3d, 0x7e, 0x29, 0x73);

#undef  INTERFACE
#define INTERFACE   IHXTEventManager

DECLARE_INTERFACE_( IHXTEventManager, IUnknown )
{
	STDMETHOD( Subscribe )( THIS_ IHXTEventSink *pEventSink ) PURE;
	STDMETHOD( Unsubscribe )( THIS_ IHXTEventSink *pEventSink ) PURE;
};





/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTFilter
 *
 *  {00627955-83B2-407f-862D-924FF1517EA9}
 *
 *  Purpose:
 *
 *  Must be implemented by all plugin filter
 *
 *
 *	Methods:
 *
 *	SetFactory - Called to provide the filter with a factory from which to construct 
 *	SetGraphServices - Called to provide the filter with a service broker from which to 
 *		access shared resources and services.
 *	Prime - Called to notify the filter that it will be receiving (or asked to provide) media samples 
 *		shortly.  This call will always precede calls to ReceiveSample.  uStream refers 
 *		to output streams on input and transform filters, and input streams on output 
 *		filters.  Note that input filters only have output streams, and output filters only
 *		have input streams.  Upon a successful completion of this method, the filter must be
 *		prepared to process data for the corresponding stream.  The ReadSample and ReceiveSample
 *		methods will only be called if Prime succeeds.  If Prime fails but the error is recoverable
 *		the system may try to recover and call Prime again.
 * 
 *	DiscardCachedSamples - Called to signal the filter to release any cached samples it may 
 *		have.  This method may be called at any time between Prime and Teardown calls.  If
 *		ReceiveSample is called after DiscardCachedSamples, the sample will generally be marked 
 *		with end of stream.  uStream refers to output streams on input filters, and input streams 
 *		on transform and output filters.  Note that input filters only have output streams, and 
 *		output filters only have input streams.  This method should return HXR_OK if there were 
 *		no cached samples or if there were cached sample and they were released.  It should
 *		return HXR_FAIL if there were cached sample and that could not be released.
 *	Teardown - Called to signal that the filter graph will be stopped shortly.  uStream
 *		refers to output streams on input filters, and input streams on transform and 
 *		output filters.  Note that input filters only have output streams, and output filters only
 *		have input streams.  The filter must not send samples after the return of this call.
 *		The filter must be written to safely handle being released after Teardown is called.  This means 
 *		that if the filter uses threads internally, and since Teardown should not block, the thread 
 *		should gracefully exit asynchronously.
 */

DEFINE_GUID( IID_IHXTFilter, 
0x627955, 0x83b2, 0x407f, 0x86, 0x2d, 0x92, 0x4f, 0xf1, 0x51, 0x7e, 0xa9);

#undef  INTERFACE
#define INTERFACE   IHXTFilter

DECLARE_INTERFACE_( IHXTFilter, IUnknown )
{

	STDMETHOD( SetFactory ) ( THIS_ IHXCommonClassFactory* pCCF ) PURE;
	STDMETHOD( SetGraphServices ) ( THIS_ IHXTServiceBroker* pGraphServices ) PURE;
	STDMETHOD( Prime )( THIS_ UINT32 uStream ) PURE;
	STDMETHOD( DiscardCachedSamples )( THIS_ UINT32 uStream ) PURE;
	STDMETHOD( Teardown )( THIS_ UINT32 uStream ) PURE;
};




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTInputFilter
 *
 *  {9B9E205B-CC01-4bfc-92F9-E568F88B736C}
 *
 *  Purpose:
 *
 *  Must be implemented by all input filters
 *
 *
 *	Methods:
 *
 *	SetAllocator - Called to provide the filter with a media sample allocator
 *	ReadSample
 *		Requests the next media sample for a particular stream. Filters will typically
 *		use the allocator provided in IHXTInputFilter::SetAllocator to create the media
 *		samples returned by the call to this method. If no sample is currently available
 *		for a particular stream, but should be shortly (such as in the case of
 *		audio/video capture), the filter should return HXR_S_NOT_HANDLED.
 *
 *		Note: Do not reuse (e.g., read from or write to the data buffer) the media sample after 
 *  	passing it to ReadSample.  The media sample is not automatically memcpy'ed, so accessing 
 *  	it may result in undefined behavior.  For example, some other object may have a 
 *  	refcount on it and modify the buffer on another thread. 
 *
 *	Signature:
 *		STDMETHOD(ReadSample) ( THIS_ 
 *								UINT32 uStreamID,
 *								IHXTMediaSample** ppSample ) PURE;
 *	Parameters:
 *		uStreamID:
 *		The identity of the stream that contains the media sample.
 *		
 *		ppSample:
 *		Address of a pointer to an IHXTMediaSample interface that manages the
 *		media sample to be read.
 *
 *	Threading Behavior:
 *		This call must not block.  If there is no sample available, but there will be in
 *		the future, it should return HXR_S_NOT_HANDLED.
 *		
 *	Behavior:
 *		If a valid sample can be produced, the filter should assign the sample to the
 *		ppSample in/out parameter and return HXR_OK.  The sample does not need to
 *		contain data, but it must have valid timestamps and flags.  If the end of
 *		stream has been reached, the filter must return HXR_S_END_OF_STREAM.  If 
 *		data is available, the filter should create a sample, and return it.  If
 *		there is no data available, the filter does not need to create the sample.
 *		Instead, the system will create one and send it downstream.
 *		
 *		The filter should return HXR_S_NOT_HANDLED if there is no data available
 *		but the end of the stream has not been reached.  ReadSample will continue
 *		to be called after this result.
 */

DEFINE_GUID( IID_IHXTInputFilter, 
0x9b9e205b, 0xcc01, 0x4bfc, 0x92, 0xf9, 0xe5, 0x68, 0xf8, 0x8b, 0x73, 0x6c);

#undef  INTERFACE
#define INTERFACE   IHXTInputFilter

DECLARE_INTERFACE_( IHXTInputFilter, IHXTFilter )
{	
	STDMETHOD( SetAllocator ) ( THIS_ UINT32 uStreamID, IHXTSampleAllocator *pAllocator ) PURE;
	STDMETHOD( ReadSample )( THIS_ UINT32 uStreamID, IHXTMediaSample** /*Out*/ ppSample ) PURE;
};




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTTransformFilter
 *
 *  {FB17765C-73DB-44ae-A87C-FFFA148FED0B}
 *
 *  Purpose:
 *
 *  Must be implemented by all transform filters
 *
 *
 *	Methods:
 *
 *	SetSampleSink - Called to set the media sample destination.  A typical transform filter
 *		will receive an incoming media sample via ReceiveSample, allocate a new sample
 *		using the allocator passed via SetAllocator, and deliver the outgoing sample to
 *		the IHXTSampleSink specified by SetSampleSink.  
 *	SetAllocator - Called to provide the filter with a media sample allocator
 *	ReceiveSample - Called to send the filter the next media sample to process.  Note that a 
 *		filter should only send a sample to the IHXTSampleSink within scope of the ReceiveSample
 *		call (i.e., if a filter processes samples on a separate thread, it must wait until
 *		the next ReceiveSample call to propagate the sample)
 */

DEFINE_GUID( IID_IHXTTransformFilter, 
0xfb17765c, 0x73db, 0x44ae, 0xa8, 0x7c, 0xff, 0xfa, 0x14, 0x8f, 0xed, 0xb);

#undef  INTERFACE
#define INTERFACE   IHXTTransformFilter

DECLARE_INTERFACE_( IHXTTransformFilter, IHXTFilter )
{
	STDMETHOD( SetSampleSink ) ( THIS_ UINT32 uStreamID, IHXTSampleSink* pOutputSink ) PURE;
	STDMETHOD( SetAllocator ) ( THIS_ UINT32 uStreamID, IHXTSampleAllocator* pAllocator ) PURE;
	STDMETHOD( ReceiveSample )( THIS_ UINT32 uStreamID, IHXTMediaSample* pSample ) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTOutputFilter
 *
 *  {3EFC0A11-0E84-4f93-B30F-8D3CD75F44AE}
 *
 *  Purpose:
 *
 *  Must be implemented by all output filters
 *
 *
 *	Methods:
 *
 *	ReceiveSample - Called to send the filter the next media sample to process
 */

DEFINE_GUID( IID_IHXTOutputFilter, 
0x3efc0a11, 0xe84, 0x4f93, 0xb3, 0xf, 0x8d, 0x3c, 0xd7, 0x5f, 0x44, 0xae);

#undef  INTERFACE
#define INTERFACE   IHXTOutputFilter

DECLARE_INTERFACE_( IHXTOutputFilter, IHXTFilter )
{
	STDMETHOD( ReceiveSample )( THIS_ UINT32 uStreamID, IHXTMediaSample* pSample ) PURE;
};






/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTConnectionAgent
 *
 *  {079FA228-B71E-49c0-92DA-8BAE07E6F521}
 *
 *  Purpose:
 *
 *  Used to advertise the various formats a filter can connect with.  Must be 
 *	implemented by all filters.
 *
 *
 *	Methods:
 *
 *	GetInputStreamCount - Returns the total number of possible input streams that can be connected.
 *	GetSupportedInputFormat - Gets the format for a particular input stream.  A filter can specify support for 
 *		multiple value for a single property (such as multiple audio sample rates) by using list and range properties. 
 *	GetPreferredInputFormat - Gets the zero-based prefered format for a particular input stream.  Returning a FAIL
 *		code indicates no preference.
 *	GetNegotiatedInputFormat - Called to retrieve the negotiated format set by SetNegotiatedInputFormat.  Filters can
 *		simply save off the property bag specified by SetNegotiatedInputFormat.
 *	SetNegotiatedInputFormat - Called to notify the filter that an input stream has been connected.  pInputFormat
 *		contains the format that was negotiated for the connection.
 *
 * 	GetOutputStreamCount - Returns the total number of possible output streams that can be connected.
 *	GetSupportedOutputFormat - Gets the format for a particular output stream.  A filter can specify support for 
 *		multiple value for a single property (such as multiple audio sample rates) by using list and range properties. 
 *	GetPreferredOutputFormat - Gets the zero-based prefered format for a particular output stream.  Returning a FAIL
 *		code indicates no preference.
 *	GetNegotiatedOutputFormat - Called to retrieve the negotiated format set by SetNegotiatedOutputFormat.  Filters can
 *		simply save off the property bag specified by SetNegotiatedOutputFormat.
 *	SetNegotiatedOutputFormat - Called to notify the filter that an output stream has been connected.  pOutputFormat
 *		contains the format that was negotiated for the connection.
 */

DEFINE_GUID( IID_IHXTConnectionAgent, 
0x79fa228, 0xb71e, 0x49c0, 0x92, 0xda, 0x8b, 0xae, 0x7, 0xe6, 0xf5, 0x21);

#undef  INTERFACE
#define INTERFACE   IHXTConnectionAgent

DECLARE_INTERFACE_( IHXTConnectionAgent, IUnknown )
{
	STDMETHOD_( UINT32, GetInputStreamCount ) ( THIS ) PURE;
	STDMETHOD ( GetSupportedInputFormat ) ( THIS_ UINT32 uIndex, IHXTPropertyBag** ppSupportedFormats ) PURE;
	STDMETHOD ( GetPreferredInputFormat ) ( THIS_ UINT32 uIndex, UINT32 uPrefRank, IHXTPropertyBag** ppPreferredFormat ) PURE;
	STDMETHOD ( GetNegotiatedInputFormat ) ( THIS_ UINT32 uIndex, IHXTPropertyBag** pSupportedFormats ) PURE;
	STDMETHOD ( SetNegotiatedInputFormat ) ( THIS_ UINT32 uStreamID, IHXTPropertyBag* pInputFormat ) PURE;

	STDMETHOD_( UINT32, GetOutputStreamCount) ( THIS ) PURE;	
	STDMETHOD ( GetSupportedOutputFormat ) ( THIS_ UINT32 uIndex, IHXTPropertyBag** pSupportedFormats ) PURE;	
	STDMETHOD ( GetPreferredOutputFormat ) ( THIS_ UINT32 uIndex, UINT32 uPrefRank, IHXTPropertyBag** ppPreferredFormat ) PURE;
	STDMETHOD ( GetNegotiatedOutputFormat ) ( THIS_ UINT32 uIndex, IHXTPropertyBag** pSupportedFormats )  PURE;
	STDMETHOD ( SetNegotiatedOutputFormat ) ( THIS_ UINT32 uStreamID, IHXTPropertyBag* pOutputFormat ) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTPluginInfoEnum
 *
 *  {5006420C-D967-4b57-810E-999C98D8E427}
 *
 *  Purpose:
 *
 *  Used to enumerate a set of plugin object instances
 *
 *
 *	Methods:
 *
 *	GetCount - Retrieves the number of plugin instances
 *	GetPluginInfoAt - Gets plugin-specific information about a particular plugin instance
 */

DEFINE_GUID(IID_IHXTPluginInfoEnum, 
0x5006420c, 0xd967, 0x4b57, 0x81, 0xe, 0x99, 0x9c, 0x98, 0xd8, 0xe4, 0x27);

#undef  INTERFACE
#define INTERFACE   IHXTPluginInfoEnum

DECLARE_INTERFACE_( IHXTPluginInfoEnum, IUnknown )
{
	STDMETHOD_( UINT32, GetCount ) ( THIS ) PURE;
	STDMETHOD ( GetPluginInfoAt )( THIS_ UINT32 ulIndex, IHXTPropertyBag ** ppIPluginInfo ) PURE;
};





/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTCaptureDialogControl
 *
 *  {791D2D69-2695-4a7a-98E7-3A0A9187CC46}
 *
 *  Purpose:
 *
 *  Used to launch capture dialog windows. 
 *  These may be provided by the operating system or capture driver vendors
 *
 *
 *	Methods:
 *
 *	LaunchDialog - displays a dialog for changing capture parameters
 *		Each capture dialog has its own unige identifier. 
 *		The window pointer is OS specific. For Windows DirectShow it is the 
 *		HWND window handle of the parent window. 
 *		LaunchDialog returns an error for certain dialogs if a capture is running.
 *		In this case, stop the capture, launch the dialog again and restart the capture.
 *		Mapping of identifiers to dialog name: the input source can be queried for property bags 
 *		kPropAudioCaptureDialogs and kPropVideoCaptureDialogs. These property bags each contain a 
 *		property bag kPropCaptureDialogNames which holds dialog name - identfier value pairs.
 */

DEFINE_GUID(IID_IHXTCaptureDialogControl, 
0x791d2d69, 0x2695, 0x4a7a, 0x98, 0xe7, 0x3a, 0xa, 0x91, 0x87, 0xcc, 0x46);

#undef  INTERFACE
#define INTERFACE   IHXTCaptureDialogControl

DECLARE_INTERFACE_( IHXTCaptureDialogControl, IUnknown )
{
	STDMETHOD_(HX_RESULT,LaunchDialog)	(THIS_ INT32 nIdentifier, void*	window) PURE;
};





static const char kValueTimeInfiniteString[] = "infinite";
static const double kValueTimeInfiniteDouble = -1.;
static const INT64 kValueTimeInfiniteInt = -1;

/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTTime
 *
 *  {FFF0FC1A-AA93-4108-B69D-57E504F25213}
 *
 *  Purpose:
 *
 *  General purpose time interface
 *
 *
 *	Methods:
 *
 *	SetMilliSeconds - Sets time in milliseconds using an INT64
 *	GetMilliSeconds - Gets time in milliseconds using an INT64
 *	SetTime - Sets time in milliseconds using a double
 *	GetTime - Gets time in milliseconds using a double
 *	SetTimeString - Sets time using a string with the format ddd:hh:mm:ss.ms
 *	GetTimeString - Gets the time string
 */
DECLARE_INTERFACE_( IHXTTime, IUnknown )
{
	STDMETHOD_( HX_RESULT, SetMilliSeconds )( THIS_ const INT64 nMilliSeconds ) PURE;
	STDMETHOD_( HX_RESULT, GetMilliSeconds )( THIS_ INT64* pnMilliSeconds ) const PURE;

	STDMETHOD_( HX_RESULT, SetTime )( THIS_ const double dMilliSeconds ) PURE;
	STDMETHOD_( HX_RESULT, GetTime )( THIS_ double* pdMilliSeconds ) const PURE;
	
	STDMETHOD_( HX_RESULT, SetTimeString )( THIS_ const char*  chTime ) PURE;
	STDMETHOD_(const char*, GetTimeString )( THIS_ BOOL bTerse = FALSE) PURE;
};                    


#undef  INTERFACE
#define INTERFACE   IHXTTime

DEFINE_GUID(IID_IHXTTime, 
0xfff0fc1a, 0xaa93, 0x4108, 0xb6, 0x9d, 0x57, 0xe5, 0x4, 0xf2, 0x52, 0x13);

 





/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTEventSample
 *
 *  {51264D91-20C1-11d6-8A13-00D0B7100250}
 *
 *  Purpose:
 *
 *  Used to store fields for event streams
 *
 *
 *	Methods:
 *
 *	SetAction - Sets event action
 *	GetAction - Gets event action
 */

DEFINE_GUID( IID_IHXTEventSample,
0x51264d91, 0x20c1, 0x11d6, 0x8a, 0x13, 0x0, 0xd0, 0xb7, 0x10, 0x2, 0x50);

#undef  INTERFACE
#define INTERFACE   IHXTEventSample

DECLARE_INTERFACE_( IHXTEventSample, IHXTMediaSample )
{
    STDMETHOD(SetAction)(THIS_
   			    UINT16 nType,
			    const char* pString,
                IHXValues* pOtherParam ) PURE;

    STDMETHOD(GetAction)(THIS_
   			    UINT16* pnType,
			    const char** ppString,
                IHXValues** ppOtherParam ) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTAudioPinFormat
 *
 *  {C470BF41-B24B-4006-97AA-E7DDCA632AEE}
 *
 *  Purpose:
 *
 *  Used to specify the format of audio samples that will be passed 
 *	to the encoding engine.
 *
 *
 *	Methods:
 *
 *	Get/SetSampleRate - Gets/sets the sample rate of audio samples 
 *	  passed to the encoding engine.
 *	Get/SetSampleFormat - Gets/sets the sample format (bits per sample, bit packing) of 
 *	  audio samples passed to the encoding engine.  See EHXTAudioSampleFormat in ihxtaudioformat.h.
 *	Get/SetChannelFormat - Gets/sets the channel format (speaker layout) in audio 
 *	  samples passed to the encoding engine.  See EHXTAudioChannelFormat in ihxtaudioformat.h.
 *
 */

DEFINE_GUID(IID_IHXTAudioPinFormat,
0xc470bf41, 0xb24b, 0x4006, 0x97, 0xaa, 0xe7, 0xdd, 0xca, 0x63, 0x2a, 0xee);

#undef  INTERFACE
#define INTERFACE   IHXTAudioPinFormat

DECLARE_INTERFACE_(IHXTAudioPinFormat, IUnknown)
{   
    STDMETHOD(GetSampleRate) (THIS_	UINT32* pulSamplesPerSec) PURE;
    STDMETHOD(SetSampleRate) (THIS_	UINT32 ulSamplesPerSec) PURE;

    STDMETHOD(GetSampleFormat) (THIS_ EHXTAudioSampleFormat* peSampleFormat) PURE;
    STDMETHOD(SetSampleFormat) (THIS_ EHXTAudioSampleFormat eSampleFormat) PURE;

    STDMETHOD(GetChannelFormat) (THIS_ EHXTAudioChannelFormat* peChannelFormat) PURE;
    STDMETHOD(SetChannelFormat) (THIS_ EHXTAudioChannelFormat eChannelFormat) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTVideoPinFormat
 *
 *  {DD001A92-18CF-410c-91B6-241E74A4F509}
 *
 *  Purpose:
 *
 *  Used to specify the format of video samples that will be passed
 *	to the encoding engine
 *
 *
 *	Methods:
 *
 *	Get/SetFrameDimensions - Gets/sets the frame dimensions of video samples 
 *	  passed to the encoding engine.
 *	Get/SetColorFormat - Gets/sets the video color format of video samples 
 *	  passed to the encoding engine.
 *	Get/SetFrameRate - Gets/sets the frame rate rate of video samples passed to
 *	  the encoding engine.
 */

DEFINE_GUID(IID_IHXTVideoPinFormat,
0xdd001a92, 0x18cf, 0x410c, 0x91, 0xb6, 0x24, 0x1e, 0x74, 0xa4, 0xf5, 0x9);

#undef  INTERFACE
#define INTERFACE   IHXTVideoPinFormat

DECLARE_INTERFACE_(IHXTVideoPinFormat, IUnknown)
{   
    STDMETHOD(GetFrameDimensions) (THIS_ UINT32* pulWidth, UINT32* pulHeight) PURE;
    STDMETHOD(SetFrameDimensions) (THIS_ UINT32 ulWidth, UINT32 ulHeight) PURE;

    STDMETHOD(GetColorFormat) (THIS_ EHXTVideoColorFormat* peVideoFormat) PURE;
    STDMETHOD(SetColorFormat) (THIS_ EHXTVideoColorFormat eVideoFormat) PURE;   

    STDMETHOD(GetFrameRate)	(THIS_ double* pdFrameRate) PURE;
    STDMETHOD(SetFrameRate)	(THIS_ double dFrameRate) PURE;
};





/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTMediaInputPin
 *
 *  {4AEAA9E4-0F44-4f5c-BD45-8246614D0C70}
 *
 *  Purpose:
 *
 *  Used to pass uncompressed media samples to the encoding engine.  Can
 *	QI for IHXTVideoPinFormat/IHXTAudioPinFormat to set encoding format
 *
 *
 *	Methods:
 *
 *	EncodeSample - Passes a media sample to the encoding engine.  Note that IHXTMediaSamples
 *	  are ref-counted, and should not be re-used.  
 *	  Also note that the size of the buffer being used for audio data should exactly match 
 *	  the size of the audio chunk (do not allocate a larger buffer).  Since audio start/end timestamps only 
 *	  have millisecond resolution, some portions of the Producer SDK determine the audio chunk size
 *	  based on the buffer size, not the start/end timestamps.
 *	GetPinEnabled - Determines if the media pin is enabled.  By default, only the
 *	audio and video media pins are enabled.
 *	SetPinEnabled - Sets whether the media pin is enabled or not.
 *
 */

DEFINE_GUID(IID_IHXTMediaInputPin,
0x4aeaa9e4, 0xf44, 0x4f5c, 0xbd, 0x45, 0x82, 0x46, 0x61, 0x4d, 0xc, 0x70);

#undef  INTERFACE
#define INTERFACE   IHXTMediaInputPin

DECLARE_INTERFACE_(IHXTMediaInputPin, IUnknown)
{   
	STDMETHOD(EncodeSample) (THIS_ IHXTMediaSample* pMediaSample) PURE;
	STDMETHOD(GetPinEnabled) (THIS_ BOOL* pbEnablePin) PURE;
	STDMETHOD(SetPinEnabled) (THIS_ BOOL bEnablePin) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTAsmHeaderSource
 *
 *  {C8CB8032-125D-11d5-96DD-00D0B7068A6E}
 *
 *  Purpose:
 *
 *  Specifies the format of an ASM stream
 *
 *
 *	Methods:
 *
 *	GetFileHeader - Called to retrieve the file header
 *	GetStreamHeader - Called to retrieve a stream header
 *
 */
DEFINE_GUID(IID_IHXTAsmHeaderSource, 
	    0xc8cb8032, 0x125d, 0x11d5, 0x96, 0xdd, 0x0, 0xd0, 0xb7, 0x6, 0x8a, 0x6e);

#undef  INTERFACE
#define INTERFACE   IHXTAsmHeaderSource

DECLARE_INTERFACE_(IHXTAsmHeaderSource, IUnknown)
{
    STDMETHOD(GetFileHeader) (THIS_ IHXValues** ppFileHeader) PURE;
    STDMETHOD(GetStreamHeader) (THIS_ UINT32 ulStreamNum, IHXValues** ppStreamHeader) PURE;
};




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTAsmHeaderSink
 *
 *  {ED256053-5129-11d5-96E2-00D0B7068A6E}
 *
 *  Purpose:
 *
 *  Specifies the format of an ASM stream
 *
 *
 *	Methods:
 *
 *	SetFileHeader - Called to set the file header
 *	SetStreamHeader - Called to set a stream header
 *
 */

DEFINE_GUID(IID_IHXTAsmHeaderSink, 
	    0xed256053, 0x5129, 0x11d5, 0x96, 0xe2, 0x0, 0xd0, 0xb7, 0x6, 0x8a, 0x6e);


#undef  INTERFACE
#define INTERFACE   IHXTAsmHeaderSink

DECLARE_INTERFACE_(IHXTAsmHeaderSink, IUnknown)
{
    STDMETHOD(SetFileHeader) (THIS_ IHXValues* pFileHeader) PURE;
    STDMETHOD(SetStreamHeader) (THIS_ UINT32 ulStreamNum, IHXValues* pStreamHeader) PURE;

};




/****************************************************************************
 * 
 *  Interface:
 *
 *  IHXTAsmHeaderTransform
 *
 *  Purpose:
 *
 *  Updates an ASM stream header
 *
 *  IID_IHXTAsmHeaderTransform
 *
 *  {9F785912-511C-11d5-96E2-00D0B7068A6E}
 *
 */
DEFINE_GUID(IID_IHXTAsmHeaderTransform, 
	    0x9f785912, 0x511c, 0x11d5, 0x96, 0xe2, 0x0, 0xd0, 0xb7, 0x6, 0x8a, 0x6e);


#undef  INTERFACE
#define INTERFACE   IHXTAsmHeaderTransform

DECLARE_INTERFACE_(IHXTAsmHeaderTransform, IUnknown)
{

	STDMETHOD(UpdateStreamHeader) (IHXValues* pStreamHeader) PURE;
};




/****************************************************************************
 * 
 *  Interface:
 *
 *  IHXTAsmConnectionProperty
 *
 *  Purpose:
 *
 *  ASM Custom Connection 
 *
 *  IID_IHXTAsmConnectionProperty
 *
 *  {6280F634-4963-4ce5-9606-98455FAC2B0E}
 *
 */

DEFINE_GUID(IID_IHXTAsmConnectionProperty, 
		0x6280f634, 0x4963, 0x4ce5, 0x96, 0x6, 0x98, 0x45, 0x5f, 0xac, 0x2b, 0xe);


#undef  INTERFACE
#define INTERFACE   IHXTAsmConnectionProperty

DECLARE_INTERFACE_(IHXTAsmConnectionProperty, IUnknown)
{
	STDMETHOD(SetAsmHeaderSource) (IHXTAsmHeaderSource* pAsmHeaderSource) PURE;
};






/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTStatistics
 *
 *  Purpose:
 *
 *  Gets Statistics.
 *
 *  {{DCF75EA0-63CA-11d6-9415-0002B31090EC}
 *
 *
 */
// 

DEFINE_GUID(IID_IHXTStatistics, 
0xdcf75ea0, 0x63ca, 0x11d6, 0x94, 0x15, 0x0, 0x2, 0xb3, 0x10, 0x90, 0xec);


#undef  INTERFACE
#define INTERFACE   IHXTStatistics

DECLARE_INTERFACE_(IHXTStatistics, IUnknown)
{
   STDMETHOD(GetCurrentStatistics)( IHXTPropertyBag* pStatsBag ) PURE;
 
   STDMETHOD(GetLifeTimeStatistics)( IHXTPropertyBag* pStatsBag ) PURE;
};


/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTLoadAdjustment
 *
 *  {20475D6E-B073-4cad-A287-530570DC0134}
 *
 *  Purpose:
 *
 *  Implemented by components that consume significant cpu load.  This
 *  interface provides the means of scaling load to meet external constraints. 
 *  This is necessary in order to gracefully degrade quality when the system
 *  is overloaded.
 *
 *	Methods:
 *	    GetLoadLevel( UINT32 *puLoadLevel )
 *		- Returns the current load level
 * 	    SetLoadLevel )( UINT32 uLoadLevel )
 *		- Sets the desired load level
 *
 */

// {20475D6E-B073-4cad-A287-530570DC0134}
DEFINE_GUID( IID_IHXTLoadAdjustment, 0x20475d6e, 0xb073, 0x4cad, 0xa2, 0x87, 0x53, 0x5, 0x70, 0xdc, 0x1, 0x34);

#undef  INTERFACE
#define INTERFACE   IHXTLoadAdjustment

DECLARE_INTERFACE_( IHXTLoadAdjustment, IUnknown )
{
	STDMETHOD( GetLoadLevel )( UINT32 *puLoadLevel ) PURE;
	STDMETHOD( SetLoadLevel )( UINT32 uLoadLevel ) PURE;
};











/****************************************************************************
 *
 *  IHXTConfigurationPlugin interface
 *
 *  This interface enables sharing of configuration properties between plugins.
 *  Its current use is to enable packetization plugins to retrieve configuration
 *  settings from the codec to aid in correct packetization configuration.
 *
 */

#undef  INTERFACE
#define INTERFACE   IHXTConfigurationPlugin

// {49587F12-3FBA-489c-B592-AC589F86C299}
DEFINE_GUID(IID_IHXTConfigurationPlugin, 
0x49587f12, 0x3fba, 0x489c, 0xb5, 0x92, 0xac, 0x58, 0x9f, 0x86, 0xc2, 0x99);

DECLARE_INTERFACE_( IHXTConfigurationPlugin, IUnknown)
{
    //	IHXTConfigurationPlugin
    STDMETHOD(SetUpstreamConfigurationAgent)(THIS_ IHXTConfigurationAgent* pDepConfigAgent) PURE;
    STDMETHOD(SetDownstreamConfigurationAgent)(THIS_ IHXTConfigurationAgent* pDepConfigAgent) PURE;
};





#endif // _HXTBASE_H
