/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 

#ifndef _HXPLUGN_H_
#define _HXPLUGN_H_

#include "hxcom.h"
#include "hxplugncompat.h"

/*
 * Forward declarations of some interfaces defined or used here-in.
 */
typedef _INTERFACE  IUnknown			    IUnknown;
typedef _INTERFACE  IHXPlugin			    IHXPlugin;
typedef _INTERFACE  IHXPluginEnumerator	    IHXPluginEnumerator;
typedef _INTERFACE  IHXBuffer			    IHXBuffer;
typedef _INTERFACE  IHXValues			    IHXValues;
typedef _INTERFACE  IHXPreferences		    IHXPreferences;

// Plugin Types.
#define	PLUGIN_FILESYSTEM_TYPE	    "PLUGIN_FILE_SYSTEM"
#define	PLUGIN_FILEFORMAT_TYPE	    "PLUGIN_FILE_FORMAT"
#define	PLUGIN_FILEWRITER_TYPE	    "PLUGIN_FILE_WRITER"
#define	PLUGIN_METAFILEFORMAT_TYPE  "PLUGIN_METAFILE_FORMAT"
#define	PLUGIN_RENDERER_TYPE	    "PLUGIN_RENDERER"
#define PLUGIN_REVERTER_TYPE	    "PLUGIN_REVERTER"
#define PLUGIN_BROADCAST_TYPE	    "PLUGIN_BROADCAST"
#define PLUGIN_STREAM_DESC_TYPE	    "PLUGIN_STREAM_DESC"
#define PLUGIN_ALLOWANCE_TYPE	    "PLUGIN_ALLOWANCE"
#define PLUGIN_PAC_TYPE		    "PLUGIN_PAC"
#define PLUGIN_CLASS_FACTORY_TYPE   "PLUGIN_CLASS_FACT"

#define	PLUGIN_CLASS		    "PluginType"
#define PLUGIN_FILENAME		    "PluginFilename"
#define PLUGIN_REGKEY_ROOT	    "PluginHandlerData"
#define PLUGIN_PLUGININFO	    "PluginInfo"
#define PLUGIN_GUIDINFO		    "GUIDInfo"
#define PLUGIN_NONHXINFO	    "NonHXDLLs"
#define PLUGIN_IDENTIFIER	    "Plugin#"
// This may no longer be needed...
#define PLUGINDIRECTORYHASH	    "DirHash"	    
// XXXAH WHO is defining this ... I think I know..
#define PLUGIN_DESCRIPTION2	    "Description"	
// XXXAH WHO is defining this ... I think I know..
#define PLUGIN_FILE_HASH	    "FileHash"
#define PLUGIN_INDEX		    "IndexNumber"
#define PLUGIN_FILENAMES	    "FileInfo"
#define PLUGIN_COPYRIGHT2	    "Copyright"
#define PLUGIN_LOADMULTIPLE	    "LoadMultiple"
#define PLUGIN_VERSION		    "Version"
#define PLUGIN_FILESYSTEMSHORT	    "FileShort"
#define PLUGIN_FILESYSTEMPROTOCOL   "FileProtocol"
#define PLUGIN_FILEMIMETYPES	    "FileMime"
#define PLUGIN_FILEEXTENSIONS	    "FileExtensions"
#define PLUGIN_FILEOPENNAMES	    "FileOpenNames"
#define PLUGIN_RENDERER_MIME	    "RendererMime"
#define PLUGIN_RENDERER_GRANULARITY "Renderer_Granularity"
#define PLUGIN_REVERTER_MIME	    "ReverterMime"
#define PLUGIN_BROADCASTTYPE	    "BroadcastType"
#define PLUGIN_STREAMDESCRIPTION    "StreamDescription"

// 
#define PLUGIN_GUID_RESPONSE	    "MainGuid"
#define PLUGIN_FACTORY_GUIDS	    "" // These are comma delimited.

//

#define PLUGIN_NUM_PLUGINS	    "NumPlugins"
#define PLUGIN_FILE_CHECKSUM	    "DLLCheckSum"
#define PLUGIN_DLL_SIZE		    "DLLSize"
#define PLUGIN_HAS_FACTORY	    "DLLHasFactory"

/****************************************************************************
 * 
 *  Function:
 * 
 *	HXCreateInstance()
 * 
 *  Purpose:
 * 
 *	Function implemented by all plugin DLL's to create an instance of 
 *	any of the objects supported by the DLL. This method is similar to 
 *	Window's CoCreateInstance() in its purpose, except that it only 
 *	creates objects from this plugin DLL.
 *
 *	NOTE: Aggregation is never used. Therefore an outer unknown is
 *	not passed to this function, and you do not need to code for this
 *	situation.
 * 
 */
#ifdef _MAC_CFM
#pragma export on
#endif

STDAPI HXCreateInstance
		(
		    IUnknown**  /*OUT*/	ppIUnknown
		);
		
#ifdef _MAC_CFM
#pragma export off
#endif


/****************************************************************************
 * 
 *  Function:
 * 
 *	HXShutdown()
 * 
 *  Purpose:
 * 
 *	Function implemented by all plugin DLL's to free any *global* 
 *	resources. This method is called just before the DLL is unloaded.
 *
 */
#ifdef _MAC_CFM
#pragma export on
#endif

STDAPI HXShutdown(void);
		
#ifdef _MAC_CFM
#pragma export off
#endif


/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXPlugin
 * 
 *  Purpose:
 * 
 *	Interface exposed by a plugin DLL to allow inspection of objects
 *	supported by the plugin DLL.
 * 
 *  IID_IHXPlugin:
 * 
 *	{00000C00-0901-11d1-8B06-00A024406D59}
 * 
 */

DEFINE_GUID(IID_IHXPlugin, 0x00000C00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
			0xa0, 0x24, 0x40, 0x6d, 0x59);

#undef  INTERFACE
#define INTERFACE   IHXPlugin

DECLARE_INTERFACE_(IHXPlugin, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					REFIID riid,
					void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)		(THIS) PURE;

    STDMETHOD_(ULONG32,Release)		(THIS) PURE;

    /*
     *	IHXPlugin methods
     */

    /************************************************************************
     *	Method:
     *	    IHXPlugin::GetPluginInfo
     *	Purpose:
     *	    Returns the basic information about this plugin. Including:
     *
     *	    bMultipleLoad	Whether or not this plugin can be instantiated
     *				multiple times. All File Formats must set
     *				this value to TRUE.  The only other type of
     *				plugin that can specify bMultipleLoad=TRUE is
     *				a filesystem plugin.  Any plugin that sets
     *				this flag to TRUE must not use global variables
     *				of any type.
     *
     *				Setting this flag to TRUE implies that you
     *				accept that your plugin may be instantiated
     *				multiple times (possibly in different
     *				address spaces).  Plugins are instantiated
     *				multiple times only in the server (for
     *				performance reasons).
     *
     *				An example of a plugin, that must set this
     *				flag to FALSE is a filesystem plugin that 
     *				uses a single TCP connection to communicate
     *				with a database.
     *				
     *	    pDescription	which is used in about UIs (can be NULL)
     *	    pCopyright		which is used in about UIs (can be NULL)
     *	    pMoreInfoURL	which is used in about UIs (can be NULL)
     *	    ulVersionNumber	The version of this plugin.
     */
    STDMETHOD(GetPluginInfo)	(THIS_
				REF(BOOL)	 /*OUT*/ bMultipleLoad,
				REF(const char*) /*OUT*/ pDescription,
				REF(const char*) /*OUT*/ pCopyright,
				REF(const char*) /*OUT*/ pMoreInfoURL,
				REF(ULONG32)	 /*OUT*/ ulVersionNumber) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin::InitPlugin
     *	Purpose:
     *	    Initializes the plugin for use. This interface must always be
     *	    called before any other method is called. This is primarily needed 
     *	    so that the plugin can have access to the context for creation of
     *	    IHXBuffers and IMalloc.
     */
    STDMETHOD(InitPlugin)   (THIS_
			    IUnknown*   /*IN*/  pContext) PURE;

};


/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXPluginEnumerator
 * 
 *  Purpose:
 * 
 *	provide methods to enumerate through all the plugins installed
 * 
 *  IID_IHXPluginEnumerator:
 * 
 *	{00000C01-0901-11d1-8B06-00A024406D59}
 * 
 */

DEFINE_GUID(IID_IHXPluginEnumerator, 0x00000C01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
		0xa0, 0x24, 0x40, 0x6d, 0x59);

#undef  INTERFACE
#define INTERFACE   IHXPluginEnumerator

DECLARE_INTERFACE_(IHXPluginEnumerator, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					REFIID riid,
					void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)		(THIS) PURE;

    STDMETHOD_(ULONG32,Release)		(THIS) PURE;

    /*
     *	IHXPluginEnumerator methods
     */

    /************************************************************************
     *	Method:
     *	    IHXPluginEnumerator::GetNumOfPlugins
     *
     *	Purpose:    
     *	    return the number of plugins available
     *
     */
    STDMETHOD_(ULONG32,GetNumOfPlugins)	(THIS) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPluginEnumerator::GetPlugin
     *	Purpose:
     *	    Return an instance (IUnknown) of the plugin
     *
     */
    STDMETHOD(GetPlugin)   (THIS_
			   ULONG32	   /*IN*/  ulIndex,
			   REF(IUnknown*)  /*OUT*/ pPlugin) PURE;

};

/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXPluginGroupEnumerator
 * 
 *  Purpose:
 * 
 *	Provide a way to enumerate through all of the plugins which
 *	implement a specific interface.
 * 
 *  IID_IHXPluginGroupEnumerator:
 * 
 *	{00000C02-0901-11d1-8B06-00A024406D59}
 * 
 */

DEFINE_GUID(IID_IHXPluginGroupEnumerator, 0x00000C02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
		0xa0, 0x24, 0x40, 0x6d, 0x59);

#undef  INTERFACE
#define INTERFACE   IHXPluginGroupEnumerator

#define CLSID_IHXPluginGroupEnumerator IID_IHXPluginGroupEnumerator

DECLARE_INTERFACE_(IHXPluginGroupEnumerator, IUnknown)
{
    /*
     * IUnknown methods
     */

    /*
     * IHXPluginGroupEnumerator methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					REFIID riid,
					void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)		(THIS) PURE;

    STDMETHOD_(ULONG32,Release)		(THIS) PURE;

    /******************************************************************
     * Method:
     *	    IHXPluginGroupEnumerator::Init
     *
     * Purpose:
     *	    tell the group enumerator which interface to group the plugins
     *     into, this method must be called before the other methods can
     *     be called.
     *
     */
    STDMETHOD(Init)         (THIS_
                            REFIID    iid) PURE;


    /******************************************************************
     * Method:
     *     IHXPluginGroupEnumerator::GetNumOfPlugins
     *
     * Purpose:
     *     return the number of plugins available that support a
     *	   particular interface.
     *
     */
    STDMETHOD_(ULONG32,GetNumOfPlugins) (THIS) PURE;


    /******************************************************************
     * Method:
     *     IHXPluginGroupEnumerator::GetPlugin
     * Purpose:
     *     Return an instance (IUnknown) of the plugin
     *
     */
    STDMETHOD(GetPlugin)   (THIS_
      UINT32    /*IN*/  ulIndex,
      REF(IUnknown*)  /*OUT*/ pPlugin) PURE;

};





/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXPluginReloader
 * 
 *  Purpose:
 * 
 *	Tells the client core to reload all plugins.
 * 
 *  IID_IHXPluginReloader:
 * 
 *	{00000C03-0901-11d1-8B06-00A024406D59}
 * 
 */

DEFINE_GUID(IID_IHXPluginReloader, 0x00000C03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
		0xa0, 0x24, 0x40, 0x6d, 0x59);

#undef  INTERFACE
#define INTERFACE   IHXPluginReloader

DECLARE_INTERFACE_(IHXPluginReloader, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					REFIID riid,
					void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)		(THIS) PURE;

    STDMETHOD_(ULONG32,Release)		(THIS) PURE;

    /*
     *	IHXPluginReloader methods
     */

    /************************************************************************
     *	Method:
     *	    IHXPluginReloader::ReloadPlugins
     *	Purpose:    
     *	    Causes the client core to reload all plugins.
     *
     */
    STDMETHOD(ReloadPlugins)	(THIS) PURE;
};



/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXPluginFactory
 * 
 *  Purpose:
 * 
 *	This interface is implemented by a plugin in order to have more then
 *	    one "RMA plugin" in a single DLL.  I.e., a plugin author could
 *	    use this interface to have 3 different file format plugins in
 *	    a single DLL.
 * 
 *  IID_IHXPluginFactory:
 * 
 *	{00000C04-0901-11d1-8B06-00A024406D59}
 * 
 */

DEFINE_GUID(IID_IHXPluginFactory, 0x00000C04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
		0xa0, 0x24, 0x40, 0x6d, 0x59);

#undef  INTERFACE
#define INTERFACE   IHXPluginFactory

DECLARE_INTERFACE_(IHXPluginFactory, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					 REFIID riid,
					 void** ppvObj) PURE;
    
    STDMETHOD_(ULONG32,AddRef)		(THIS) PURE;
    
    STDMETHOD_(ULONG32,Release)		(THIS) PURE;
    
    /*
     *	IHXPluginFactory methods
     */
    
    /*****************************************************************
     *	Method:
     *	    IHXPluginFactory::GetNumPlugins
     *	Purpose:
     *	    Report the number of Plugins within the DLL.
     *
     *	Parameters:
     */
    STDMETHOD_(UINT16, GetNumPlugins) (THIS)  PURE;

    /*****************************************************************
     *	Method:
     *	    IHXPluginFactory::GetPlugin
     *	Purpose:
     *	    Returns an IUnknown interface to the requested plugin. 
     *	
     *	Parameters:
     */

    STDMETHOD(GetPlugin) (THIS_
			 UINT16 	uIndex, 
			 IUnknown**  	pPlugin) PURE;
};



/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXGenericPlugin
 * 
 *  Purpose:
 * 
 *	Interface exposed by a plugin DLL to inform the client / server core
 *	that your plugin wishes to have InitPlugin called immediately.
 *
 *  IID_IHXGenericPlugin:
 * 
 *	{00000C09-0901-11d1-8B06-00A024406D59}
 * 
 */

DEFINE_GUID(IID_IHXGenericPlugin, 0x00000C09, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
			0xa0, 0x24, 0x40, 0x6d, 0x59);

#undef  INTERFACE
#define INTERFACE   IHXGenericPlugin

DECLARE_INTERFACE_(IHXGenericPlugin, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					REFIID riid,
					void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)		(THIS) PURE;

    STDMETHOD_(ULONG32,Release)		(THIS) PURE;

    /*
     *	IHXGenericPlugin methods
     */

    STDMETHOD(IsGeneric)	(THIS_
				REF(BOOL)	 /*OUT*/ bIsGeneric) PURE;
};


DEFINE_GUID(IID_IHXPluginHandler,	0x00000200, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0);

DEFINE_GUID(IID_IHXPlugin2Handler,	0x00000201, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0);

#undef  INTERFACE
#define INTERFACE   IHXPlugin2Handler

DECLARE_INTERFACE_(IHXPlugin2Handler, IUnknown)
{
    /*
     *  IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    /*
     *	IHXPlugin2Handler Methods
     */

     /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::Init
     *
     *	Purpose:    
     *	    Specifies the context and sets the pluginhandler in motion.
     *
     */
    STDMETHOD(Init)    (THIS_ IUnknown* pContext) PURE;
     
     /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::GetNumPlugins2
     *
     *	Purpose:    
     *	    Gets the info of a particular plugin.
     *
     */
    STDMETHOD_(ULONG32,GetNumOfPlugins2)    (THIS) PURE;
    
    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::GetPluginInfo
     *
     *	Purpose:    
     *	    Gets the info of a particular plugin.
     *
     */
    STDMETHOD(GetPluginInfo)	(THIS_ 
				UINT32 unIndex, 
				REF(IHXValues*) /*OUT*/ Values) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::FlushCache()
     *
     *	Purpose:    
     *	    Flushes the LRU cache -- Unloads all DLLs from memory 
     *	    which currenltly have a refcount of 0.
     */

    STDMETHOD(FlushCache)	(THIS) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::SetCacheSize
     *
     *	Purpose:    
     *	    This function sets the size of the Cache. The cache is 
     *	    initally set to 1000KB. To disable the cache simply set
     *	    the size to 0.If the cache is disabled a DLL will be 
     *	    unloaded whenever it's refcount becomes zero. Which MAY
     *	    cause performance problems.
     */

    STDMETHOD(SetCacheSize)	(THIS_ ULONG32 nSizeKB) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::GetInstance
     *
     *	Purpose:    
     *	    
     *	    This function will return a plugin instance given a plugin index.
     *		
     */

    STDMETHOD(GetInstance) (THIS_ UINT32 index, REF(IUnknown*) pUnknown) PURE; 

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::FindIndexUsingValues
     *
     *	Purpose:    
     *	    Finds a plugin  which matches the set of values given. An index
     *	    is returned which can be used to either get the values (using 
     *	    GetPluginInfo) or an instance can be created using GetPluing(). 	
     * 
     */

    STDMETHOD(FindIndexUsingValues)	    (THIS_ IHXValues*, 
						    REF(UINT32) unIndex) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::FindPluginUsingValues
     *
     *	Purpose:    
     *	    Finds a plugin  which matches the set of values given. A Plugin
     *	    instance is returned. 
     *	    
     */

    STDMETHOD(FindPluginUsingValues)	    (THIS_ IHXValues*, 
						    REF(IUnknown*) pUnk) PURE;
    
    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::FindIndexUsingStrings
     *
     *	Purpose:    
     *	    Finds a plugin  which matches the set of values given. An index
     *	    is returned which can be used to either get the values (using 
     *	    GetPluginInfo) or an instance can be created using GetPluing(). 	
     *	    NOTE: that a max of two values may be given.
     */

    STDMETHOD(FindIndexUsingStrings)	    (THIS_ char* PropName1, 
						    char* PropVal1, 
						    char* PropName2, 
						    char* PropVal2, 
						    char* PropName3, 
						    char* PropVal3, 
						    REF(UINT32) unIndex) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::FindPluginUsingStrings
     *
     *	Purpose:    
     *	    Finds a plugin  which matches the set of values given. A Plugin
     *	    instance is returned. 
     *	    NOTE: that a max of two values may be given.
     */

    STDMETHOD(FindPluginUsingStrings)	    (THIS_ char* PropName1, 
						    char* PropVal1, 
						    char* PropName2, 
						    char* PropVal2, 
						    char* PropName3, 
						    char* PropVal3, 
						    REF(IUnknown*) pUnk) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::FindImplementationFromClassID
     *
     *	Purpose:    
     *	    Finds a CommonClassFactory plugin which supports the 
     *	    ClassID given. An instance of the Class is returned. 
     */

    STDMETHOD(FindImplementationFromClassID)
    (
	THIS_ 
	REFGUID GUIDClassID, 
	REF(IUnknown*) pIUnknownInstance
    ) PURE;

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::Close
     *
     *	Purpose:    
     *	    A function which performs all of the functions of delete.
     *	    
     *
     */
    
    STDMETHOD(Close)		(THIS) PURE; 

    /************************************************************************
     *	Method:
     *	    IHXPlugin2Handler::SetRequiredPlugins
     *
     *	Purpose:    
     *	    This function sets the required plugin list
     *	    
     *
     */

    STDMETHOD(SetRequiredPlugins) (THIS_ const char** ppszRequiredPlugins) PURE;


};









#endif /* _HXPLUGN_H_ */
