import os
import re
import sys

from dirwalker import DirWalker
from isumake import IsUmakeFile

class UmakeWalker(DirWalker):
    def __init__(self, opts):
        self.opts = opts
        
        if self.opts.has_key('verbose'): self.m_bVerbose = 1
        else: self.m_bVerbose = 0

    def Visit(self, f):
        fpstr = os.path.join(self.baseDir, self.subDir, f)
        if IsUmakeFile(fpstr, self.opts):
            if self.opts.has_key('fullpath'):
                outstr = fpstr
            elif len(self.baseFile) > 0:
                # If "walking" a file instead of dir...
                outstr = self.baseFile
            else:
                outstr = os.path.join(self.subDir, f)

            if self.opts.has_key('print0'):
                sys.stdout.write(outstr + "\0")
            elif self.opts.has_key('xargs'):
                print "\"%s\"" % outstr
            else:
                print outstr

