
import os
import re
import sys

from dirwalker import DirWalker

class FeatureWalker(DirWalker):
    def __init__(self, opts):
        self.opts = opts
        self.featuredict = {}
        self.fileMatchRE = re.compile(r'[uU]makefil|.*\.([chHC]|cpp?|CPP?|rc|pcf)')
        self.fileNoMatchRE = re.compile(r'([mM]akefile|Entries|README.*|Repository|Root|Tag|.*\.([aio]|dll|in|lib|mak|obj|orig.*|so[\.0-9]*|ver))$')
        self.featureSearchRE = re.compile("HELIX_FEATURE\w+")
        self.contentSearchRE = re.compile(r'(project\.|common_(includes|libraries|srcs)|MultiTarget)',
                                          re.DOTALL)
        
        if self.opts.has_key('verbose'): self.m_bVerbose = 1
        else: self.m_bVerbose = 0

    def Visit(self, f):
        filepath = os.path.join(self.baseDir, self.subDir, f)
        if self.m_bVerbose: print "# Visit(%s)" % filepath

        bMayHaveFeatures = 0
        if not os.path.isfile(filepath):
            if self.m_bVerbose: print "#...is not a regular file"
        elif self.fileMatchRE.match(f):
            if self.m_bVerbose: print "#...matched filename"
            bMayHaveFeatures = 1
        elif self.fileNoMatchRE.match(f):
            if self.m_bVerbose: print "#...no-matched filename"
        else:
            if self.m_bVerbose: print "#...no filename pattern match...scanning file contents"
            bMayHaveFeatures = self.ScanFile(filepath)

        if bMayHaveFeatures:
            self.ScanForFeatures(filepath)

    def ScanFile(self, f):
        if self.m_bVerbose: print "# ScanFile(%s)" % f
        file = None
        try:
            file = open(f)
        except:
            print "# WARNING: Error opening %s" % f

        m = None
        if file:
            fileStr = file.read()
            file.close()
            
            m = self.contentSearchRE.search(fileStr)

            if self.m_bVerbose:
                if m: print "#...this is a umake file"
                else: print "#...this is NOT a umake file"

        return m

    def ScanForFeatures(self, f):
        if self.m_bVerbose: print "# ScanForFeatures(%s)" % f
        file = None
        try:
            file = open(f)
        except:
            print "# WARNING: Error opening %s" % f

        m = None
        if file:
            fileStr = file.read()
            file.close()

            m = self.featureSearchRE.search(fileStr)
            while m:
                featureStr = fileStr[m.start():m.end()]
                if self.m_bVerbose: print "#...found feature %s" % featureStr
                if featureStr not in self.featuredict:
                    if self.m_bVerbose: print "#...adding feature %s to dictionary" % featureStr
                    self.featuredict[featureStr] = 1
                else:
                    if self.m_bVerbose: print "#...feature %s already in dictionary" % featureStr
                    
                pos = m.end()
                m = self.featureSearchRE.search(fileStr, pos)

    def PrintOutDictionary(self):
        if self.m_bVerbose: print "# Printing out dictionary"

        featurelist = []
        for q in self.featuredict:
            featurelist.append(q)
        featurelist.sort()

        for r in featurelist:
            print "project.AddDefines(\"%s\")" % r
