#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>

#include "lcdutils.h"
#include "lcd_private.h"


void lcd_setcursorpos(void *lcd_private, unsigned char address) 
{
  struct lcd_private *lcd = lcd_private;

  if (!lcd || (lcd->fd < 0)) 
    return;

  lcd->display.cursor_address = address;
  ioctl(lcd->fd, LCD_Set_Cursor_Pos, &lcd->display);
}


void lcd_setcursor(void *lcd_private, unsigned char character)
{
  struct lcd_private *lcd = lcd_private;

  if (!lcd || (lcd->fd < 0)) 
    return;

  lcd->display.character = character;
  ioctl(lcd->fd, LCD_Set_Cursor, &lcd->display);
}


int lcd_getcursorpos(void *lcd_private)
{ 
  struct lcd_private *lcd = lcd_private;

  if (!lcd || (lcd->fd < 0)) 
    return -1;

  ioctl(lcd->fd, LCD_Get_Cursor_Pos, &lcd->display);
  return lcd->display.cursor_address;
}


int lcd_getcursor(void *lcd_private)
{ 
  struct lcd_private *lcd = lcd_private;

  if (!lcd || (lcd->fd < 0)) 
    return -1;

  ioctl(lcd->fd, LCD_Get_Cursor, &lcd->display);
  return lcd->display.character;
}
/* Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: 
 * 
 * -Redistribution of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * -Redistribution in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution. 
 *
 * Neither the name of Sun Microsystems, Inc. or the names of contributors may
 * be used to endorse or promote products derived from this software without 
 * specific prior written permission.

 * This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
 */
