#!/usr/bin/perl -w -I/usr/sausalito/perl -I.
# $Id: am_enabled.pl,v 1.7 2001/06/13 17:40:28 will Exp $
# Copyright 2000, 2001 Sun Microsystems, Inc., All rights reserved.
# 
# ActiveMonitor.*.enabled handler
# author: Tim Hockin (based on work by Jonathan Mayer <jmayer@cobalt.com>)
#
use strict;
use CCE;

my $cce = new CCE;
$cce->connectfd();

# retreive object data:
my $oid = $cce->event_oid();
my $ns = $cce->event_namespace();
my ($ok, $newobj, $oldobj) = $cce->get($oid, $ns);

my ($olden, $newen, $oldmon, $newmon);
$olden = $oldobj->{enabled} ? 1 : 0;
$newen = $newobj->{enabled} ? 1 : 0;
$oldmon = $oldobj->{monitor} ? 1 : 0;
$newmon = $newobj->{monitor} ? 1 : 0;

# only set on a real change of boolean value, not just string value
if (!($olden eq $newen) || !($oldmon eq $newmon)) {
	# since we have changed a monitoring state - blank out state data
	($ok) = $cce->set($oid, $ns, { 
		currentState => 'N',
		currentMessage => '',
		lastChange => time()});
	if (!$ok) {
		$cce-bye('FAIL');
	}
}

$cce->bye('SUCCESS');
exit(0);
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
