#include <bw_mgmt.h>
#include <linux/proc_fs.h>

#ifndef min
#define min(x, y) ((x) < (y) ? (x) : (y))
#endif

#define TEST_FAMILY AF_INET
#define TEST_PROTO 6

extern struct net_proto_family user_sock_family;
struct net_proto_family *fams[NPROTO];
extern int errno;
extern char *optarg;
struct proc_dir_entry proc_root;


#define MAX_SOCK_ADDR 128


#define VERB_SCHED 0x1
int verbose = 0; 

void
dbg_printf(int flag, const char *fmt, ...)
{
    va_list ap;

    if (flag & verbose)
	vprintf(fmt, ap);
    va_end(ap);
}

main(int ac, char **av)
{
    sock_register(&user_sock_family);
    bw_init_all();
    stub_init();
    printf("starting multi-threaded operation\n");
    user_interact();
    return;

}

void __pollwait(struct file * filp, struct wait_queue ** wait_address,
		poll_table *p)
{
}

void 
kfree(const void *buf)
{
    free((void *) buf);
}

void *
kmalloc(size_t size, int type)
{
    return (void *) malloc(size);
}

int
memcpy_fromiovec(unsigned char *kdata, struct iovec *iov, int len)
{
    while(len>0) {
	if(iov->iov_len) { 
	    int copy=min(len,iov->iov_len);
	    memcpy(kdata, iov->iov_base, copy);
	    len-=copy;
	    kdata+=copy;
	    iov->iov_base+=copy;
	    iov->iov_len-=copy; 
	}
	iov++;   
    }

}


void
panic(const char *fmt, ...)
{
    va_list ap;

    vprintf(fmt, ap);
    va_end(ap);

    while (1)
	sleep(1);
}

asmlinkage
int
printk(const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    vprintf(fmt, ap);
    va_end(ap);
}

put_user_4(int val, int *dest)
{
    *dest = val;
}

unsigned long jiffies;
struct timer_list *tim_list;

long interruptible_sleep_on_timeout(struct wait_queue **p,
	signed long timeout)
{
    struct timer_list tim;
    extern void *look_me_up();
    extern void wake_him_up();

    init_timer(&tim);

    tim.data = (long) look_me_up();
    tim.function = wake_him_up;
    tim.expires = timeout + jiffies;
    add_timer(&tim);
    interruptible_sleep_on(p);
}

void interruptible_sleep_on(struct wait_queue **p)
{
    void *my_id;
    struct wait_queue wait;
    struct wait_queue **wpp;
    extern void *set_me_to_sleep();

    my_id = set_me_to_sleep();
    wait.task = (struct task_struct *) my_id;
    wait.next = *p;

    *p = &wait;

    schedule();

    for (wpp = p; (*wpp) ; wpp = &(*wpp)->next) 
	if ((*wpp) == &wait) {
	    *wpp = wait.next;
	    break;
	}
}

int
send_sig(int sig, struct task_struct *p, int priv)
{
}

void
__wake_up(struct wait_queue **q, unsigned int mode)
{
    struct wait_queue *wp;
    extern void wake_him_up(void *);

    for (wp = *q; wp ; wp = wp->next) {
	wake_him_up((void *) wp->task);
    }
}

#undef current
struct task_struct *current, current_data;

rwlock_t waitqueue_lock;
struct cpuinfo_x86 boot_cpu_data;


stub_init()
{
    current = &current_data;
    /*
     * The world is our oyster.
     */
    current->addr_limit.seg = 0xffff0000;
    boot_cpu_data.wp_works_ok = 1;
}

int __verify_write(const void * addr, unsigned long size)
{
    return 1;
}


int real_sock_register(struct net_proto_family *famp)
{
    fams[famp->family] = famp;

    printf("real_sock_register called - family %d registered\n", famp->family);
}

int real_sock_unregister(int family)
{
    printf("real_sock_register called\n");
}

int
user_sock_create(struct socket *sock, int protocol)
{
    extern struct proto_ops user_sock_proto;

    printf("user_sock_create called - protocol %d\n", protocol);
    if (protocol == user_sock_proto.family)
	sock->ops = &user_sock_proto;
    else printf("unknown protocol\n");

    return 0;
}

int
user_sock_dup(struct socket *newsock, struct socket *oldsock)
{
    printf("user_sock_dup called\n");
    return 0;
}

int
user_sock_release(struct socket *sock, struct socket *peer)
{
    printf("user_sock_release called\n");
    return 0;
}

int
user_sock_bind(struct socket *sock, struct sockaddr *umyaddr, int sockaddr_len)
{
    sock->sk = (struct sock *) malloc(sizeof(*sock->sk));
    sock->sk->rcv_saddr = * (int *) umyaddr->sa_data;
    printf("user_sock_bind called\n");
    return 0;
}

int
user_sock_connect(struct socket *sock, struct sockaddr *uservaddr,
		int sockaddr_len, int flags)
{
    printf("user_sock_connect called\n");
    return 0;
}

int
user_sock_socketpair(struct socket *sock1, struct socket *sock2)
{
    printf("user_sock_socketpair called\n");
    return 0;
}

int
user_sock_accept(struct socket *sock, struct socket *newsock,
                         int flags)
{
    printf("user_sock_accept called\n");
    return 0;
}

int
user_sock_getname(struct socket *sock, struct sockaddr *uaddr,
                         int *usockaddr_len, int peer)
{
    printf("user_sock_getname called\n");
    return 0;
}

#if LINUX_VERSION_CODE < 0x20200
user_sock_select,
#else
unsigned int
user_sock_poll(struct file *file, struct socket *sock,
		struct poll_table_struct *wait)
{
    printf("user_sock_poll called\n");
    return POLLIN | POLLRDNORM | POLLOUT | POLLWRNORM;
}
#endif

int
user_sock_ioctl(struct socket *sock, unsigned int cmd,
                         unsigned long arg)
{
    printf("user_sock_ioctl called\n");
    return 0;
}

int
user_sock_listen(struct socket *sock, int len)
{
    printf("user_sock_listen called\n");
    return 0;
}

int
user_sock_shutdown(struct socket *sock, int flags)
{
    printf("user_sock_shutdown called\n");
    return 0;
}

int
user_sock_setsockopt(struct socket *sock, int level, int optname,
                         char *optval, int optlen)
{
    printf("user_sock_setsockopt called\n");
    return 0;
}

int
user_sock_getsockopt(struct socket *sock, int level, int optname,
                         char *optval, int *optlen)
{
    printf("user_sock_getsockopt called\n");
    return 0;
}

int
user_sock_fcntl(struct socket *sock, unsigned int cmd,
                         unsigned long arg)
{
    printf("user_sock_fcntl called\n");
    return 0;
}

int
user_sock_sendmsg(struct socket *sock, struct msghdr *m, int total_len,
		struct scm_cookie *scm)
{
    extern int sock_to_fdnum(struct socket *);
    static int errcnt = 0;
    extern int error_freq;

    printf("\t%d : user_sock_sendmsg - %d bytes on socket fd %d\n", 
	    jiffies, total_len, sock_to_fdnum(sock));

    if (random() % 100 < error_freq)
	return -42;

    return total_len;
}

int
user_sock_recvmsg(struct socket *sock, struct msghdr *m, int total_len,
		int flags, struct scm_cookie *scm)
{
    printf("user_sock_recvmsg called\n");
    return 0;
}

struct net_proto_family user_sock_family = {
    TEST_FAMILY, user_sock_create, 0, 0, 0 
};

struct proto_ops user_sock_proto = {
	TEST_PROTO,
#if LINUX_VERSION_CODE < 0x20200
	user_sock_create,
#endif
	user_sock_dup,
	user_sock_release,
	user_sock_bind,
	user_sock_connect,
	user_sock_socketpair,
	user_sock_accept,
	user_sock_getname,
#if LINUX_VERSION_CODE < 0x20200
	user_sock_select,
#else
	user_sock_poll,
#endif
	user_sock_ioctl,
	user_sock_listen,
	user_sock_shutdown,
	user_sock_setsockopt,
	user_sock_getsockopt,
	user_sock_fcntl,
	user_sock_sendmsg,
	user_sock_recvmsg,
};

struct socket test_sock, dup_sock;

test_sock_create()
{
    return fams[TEST_FAMILY]->create(&test_sock, TEST_PROTO);
}

test_sock_accept()
{
    int flags;	/* file flags on src socket - O_NONBLOCK, etc. */
    char address[MAX_SOCK_ADDR];
    int len = MAX_SOCK_ADDR;

    dup_sock.type = test_sock.type;
    test_sock.ops->dup(&dup_sock, &test_sock);

    test_sock.ops->accept(&test_sock, &dup_sock, flags);

    test_sock.ops->getname(&dup_sock, (struct sockaddr *)address, &len, 1);

}

test_sock_release()
{
}

test_sock_bind(struct sockaddr *address, int len)
{
    test_sock.ops->bind(&test_sock, (struct sockaddr *) address, len);
}

test_sock_connect()
{
    char address[MAX_SOCK_ADDR];
    int flags; /* open flags */

    test_sock.ops->connect(&test_sock, (struct sockaddr *)address,
		MAX_SOCK_ADDR, flags);
}

test_sock_socketpair()
{
    test_sock.ops->socketpair(&test_sock, &dup_sock);
}

test_sock_getname()
{
    char address[MAX_SOCK_ADDR];
    int len = MAX_SOCK_ADDR;

    test_sock.ops->getname(&test_sock, (struct sockaddr *)address, &len, 1);
}

#if LINUX_VERSION_CODE < 0x20200
test_sock_select()
{
}

#else

struct file test_file;

test_sock_poll()
{
    poll_table wait;

    test_sock.ops->poll(&test_file, &test_sock, &wait);
}

#endif

int
test_sock_ioctl(int fd, unsigned int cmd, unsigned long arg)
{
    extern struct socket *socklist[];
    return socklist[fd]->ops->ioctl(socklist[fd], cmd, arg);
}

test_sock_listen()
{
    int backlog = 5;

    test_sock.ops->listen(&test_sock, backlog);
}

test_sock_shutdown()
{
    int how;

    test_sock.ops->shutdown(&test_sock, how);
}

test_sock_setsockopt()
{
    int level, optname;
    char *optval;
    int optlen;

    test_sock.ops->setsockopt(&test_sock, level, optname, optval, optlen);
}

test_sock_getsockopt()
{
    int level, optname;
    char *optval;
    int optlen;

    test_sock.ops->getsockopt(&test_sock, level, optname, optval, &optlen);
}

test_sock_fcntl()
{
    unsigned int cmd;
    unsigned long arg;

    test_sock.ops->fcntl(&test_sock, cmd, arg);
}

test_sock_sendmsg(int count)
{
    struct msghdr	msg_sys;
    struct iovec	iovec;
    char		buf[10000];
    int len;
    int ret;

    if (count > sizeof(buf))
	len = sizeof(buf);
    else len = count;

    iovec.iov_base = (void *) buf;
    iovec.iov_len = len;

    memset(&msg_sys, 0, sizeof(msg_sys));
    msg_sys.msg_iov = &iovec;
    msg_sys.msg_iovlen = 1;


    ret = test_sock.ops->sendmsg(&test_sock, &msg_sys, len, NULL);

    printf("test_sock_sendmsg %d bytes returned %d\n", len, ret);
}

test_sock_recvmsg()
{
    struct msghdr msg_sys;
    int len = 0;

    test_sock.ops->recvmsg(&test_sock, &msg_sys, len, 0, NULL);
}


int
bw_set_ip_limit(int fd, struct sockaddr *addr, int alen, int mask,
                int protocol, int port, enum bw_iotype rw, int bps)
{   
    struct bwlim_params bwp;

    bwp.bwp_bwid.bwid_type = BW_IP;
    bwp.bwp_bwid.bwid_rw = rw;
    bwp.bwp_bwid.bwid_addr = * (u_int32_t *) addr->sa_data;
    bwp.bwp_bwid.bwid_protocol = protocol;
    bwp.bwp_bwid.bwid_mask = mask;
    bwp.bwp_bwid.bwid_port = port;

    bwp.bwp_flags = BWPARAM_SETBPS;
    bwp.bwp_bps = bps;

    return test_sock_ioctl(fd, BW_IOC_SETPARAM, (unsigned long int) &bwp);
}


int proc_unregister(struct proc_dir_entry * dir, int ino)
{
}

int proc_register(struct proc_dir_entry *pd, struct proc_dir_entry *par_pd)
{
}

#define MAX_TESTSOCK 20
struct socket *socklist[MAX_TESTSOCK];

int
sock_to_fdnum(struct socket *sock)
{
    int i;

    for (i = 0; i < MAX_TESTSOCK; i++) 
	if (socklist[i] == sock)
	    return i;

    return -1;
}

int 
get_sock_fd()
{
    int i;

    for (i = 0; i < MAX_TESTSOCK; i++) {
	if ( ! socklist[i])
	    break;
    }       
    if (i == MAX_TESTSOCK) { 
	printf("Too many open test files - max %d\n", MAX_TESTSOCK);
	return -1;
    }   

    socklist[i] = (struct socket *) malloc(sizeof(*socklist[i]));

    if (socklist[i] == NULL) {
	printf("test_create: out of memory\n");
	return -1; 
    }
    return i;
}

free_sock_fd(int fd)
{
    if (socklist[fd]) {
	free(socklist[fd]);
	socklist[fd] = NULL;
    }
}

set_fd_type(int fd, int type)
{
    socklist[fd]->type = type;
}

get_fd_type(int fd)
{
    return socklist[fd]->type;
}

int
do_dup(int fd, int newfd)
{
    return socklist[fd]->ops->dup(socklist[newfd], socklist[fd]);
}

int
do_accept(int newfd, int fd, int flags)
{
    return socklist[fd]->ops->accept(socklist[newfd], socklist[fd], flags);
}

int
do_connect(int fd, struct sockaddr *address, int len, int flags)
{
    return socklist[fd]->ops->connect(socklist[fd], address, len, flags);
}

int
do_socketpair(int fd0, int fd1)
{
    return socklist[fd0]->ops->socketpair(socklist[fd0], socklist[fd1]);
}

int
do_getname(int fd, struct sockaddr *address, int *len, int what)
{
    return socklist[fd]->ops->getname(socklist[fd], address, len, what);
}

int
do_poll(int fd)
{
    struct file test_file;
    poll_table wait;

    return socklist[fd]->ops->poll(&test_file, socklist[fd], &wait);
}

int
do_listen(int fd, int back)
{

    return socklist[fd]->ops->listen(socklist[fd], back);
}

int
do_setsockopt(int fd, int level, int opts, char *val, int vsize)
{
    return socklist[fd]->ops->setsockopt(socklist[fd], level, opts,
		    val, vsize);
}

int
do_getsockopt(int fd, int level, int opts, char *val, int *vsize)
{
    return socklist[fd]->ops->getsockopt(socklist[fd], level, opts,
		    val, vsize);
}

int
do_fcntl(int fd, int cmd, int val)
{
    return socklist[fd]->ops->fcntl(socklist[fd], cmd, val);
}

int
do_sendmsg(int fd, struct msghdr *msg_sys, int size, void *extra)
{
    return socklist[fd]->ops->sendmsg(socklist[fd], msg_sys, size, extra);
}

int
do_recvmsg(int fd, struct msghdr *msg_sys, int size, int extra1, void *extra2)
{
    return socklist[fd]->ops->recvmsg(socklist[fd], msg_sys, size,
	    extra1, extra2);
}

int
do_release(int fd)
{
    return socklist[fd]->ops->release(socklist[fd], NULL);
}

int
do_shutdown(int fd, int how)
{
    return socklist[fd]->ops->shutdown(socklist[fd], how);
}

int
do_bind(int fd, struct sockaddr *saddr, int len)
{
    return socklist[fd]->ops->bind(socklist[fd], saddr, len);
}

int
do_create(int fd, int proto)
{
    return fams[TEST_FAMILY]->create(socklist[fd], proto);
}

sock_wake_async(struct socket *sock, int how)
{
    printf("wakeup socket 0x%x\n", (int) sock);
}
// LICENSE:
// This software is subject to the terms of the GNU GENERAL 
// PUBLIC LICENSE Version 2, June 1991
