#ifndef __bw_user_h__ /* { */
#define __bw_user_h__
/*
 * bw_user.h : user mode API for bandwidth management module
 *
 * Copyright (C) 1999, Cobalt Networks, Inc.
 * All rights reserved.
 *
 * This file contains the interface definition for the kernel/user
 * interface layers.
 */
#define N_BW_TYPES 3
enum bw_types { BW_IP=0, BW_UID, BW_GID };

/*
 * values for bwid_rw and indicies into bw_io below
 * (We don't index by BW_RDWRIO - it is a hash lookup cookie.)
 */
enum bw_iotype { BW_RDIO=0, BW_WRIO=1, BW_RDWRIO=2 };

/*
 * bw_limit_id defines the types of things that can be regulated.
 * For now, only IP works.
 */
struct bw_limit_id {
    enum bw_types	bwid_type;
    enum bw_iotype	bwid_rw;
    union {
	struct {
	    u_int32_t	bwip_addr;
	    u_int8_t 	bwip_protocol;
	    u_int8_t	bwip_mask;
	    u_int16_t 	bwip_port;
	} bw_ip_id;
	gid_t bwgrp_gid;
	uid_t bwuid_uid;
    } bw_reg_un;
};

#define bwid_addr	bw_reg_un.bw_ip_id.bwip_addr
#define bwid_protocol	bw_reg_un.bw_ip_id.bwip_protocol
#define bwid_mask	bw_reg_un.bw_ip_id.bwip_mask
#define bwid_port	bw_reg_un.bw_ip_id.bwip_port
#define bwid_gid	bw_reg_un.bwgrp_gid
#define bwid_uid	bw_reg_un.bwuid_uid

typedef unsigned int	bwl_time_t;

typedef unsigned long long bwl_totcnt_t;

/*
 * bwlim_params defines the ioctl interface to the bandwidth manager.
 * The flags tells the kernel what fields are valid.  For now, only
 * the bwp_bwid, bwp_flags, and bwp_bps fields are processed.
 */
struct bwlim_params {
    struct bw_limit_id	bwp_bwid;
    int			bwp_flags;
    int			bwp_bps;
    bwl_totcnt_t	bwp_max_bytes;
    bwl_time_t		bwp_rearm_time;
    int			bwp_overlim_bps;
    int			bwp_burst;
};

#define BWPARAM_SETBPS		0x1
#define BWPARAM_SETMAX		0x2
#define BWPARAM_SETTIME		0x4
#define BWPARAM_SETOVERBPS	0x8
#define BWPARAM_SETBURST	0x10
#define BWPARAM_OVERMAX		0x20
#define BWPARAM_DELETE		0x40

#define BW_IOC_KEY		((('b'<<1)^'w') & ((1 << _IOC_TYPEBITS) - 1))
#define BW_IOC_SETPARAM		_IOW(BW_IOC_KEY, 1, sizeof(struct bwlim_params))
#define BW_IOC_DELETE		_IOW(BW_IOC_KEY, 2, sizeof(struct bwlim_params))

#endif /* } __bw_user_h__ */
// LICENSE:
// This software is subject to the terms of the GNU GENERAL 
// PUBLIC LICENSE Version 2, June 1991
