/* $Id: debug.h,v 1.2 2001/08/10 22:23:11 mpashniak Exp $ */
/* Copyright 2001 Sun Microsystems, Inc.  All rights reserved. */

#ifndef __FUNKY_DEBUG_H__
#define __FUNKY_DEBUG_H__

#define TRY(expr, f, a...)                                  \
  { tests++;                                                \
	fprintf(stderr, "test%03d: %20.20s(%d) -> ", tests , __FILE__ , __LINE__ ); \
	if (!(expr)) { errors++; fprintf(stderr, "FAILED " f "\n", ##a ); } \
    else { fprintf(stderr, "ok.\n"); }                      \
  }

/* QTRY: a quieter version of TRY.  Doesn't run an official test, but
 * still reports a failure */
#define QTRY(expr, f, a...) \
  { if (!(expr))  \
	fprintf(stderr, "operatn: %-60.60s -> FAILED \n" f "\n", #expr ##a ); \
  }

static unsigned int tests = 0;
static unsigned int errors = 0;

#define END_MAIN \
  fprintf(stderr, "\n%d errors, %d tests.\n", errors, tests); \
  return errors;


#endif
/* Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: 
 * 
 * -Redistribution of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * -Redistribution in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution. 
 *
 * Neither the name of Sun Microsystems, Inc. or the names of contributors may
 * be used to endorse or promote products derived from this software without 
 * specific prior written permission.

 * This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
 */
