#!/bin/bash
# Stew Smith <stew.smith@sun.com>
# pass the name of a README.txt file full of packages
#
# usage:
# productmake.sh -S <source-root> -D <destination-root> -U <url-root> README

### CONFIGURATION ###
RM_BIN=/bin/rm
MV_BIN=/bin/mv
GZIP_BIN=/bin/gzip
TAR_BIN=/bin/tar
FIND_BIN=/usr/bin/find
GREP_BIN=/bin/grep

### SUBROUTINES BELOW ###
make_response () {
	METADIR=$1
	(cd ${METADIR}; ${TAR_BIN} -czf ../packages.tgz *)
}
### SUBROUTINES ABOVE ###

# process command line options
while getopts "S:D:U:" OPTION
do
	case ${OPTION} in
	  S ) SRCROOT=${OPTARG};;
	  D ) DESTROOT=${OPTARG};;
	  U ) URLROOT=${OPTARG};;
	  * ) echo "unknown option" && exit 1;;
	esac
done
shift $(($OPTIND - 1))
README=$1
SRCROOT=${SRCROOT:?'must be defined!'}
DESTROOT=${DESTROOT:?'must be defined'}
URLROOT=${URLROOT:?'must be defined'}

# main()
# check arguements
if [ "x${README}" == "x" ]; then
	echo "ERROR: you must pass the name of a valid README file."
	exit
fi

# <hacky> try to handle either
# /mnt/devupdates/pub/products/qube3/ml/README.txt
# /pub/products/qube3/ml/README.txt
# ...but requires the 1st line to be like "# file: __filename__"
if [ -f ${README} ]; then
      README=`head -n 1 ${README} | awk '{print $3}'`
fi
if [ ! -f ${SRCROOT}/${README} ]; then
	echo "ERROR: readme file ${README} does not exist!"
	exit
fi

DESTDIR=${DESTROOT}/$(dirname ${README})/.meta
METALIST=${DESTDIR}/package_list
FILES=`${GREP_BIN} -Ev '^(\s)*#' ${SRCROOT}/${README} | cut -d ' ' -f 3`

# init and clean metadir
if [ ! -d ${DESTDIR} ]; then
	mkdir --parents ${DESTDIR}
else
	${RM_BIN} -rf ${DESTDIR}/*
fi

# add header
echo '[PackageList -- Version=1.0]' > ${METALIST}

for f in ${FILES}; do
	URLPATH=${URLROOT}${f}
	echo "processing ${f}"
	./blqfile2meta --metadir ${DESTDIR} --plist --location ${URLPATH} \
	  		--vendor Cobalt ${SRCROOT}/${f} >>${METALIST}
done

# add footer
echo -e "[/PackageList]" >> ${METALIST}
# copy packagelist minus header/footer to the master
make_response ${DESTDIR}

exit
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
