#!/bin/bash

# Stew Smith <stew.smith@sun.com>
# $Id: post.sh,v 1.3 2003/02/26 21:20:01 ssmith Exp $
# this is a giant hack to post files in a friendly way.
# here is what i'm trying to accomplish:
# + post the file specified on the cmd line to the proper location
# + source components? post them too.
#   - find them on glazed
#   - prompt if there are multiple distinct versions of the file
#   - copy them to the appropriate place adding their presence
#     to the directory's README.txt file

. products.defs
#. experimental.defs

SSH=/usr/bin/ssh
SCP='/usr/bin/scp -q'
MD5SUM=/usr/bin/md5sum
MKDIR=/bin/mkdir
BLQCONTENTS=./blqcontents.pl
PLOGFILE=/tmp/post.log
SSHUSER=mirror

declare HOSTNAME		# destination host
declare DEBUG=0			# debug flag
declare PACKAGE			# file to post
declare PPATH			# path(s) to post file to
declare SPATH			# path(s) to post _sources_ to
declare SOURCES			# sources of package
declare SRCFILES		# local path of source files
declare PRODUCT			# product the package applies to
declare PACKAGEBASE		# basename of PACKAGE
declare FARGOPATH		# return string used in fargofind()

mylog () {
	LOGMESG=$1
	echo "${LOGMESG}"
	echo `date +'[%d/%b/%G:%k:%M:%S] '`${LOGMESG} >> ${PLOGFILE}
}

# takes a message to prompt user with
# returns 1 for yes, 0 for no
yesno () {
	MSG=$1
	declare RESPONSE
	while [ /bin/true ]; do
		echo "${MSG}? (yes/no)"
		read RESPONSE
		echo ${RESPONSE} | grep -iq '^yes$'
		if [ $? == 0 ]; then	# user said yes
			return 1
		fi
		echo ${RESPONSE} | grep -iq '^no$'
		if [ $? == 0 ]; then	# user said no
			return 0
		fi
	done
}

fargofind () {
	BASEDIR=/fargo
	TEMPFILE=`mktemp /tmp/fargofind.XXXXXX` || exit 1
	
	if [ ! -d ${BASEDIR}/rpms ]; then
		echo "ERROR: check that /fargo is mounted."; return 1
	fi
	
	if [ "x$*" == "x" ]; then
		echo "usage: fargofind <filename>"; return 1
	fi
	
	FILENAME=$1
	NUMFILES=0
	FILES=`find ${BASEDIR} -type f -name ${FILENAME} -print 2>/dev/null`

	for nfile in ${FILES}; do
		((++NUMFILES))
	done
	
	if [ ${NUMFILES} -eq 0 ]; then
		rm -f ${TEMPFILE}
		return 1				# file not found
	elif [ ${NUMFILES} -eq 1 ]; then
		FARGOPATH=${FILES}
		rm -f ${TEMPFILE}
		return 0				# one instance found
	else
		echo ${FILES} | xargs /usr/bin/md5sum |\
				sort | uniq -w 32 | nl -n ln > ${TEMPFILE}
		numuniqfiles=`cat ${TEMPFILE} | wc -l`
		if [ ${numuniqfiles} -gt 1 ]; then
		  clear
		  echo -e "\a"				# beep beep
		  echo "ATTENTION"
		  echo "  Multiple versions of ${FILENAME} found!"
		  echo "---------------------------------------------------"
		  cat ${TEMPFILE}
		  echo "---------------------------------------------------"
		  echo -n "Which file: "
		  read FILENUM
		  FILEPATH=`/bin/grep -E "^$FILENUM(\s)*" ${TEMPFILE} | awk '{print $3}'`
		else
		  FILEPATH=`head -n 1 ${TEMPFILE} | awk '{print $3}'`
		fi
		FARGOPATH=${FILEPATH}
	fi
	
	rm -f ${TEMPFILE}
	return 0
}

do_cmd () {
	cmd=$1
	if [ `expr ${DEBUG} == 1` == 1 ]; then
		echo "DEBUG: $cmd"
	else
		${cmd}
	fi
}

print_list () {
	LIST=$1
	#for word in `echo ${LIST} | tr ' ' "\n"`; do
	#for word in `echo ${LIST} | awk 'BEGIN {RS=" "} {print $0}'`
	for word in ${LIST}
	do
		echo "  ${word}"
	done
}

usage () {
	cat <<EIEIO
usage: $0 <package-file>
  options:
    -H <host>    : destination host for packages
    -p <product> : product code for file
    -d           : debug, do not copy any files
EIEIO
}

# process cmd line args
while getopts "H:p:d" OPTION
do
	case ${OPTION} in
	  H ) HOSTNAME=${OPTARG};;
	  p ) PRODUCT=${OPTARG};;
	  d ) DEBUG=1;;
	  * ) echo "unknown option" && exit 1;;
	esac
done
shift $(($OPTIND - 1))
PACKAGE=$1

if [ "x${PACKAGE}" == "x" ]; then	# must specify a package
	echo "ERROR: package not specified!"
	usage && exit
fi
if [ "x${HOSTNAME}" == "x" ]; then	# must specify a dest. host
	echo "ERROR: destination hostname not specified!"
	usage && exit
fi

# if not given on the cmdline, prompt for product
declare index elements prod_number
index=1; elements=${#PRODUCTS[@]}
if [ "x${PRODUCT}" == "x" ]; then
	echo -e "file:${PACKAGE}\nChoose the product:"
	select prod_number in ${PRODUCTS[@]}
	do
		PRODUCT="$prod_number"; break
	done
fi

# find product in the PRODUCTS array
while [ "${index}" -le "${elements}" ]
do
	echo ${PRODUCT} | grep -x ${PRODUCTS[$index]} > /dev/null 2>&1
	if [ $? == 0 ]
	then
		prod_number=$index
		break
	fi
	let "index = ${index} + 1"
done

PPATH="${PKGPATH[$prod_number]}"
SPATH="${SRCPATH[$prod_number]}"
SOURCES=`${BLQCONTENTS} --srpms ${PACKAGE}`
PACKAGEBASE=`basename ${PACKAGE}`

#mylog "post ${PACKAGE}"
mylog "post ${PACKAGEBASE}"

for source in ${SOURCES}; do
	# skip sausalito src rpms (base-*.src.rpm)
	echo ${source} | grep -Eq '^base-(.)*\.src\.rpm'
	if [ $? == 0 ]; then
		continue
	fi
	fargofind ${source}
	if [ $? == 0 ]; then
		SRCFILES="${SRCFILES} ${FARGOPATH}"
	else
		echo "Missing source file: ${source}."
		yesno "continue"
		if [ $? == 0 ]; then
			echo "exiting..."
			exit 2
		fi
	fi
done

### DEBUGGING SECTION ###
#echo '------------------------------------------------------------'
#echo "file:     ${PACKAGE}"
#echo "product:  ${PRODUCT}"
#echo "hostname: ${HOSTNAME}"
#echo "file dest:"; print_list "${PPATH}"
#echo "source dest:"; print_list "${SPATH}"
#echo "source files:"; print_list "${SOURCES}"
#echo "source paths:"; print_list "${SRCFILES}"
#echo '------------------------------------------------------------'

# post the package
# > if the package exists, exit.
# > else copy it to each package path (PPATH)
#   - add the md5sum to each PPATH/README.txt
# requires: ${PKGROOT}
for pdir in ${PPATH}; do
	if [ ! -d ${PKGROOT}/${pdir} ]; then		# destination exist?
		do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} ${MKDIR} -p ${pdir}"
	fi
	# prompt if the package dir README doesn't exist. new product?
	if [ ! -e "${PKGROOT}/${pdir}/README.txt" ]; then
		echo "WARNING: ${pdir}/README.txt does not exist!"
		yesno "Create it"
		if [ $? == 0 ]; then	# bail if no!
			echo "exiting..."
			exit 2
		fi
		do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} echo '# file:'${pdir}/README.txt > ${pdir}/README.txt"
	fi
	if [ ! -e "${PKGROOT}/${pdir}/${PACKAGEBASE}" ]; then
		mylog "  copying ${PACKAGEBASE}"
		do_cmd "${SCP} ${PACKAGE} mirror@${HOSTNAME}:${pdir}/${PACKAGEBASE}"
		do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} md5sum ${pdir}/${PACKAGEBASE} >> ${pdir}/README.txt"
	else
		echo "WARNING: ${pdir}/${PACKAGEBASE} already exists!"
		yesno "Continue"
		if [ $? == 0 ]; then	# bail if no
			echo "exiting..."
			exit 2
		fi
	fi
done

# bail if we are posting to devupdates/devbluelinq. we don't
# want to post sources for development packages
echo ${HOSTNAME} | grep -q '^devupdates'
if [ $? == 0 ]; then
	exit 0
fi

# post the sources
for sdir in ${SPATH}; do
	if [ ! -d ${PKGROOT}/${sdir} ]; then
		do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} ${MKDIR} -p ${sdir}"
	fi
	do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} ls ${sdir}/README.txt >/dev/null 2>&1"
	if [ $? != 0 ]; then
		do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} echo '# file:'${sdir}/README.txt > ${sdir}/README.txt"
	fi
	# sync remote fs
	do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} /usr/bin/sync"
	do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} ls ${sdir}/README.txt >/dev/null 2>&1"
	if [ $? != 0 ]; then
		echo "${sdir}/README.txt still not there"
		echo "exiting..."
		exit 255
	fi

	do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} echo '# package ${PACKAGEBASE}' >> ${sdir}/README.txt"

	for source in ${SRCFILES}; do
		srcbase=`basename $source`

		if [ ! -e "${PKGROOT}/${sdir}/${srcbase}" ]; then
			mylog "    copying ${srcbase}"
			do_cmd "${SCP} ${source} mirror@${HOSTNAME}:${sdir}/${srcbase}" 
		fi
		do_cmd "${SSH} -l ${SSHUSER} ${HOSTNAME} md5sum ${sdir}/${srcbase} >> ${sdir}/README.txt"
	done
done

exit 0

# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
