#!/bin/bash

### CONFIGURATION ###
RM_BIN=/bin/rm
MV_BIN=/bin/mv
GZIP_BIN=/bin/gzip
TAR_BIN=/bin/tar
FIND_BIN=/usr/bin/find
GREP_BIN=/bin/grep

PRODUCTS='cacheraq2 cacheraq4 qube2 qube3 raq2 raq3 raq4 raqxtr raq550 sccs1'
PKGROOT=/home/data
METASRCROOT=/mnt/ftproot/pub/packages/
METADESTROOT=/home/sites/home/web/pub/packages
FSROOT=/home/sites/home/web/pub/packages
URLROOT=http://updatestage.sfbay.sun.com
READMES=`(cd ${METASRCROOT}; ${FIND_BIN} ${PRODUCTS} -mindepth 1 -name README.txt)`
#READMES="qube3/ml/README.txt"

### SUBROUTINES BELOW ###
make_response () {
	METADIR=$1
	(cd ${METADIR}; tar -czf ../packages.tgz *)
}
### SUBROUTINES ABOVE ###

# main()
for r in ${READMES}; do
	METADESTPATH=${METADESTROOT}/`dirname ${r}`
	METADIR=${METADESTPATH}/.meta
	METALIST=${METADIR}/package_list
	FILES=`${GREP_BIN} -Ev '^(\s)*#' ${METASRCROOT}/${r} | cut -d ' ' -f 3`

	# init and clean metadir
	if [ ! -d ${METADIR} ]; then
		mkdir --parents ${METADIR}
	else
		${RM_BIN} -rf ${METADIR}/*
	fi

	# add header
	echo '[PackageList -- Version=1.0]' > ${METALIST}

	for f in ${FILES}; do
		URLPATH=${URLROOT}${f}
		echo "processing ${f}"
		./blqfile2meta --metadir ${METADIR} --plist --location ${URLPATH} --vendor Cobalt ${PKGROOT}/${f} >>${METALIST}
	done
	# add footer
	echo -e "[/PackageList]" >> ${METALIST}
	# copy packagelist minus header/footer to the master
	make_response ${METADIR}
done

exit
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
