#!/bin/bash
# $ID$
# Stew Smith <stew.smith@sun.com>
# * package link checker for bluelinq

WGET=/usr/bin/wget
WGET_OPTS="--quiet"
TAR=/bin/tar
RM=/bin/rm
ECHO=/bin/echo
OUTDIR=`pwd`/tmp
OUTFILE=$OUTDIR/packages.tar.gz
PRODUCTS="4100CS 2800CR 3100CR 3000CR 2800WG 2800WGJ 2800WGG 2800WGF 2800WGZHT 2800R 2800RJ 3000R 3000R-ja 3001R 3100R 3001R-ja 3100R-ja 4000WG 4010WG 4100WG 4000WGJ 4010WGJ 4100WGJ 4010WGJ-VML 3500R 3599R 3500R-ja 3599R-ja 4100R"
HOST="http://updates.cobalt.com/packages/?version=1.0&product="


for prod in ${PRODUCTS}; do
	URL=${HOST}${prod}
	${RM} -rf ${OUTDIR}/*
	`${WGET} ${WGET_OPTS} ${URL} --output-document=${OUTFILE}`
	(cd $OUTDIR; ${TAR} -xzf ${OUTFILE} package_list)
	if [ ! -e ${OUTDIR}/package_list ]; then
		${ECHO} "ERROR: package_list not found!"
		exit 1
	fi
	URLS=`egrep "^Location" ${OUTDIR}/package_list | sed -e 's/Location\:\W*//'`
	for pkg in ${URLS}; do
		${ECHO} -n "${pkg}..."
		if `${WGET} ${WGET_OPTS} --spider ${pkg}`; then
			${ECHO} "done"
		else
			${ECHO} "ERROR!"
			exit 1
		fi
	done
done

exit 0

# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
