#!/usr/bin/perl -w
# writes list of links to $outfile, and checks all package-type links

use strict;
use LWP::UserAgent;
use HTML::LinkExtor;

my($p,$outfile,$ua,@urls,$url,$res,@pkgs);
$outfile = "pkglist.txt";
@urls = qw{http://sunsolve.sun.com/patches/cobalt/cacheqube.eng.html
http://sunsolve.sun.com/patches/cobalt/cacheraq1.eng.html
http://sunsolve.sun.com/patches/cobalt/cacheraq2.eng.html
http://sunsolve.sun.com/patches/cobalt/cacheraq4.eng.html
http://sunsolve.sun.com/patches/cobalt/manageraq.eng.html
http://sunsolve.sun.com/patches/cobalt/nasraq.eng.html
http://sunsolve.sun.com/patches/cobalt/qube1.eng.html
http://sunsolve.sun.com/patches/cobalt/qube2.chi.html
http://sunsolve.sun.com/patches/cobalt/qube2.eng.html
http://sunsolve.sun.com/patches/cobalt/qube2.fre.html
http://sunsolve.sun.com/patches/cobalt/qube2.ger.html
http://sunsolve.sun.com/patches/cobalt/qube3.eng.html
http://sunsolve.sun.com/patches/cobalt/raq1.eng.html
http://sunsolve.sun.com/patches/cobalt/raq2.eng.html
http://sunsolve.sun.com/patches/cobalt/raq3.eng.html
http://sunsolve.sun.com/patches/cobalt/raq4.eng.html
http://sunsolve.sun.com/patches/cobalt/raqxtr.eng.html
http://sunsolve.sun.com/patches/cobalt/staqwareraq3.html
http://sunsolve.sun.com/patches/cobalt/staqwareraq4.html
http://sunsolve.sun.com/patches/cobalt/qube.migration.html
http://sunsolve.sun.com/patches/cobalt/migration.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/qube1.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/qube2.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/qube3.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/raq1.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/raq2.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/raq3.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/raq4.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/raq550.jpn.html
http://sunsolve.sun.co.jp/patches/cobalt/japan/raqxtr.jpn.html};

$ua = LWP::UserAgent->new();
$ua->proxy(['http','ftp'],'http://ssla-cache.west.sun.com:8080');
$p = HTML::LinkExtor->new(\&anchorPrint);
if (-e $outfile) { unlink($outfile) or die "Couldn't remove output file: $!" }
open (OUTPUT,">> $outfile") or die "Cannot open output file: $!";

foreach my $url (@urls) {
	print "URL: $url\n";
	print OUTPUT "<!--\n\t$url\n-->\n";
	$res = $ua->request(
			HTTP::Request->new('GET' => $url),
			sub { $p->parse($_[0])}
	);
	unless ($res->is_success()) {
		print "ERROR: Could not retreive $url\n";
	}
}
# link checker
map { checkLink($_) } @pkgs;
close(OUTPUT) or die "Could not close output file: $!";
exit(0);

# gets lowercase tag name, and all key/value link attributes
# if its an anchor tag, and matches pattern; print it
sub anchorPrint {
	my($tag,%attr,$url) = @_;
	return unless $tag eq 'a';	# only anchor tags
	$url = $attr{"href"};
	#if ($attr{"href"} =~ m/http:\/\/ftp\.cobalt\.sun\.com(.+)pkg(.*)/) {
	if ($url =~ m/http:\/\/ftp\.cobalt(.+)\/pub(.+)pkg/) {
		push(@pkgs,"http://updatestage.sfbay.sun.com/pub$2pkg");
		print OUTPUT $attr{"href"}, "\n";
	}
}

# check the url given
sub checkLink {
	my ($curl,$cua,$cres);
	$curl = shift || die "You must pass a URL to check.";
	$cua = LWP::UserAgent->new();
	$cua->proxy(['http','ftp'],'http://ssla-cache.west.sun.com:8080');
	$cres = $cua->request(HTTP::Request->new('HEAD' => $curl));
	unless ($cres->is_success()) {
		print "--Bad link-- code: ", $cres->code(), ": $curl\n";
	}
}
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
