#!/usr/bin/perl -w -I../lib
# $Id: blqcontents.pl,v 1.1 2003/02/20 21:21:27 ssmith Exp $
# takes: path to a bluelinq package
# returns: the complete list of rpms or srpms appropriate for the package


$|++;
use strict;
use Bluelinq::Sausalito;
use Data::Dumper;
use Getopt::Long;

my($DEBUG,$TEMPDIR,$opt,$options,$filename,$file,$obj,%RPMLIST);
$DEBUG = 0;
$TEMPDIR = "/tmp/blqtemp.$$";

$opt = {};
$options = [
	'rpms'			=>	\$opt->{'rpms'},
	'srpms'			=>	\$opt->{'srpms'},
	'verbose+'		=>	\$opt->{'verbose'},
	'quiet:i'		=>	sub { $opt->{'verbose'} = 0 }
];

# main()
GetOptions(@$options);
processOpts();
#$file = Bluelinq::File::Sauce->new(@{$obj});
#$file = Bluelinq::File::Sausalito->new(@{$obj});
$file = Bluelinq::factory($filename,@{$obj});

$file->verbose($DEBUG);		# set verbosity level
$file->init();			# intialize file
$file->unpack();		# unpack file
$file->get_meta_info();		# read packing list

if($opt->{'rpms'})	{
	$file->dumpRPMS();
} else			{
	$file->dumpSRPMS();
}
exit(0);

###### SUBROUTINES BELOW ######
sub processOpts {
	if ( (!($opt->{"rpms"}) && !($opt->{"srpms"})) ||
				($opt->{"rpms"} && ($opt->{"srpms"})) ) {
		&usage(); die "Specify exactly one output format or another";
	}
	if (!($filename = shift @ARGV)) {
		&usage(); die "You must supply a filename to $0";
	}
	# set DEBUG if given. it has a max value of 2
	if ($opt->{"verbose"}) { $DEBUG = $opt->{"verbose"} }
	if ($DEBUG > 2) { $DEBUG = 2; }
	push(@{$obj},"filename",$filename);
}

sub usage {
	print <<"EOU";
usage: $0 [--verbose]
	  [--quiet]
	  [--rpms or --srpms]
          [filename]
EOU
}
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
