#!/usr/bin/perl -Tw
# Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
# The Sun Cobalt BlueLinQ server.
#
use strict;
use CGI qw{:standard};
use Fcntl qw{O_RDONLY};
use Sys::Syslog qw{openlog setlogsock syslog};

use vars qw($DEBUG $PKGS_BASE_DIR %PROD_HASH);
$DEBUG = 0;
$PKGS_BASE_DIR = "/home/sites/home/web/pub/packages";
# hash of build ids to actual bluelinq products
%PROD_HASH = (
	"4100CS"	=> "sccs1/all/packages.tgz",	# control station 1.0
	"2800CR"	=> "cacheraq2/packages.tgz",	# cacheraq2
	"3100CR"	=> "cacheraq4/packages.tgz",	# cacheraq4
	"3000CR"	=> "cacheraq4/packages.tgz",
	"2800WG"	=> "qube2/eng/packages.tgz",	# qube2
	"2800WGJ"	=> "qube2/jpn/packages.tgz",	# qube2ja
	"2800WGG"	=> "qube2/ger/packages.tgz",	# qube2de
	"2800WGF"	=> "qube2/fre/packages.tgz",	# qube2fr
	"2800WGZHT"	=> "qube2/chi/packages.tgz",	# qube2zh
	"2800R"		=> "raq2/eng/packages.tgz",	# raq2
	"2800RJ"	=> "raq2/jpn/packages.tgz",	# raq2j
	"3000R"		=> "raq3/eng/packages.tgz",	# raq3
	"3000R-ja"	=> "raq3/jpn/packages.tgz",	# raq3j
	"3001R"		=> "raq4/eng/packages.tgz",	# raq4
	"3100R"		=> "raq4/eng/packages.tgz",
	"3001R-ja"	=> "raq4/jpn/packages.tgz",	# raq4j
	"3100R-ja"	=> "raq4/jpn/packages.tgz",
	"4000WG"	=> "qube3/ml/packages.tgz",	# qube3
	"4010WG"	=> "qube3/ml/packages.tgz",
	"4100WG"	=> "qube3/ml/packages.tgz",
	"4000WGJ"	=> "qube3/jpn/packages.tgz",	# qube3j
	"4010WGJ"	=> "qube3/jpn/packages.tgz",
	"4100WGJ"	=> "qube3/jpn/packages.tgz",
	"5100WG"	=> "qube4/all/packages.tgz",	# qube4
	"3500R"		=> "raqxtr/eng/packages.tgz",	# raqxtr
	"3599R"		=> "raqxtr/eng/packages.tgz",
	"3500R-ja"	=> "raqxtr/jpn/packages.tgz",	# raqxtrj
	"3599R-ja"	=> "raqxtr/jpn/packages.tgz",
	"4100R"		=> "raq550/all/packages.tgz",	# raq550
);
# main()
my ($cgi,$product,$version) = (undef,'','');
$cgi = new CGI;
$product = $cgi->param("product");
$version = $cgi->param("version");
log_error() unless (($version) && ($version eq '1.0'));
log_error() unless $cgi->request_method() eq 'GET';
log_error() unless (($product ne '') && ($product ne 'all'));
log_error() unless exists($PROD_HASH{"$product"});
send_response($product);
exit(0);

# returns the pregenerated request file
sub send_response {
	my($build,$file);
	$build = shift;
	$file = $PKGS_BASE_DIR . "/" . $PROD_HASH{"$build"};
	if (! -r $file) { log_error("cannot read response") }
	sysopen(PKGS,$file,O_RDONLY) or log_error("cannot open response");
	log_request();
	binmode PKGS; binmode STDOUT;
	while (<PKGS>) { print }
	close(PKGS);
}

# logs the request via syslog: local6.notice
sub logger {
	my($str) = shift || "";
	openlog('updates','','local6') or die "Could not openlog: $!";
	setlogsock('unix') or die "Could not set socket type: $!";
	syslog('notice',"%s - %s", $cgi->query_string(), $str);
}

# sends headers, logs request
sub log_request {
	my($type);
	$type = ($DEBUG ? "text/plain" : "application/x-gzip");
	print $cgi->header("-type" => $type, "-expires"	=> "-1d");
	logger('200 OK');
}

# sends headers, logs error, prints error, and exits
sub log_error {
	my($err,$url,$rhost);
	$err = shift || '';
	$url = $cgi->url(); $rhost = $cgi->remote_host();
	print $cgi->header("-type" => "text/plain", "-expires" => "-1d");
	
	print <<"EOF";
Unsupported protocol

Hello $rhost, welcome to the bluelinq server at:
$url

An error has occurred because this request was not
properly formatted. Please remember this URL is
only valid within the bluelinq application of a
Sun Cobalt Server Appliance.
EOF
	logger("400 ERROR: $err");
	exit(0);
}
