# Bluelinq::::Sausalito::Meta::plist.pm
# Copyright 2002, Sun Microsystems, Inc
# $Id: plist.pm,v 1.2 2002/06/24 15:48:22 ssmith Exp $

package Bluelinq::Sausalito::Meta::plist;
use base qw/Bluelinq::Sausalito::Meta/;
use strict;
#use vars qw/$AUTOLOAD/;
use Carp;

my %Data = (
	'vendor'		=> 'unknown',
	'vendorTag'		=> undef,
	'name'			=> undef,
	'nameTag'		=> undef,
	'version'		=> undef,
	'versionTag'		=> undef,
	'location'		=> undef,
	'category'		=> undef,
	'splashPages'		=> undef,
	'encryptionFormat'	=> undef,
	'fileName'		=> undef,
	'product'		=> [],
	'packageType'		=> 'complete',
	'options'		=> undef,
	'size'			=> undef,
	'url'			=> undef,
	'urloptions'		=> undef,
	'longDesc'		=> undef,
	'shortDesc'		=> undef,
	'copyright'		=> undef,
	'architecture'		=> undef,
	'incompatibleList'	=> [],
	'patchId'		=> undef,
	'patchList'		=> [],
	'reverseDependencyList'	=> [],
	'obsoletedBy'		=> undef,
	'packageBundleName'	=> undef,
	'licenseDesc'		=> undef,
	'dependencyList'	=> [],
	'visibleList'		=> [],
	'obsoletesList'		=> [],
	'RPMList'		=> [],
	'SRPMList'		=> [],
	'log'			=> [],
);

sub new {
	my $self = shift;
	my $class = ref($self) || $self;
	my $this = { %Data, @_ };
	bless $this, $class;
	return $this;
}
#sub new {
#	my $self = shift;
#	my $class = ref($self) || $self;
#	my $this = $self->SUPER::new();
#	bless $this, $class;
#	return $this;
#}

# populates $self with data from the file
# takes an open filehandle
# returns 1 for success, 0 on error
#
sub readmeta {
	my($self,$fh,$inpackage,$ref,$vendor,$name,$op,$val);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	$fh = shift or $self->blqerror("parse: You must pass a filehandle!");
	$inpackage = 0;
	while(<$fh>) {
		next if m/^\s*#/;		# skip comments
		next unless /\S/;		# skip blank lines
		++$inpackage if m/^\[Package -- Version=1.0\]/i;
		last;
	}
	return 0 unless $inpackage;
	while(<$fh>) {
		$ref = undef;
		next if m/^\s*#/;		# skip comments
		next unless /\S/;		# skip blank lines
		last if /^\[\/Package\]/;	# jump out of loop
		(s/\s+\n//);			# strip trailing whitespace
		# save everything to end of line
		if (/^Category:\s*(\S+)/i) {
			$self->{"category"} = $1; next;
		}
		if (/^Splash:\s*(.+)/i) {
			$self->{"splash"} = $1; next;
		}
		if (/^EncryptionFormat:\s*(\S+)/i) {
			$self->{"encryptionFormat"} = $1; next;
		}
		if (/^FileName:\s*(\S+)/i) {
			$self->{"fileName"} = $1; next;
		}
		if (/^Location:\s*(\S+)/i) {
			$self->{"location"} = $1; next;
		}
		if (/^Copyright:\s*(.+)/i) {
			$self->{"copyright"} = $1; next;
		}
		if (/^ShortDesc:\s*(.+)/i) {
			$self->{"shortDesc"} = $1; next;
		}
		if (/^LongDesc:\s*(.+)/i) {
			$self->{"longDesc"} = $1; next;
		}
		if (/^License:\s*(.+)/i) {
			$self->{"licenseDesc"} = $1; next;
		}
		if (/^Name:\s*(\S+)/i) {
			$self->{"name"} = $1; next;
		}
		if (/^NameTag:\s*(.+)\n/i) {
			$self->{"nameTag"} = $1; next;
		}
		if (/^Product:\s*(\S+)/i) {
			push(@{$self->{"product"}},$1); next;
		}
		if (/^PackageType:\s*(\S+)/i) {
			$self->{"packageType"}
				= ($1 eq 'update') ? 'update' : 'complete';
			next;
		}
		if (/^Options:\s*(.+)\n/i) {
			$self->{"options"} = $1; next;
		}
		if (/^Size:\s*(\d+)/i) {
			$self->{"size"} = $1; next;
		}
		if (/^InfoURL:\s*(\S+)/i) {
			$self->{"url"} = $1; next;
		}
		if (/^InfoURLOptions:\s*(.+)\n/i) {
			$self->{"urloptions"} = $1; next;
		}
		if (/^Vendor:\s*(\S+)/i) {
			$self->{"vendor"} = $1; next;
		}
		if (/^VendorTag:\s*(.+)\n/i) {
			$self->{"vendorTag"} = $1; next;
		}
		if (/^Version:\s*(\S+)/i) {
			$self->{"version"} = $1; next;
		}
		if (/^VersionTag:\s*(.+)\n/i) {
			$self->{"versionTag"} = $1; next;
		}
		#  depends vendor:package [!,=,!=,>=,=,<=] [version]
		if (/^Depend:\s*(\S+):(\S+)\s*(?:([!>=<]*)\s*(\S+))*/i) {
			$ref->{"vendor"} = $1;
			$ref->{"name"} = ($2) ? $2 : '';
			$ref->{"op"} = ($3) ? $3 : '';
			$ref->{"version"} = ($4) ? $4 : '';
			push(@{$self->{"dependencyList"}},$ref); next;
		}
		# visibledepends
		if (/^VisibleDepend:\s*(\S+):(\S+)\s*(?:([!>=<]*)\s*(\S+))*/i) {
			$ref->{"vendor"} = $1;
			$ref->{"name"} = ($2) ? $2 : '';
			$ref->{"op"} = ($3) ? $3 : '';
			$ref->{"version"} = ($4) ? $4 : '';
			push(@{$self->{"visibleList"}},$ref); next;
		}
		# obsoletes
		if (/^Obsoletes:\s*(\S+):(\S+)\s*(?:([>=<]*)\s*(\S+))*/i) {
			$ref->{"vendor"} = ($1) ? $1 : '';
			$ref->{"name"} = ($2) ? $2 : '';
			$ref->{"op"} = ($3) ? $3 : '';
			$ref->{"version"} = ($4) ? $4 : '';
			push(@{$self->{"obsoletesList"}},$ref); next;
		}
		if (/^RPM:\s*(\S+)/i) {
		    push(@{$self->{"RPMList"}},$1); next;
		} 
		if (/^SRPM:\s*(\S+)/i) {
		    push(@{$self->{"SRPMList"}},$1); next;
		} 
		$self->blqwarn("unknown line in packing_list:\n>>$_");
	}
	return 1;
}

# writes plist to a filehandle
# takes: filehandle
sub writemeta {
	my($self,$fh,$pl,$order,$val,$e,$i);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	$fh = shift or $self->blqerror("You must pass a filehandle");
	print $fh '[Package -- Version=1.0]', "\n";
	# verbose
	#next unless $order->[$i]->{'value'};	# ignore undef values
	# print all elements if an array
	$self->_write_plist_line($fh,"Vendor",$self->{"vendor"});
	$self->_write_plist_line($fh,"VendorTag",$self->{"vendorTag"});
	$self->_write_plist_line($fh,"Name",$self->{"name"});
	$self->_write_plist_line($fh,"NameTag",$self->{"nameTag"});
	$self->_write_plist_line($fh,"Version",$self->{"version"});
	$self->_write_plist_line($fh,"VersionTag",$self->{"versionTag"});
	$self->_write_plist_line($fh,"Location",$self->{"location"});
	$self->_write_plist_line($fh,"Category",$self->{"category"});
	$self->_write_plist_line($fh,"Splash",$self->{"splashPages"});
	$self->_write_plist_line($fh,"EncryptionFormat",$self->{"encryptionFormat"});
	$self->_write_plist_line($fh,"FileName",$self->{"fileName"});
	$self->_write_plist_array($fh,"Product",$self->{"product"});
	$self->_write_plist_line($fh,"PackageType",$self->{"packageType"});
	$self->_write_plist_line($fh,"Options",$self->{"options"});
	$self->_write_plist_line($fh,"Size",$self->{"size"});
	$self->_write_plist_line($fh,"InfoUrl",$self->{"url"});
	$self->_write_plist_line($fh,"InfoUrlOptions",$self->{"urloptions"});
	$self->_write_plist_line($fh,"LongDesc",$self->{"longDesc"});
	$self->_write_plist_line($fh,"ShortDesc",$self->{"shortDesc"});
	$self->_write_plist_line($fh,"Copyright",$self->{"copyright"});
	$self->_write_plist_line($fh,"Architecture",$self->{"architecture"});
	$self->_write_plist_array($fh,"IncompatibleList",$self->{"incompatibleList"});
	$self->_write_plist_line($fh,"PatchId",$self->{"patchId"});
	$self->_write_plist_array($fh,"PatchList",$self->{"patchList"});
	$self->_write_plist_array($fh,"ReverseDependencyList",$self->{"reverseDependencyList"});
	$self->_write_plist_line($fh,"ObsoletedBy",$self->{"obsoletedBy"});
	$self->_write_plist_line($fh,"PackageBundleName",$self->{"packageBundleName"});
	$self->_write_plist_line($fh,"License",$self->{"licenseDesc"});
	$self->_write_dependency_array($fh,"Depend",$self->{"dependencyList"});
	$self->_write_dependency_array($fh,"VisibleDepend",$self->{"visibleList"});
	$self->_write_dependency_array($fh,"Obsoletes",$self->{"obsoletesList"});
	## DONT WRITE RPM/SRPM LINES
	##$self->_write_plist_array($fh,"RPM",$self->{"RPMList"});
	##$self->_write_plist_array($fh,"SRPM",$self->{"SRPMList"});
	print $fh '[/Package]', "\n";
}

# for writing out "vendor:name [operator] version" meta lines
sub _write_dependency_array {
	my($self,$fh,$label,$list,$ref,$line);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	($fh,$label,$ref) = (@_)[0,1,2];
	foreach $ref (@{$ref}) {
		$line = "$ref->{'vendor'}:$ref->{'name'}";
		$line .= ($ref->{"op"}) ? " $ref->{'op'}" : "";
		$line .= ($ref->{"version"}) ? " $ref->{'version'}" : "";
		$self->_write_plist_line($fh,$label,$line);
	}
}

# takes: references to a filehandle, element label, and array of elements,
# returns: none
sub _write_plist_array {
	my($self,$fh,$label,$ref,$i);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	($fh,$label,$ref) = (@_)[0,1,2];
	foreach $i (@{$ref}) { $self->_write_plist_line($fh,$label,$i) }
}

sub _write_plist_line {
	my($self,$fh,$key,$value);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	$fh = shift or $self->blqerror("Must pass a filehandle!");
	(($key,$value) = (@_)[0,1]);
	return unless $value;
	$key .= ':';
	# 24 chars for key, fill rest of line with value
	format plist_line =
@<<<<<<<<<<<<<<<<<<<<<<<@*
$key,                   $value
.
	$~ = "plist_line";
	write();
}

1; # end of Bluelinq::Meta::plist
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
