# Bluelinq::::Sausalito::Meta.pm
# Copyright 2002, Sun Microsystems, Inc
# $Id: Meta.pm,v 1.1.1.1 2002/05/31 06:25:06 ssmith Exp $

# This class creates objects representing the meta-information concerned
# with bluelinq resouces.

package Bluelinq::Sausalito::Meta;
use base qw/Bluelinq::Sausalito/;
use strict;
use vars qw/$AUTOLOAD/;
use Carp;

my %Data = (
	'vendor'		=> 'unknown',
	'vendorTag'		=> undef,
	'name'			=> undef,
	'nameTag'		=> undef,
	'version'		=> undef,
	'versionTag'		=> undef,
	'location'		=> undef,
	'category'		=> undef,
	'splashPages'		=> undef,
	'encryptionFormat'	=> undef,
	'fileName'		=> undef,
	'product'		=> [],
	'packageType'		=> 'complete',
	'options'		=> undef,
	'size'			=> undef,
	'url'			=> undef,
	'urloptions'		=> undef,
	'longDesc'		=> undef,
	'shortDesc'		=> undef,
	'copyright'		=> undef,
	'architecture'		=> undef,
	'incompatibleList'	=> [],
	'patchId'		=> undef,
	'patchList'		=> [],
	'reverseDependencyList'	=> [],
	'obsoletedBy'		=> undef,
	'packageBundleName'	=> undef,
	'license'		=> undef,
	'licenseDesc'		=> undef,
	'dependencyList'	=> [],
	'visibleList'		=> [],
	'obsoletesList'		=> [],
	'RPMList'		=> [],
	'SRPMList'		=> [],
	'log'			=> [],
);

sub new {
	my $self = shift;
	my $class = ref($self) || $self;
	my $this = { %Data, @_ };
	bless $this, $class;
	return $this;
}

sub AUTOLOAD {
	my $self = shift;
	# only handle instance methods, not class methods.
	croak ("autoload $AUTOLOAD: $self not an object") unless ref($self);
	my $name = $AUTOLOAD;
	return if $name =~ /::DESTROY$/;
	$name =~ s/.*://;       # Field names not fully qualified, strip it.
	unless (exists $self->{$name}) {
		croak ("Can't access '$name' field in $self $AUTOLOAD");
	}
	if (@_) { return $self->{$name} = shift }
	else    { return $self->{$name}	}
}

sub DESTROY {
	return;
}

sub init {
	return;
}

### DEFINITION OF Bluelinq::Sausalito::Meta INTERFACE BELOW ###

# populates $self with data from the file
# takes an open filehandle
# returns 1 for success, 0 on error
#
sub readmeta {
	my $self = shift;
	croak ("$self not an object") unless ref($self);
	$self->blqerror("Sausalito::Meta::read() This method must be overridden.");
}

# verifies the data contained in $self
# returns 1 for success, 0 on error
#
sub verify {
	my $self = shift;
	croak ("$self not an object") unless ref($self);
	$self->blqerror("Sausalito::Meta::verify() This method must be overridden.");
}

# writes the data contained in $self in the appropriate format
# takes an open filehandle
# returns 1 for success, 0 on error
#
sub writemeta {
	my $self = shift;
	croak ("$self not an object") unless ref($self);
	$self->blqerror("Sausalito::Meta::write() This method must be overridden.");
}

# _check_meta_info()
# - some quick checking of self->plist()
# - definately not exhaustive
sub _check_meta_info {
	my($self,$pl);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	# vendor,name,version are critical, must be defined w/ only word chars
	if ((!$self->{'vendor'}->{'value'}) || 
				($self->{'vendor'}->{'value'} =~ /\W/)) {
	  $self->blqerror("Invalid Vendor value: ", $self->filename());
	}
	if ((!$self->{'name'}->{'value'}) ||
				($self->{'name'}->{'value'} =~ /\W/)) {
	  $self->blqerror("Invalid Name value: ", $self->filename())
	}
	if ((!$self->{'version'}->{'value'}) &&
				($self->{'version'}->{'value'} =~ /\W/)) {
	  $self->blqerror("Invalid Version value: ", $self->filename())
	}
	# packages need location field
	if (!$self->{'location'}->{'value'}) {
	  $self->blqerror("Location field is not defined: ".$self->filename())
	}
	# packages need a realistic looking size field
	if (!$self->{'size'}->{'value'} =~ m/^\d{3,}$/) {
	  $self->blqerror("Invalid size field: ".$self->filename())
	}
}

# _normalize_plist()
# tries to convert values read in the packing_list
# into more well-structured, portable forms
# takes: none
# returns: none
# alters: $self->packing_list();
sub _normalize_plist {
	my($self,$pl,@token_based,$item,$i);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	$pl = $self->plist();			# shorthand
	# plist fields that are based on vendor,name,operator,version
	@token_based = (	$pl->{'visibleList'},
				$pl->{'obsoletesList'},
				$pl->{'dependencyList'});
	# normalize each token_based packing_list entry
	# replace the string entry with a hashref
	foreach $item (@token_based) {
		next if (scalar @{$item->{'value'}} == 0);	# no values
		for ($i=0; $i <= $#{$item->{'value'}}; ++$i) {
			my $val = ${$item->{'value'}}[$i];
			${$item->{'value'}}[$i] = _normalize_token_item($val);
		}
	}
}

1; # end of Bluelinq::Sausalito::Meta
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
