# Bluelinq::Sauce::Meta.pm
# Copyright 2002, Sun Microsystems, Inc
# $Id: Meta.pm,v 1.2 2002/06/12 00:17:08 ssmith Exp $

package Bluelinq::Sauce::Meta;
use base qw/Bluelinq::Sauce/;
use strict;
use vars qw/$AUTOLOAD/;
use Carp;

my %Data = (
		package		=>	undef,
		version		=>	undef,
		listfile	=>	'',
		reboot		=>	'no',
		uninstall	=>	'no',
		url		=>	'',
		rpms		=>	[],
		scripts		=>	[],
		products	=>	[],
		dependencyList	=>	[],
		obsoletesList	=>	[],
		vendor		=>	'unknown',
		filesize	=>	undef,
		location	=>	'',
);

sub new {
	my $self = shift;
	my $class = ref($self) || $self;
	my $this = { %Data, @_ };
	bless $this, $class;
	return $this;
}

sub AUTOLOAD {
	my $self = shift;
	# only handle instance methods, not class methods.
	croak ("autoload $AUTOLOAD: $self not an object") unless ref($self);
	my $name = $AUTOLOAD;
	return if $name =~ /::DESTROY$/;
	$name =~ s/.*://;       # Field names not fully qualified, strip it.
	unless (exists $self->{$name}) {
		croak ("Sauce::Meta: Can't access '$name' field in $self $AUTOLOAD");
	}
	if (@_) { return $self->{$name} = shift }
	else    { return $self->{$name} }
}

### DEFINITION OF Bluelinq::Sauce::Meta INTERFACE BELOW ###

# populates $self with data from the file
# takes an open filehandle
# returns 1 for success, 0 on error
#
sub readmeta {
	my $self = shift;
	croak ("$self not an object") unless ref($self);
	$self->blqerror("Sauce::Meta::read() This method must be overridden.");
}

# verifies the data contained in $self
# returns 1 for success, 0 on error
#
sub verify {
	my $self = shift;
	croak ("$self not an object") unless ref($self);
	$self->blqerror("Sauce::Meta::verify() This method must be overridden.");
}

# writes the data contained in $self in the appropriate format
# takes an open filehandle
# returns 1 for success, 0 on error
#
sub writemeta {
	my $self = shift;
	croak ("$self not an object") unless ref($self);
	$self->blqerror("Sauce::Meta::write() This method must be overridden.");
}

# only handles simple dependencies for now
# (i.e. "Deppend:		Cobalt:RaQ4-All-Kernel-2.0.1-2.2.16C32III"
sub _add_depend {
	my($self,$vendor,$name,$ref);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	(($vendor,$name) = (@_)[0,1]);
	$self->blqerror("Invalid dependency: $vendor:$name!")
						unless ($vendor && $name);
	$ref->{"vendor"} = $vendor;
	$ref->{"name"} = $name;
	$ref->{"op"} = '';		# --not handled--
	$ref->{"version"} = '';		# --not handled--
	push(@{$self->{"dependencyList"}},$ref);
}

# only handles simple obsoletes for now
# (i.e. "Obsoletes:		Cobalt:RaQ4-All-Kernel-2.0.1-2.2.16C32III"
sub _add_obsoletes {
	my($self,$vendor,$name,$ref);
	$self = shift;
	croak ("$self not an object") unless ref($self);
	(($vendor,$name) = (@_)[0,1]);
	$self->blqerror("Invalid obsoletes: $vendor:$name!")
						unless ($vendor && $name);
	$ref->{"vendor"} = $vendor;
	$ref->{"name"} = $name;
	$ref->{"op"} = '';		# --not handled--
	$ref->{"version"} = '';		# --not handled--
	push(@{$self->{"obsoletesList"}},$ref);
}

1;
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
