#!/bin/sh

#######################################
# Auther: Hisao SHIBUYA
# $Id:$
#######################################

## Check permission
if [ $UID -ne 0 ]; then
  echo "This installer must be executed by root or with sudo."
  exit 1
fi


## Check installed RPMS
echo
echo "[Phase 1 : checking intalled RPMS...]"
echo

grep "Red Hat Linux release 9" /etc/redhat-release > /dev/null
if [ ! $? ]; then
  echo "** ERROR **"
  echo "This package supports for Red Hat Linux release 9 only!!"
fi

requires="expect httpd"
for rpm in $requires; do
  rpm -q $rpm > /dev/null
  if [ ! $? ]; then
    echo "** ERROR **"
    echo "[$rpm] is not installed. Please install [$rpm] package."
    exit 1;
  fi
  echo "[$rpm] is installed."
done


## Install RPMS
echo
echo "[Phase 2 : installing RPMS...]"
echo
RPM_PATH=`pwd`/pkgs/RPMS

rpm -Uvh --force \
  $RPM_PATH/glib-1.2.10-10OQ1.i386.rpm \
  $RPM_PATH/glib-devel-1.2.10-10OQ1.i386.rpm \
  $RPM_PATH/perl-Jcode-0.83-2OQ1.i386.rpm \
  $RPM_PATH/perl-Quota-1.4.8-2OQ1.i386.rpm \
  $RPM_PATH/re2c-0.9.1-2OQ1.i386.rpm


## Install base Packages of Open Source Qube
echo
echo "[Phase 3 : installing Open Source Qube base packages...]"
echo
RPM_PATH=`pwd`/RPMS
rpm -ivh --nodeps --force $RPM_PATH/*


## copy template config and clean up
echo "build 20031117 for a 5100BQ" > /etc/build

# move mail, mqueue spool dir to /home
if [ ! -d /home/spool ]; then
  mkdir -m 0755 /home/spool
  chown root.root /home/spool
fi
if [ ! -d /home/spool/mail ]; then
  mv /var/spool/mail /home/spool
  ln -s /home/spool/mail /var/spool/mail
fi
if [ ! -d /home/spool/mqueue ]; then
  mv /var/spool/mqueue /home/spool
  ln -s /home/spool/mqueue /var/spool/mqueue
fi

## copy template config


## start daemons
echo
echo "[Phase 4 : starting daemons...]"
echo
chkconfig httpd on
service httpd restart
service cced.init start


## finished
echo
echo "Finish installation"
echo
