#!/usr/bin/perl -w -I/usr/sausalito/perl -I.

use CCE;
use Sauce::Config;
use Sauce::Util;

my $cce = new CCE;
$cce->connectfd(\*STDIN,\*STDOUT);

my $oid = $cce->event_oid();
my $obj = $cce->event_object();

my $device = $obj->{'device'} || 'eth0';
my $ipaddr = $obj->{'enabled'} ? $obj->{'ipaddr'} : '0.0.0.0';


my $netmask = $obj->{'netmask'} || '255.255.255.255';
my $enabled = $obj->{'enabled'} && $ipaddr;
my $bootproto = $obj->{'bootproto'} ? $obj->{'bootproto'} : 'none';
my ($network, $broadcast) = calcnetwork ($ipaddr, $netmask);
my $onboot = $enabled ? 'yes' : 'no';

if (!$ipaddr) {
	$cce->bye("SUCCESS");
	exit(0);
}

# edit ifcfg file
my $filename = '/etc/sysconfig/network-scripts/ifcfg-' . $device;
my $ok = Sauce::Util::editfile($filename, sub {
	my ($fin, $fout) = (shift, shift);
  print $fout <<EOT ;
# $filename
# generated by $0
#
# ${oid}.device = $device
# ${oid}.ipaddr = $ipaddr
# ${oid}.netmask = $netmask
# ${oid}.enabled = $enabled
DEVICE=$device
BOOTPROTO=$bootproto
ONBOOT=$onboot
BROADCAST=$broadcast
NETWORK=$network
NETMASK=$netmask
IPADDR=$ipaddr
USERCTL=no
EOT
});

my $up = $enabled ? "up" : "down";

# modify the running interface
if ($ipaddr) {
  my @cmd = ('/sbin/ifconfig', $device, 
	$ipaddr, 
	'broadcast', $broadcast,
	'netmask', $netmask,
	$up,
  );
  system(@cmd);
}

chmod(0755,$filename);
$cce->bye('SUCCESS');
exit(0);

####################### helper functions ##############################

sub calcnetwork
{
	my ($ipaddr, $netmask) = (shift, shift);
  my $binip = pack("CCCC", split(/\./, $ipaddr));
  my $binmask = pack("CCCC", split(/\./, $netmask));
  my $binnet = $binip & $binmask;
  my $binbcast = $binnet | ~$binmask;
  my $network = join(".",unpack("CCCC", $binnet));
  my $bcast   = join(".",unpack("CCCC", $binbcast));
  return ($network, $bcast);
}

sub checkquad
{
	my $quad = shift;
  my $tester = join(".",unpack("CCCC",pack("CCCC",split(/\./,$quad))));
  return $quad eq $tester;
}
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
