#!/usr/bin/perl -w -I/usr/sausalito/perl -I.
# $Id:$

# author: shibuya@alpha.or.jp

# this needs use lib because it isn't a handler
use lib qw(/usr/sausalito/handlers/base/network);
use CCE;

my $DEBUG = 0;

my $errors = 0;

my $conf = '/etc/sysconfig/network';

my $cce = new CCE;
$cce->connectuds();

my ($system_oid) = $cce->find('System');
my ($ok, $system) = $cce->get($system_oid);
if ($system_oid) {
    $DEBUG && print STDERR "Default gateway doesn't set\n";
    open(CONF, $conf) || die "Can't read configfile: $conf\n";
    while (<CONF>) {
	next unless /^GATEWAY=\s*(\S+)/;
	$gateway = $1;
	$DEBUG && print STDERR "Gateway is $gateway\n";
    }
    close(CONF);

    $cce->set($system_oid, '', {'gateway' => $gateway});
}
$cce->bye();
exit 0;
