<?php
// $Id: Shell.php.list.User,v 1.1.1.1 2001/10/19 22:54:08 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All Rights Reserved.
// This extension displays on icon on the user list if shell is enabled
// for the user.

include('UIExtension.php');

class ShellExtension extends UIExtension
{
	function display(&$ServerScriptHelper, &$container, $parameters)
	{
		$factory = $ServerScriptHelper->getHtmlComponentFactory("base-shell");
		$cce = $ServerScriptHelper->getCceClient();

		// if configuring for virtual sites, don't show if the feature
		// is not enabled 
		if ( isset($parameters["VSITE_OID"]) ) {
			$feature = $cce->get($parameters["VSITE_OID"], "Shell");
			if ( !$feature["enabled"] )
				return;	
		}	
		$user = $cce->get($parameters["CCE_OID"], "Shell");
	
		// the container is an array
		$container[] = ($user["enabled"]) ? $factory->getImageLabel("shellIsEnabled", "/libImage/telnet_icon_small.gif") : $factory->getImageLabel("blank", "/libImage/blankIcon.gif", false);
	}

	// user list is a display only extension
	function handle(&$ServerScriptHelper, &$errors, $parameters)
	{
	}
}
?>
