<?php
// $Id: Shell.php.defaults.Vsite,v 1.1.1.1 2001/10/19 22:54:08 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All Rights Reserved.
// Shell.php.defaults.Vsite

include_once('UIExtension.php');

class ShellExtension extends UIExtension
{
    function display(&$ServerScriptHelper, &$container, $parameters)
    {
        $factory = $ServerScriptHelper->getHtmlComponentFactory('base-shell');
        $cce = $ServerScriptHelper->getCceClient();
        
        $defaults = $cce->get($parameters['CCE_SERVICES_OID'], 'Shell');
    
        $shellEnable = $factory->getBoolean('Shell_enabled', 
                            $defaults['enabled']);
        
        // assume PagedBlock because that is most likely going to be it
        $page_id = $parameters['PAGED_BLOCK_DEFAULT_PAGE'];
        $container->addFormField($shellEnable, 
                $factory->getLabel('enableShell'), $page_id);
    }

    function handle(&$ServerScriptHelper, &$errors, $parameters)
    {
        global $Shell_enabled;

        $cce = $ServerScriptHelper->getCceClient();
        
        $cce->set($parameters["CCE_SERVICES_OID"], "Shell", array("enabled" => $Shell_enabled));
        $errors = array_merge($errors, $cce->errors());
    }
}
?>
