<?php
// $Id: Shell.php.defaults.User,v 1.2 2001/10/23 00:25:58 pbose Exp $
// Copyright 2001 Sun Microsystems, Inc.  All Rights Reserved.

include_once('UIExtension.php');

class ShellExtension extends UIExtension
{
    function display(&$ServerScriptHelper, &$container, $parameters)
    {
        $factory =& $ServerScriptHelper->getHtmlComponentFactory("base-shell");
        $cce = $ServerScriptHelper->getCceClient();

        // if configuring for virtual sites, don't show if the feature
        // is not enabled 
        if (isset($parameters["VSITE_OID"])) 
        {
            $feature = $cce->get($parameters["VSITE_OID"], "Shell");
            if (!$feature["enabled"])
                return;    
        }
        
        $defaults = $cce->get($parameters["CCE_SERVICES_OID"], "Shell");
    
        $shellEnable = $factory->getBoolean("Shell_enabled", $defaults["enabled"]);
        
        // assume PagedBlock because that is most likely going to be it
        $page_id = $parameters['PAGED_BLOCK_DEFAULT_PAGE'];
        $container->addFormField($shellEnable, 
            $factory->getLabel("userEnableShell"), $page_id);
    }

    function handle(&$ServerScriptHelper, &$errors, $parameters)
    {
        global $Shell_enabled;

        if (!isset($Shell_enabled))
            return;

        $cce = $ServerScriptHelper->getCceClient();
        
        $cce->set($parameters["CCE_SERVICES_OID"], "Shell", array("enabled" => $Shell_enabled));
        
        $errors = array_merge($errors, $cce->errors());
    }
}
?>
