<?php
// $Id: Shell.php.create.User,v 1.1.1.1 2001/10/19 22:54:08 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All Rights Reserved.

include('UIExtension.php');

class ShellExtension extends UIExtension
{
	function display(&$ServerScriptHelper, &$container, $parameters)
	{
		$factory = $ServerScriptHelper->getHtmlComponentFactory("base-shell");
		$cce = $ServerScriptHelper->getCceClient();

		// if configuring for virtual sites, don't show if the feature
		// is not enabled 
		if ( isset($parameters["VSITE_OID"]) ) {
			$feature = $cce->get($parameters["VSITE_OID"], "Shell");
			if ( !$feature["enabled"] )
				return;	
		}
		
		$defaults = $cce->get($parameters["CCE_SERVICES_OID"], "Shell");
	
		$shellEnable = $factory->getBoolean("Shell_enabled", $defaults["enabled"]);
		
		// assume PagedBlock because that is most likely going to be it
		$pageIds = $container->getPageIds();
		$container->addFormField(
                $shellEnable, 
                $factory->getLabel("userEnableShell"), $pageIds[0]);
	}

	function handle(&$ServerScriptHelper, &$errors, $parameters)
	{
		global $Shell_enabled;
		if ( !isset($Shell_enabled) )
			return;

		$cce = $ServerScriptHelper->getCceClient();
		
		$cce->set($parameters["CCE_OID"], "Shell", array("enabled" => $Shell_enabled));
		$errors = array_merge($errors, $cce->errors());
	}
}
?>
