package PWDB;

require 5.005_62;
use strict;
use warnings;
use Carp;

require Exporter;
require DynaLoader;
use AutoLoader;

our @ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use PWDB ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	PWDB_F_NOACCESS
	PWDB_F_NOUPDATE
	PWDB_F_PASS_PHRASE
	PWDB_ID_UNKNOWN
	PWDB_NAME_UNKNOWN
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	PWDB_F_NOACCESS
	PWDB_F_NOUPDATE
	PWDB_F_PASS_PHRASE
	PWDB_ID_UNKNOWN
	PWDB_NAME_UNKNOWN
	PWDB_SUCCESS
	PWDB_UNIX
	PWDB_SHADOW
	PWDB_NIS
	PWDB_RADIUS
	PWDB_DECNIS
	PWDB_UNIXDB
	PWDB_SHADOWDB
);
our $VERSION = '0.02';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/ || $!{EINVAL}) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
	    croak "Your vendor has not defined PWDB macro $constname";
	}
    }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
	if ($] <= 5.006 && $] >= 5.00561) {
	    *$AUTOLOAD = sub () { $val };
	}
	else {
	    *$AUTOLOAD = sub { $val };
	}
    }
    goto &$AUTOLOAD;
}

bootstrap PWDB $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

PWDB - Perl extension for pwdb

=head1 SYNOPSIS

  use PWDB;
  PWDB::pwdb_start(); # IMPORTANT
  $newuser = PWDB::pwdb_new('user', [PWDB_UNIXDB, PWDB_SHADOWDB], 1000);
  $newuser->set_entry('passwd', 'crypted_password');
  $newuser->set_entry('user', 'newuser');
  $newuser->set_entry('create_user', 'junk');
  
  $user = PWDB::pwdb_locate('user', [], 'foouser', 0);
  $group = PWDB::pwdb_locate('group', [], 'foogroup', 0);
  $uid = $user->get_entry('uid');
  $gid = $group->get_entry('gid');

  $user->set_entry('dir', '/home/foo');
  PWDB::pwdb_replace($user, 'foouser', $uid);

  $errno = PWDB::pwdb_remove('user', [PWDB_UNIX, PWDB_SHADOW], 'deluser', 0);

  PWDB::pwdb_end(); # IMPORTANT

=head1 DESCRIPTION

This is the perl extension for the Password Database library (libpwdb).  It
currently supports most of the interface for libpwdb, and the major functions
such as locate, replace, and remove have been tested.  It is still in need of
major work and most likely the api will be rewritten before it reaches a
release candidate state.  However, it should be usable for most of the basic
needs associated with managing user and group entries in the various databases
supported by libpwdb.

=head1 EXPORT

None by default.

=head2 Exportable constants

  PWDB_F_NOACCESS
  PWDB_F_NOUPDATE
  PWDB_F_PASS_PHRASE
  PWDB_ID_UNKNOWN
  PWDB_NAME_UNKNOWN

=head1 METHODS

=over 4

=item PWDB::pwdb_start()

This initializes libpwdb.  You MUST call this before trying to query libpwdb.

=item PWDB::pwdb_end()

This tells libpwdb that it should free any memory it has allocated to prepare
for shutdown.  You should ALWAYS call this before your script exits.

=item $pwdb = PWDB::pwdb_new($class, $src, $time_to_live)

I<pwdb_new> returns a fresh PWDB object that can be used to create a new user
or group.  It returns undef if there is an error for some reason.

=over 4

=item *

C<$class> is the class of database the returned PWDB ojbect should be associated
with by default.  Currently, the only possible values for class are 'user' and
'group'.  Specify 'user' to deal with users, and 'group' to deal with groups.

=item *

C<$src> is a reference to an array which contains the database sources that this
PWDB object should look at when doing a remove or replace.  Normally, when
using I<pwdb_new>, the database sources should be explicitly specified.  For
most users, C<$src> will be [$PWDB_UNIX, $PWDB_SHADOW] to associate the PWDB
object with the flat unix files (e.g. /etc/passwd, /etc/group, /etc/shadow) or 
[$PWDB_UNIXDB, $PWDB_SHADOWDB] to associate it with the Berekely DB style
versions of the flat files (usually) stored in /var/db.

=item *

C<$time_to_live> specifies the length of time in seconds that the library should
trust the cached copy of the PWDB object.  See the libpwdb documentation for
more info

=back

=item $pwdb = PWDB::pwdb_locate($class, $src, $name, $id)

This method queries the user or group databases to see if the group specified
by name or id exists.  If found, it returns a PWDB object that can be further
queried for specific information on the user or group (SEE I<PWDB METHODS>).
The C<$class> and C<$src> arguments are the same as those for the I<pwdb_new>
method.

=over 4

=item *

C<$name> is the name of the user or group for which to search.  If the name
is unknown, '' can be specified for this argument.  However, if '' is specified,
the C<$id> argument must specify a valid uid or gid for which to search.

=item *

C<$id> is the uid for users or gid for groups.  If the uid/gid is unknown, 0 can
be specified to indicate that only the C<$name> argument contains useful
information with which to search.  One of C<$name> or C<$id> must have a
non-empty or non-zero value to use this method.

=back

=item PWDB::pwdb_replace($pwdb, $current_name, $current_id)

I<pwdb_replace> updates or adds the database entry for the user or group 
specified by the information in C<$current_name> and C<$current_id> with the 
information in C<$pwdb>.  Both C<$current_name> and C<$current_id> should 
always be specified. By default, users or groups that do not exist are not
created.  To specify that a non-existent user or group should be created add
a 'create_user' or 'create_group' entry to C<$pwdb> before passing it to 
I<pwdb_replace>.  It returns true on success and false on failure.

=over 4

=item *

C<$pwdb> is a PWDB object as returned by I<pwdb_new> or I<pwdb_locate>.

=item *

C<$current_name> is the name of the user or group before modifying it.  This
can be different than the user or group entry in C<$pwdb>.  If it is different,
any entries in the database matching C<$current_name> will be removed after the
information in C<$pwdb> is added to the database.

=item *

C<$current_id> is the uid or gid of the user or group before modifying it.  As
with C<$current_name> this can be used to change the uid or gid for a user or
group.

=back

=item PWDB::pwdb_remove($class, $src, $name, $id)

FIXME: needs to be documented.

=back

=head1 PWDB METHODS

=over 4

=item $value = $pwdb->get_entry($entry_name);

This gets an entry value from the PWDB object on which it is called.

=over 4

=item *

C<$entry_name> is the name of the entry to get.

=back

=item $pwdb->set_entry($entry_name, $value);

This sets or adds an entry value in the PWDB object on which it is called.

=over 4

=item *

C<$entry_name> is the name of the entry to set or add.

=item *

C<$value> is the value to which the entry should be set.

=back

=head1 AUTHOR

Patrick Baltz, patrick.baltz@sun.com

=head1 SEE ALSO

perl(1).

=cut
