<?php
// $Id: 40_CGI.php.modifyWeb.Vsite,v 1.1 2001/11/05 08:08:12 pbose Exp $
// Copyright 2001 Sun Microsystems, Inc.  All rights reserved.
//

include('UIExtension.php');

class CGIExtension extends UIExtension
{
	function display(&$ServerScriptHelper, &$container, $parameters)
	{
		$cce = $ServerScriptHelper->getCceClient();

		// will assume the container is a PagedBlock for the time being
		$page_id = $parameters['PAGED_BLOCK_DEFAULT_PAGE'];
		$factory = $ServerScriptHelper->getHtmlComponentFactory("base-apache");

		$featureCGI = $cce->get($parameters['CCE_OID'], 'CGI');

		if ($parameters['IS_SITE_ADMIN']) {
			if ( $featureCGI['enabled'] )
				$container->addFormField(
					$factory->getBoolean('cgi', $featureCGI['enabled'], 'r'),
					$factory->getLabel('cgi'), $page_id
					);
		} else {
				$container->addFormField(
					$factory->getBoolean('cgi', $featureCGI['enabled'], 'rw'),
					$factory->getLabel('cgi'), $page_id
					);
		}
	}

	function handle(&$ServerScriptHelper, &$errors, $parameters)
	{
    global $cgi;
		$cce = $ServerScriptHelper->getCceClient();

    $cce->set($parameters['CCE_OID'], 'CGI', array('enabled' => $cgi));
    $errors = array_merge($errors, $cce->errors());
	}
}
?>
