<?php
// $Id: 50_SSI.php.defaults.Vsite,v 1.1 2001/11/15 02:53:50 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All rights reserved.
//
// ui extension to set default settings for ssi

if(defined("SSI_EXTENSION_DEFAULTS_VSITE"))
{
    return 1;
}
define("SSI_EXTENSION_DEFAULTS_VSITE", 1);

include_once("UIExtension.php");

class SSIExtension extends UIExtension
{
    function display(&$helper, &$container, &$cce_info)
    {
        $factory =& $helper->getHtmlComponentFactory("base-apache");
        $cce = $helper->getCceClient();
    
        $defaults = $cce->get($cce_info["CCE_SERVICES_OID"], 'SSI');
       
        if (!in_array('webScripting', $container->getPageIds()))
        {
            $container->addPage(
                "webScripting", 
                $factory->getLabel("webScripting"));
        }

	    $container->addFormField(
			$factory->getBoolean('SSI_enabled', $defaults['enabled']),
			$factory->getLabel('ssi'),
			"webScripting"
			);
    }

    function handle(&$helper, &$errors, &$cce_info)
    {
        global $SSI_enabled;

        $cce = $helper->getCceClient();

        $cce->set($cce_info["CCE_SERVICES_OID"], 'SSI',
                    array('enabled' => $SSI_enabled));

        $errors = array_merge($errors, $cce->errors());
    }
}


