<?php
// $Id: 60_CGI.php.create.Vsite,v 1.1 2001/11/15 02:53:50 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All rights reserved.
//
// ui extension to set settings for cgi Vsite creation

if(defined("CGI_EXTENSION_CREATE_VSITE"))
{
    return 1;
}
define("CGI_EXTENSION_CREATE_VSITE", 1);

include_once("UIExtension.php");

class CGIExtension extends UIExtension
{
    function display(&$helper, &$container, &$cce_info)
    {
        $factory =& $helper->getHtmlComponentFactory("base-apache");
        $cce =& $helper->getCceClient();
    
        $defaults = $cce->get($cce_info["CCE_SERVICES_OID"], 'CGI');
        
        // only add page if not already there
        if ($cce_info['CAN_ADD_PAGE'])
        {
            $pageId = 'webScripting';
            if (!in_array('webScripting', $container->getPageIds()))
            {
                $container->addPage("webScripting", 
                    $factory->getLabel("webScripting"));
            }
        }
        else
        {
            $pageId = $cce_info['PAGED_BLOCK_DEFAULT_PAGE'];
        }
        
	    $container->addFormField(
			$factory->getBoolean('CGI_enabled', $defaults['enabled']),
		    $factory->getLabel('cgi'),
			$pageId
		    );
    }

    function handle(&$helper, &$errors, &$cce_info)
    {
        global $CGI_enabled;

        $cce =& $helper->getCceClient();

        $cce->set($cce_info["CCE_OID"], 'CGI', 
                array('enabled' => $CGI_enabled));

        $errors = array_merge($errors, $cce->errors());
    }
}


